/*
 * Created on Dec 9, 2008
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.reports.server.integration;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;

import org.apache.log4j.Logger;

import com.tandbergtv.cms.portal.reports.server.entity.CMSUserSession;

/**
 * Class responsible for the integration with the CMS application.
 *  
 * @author <a href="mailto:francisco.neto@venturus.org.br">xfranet - Francisco Bento</a>
 */
public class ReportsSSOIntegrationManager {

    private static final Logger logger = Logger.getLogger(ReportsSSOIntegrationManager.class);
    
    /**
     *      Validate if the specified session is Active.
     *      
     * @param id
     * @param cmsSessionID
     * @return
     */
    public String validateSessionTicket(Long id, String cmsSessionID) {
        String result = null;
        EntityManager em = null;
        EntityTransaction transaction = null;
        try {
            em = JPAUtil.getInstance().getEntityManager();
            transaction = em.getTransaction();
            transaction.begin();
            Query query = em.createNamedQuery("CMSUserSession.FindBySessionId");
            
            query.setParameter("cmsSessionId", cmsSessionID);
            query.setParameter("id", id);
    
            List<CMSUserSession> userSessions = query.getResultList();
            
            CMSUserSession userSession = null;
            if (userSessions.size() > 0) {
                userSession = userSessions.get(0);
            }
            
            if (userSession != null) {
                result = userSession.getUserName();
                em.remove(userSession);
            }
            transaction.commit();
        } catch (RuntimeException e) {
            try {
                transaction.rollback();
            } catch (Exception t) {};
            e.printStackTrace();
            System.out.println("Error " + e.getMessage());
            logger.error("Error validating session", e);
            throw e;
        } finally {
            if (em != null) {
                em.close();
            }
        }
        
        return result;
    }
}
