package com.tandbergtv.cms.portal.reports.server.jreport;

import java.util.Properties;

public class CMSProperties {

    private static CMSProperties instance;
    
    private Properties properties = new Properties();
    
    private CMSProperties() {
        loadProperties();
    }
    
    public void loadProperties() {
        try {
            properties.load(this.getClass().getClassLoader().getResourceAsStream("cms.properties"));
        } catch (Exception e) {
            System.out.println("Error loading CMS properties " + e.getMessage());
            e.printStackTrace();
        }
    }
    
    public String get(String key) {
        return properties.getProperty(key); 
    }
    
    public static CMSProperties getInstance() {
        if (instance == null) {
            instance = new CMSProperties();
        }
        return instance;
    }
    
    
}
