/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.ChartShowValueCondition;
import chart.axis.ChartCategoryAxis;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DAreaP;
import chart.chart2d.Graph2DStaticHint;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartShading;
import chart.properties.ChartNumericAxisProperties;
import chart.util.ChartHintLabel;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.List;

public class Graph2DArea
extends Chart2DObject {
    protected Shape[] seriesShapes;
    protected Shape[] seriesTopFaceShapes;
    protected Shape[] seriesRightFaceShapes;
    protected Shape[][] itemShapes;
    protected float startX;
    protected float unitX;
    protected float unitY;
    protected int row;
    protected int col;
    protected float[][] value;
    protected float[][] hint;
    protected float[][] tHint;
    protected float[][] point;
    protected float[][] tpoint;
    protected float[][] lastpoint;
    protected float[][] tlastpoint;
    protected float[][] tlastpoint2;
    protected int gap = 5;
    protected boolean useDropline = false;
    protected float[][] droplinePoints;
    protected float[][] bottomDroplinePoints;
    protected Line2D[] droplines;
    private String[][][] HighLightPattern;
    protected double[] SumOfRows;
    protected GeneralPath topPath;
    protected GeneralPath rightPath;
    protected float depth;
    protected float depthH = 0.0f;
    protected float depthW = 0.0f;
    protected float startOffsetW = 0.0f;
    protected float startOffsetH = 0.0f;
    protected float offsetW = 0.0f;
    protected float offsetH = 0.0f;
    protected int offsetN = 1;
    protected float[][] dPoint;
    protected float[][] tDPoint;
    protected boolean labelOnTickmark;
    public boolean crossNullPoint = false;

    Graph2DArea(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    Graph2DArea(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer, int n) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
        this.offsetN = n;
    }

    @Override
    public void init() {
        int n;
        super.init();
        this.crossNullPoint = this.paper.getProperties().isIgnoreNullValue();
        this.useDropline = this.objectProperties.isUseDropline();
        double d = Math.PI / 180 * (double)this.objectProperties.getDepthDirection();
        this.depth = this.objectProperties.getDepth() / (float)this.layer.getChartCount();
        this.startOffsetW = (float)((double)(this.depth * (float)(this.offsetN - 1)) * Math.cos(d));
        this.startOffsetH = (float)((double)(this.depth * (float)(this.offsetN - 1)) * Math.sin(d));
        this.startOffsetW = this.startOffsetW < 0.0f ? 0.0f : this.startOffsetW;
        this.startOffsetH = this.startOffsetH < 0.0f ? 0.0f : this.startOffsetH;
        this.depth *= (float)this.offsetN;
        this.depthW = (float)((double)this.depth * Math.cos(d));
        this.depthH = (float)((double)this.depth * Math.sin(d));
        this.depthW = this.depthW < 0.0f ? 0.0f : this.depthW;
        this.depthH = this.depthH < 0.0f ? 0.0f : this.depthH;
        this.offsetW = this.depthW / (float)this.offsetN;
        this.offsetH = this.depthH / (float)this.offsetN;
        this.col = this.dataset.getCategorySize();
        this.row = this.dataset.getSeriesSize();
        int n2 = this.I();
        this.value = new float[this.row][this.col];
        this.hint = new float[this.row * n2][2];
        this.tHint = new float[this.row * n2][2];
        this.unitX = this.layer.I();
        this.unitY = this.layer.Z();
        this.HighLightPattern = new String[this.row][n2][3];
        this.labelOnTickmark = this.layer.getAxisX().getProperties().getPositionAxis() == 0 && this.paper.isSupportLabelOnTickmark() && !this.layer.useDepth();
        this.seriesShapes = new Shape[this.row];
        this.itemShapes = new Shape[this.row][n2];
        this.droplinePoints = new float[this.row][n2];
        this.droplines = new Line2D[n2];
        this.bottomDroplinePoints = new float[n2][2];
        if (this.layer.isDepth()) {
            this.seriesTopFaceShapes = new Shape[this.row];
            this.seriesRightFaceShapes = new Shape[this.row];
            for (n = 0; n < this.row; ++n) {
                this.seriesTopFaceShapes[n] = new GeneralPath();
                this.seriesRightFaceShapes[n] = new GeneralPath();
            }
            this.topPath = new GeneralPath();
            this.rightPath = new GeneralPath();
            this.dPoint = new float[n2 * this.row][2];
            this.tDPoint = new float[n2 * this.row][2];
        }
        for (n = 0; n < this.row; ++n) {
            this.seriesShapes[n] = new GeneralPath();
            for (int i = 0; i < n2; ++i) {
                this.itemShapes[n][i] = new GeneralPath();
            }
        }
        this.point = new float[n2][2];
        this.tpoint = new float[n2][2];
        this.lastpoint = new float[n2][2];
        this.tlastpoint = new float[n2][2];
        this.tlastpoint2 = new float[n2][2];
        this.startX = ((ChartCategoryAxis)this.layer.getAxisX()).isLineUnit() ? 0.0f : this.unitX / 2.0f;
        this.HighLightPattern();
    }

    @Override
    public void locate() {
        int n;
        int n2 = this.I();
        if (this.layer.isDepth()) {
            for (n = 0; n < this.row; ++n) {
                ((GeneralPath)this.seriesTopFaceShapes[n]).reset();
                ((GeneralPath)this.seriesRightFaceShapes[n]).reset();
            }
        }
        for (n = 0; n < this.row; ++n) {
            ((GeneralPath)this.seriesShapes[n]).reset();
            for (int i = 0; i < n2; ++i) {
                ((GeneralPath)this.itemShapes[n][i]).reset();
            }
        }
        this.layer.I(this.hint, this.tHint);
    }

    @Override
    float[][] getStaticHintLocation() {
        return null;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        int n;
        Graphics2D graphics2D2 = graphics2D;
        if (this.layer.getAxisX() != null && this.layer.getAxisX().custommerConstant()) {
            Rectangle rectangle = this.paper.getScaledGraphArea();
            graphics2D2 = (Graphics2D)graphics2D.create();
            graphics2D2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        boolean bl = this.paper.isScrollChart();
        for (n = this.row - 1; n >= 0; --n) {
            if (this.seriesPattern[n] != null) {
                if (this.layer.isDepth()) {
                    this.drawDepthArea(graphics2D2, n);
                } else {
                    this.seriesPattern[n].fill(graphics2D2, this.seriesShapes[n]);
                }
            }
            if (this.objectProperties.isContour()) {
                this.objectProperties.getContourPen().draw(graphics2D2, this.seriesShapes[n]);
            }
            if (this.valueLabelPosition == 0) continue;
            Graph2DStaticHint graph2DStaticHint = new Graph2DStaticHint(this.paper.model, graphics2D, this.dataset, this.paper, this.layer, this.tHint, n, n + 1, this.valueLabelPosition, this.SumOfRows);
            if (this.paper.getAxisX1().custommerConstant()) {
                graph2DStaticHint.setFilteredPaintColumn(this.paper.getFilterConstant());
            }
            if (!bl) {
                graph2DStaticHint.paint();
                continue;
            }
            graph2DStaticHint.setColumnNumber(this.I());
            graph2DStaticHint.paint();
        }
        if (!this.layer.isDepth()) {
            n = this.I();
            if (this.useDropline) {
                for (int i = 0; i < n; ++i) {
                    this.objectProperties.getContourPen().draw(graphics2D2, this.droplines[i]);
                }
            }
        }
    }

    public void drawDepthArea(Graphics2D graphics2D, int n) {
        if (this.seriesPattern[n] != null) {
            ChartFillPattern chartFillPattern = ChartShading.HighLightPattern(this.seriesPattern[n], -20);
            chartFillPattern.fill(graphics2D, this.seriesTopFaceShapes[n]);
            this.seriesPattern[n].fill(graphics2D, this.seriesShapes[n]);
            chartFillPattern.fill(graphics2D, this.seriesRightFaceShapes[n]);
        }
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return this.seriesShapes[n];
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.itemShapes[n][n2];
    }

    @Override
    public Shape[][] getItemShapes() {
        return this.itemShapes;
    }

    @Override
    public String[] search(int n, int n2) {
        this.drilldown = null;
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.I(); ++j) {
                if (!this.itemShapes[i][j].contains(n, n2)) continue;
                this.drilldown = new int[2];
                this.drilldown[0] = i;
                this.drilldown[1] = j;
                return this.HighLightPattern[i][j];
            }
        }
        return null;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public int searchSeries(int n, int n2) {
        for (int i = 0; i < this.seriesShapes.length; ++i) {
            if (!this.seriesShapes[i].contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    protected void construtDroplines() {
        if (this.row == 0) {
            return;
        }
        int n = this.I();
        float[][] fArray = new float[n][2];
        for (int i = 0; i < n; ++i) {
            fArray[i][0] = this.bottomDroplinePoints[i][0];
            fArray[i][1] = this.droplinePoints[0][i];
            for (int j = 0; j < this.row; ++j) {
                fArray[i][1] = fArray[i][1] > this.droplinePoints[j][i] ? this.droplinePoints[j][i] : fArray[i][1];
            }
            this.droplines[i] = new Line2D.Float();
            this.droplines[i].setLine(this.bottomDroplinePoints[i][0], this.bottomDroplinePoints[i][1], fArray[i][0], fArray[i][1]);
        }
    }

    void HighLightPattern() {
        int n;
        boolean bl;
        int n2 = this.I();
        float[] fArray = null;
        boolean bl2 = bl = ((ChartNumericAxisProperties)this.layer.axisY.getProperties()).getIsShowPercent() && !(this instanceof Graph2DAreaP);
        if (bl) {
            fArray = new float[this.row];
            if (this.dataset.getChartDataSetModel().isOneGroup()) {
                for (n = 0; n < fArray.length; ++n) {
                    fArray[n] = (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfSeries(n);
                    fArray[n] = fArray[n] == 0.0f ? 1.0f : fArray[n];
                }
            } else {
                for (n = 0; n < fArray.length; ++n) {
                    fArray[n] = (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfSeries(n);
                    fArray[n] = fArray[n] == 0.0f ? 1.0f : fArray[n];
                }
            }
        }
        if (!this.paper.isScrollChart()) {
            for (n = 0; n < this.row; ++n) {
                for (int i = 0; i < n2; ++i) {
                    Number number = ((Chart1DDataSet)this.dataset).getValue(n, i);
                    if (number == null) {
                        this.value[n][i] = 0.0f;
                        continue;
                    }
                    if (bl) {
                        this.value[n][i] = number.floatValue() / fArray[n];
                        this.hint[n * n2 + i][1] = this.unitY * this.value[n][i];
                    } else {
                        this.value[n][i] = number.floatValue();
                        this.hint[n * n2 + i][1] = this.unitY * this.value[n][i];
                    }
                    if (this.paper.getAxisX1() == null || !this.paper.getAxisX1().custommerConstant()) {
                        this.hint[n * n2 + i][0] = this.unitX * (float)i;
                        if (this.labelOnTickmark) continue;
                        float[] fArray2 = this.hint[n * n2 + i];
                        fArray2[0] = fArray2[0] + this.unitX / 2.0f;
                        continue;
                    }
                    Object object = this.getChartDataSet().getChartDataSetModel().getCategoryName(i);
                    this.hint[n * n2 + i][0] = this.layer.getAxisX().getX(object, this.unitX);
                }
            }
        } else {
            n = this.paper.I.showScrollLabelStart();
            for (int i = 0; i < this.row; ++i) {
                for (int j = 0; j < n2; ++j) {
                    Number number = ((Chart1DDataSet)this.dataset).getValue(i, j + n);
                    if (number == null) {
                        this.value[i][j] = 0.0f;
                        continue;
                    }
                    if (bl) {
                        this.value[i][j] = number.floatValue() / fArray[i];
                        this.hint[i * n2 + j][1] = this.unitY * this.value[i][j];
                    } else {
                        this.value[i][j] = number.floatValue();
                        this.hint[i * n2 + j][1] = this.unitY * this.value[i][j];
                    }
                    if (this.paper.getAxisX1() == null || !this.paper.getAxisX1().custommerConstant()) {
                        this.hint[i * n2 + j][0] = this.unitX * (float)j;
                        if (this.labelOnTickmark) continue;
                        float[] fArray3 = this.hint[i * n2 + j];
                        fArray3[0] = fArray3[0] + this.unitX / 2.0f;
                        continue;
                    }
                    Object object = this.getChartDataSet().getChartDataSetModel().getCategoryName(j + n);
                    this.hint[i * n2 + j][0] = this.layer.getAxisX().getX(object, this.unitX);
                }
            }
        }
        if (this.paper.getProperties().getGraphProperties().getValueLabelType() != 0 && this.valueLabelPosition != 0) {
            this.SumOfRows();
        }
        this.SEDU();
    }

    void SEDU() {
        int n = this.I();
        if (!this.paper.isScrollChart()) {
            for (int i = 0; i < this.row; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (this.layer.isShowCategoryAndSeries()) {
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                        this.HighLightPattern[i][j] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(i, j);
                        continue;
                    }
                    this.HighLightPattern[i][j][0] = this.dataset.getFormatedHintValue(((Chart1DDataSet)this.dataset).getOriginValue(i, j));
                }
            }
        } else {
            int n2 = this.paper.I.showScrollLabelStart();
            for (int i = 0; i < this.row; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (((Chart1DDataSet)this.dataset).getValue(i, j + n2) == null) continue;
                    if (this.layer.isShowCategoryAndSeries()) {
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                        this.HighLightPattern[i][j] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(i, j + n2);
                        continue;
                    }
                    this.HighLightPattern[i][j][0] = this.dataset.getFormatedHintValue(((Chart1DDataSet)this.dataset).getOriginValue(i, j + n2));
                }
            }
        }
    }

    void SumOfRows() {
        this.SumOfRows = new double[this.row];
        if (this.dataset.getChartDataSetModel().isOneGroup()) {
            for (int i = 0; i < this.row; ++i) {
                this.SumOfRows[i] = ((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfSeries(i);
                this.SumOfRows[i] = this.SumOfRows[i] == 0.0 ? 1.0 : this.SumOfRows[i];
            }
        } else {
            for (int i = 0; i < this.row; ++i) {
                this.SumOfRows[i] = ((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfSeries(i);
                this.SumOfRows[i] = this.SumOfRows[i] == 0.0 ? 1.0 : this.SumOfRows[i];
            }
        }
    }

    int I() {
        if (this.paper.isScrollChart()) {
            return this.getScrollLabelCount();
        }
        return this.col;
    }

    float[] Z() {
        float f;
        float f2;
        float[] fArray = new float[2];
        float f3 = 0.0f;
        float f4 = 0.0f;
        f3 = f2 = (float)((ChartNumericAxis)this.layer.getAxisY()).getLabelEndValue();
        fArray[0] = f4 = (f = (float)((ChartNumericAxis)this.layer.getAxisY()).getLabelStartValue());
        fArray[1] = f3;
        return fArray;
    }

    protected int[] getLineSquence(float[] fArray) {
        int[] nArray = null;
        if (fArray != null && fArray.length > 1) {
            nArray = new int[fArray.length];
            boolean[] blArray = new boolean[fArray.length];
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = true;
            }
            float f = 0.0f;
            for (int i = 0; i < fArray.length; ++i) {
                int n;
                nArray[i] = 0;
                if (i == 0) {
                    nArray[i] = 0;
                    f = fArray[i];
                } else {
                    for (n = 0; n < fArray.length; ++n) {
                        if (!blArray[n]) continue;
                        nArray[i] = n;
                        f = fArray[n];
                        break;
                    }
                }
                for (n = 0; n < fArray.length; ++n) {
                    if (!blArray[n] || !(f >= fArray[n])) continue;
                    f = fArray[n];
                    nArray[i] = n;
                }
                blArray[nArray[i]] = false;
                f = fArray[nArray[i]];
            }
        }
        return nArray;
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        int[] nArray = null;
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.I(); ++j) {
                if (!this.itemShapes[i][j].contains(n, n2)) continue;
                ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(i, j);
                if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                    nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(i)).get(j)).getChartLinkInfo();
                }
                return nArray;
            }
        }
        return null;
    }
}

