/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.ChartLabelBase;
import chart.ChartShowValueCondition;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DGuageDial;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartTextStyle;
import chart.util.ChartHintLabel;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class Graph2DGuageDials
extends Chart2DObject {
    float[] abs;
    float[] append;
    float[][] I;
    String[][][] axisY;
    Graph2DGuageDial[] clone;
    int contains;
    int Z;
    float C;
    float[][] cos;
    float[][] floatValue;
    float[][][] get;
    float[][] getAxisXProperties;
    Shape[] getAxisY;
    Shape[] getAxisYProperties;
    Shape[] getBounds;
    Shape[][] getCategorySize;
    Shape[][] getChartDataSetModel;
    Shape[][] getChartLink;
    Shape[][] getChartLinkInfo;
    float[][][] getCondition;
    Line2D[][] getDimension;
    Arc2D[] getFilteredCategoryNames;
    Shape[][] getFormatedHintValue;
    ChartLabelBase[] getGaugeAlertValueMax;
    ChartLabelBase[] getGaugeAlertValueMin;
    private float getGaugeDialCurveStyle;
    private float getGaugeDialLineStyle;
    float getGaugeDialOuterInnerGap;
    float getGaugeDialStartAngle;
    float getGaugeDialStopAngle;
    double[][] getGaugeErrorValueMax;
    Shape[][] getGaugeErrorValueMin;

    Graph2DGuageDials(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    @Override
    public void init() {
        super.init();
        this.Z = this.dataset.getSeriesSize();
        this.contains = this.dataset.getCategorySize();
        this.clone = new Graph2DGuageDial[this.contains];
        ChartFillPattern[] chartFillPatternArray = this.objectProperties.getGuagePatterns();
        for (int i = 0; i < this.contains; ++i) {
            this.clone[i] = new Graph2DGuageDial(this, i);
            this.clone[i].setGaugePatterns(chartFillPatternArray);
        }
        this.getGaugeErrorValueMax = new double[this.Z][this.contains];
        this.getGaugeDialStartAngle = this.objectProperties.getGaugeDialStartAngle();
        this.getGaugeDialStopAngle = this.objectProperties.getGaugeDialStopAngle();
        this.getGaugeDialOuterInnerGap = this.getGaugeDialStopAngle - this.getGaugeDialStartAngle;
        this.SEDU();
        this.cos();
        this.contains();
        this.dataset();
    }

    private void SEDU() {
        this.I = new float[this.Z][this.contains];
        this.axisY = new String[this.Z][this.contains][3];
        for (int i = 0; i < this.Z; ++i) {
            for (int j = 0; j < this.contains; ++j) {
                Number number = ((Chart1DDataSet)this.dataset).getValue(i, j);
                if (number == null) {
                    this.I[i][j] = 0.0f;
                    continue;
                }
                this.I[i][j] = number.floatValue();
                if (this.layer.isShowCategoryAndSeries()) {
                    ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                    this.axisY[i][j] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(i, j);
                    continue;
                }
                this.axisY[i][j][0] = this.dataset.getFormatedHintValue(number);
            }
        }
    }

    @Override
    public void locate() {
        if (this.objectProperties.getGaugeDialStartAngle() >= 0.0f && this.objectProperties.getGaugeDialStartAngle() <= 180.0f && this.objectProperties.getGaugeDialStopAngle() >= 0.0f && this.objectProperties.getGaugeDialStopAngle() <= 180.0f) {
            this.append();
        } else {
            this.axisY();
        }
        this.floatValue();
        this.get();
        this.getAxisYProperties();
        this.drilldown();
        this.getAxisY();
        this.getBounds();
        this.getAxisXProperties();
    }

    private int[] abs() {
        int[] nArray = new int[2];
        float f = (float)this.paper.getBounds().width * this.paper.getProperties().getScaleX();
        float f2 = (float)this.paper.getBounds().height * this.paper.getProperties().getScaleY();
        float f3 = Math.min(f, f2);
        float f4 = Math.max(f, f2);
        int n = 1;
        int n2 = 1;
        boolean bl = false;
        for (int i = 1; i <= this.contains; ++i) {
            n = i;
            for (int j = 1; j <= (int)(f4 / (f3 / (float)n)); ++j) {
                if (n * j < this.contains) continue;
                n2 = j;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (f >= f2) {
            nArray[0] = n;
            nArray[1] = n2;
        } else {
            nArray[0] = n2;
            nArray[1] = n;
        }
        return nArray;
    }

    private void append() {
        int[] nArray = this.abs();
        this.cos = new float[this.contains][2];
        this.floatValue = new float[this.contains][2];
        float f = (float)this.paper.getBounds().width * this.paper.getProperties().getScaleX();
        float f2 = (float)this.paper.getBounds().height * this.paper.getProperties().getScaleY();
        float f3 = f2 / (float)nArray[0];
        float f4 = f / (float)nArray[1];
        float f5 = Math.min(f3 * 2.0f, f / (float)nArray[1]);
        float f6 = f5 / 2.0f;
        float f7 = (float)this.paper.getBounds().width * (1.0f - this.paper.getProperties().getScaleX()) / 2.0f;
        float f8 = (float)this.paper.getBounds().height * (1.0f - this.paper.getProperties().getScaleY()) / 2.0f;
        float f9 = f7 + (f4 - f5 * this.objectProperties.getRadiusRange()) / 2.0f;
        float f10 = f8 + (f3 - f6 * this.objectProperties.getRadiusRange()) / 2.0f;
        this.C = (int)(f6 * this.objectProperties.getRadiusRange());
        float f11 = this.getCategorySize(f6);
        if (f11 < this.C && this.layer.getAxisY().getProperties().getTickMarkType() == 1) {
            f9 += this.C - f11;
            f10 += this.C - f11;
            this.C = f11;
        }
        this.getGaugeDialCurveStyle = this.objectProperties.getGaugeDialOuterInnerGap() > this.C ? this.C : this.objectProperties.getGaugeDialOuterInnerGap();
        this.getGaugeDialLineStyle = this.C - this.getGaugeDialCurveStyle;
        for (int i = 0; i < this.contains; ++i) {
            int n = i / nArray[1];
            int n2 = i % nArray[1];
            this.cos[i][0] = f9 + (float)n2 * f4;
            this.cos[i][1] = f10 + (float)n * f3;
            this.floatValue[i][0] = this.cos[i][0] + this.C;
            this.floatValue[i][1] = this.cos[i][1] + this.C;
        }
    }

    private void axisY() {
        float f;
        this.cos = new float[this.contains][2];
        this.floatValue = new float[this.contains][2];
        int[] nArray = this.abs();
        float f2 = (float)this.paper.getBounds().width * this.paper.getProperties().getScaleX();
        float f3 = (float)this.paper.getBounds().height * this.paper.getProperties().getScaleY();
        float f4 = f = Math.min(f3 / (float)nArray[0], f2 / (float)nArray[1]);
        float f5 = f2 / (float)nArray[1];
        float f6 = f3 / (float)nArray[0];
        float f7 = (float)this.paper.getBounds().width * (1.0f - this.paper.getProperties().getScaleX()) / 2.0f;
        float f8 = (float)this.paper.getBounds().height * (1.0f - this.paper.getProperties().getScaleY()) / 2.0f;
        float f9 = f7 + (f5 - f * this.objectProperties.getRadiusRange()) / 2.0f;
        float f10 = f8 + (f6 - f4 * this.objectProperties.getRadiusRange()) / 2.0f;
        this.C = (int)(f4 * this.objectProperties.getRadiusRange()) / 2;
        float f11 = this.getCategorySize(f4 / 2.0f);
        if (f11 < this.C && this.layer.getAxisY().getProperties().getTickMarkType() == 1) {
            f9 += this.C - f11;
            f10 += this.C - f11;
            this.C = f11;
        }
        this.getGaugeDialCurveStyle = this.objectProperties.getGaugeDialOuterInnerGap() > this.C ? this.C : this.objectProperties.getGaugeDialOuterInnerGap();
        this.getGaugeDialLineStyle = this.C - this.getGaugeDialCurveStyle;
        for (int i = 0; i < this.contains; ++i) {
            int n = i / nArray[1];
            int n2 = i % nArray[1];
            this.cos[i][0] = f9 + (float)n2 * f5;
            this.cos[i][1] = f10 + (float)n * f6;
            this.floatValue[i][0] = this.cos[i][0] + this.C;
            this.floatValue[i][1] = this.cos[i][1] + this.C;
        }
    }

    private void contains() {
        String[] stringArray = this.dataset.getChartDataSetModel().getFilteredCategoryNames();
        if (stringArray != null) {
            int n = stringArray.length;
            this.getGaugeAlertValueMax = new ChartLabelBase[n];
            for (int i = 0; i < n; ++i) {
                this.getGaugeAlertValueMax[i] = new ChartLabelBase(stringArray[i]);
                this.getGaugeAlertValueMax[i].setChartTextStyle(this.paper.getProperties().getAxisXProperties().getLabelTextStyle());
            }
        }
    }

    private void cos() {
        int n;
        float f = (float)((ChartNumericAxis)this.layer.getAxisY()).getMax();
        float f2 = (float)((ChartNumericAxis)this.layer.getAxisY()).getMin();
        this.abs = new float[3];
        this.append = new float[3];
        this.abs[0] = (float)this.objectProperties.getGaugeNormalValueMin();
        this.abs[1] = (float)this.objectProperties.getGaugeAlertValueMin();
        this.abs[2] = (float)this.objectProperties.getGaugeErrorValueMin();
        this.append[0] = (float)this.objectProperties.getGaugeNormalValueMax();
        this.append[1] = (float)this.objectProperties.getGaugeAlertValueMax();
        this.append[2] = (float)this.objectProperties.getGaugeErrorValueMax();
        boolean bl = true;
        for (n = 0; n < 3; ++n) {
            if (this.abs[n] > this.append[n]) {
                float f3 = this.abs[n];
                this.abs[n] = this.append[n];
                this.append[n] = f3;
            }
            bl = this.append[n] == this.append[n] && this.append[n] == 0.0f && bl;
        }
        if (bl) {
            float f4 = (f - f2) / 3.0f;
            for (int i = 0; i < 3; ++i) {
                this.abs[i] = f2 + (float)i * f4;
                this.append[i] = this.abs[i] + f4;
            }
        }
        for (n = 0; n < 3; ++n) {
            if (this.abs[n] < f2) {
                this.abs[n] = f2;
            }
            if (this.abs[n] > f) {
                this.abs[n] = f;
            }
            if (this.append[n] < f2) {
                this.append[n] = f2;
            }
            if (!(this.append[n] > f)) continue;
            this.append[n] = f;
        }
    }

    private void dataset() {
        String[] stringArray = ((ChartNumericAxis)this.layer.axisY).getLabels();
        if (stringArray == null) {
            return;
        }
        int n = stringArray.length;
        this.getGaugeAlertValueMin = new ChartLabelBase[n];
        for (int i = 0; i < n; ++i) {
            this.getGaugeAlertValueMin[i] = new ChartLabelBase(stringArray[n - i - 1]);
            this.getGaugeAlertValueMin[i].setChartTextStyle(this.paper.getProperties().getAxisYProperties().getLabelTextStyle());
            this.getGaugeAlertValueMin[i].locate();
        }
    }

    private void drilldown() {
        if (this.getGaugeAlertValueMax == null) {
            return;
        }
        int n = this.getGaugeAlertValueMax.length;
        ChartTextStyle chartTextStyle = this.paper.getProperties().getAxisXProperties().getLabelTextStyle();
        this.getAxisXProperties = new float[n][2];
        for (int i = 0; i < n; ++i) {
            Rectangle2D rectangle2D = chartTextStyle.getDimension(this.getGaugeAlertValueMax[i].getLabelText());
            if (this.objectProperties.getGaugeDialStartAngle() >= 0.0f && this.objectProperties.getGaugeDialStopAngle() <= 180.0f && this.objectProperties.getGaugeDialStopAngle() >= 0.0f && this.objectProperties.getGaugeDialStartAngle() <= 180.0f) {
                this.getAxisXProperties[i][0] = (float)((double)this.floatValue[i][0] - rectangle2D.getWidth() / 2.0);
                this.getAxisXProperties[i][1] = this.floatValue[i][1] + this.paper.getProperties().getAxisXProperties().getLabelAxisGap();
                continue;
            }
            this.getAxisXProperties[i][0] = (float)((double)this.floatValue[i][0] - rectangle2D.getWidth() / 2.0);
            this.getAxisXProperties[i][1] = (float)((double)this.floatValue[i][1] - rectangle2D.getHeight() / 2.0) + this.paper.getProperties().getAxisXProperties().getLabelAxisGap();
        }
    }

    private void floatValue() {
        this.getBounds = new Shape[this.contains];
        switch (this.paper.getProperties().getAxisYProperties().getTickMarkType()) {
            case 0: 
            case 1: {
                this.getGaugeErrorValueMin = new Shape[1][this.contains];
                for (int i = 0; i < this.contains; ++i) {
                    this.getBounds[i] = new Arc2D.Float(this.cos[i][0], this.cos[i][1], this.C * 2.0f, this.C * 2.0f, this.getGaugeDialStartAngle, this.getGaugeDialOuterInnerGap, 0);
                    this.getGaugeErrorValueMin[0][i] = this.getBounds[i];
                }
                break;
            }
            case 2: {
                this.getGaugeErrorValueMin = new Shape[1][this.contains];
                for (int i = 0; i < this.contains; ++i) {
                    this.getBounds[i] = new Arc2D.Float(this.cos[i][0] + this.getGaugeDialCurveStyle, this.cos[i][1] + this.getGaugeDialCurveStyle, this.getGaugeDialLineStyle * 2.0f, this.getGaugeDialLineStyle * 2.0f, this.getGaugeDialStartAngle, this.getGaugeDialOuterInnerGap, 0);
                    this.getGaugeErrorValueMin[0][i] = this.getBounds[i];
                }
                break;
            }
            case 3: {
                this.getGaugeErrorValueMin = new Shape[2][this.contains];
                for (int i = 0; i < this.contains; ++i) {
                    Arc2D.Float float_ = new Arc2D.Float(this.cos[i][0], this.cos[i][1], this.C * 2.0f, this.C * 2.0f, this.getGaugeDialStartAngle, this.getGaugeDialOuterInnerGap, 0);
                    Arc2D.Float float_2 = new Arc2D.Float(this.cos[i][0] + this.getGaugeDialCurveStyle, this.cos[i][1] + this.getGaugeDialCurveStyle, this.getGaugeDialLineStyle * 2.0f, this.getGaugeDialLineStyle * 2.0f, this.getGaugeDialStartAngle, this.getGaugeDialOuterInnerGap, 0);
                    this.getBounds[i] = new GeneralPath(float_);
                    ((GeneralPath)this.getBounds[i]).append(float_2, false);
                    this.getGaugeErrorValueMin[0][i] = float_;
                    this.getGaugeErrorValueMin[1][i] = float_2;
                }
                break;
            }
        }
    }

    private void get() {
        int n = ((ChartNumericAxis)this.layer.getAxisY()).getNumOfTick();
        float f = this.paper.getProperties().getAxisYProperties().getTickMarkLength();
        float f2 = this.paper.getProperties().getAxisYProperties().getMinorTickMarkLength();
        float f3 = this.paper.getProperties().getAxisYProperties().getLabelAxisGap();
        ChartTextStyle chartTextStyle = this.paper.getProperties().getAxisYProperties().getLabelTextStyle();
        float[][] fArray = new float[2][2];
        float[][] fArray2 = new float[2][2];
        this.getCategorySize = new Shape[this.contains][2 * n + 1];
        this.get = new float[this.contains][n + 1][2];
        for (int i = 0; i < this.contains; ++i) {
            double d = (double)this.getGaugeDialOuterInnerGap / (2.0 * (double)n);
            block7: for (int j = 0; j < 2 * n + 1; ++j) {
                this.getCategorySize[i][j] = new GeneralPath();
                double d2 = Math.cos((180.0 - (double)j * d - (double)this.getGaugeDialStartAngle) * Math.PI / 180.0);
                double d3 = Math.sin((180.0 - (double)j * d - (double)this.getGaugeDialStartAngle) * Math.PI / 180.0);
                switch (this.paper.getProperties().getAxisYProperties().getTickMarkType()) {
                    case 1: {
                        Cloneable cloneable;
                        if (j % 2 == 0) {
                            fArray[0][0] = (float)((double)this.floatValue[i][0] - (double)(this.C + f) * d2);
                            fArray[0][1] = (float)((double)this.floatValue[i][1] - (double)(this.C + f) * d3);
                            cloneable = this.getGaugeAlertValueMin[j / 2].getLabelBaseDimension();
                            float f4 = (float)((double)this.floatValue[i][0] - (double)(this.C + f + f3) * d2);
                            float f5 = (float)((double)this.floatValue[i][1] - (double)(this.C + f + f3) * d3);
                            this.get[i][j / 2][0] = Math.abs(d2) * 10.0 < 1.0 ? f4 - (float)(cloneable.width / 2) : (d2 > 0.0 ? f4 - (float)cloneable.width : f4);
                            this.get[i][j / 2][1] = d3 >= 0.0 ? f5 - (float)cloneable.height : f5;
                        } else {
                            fArray[0][0] = (float)((double)this.floatValue[i][0] - (double)(this.C + f2) * d2);
                            fArray[0][1] = (float)((double)this.floatValue[i][1] - (double)(this.C + f2) * d3);
                        }
                        fArray[1][0] = (float)((double)this.floatValue[i][0] - (double)this.C * d2);
                        fArray[1][1] = (float)((double)this.floatValue[i][1] - (double)this.C * d3);
                        ((GeneralPath)this.getCategorySize[i][j]).moveTo(fArray[0][0], fArray[0][1]);
                        ((GeneralPath)this.getCategorySize[i][j]).lineTo(fArray[1][0], fArray[1][1]);
                        continue block7;
                    }
                    case 2: {
                        Cloneable cloneable;
                        if (j % 2 == 0) {
                            fArray2[0][0] = (float)((double)this.floatValue[i][0] - (double)(this.getGaugeDialLineStyle - f) * d2);
                            fArray2[0][1] = (float)((double)this.floatValue[i][1] - (double)(this.getGaugeDialLineStyle - f) * d3);
                            cloneable = this.getGaugeAlertValueMin[j / 2].getLabelBaseDimension();
                            float f6 = (float)((double)this.floatValue[i][0] - (double)(this.getGaugeDialLineStyle - f - f3) * d2);
                            float f7 = (float)((double)this.floatValue[i][1] - (double)(this.getGaugeDialLineStyle - f - f3) * d3);
                            this.get[i][j / 2][0] = Math.abs(d2 * 10.0) < 1.0 ? f6 - (float)(cloneable.width / 2) : (d2 > 0.0 ? f6 : f6 - (float)cloneable.width);
                            this.get[i][j / 2][1] = Math.abs(d3 * 10.0) < 1.0 ? f7 - (float)cloneable.height : (d3 > 0.0 ? f7 : f7 - (float)cloneable.height);
                        } else {
                            fArray2[0][0] = (float)((double)this.floatValue[i][0] - (double)(this.getGaugeDialLineStyle - f2) * d2);
                            fArray2[0][1] = (float)((double)this.floatValue[i][1] - (double)(this.getGaugeDialLineStyle - f2) * d3);
                        }
                        fArray2[1][0] = (float)((double)this.floatValue[i][0] - (double)this.getGaugeDialLineStyle * d2);
                        fArray2[1][1] = (float)((double)this.floatValue[i][1] - (double)this.getGaugeDialLineStyle * d3);
                        ((GeneralPath)this.getCategorySize[i][j]).moveTo(fArray2[0][0], fArray2[0][1]);
                        ((GeneralPath)this.getCategorySize[i][j]).lineTo(fArray2[1][0], fArray2[1][1]);
                        continue block7;
                    }
                    case 3: {
                        Cloneable cloneable;
                        fArray[0][0] = (float)((double)this.floatValue[i][0] - (double)this.C * d2);
                        fArray[0][1] = (float)((double)this.floatValue[i][1] - (double)this.C * d3);
                        if (j % 2 == 0) {
                            fArray[1][0] = (float)((double)this.floatValue[i][0] - (double)(this.C - f) * d2);
                            fArray[1][1] = (float)((double)this.floatValue[i][1] - (double)(this.C - f) * d3);
                        } else {
                            fArray[1][0] = (float)((double)this.floatValue[i][0] - (double)(this.C - f2) * d2);
                            fArray[1][1] = (float)((double)this.floatValue[i][1] - (double)(this.C - f2) * d3);
                        }
                        fArray2[0][0] = (float)((double)this.floatValue[i][0] - (double)this.getGaugeDialLineStyle * d2);
                        fArray2[0][1] = (float)((double)this.floatValue[i][1] - (double)this.getGaugeDialLineStyle * d3);
                        if (j % 2 == 0) {
                            fArray2[1][0] = (float)((double)this.floatValue[i][0] - (double)(this.getGaugeDialLineStyle + f) * d2);
                            fArray2[1][1] = (float)((double)this.floatValue[i][1] - (double)(this.getGaugeDialLineStyle + f) * d3);
                        } else {
                            fArray2[1][0] = (float)((double)this.floatValue[i][0] - (double)(this.getGaugeDialLineStyle + f2) * d2);
                            fArray2[1][1] = (float)((double)this.floatValue[i][1] - (double)(this.getGaugeDialLineStyle + f2) * d3);
                        }
                        if (j % 2 == 0) {
                            cloneable = this.getGaugeAlertValueMin[j / 2].getLabelBaseDimension();
                            float f8 = (float)((double)this.floatValue[i][0] - (double)((this.getGaugeDialLineStyle + this.C) / 2.0f) * d2);
                            float f9 = (float)((double)this.floatValue[i][1] - (double)((this.getGaugeDialLineStyle + this.C) / 2.0f) * d3);
                            if (Math.abs(d3 * 10.0) < 1.0) {
                                this.get[i][j / 2][0] = f8 - (float)(cloneable.width / 2);
                                this.get[i][j / 2][1] = f9 - (float)cloneable.height;
                            } else {
                                this.get[i][j / 2][0] = f8 - (float)(cloneable.width / 2);
                                this.get[i][j / 2][1] = f9 - (float)(cloneable.height / 2);
                            }
                        }
                        cloneable = new Line2D.Float(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1]);
                        Line2D.Float float_ = new Line2D.Float(fArray2[0][0], fArray2[0][1], fArray2[1][0], fArray2[1][1]);
                        this.getCategorySize[i][j] = new GeneralPath((Shape)((Object)cloneable));
                        ((GeneralPath)this.getCategorySize[i][j]).append(float_, false);
                        continue block7;
                    }
                    case 0: {
                        if (j % 2 != 0) continue block7;
                        Dimension dimension = this.getGaugeAlertValueMin[j / 2].getLabelBaseDimension();
                        float f10 = (float)((double)this.floatValue[i][0] - (double)(this.C + f3) * d2);
                        float f11 = (float)((double)this.floatValue[i][1] - (double)(this.C + f3) * d3);
                        this.get[i][j / 2][0] = Math.abs(d2) * 10.0 < 1.0 ? f10 - (float)(dimension.width / 2) : (d2 > 0.0 ? f10 - (float)dimension.width : f10);
                        if (d3 >= 0.0) {
                            this.get[i][j / 2][1] = f11 - (float)dimension.height;
                            continue block7;
                        }
                        this.get[i][j / 2][1] = f11;
                        continue block7;
                    }
                }
            }
        }
    }

    private void getAxisXProperties() {
        float f = (float)((ChartNumericAxis)this.layer.getAxisY()).getMax();
        float f2 = (float)((ChartNumericAxis)this.layer.getAxisY()).getMin();
        float[] fArray = new float[2];
        this.getFormatedHintValue = new Shape[this.Z][this.contains];
        this.getAxisYProperties = new Shape[this.Z];
        this.getDimension = new Line2D[this.Z][this.contains];
        this.getFilteredCategoryNames = new Arc2D[this.contains];
        this.getChartLinkInfo = new Shape[this.Z][this.contains];
        this.getCondition = new float[this.Z][this.contains][2];
        for (int i = 0; i < this.Z; ++i) {
            this.getAxisYProperties[i] = new GeneralPath();
            for (int j = 0; j < this.contains; ++j) {
                double d;
                this.getFormatedHintValue[i][j] = new GeneralPath();
                if (this.I[i][j] > f || this.I[i][j] < f2) continue;
                float f3 = 180.0f - this.getGaugeDialStartAngle - (float)((int)((f - this.I[i][j]) * this.getGaugeDialOuterInnerGap / (f - f2)));
                this.getGaugeErrorValueMax[i][j] = d = (double)f3 * Math.PI / 180.0;
                double d2 = Math.cos(d);
                double d3 = Math.sin(d);
                fArray[0] = this.floatValue[j][0] - (float)((int)((double)(this.C - this.getGaugeDialCurveStyle / 5.0f) * d2));
                fArray[1] = this.floatValue[j][1] - (float)((int)((double)(this.C - this.getGaugeDialCurveStyle / 5.0f) * d3));
                switch (this.objectProperties.getGaugeDialLineStyle()) {
                    case 0: {
                        float f4 = this.C / 16.0f;
                        ((GeneralPath)this.getFormatedHintValue[i][j]).moveTo((float)((double)this.floatValue[j][0] - (double)f4 * d3), (float)((double)this.floatValue[j][1] + (double)f4 * d2));
                        ((GeneralPath)this.getFormatedHintValue[i][j]).lineTo((float)((double)this.floatValue[j][0] + (double)f4 * d3), (float)((double)this.floatValue[j][1] - (double)f4 * d2));
                        ((GeneralPath)this.getFormatedHintValue[i][j]).lineTo(fArray[0], fArray[1]);
                        ((GeneralPath)this.getFormatedHintValue[i][j]).lineTo((float)((double)this.floatValue[j][0] - (double)f4 * d3), (float)((double)this.floatValue[j][1] + (double)f4 * d2));
                        break;
                    }
                    case 1: {
                        double d4 = Math.cos(0.1308996938995747);
                        double d5 = Math.cos(d - 0.1308996938995747);
                        double d6 = Math.sin(d - 0.1308996938995747);
                        double d7 = (double)this.C / (5.0 * Math.cos(d4));
                        float f5 = (float)((double)this.floatValue[j][0] - d7 * d5);
                        float f6 = (float)((double)this.floatValue[j][1] - d7 * d6);
                        ((GeneralPath)this.getFormatedHintValue[i][j]).moveTo(this.floatValue[j][0], this.floatValue[j][1]);
                        ((GeneralPath)this.getFormatedHintValue[i][j]).lineTo(f5, f6);
                        ((GeneralPath)this.getFormatedHintValue[i][j]).lineTo(fArray[0], fArray[1]);
                        d5 = Math.cos(d + 0.1308996938995747);
                        d6 = Math.sin(d + 0.1308996938995747);
                        f5 = (float)((double)this.floatValue[j][0] - d7 * d5);
                        f6 = (float)((double)this.floatValue[j][1] - d7 * d6);
                        ((GeneralPath)this.getFormatedHintValue[i][j]).lineTo(f5, f6);
                        ((GeneralPath)this.getFormatedHintValue[i][j]).lineTo(this.floatValue[j][0], this.floatValue[j][1]);
                        break;
                    }
                    case 2: {
                        float f7 = (float)((double)this.floatValue[j][0] - (double)(this.C - 2.0f * this.getGaugeDialCurveStyle / 5.0f) * d2);
                        float f8 = (float)((double)this.floatValue[j][1] - (double)(this.C - 2.0f * this.getGaugeDialCurveStyle / 5.0f) * d3);
                        this.getCondition[i][j][0] = f7;
                        this.getCondition[i][j][1] = f8;
                        this.getDimension[i][j] = new Line2D.Float((float)((double)this.floatValue[j][0] + (double)this.C * d2 / 6.0), (float)((double)this.floatValue[j][1] + (double)this.C * d3 / 6.0), f7, f8);
                        ((GeneralPath)this.getFormatedHintValue[i][j]).moveTo((float)((double)this.floatValue[j][0] + (double)this.C * d2 / 6.0), (float)((double)this.floatValue[j][1] + (double)this.C * d3 / 6.0));
                        ((GeneralPath)this.getFormatedHintValue[i][j]).lineTo(f7, f8);
                        this.getChartLinkInfo[i][j] = new GeneralPath();
                        ((GeneralPath)this.getChartLinkInfo[i][j]).moveTo(f7 - 5.0f, f8 + 5.0f);
                        ((GeneralPath)this.getChartLinkInfo[i][j]).lineTo(f7 + 5.0f, f8 + 5.0f);
                        ((GeneralPath)this.getChartLinkInfo[i][j]).lineTo(f7 + 5.0f, f8 - 5.0f);
                        ((GeneralPath)this.getChartLinkInfo[i][j]).lineTo(f7 - 5.0f, f8 - 5.0f);
                        ((GeneralPath)this.getChartLinkInfo[i][j]).lineTo(f7 - 5.0f, f8 + 5.0f);
                        ((GeneralPath)this.getFormatedHintValue[i][j]).append(this.getChartLinkInfo[i][j], false);
                        this.getFilteredCategoryNames[j] = new Arc2D.Float(this.floatValue[j][0] - 5.0f, this.floatValue[j][1], 10.0f, 10.0f, 0.0f, 360.0f, 0);
                        break;
                    }
                }
                ((GeneralPath)this.getAxisYProperties[i]).append(this.getFormatedHintValue[i][j], false);
            }
        }
    }

    private void getAxisY() {
        this.getChartLink = new Shape[this.contains][3];
        float f = (float)((ChartNumericAxis)this.layer.getAxisY()).getMax();
        float f2 = (float)((ChartNumericAxis)this.layer.getAxisY()).getMin();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < this.contains; ++j) {
                float f3 = (this.append[i] - f2) * this.getGaugeDialOuterInnerGap / (f - f2);
                float f4 = (this.abs[i] - f2) * this.getGaugeDialOuterInnerGap / (f - f2);
                float f5 = f3 - f4;
                float f6 = (f - this.append[i]) * this.getGaugeDialOuterInnerGap / (f - f2) + this.getGaugeDialStartAngle;
                this.getChartLink[j][i] = new Arc2D.Double(this.cos[j][0], this.cos[j][1], this.C * 2.0f, this.C * 2.0f, f6, f5, 2);
                Area area = new Area(this.getChartLink[j][i]);
                Arc2D.Double double_ = new Arc2D.Double(this.cos[j][0] + this.getGaugeDialCurveStyle, this.cos[j][1] + this.getGaugeDialCurveStyle, (this.C - this.getGaugeDialCurveStyle) * 2.0f, (this.C - this.getGaugeDialCurveStyle) * 2.0f, -0.0, 360.0, 1);
                area.subtract(new Area(double_));
                this.getChartLink[j][i] = area;
            }
        }
    }

    private void getAxisYProperties() {
        float f = (float)((ChartNumericAxis)this.layer.getAxisY()).getMax();
        float f2 = (float)((ChartNumericAxis)this.layer.getAxisY()).getMin();
        this.getChartDataSetModel = new Shape[this.contains][4];
        for (int i = 0; i < this.contains; ++i) {
            for (int j = 0; j < 4; ++j) {
                float f3;
                float f4;
                float f5;
                float f6;
                double d;
                if (j == 0) {
                    d = (double)(this.getGaugeDialStopAngle - (this.abs[j] - f2) * this.getGaugeDialOuterInnerGap / (f - f2)) * Math.PI / 180.0;
                    f6 = (float)((double)this.floatValue[i][0] + (double)this.C * Math.cos(d));
                    f5 = (float)((double)this.floatValue[i][1] - (double)this.C * Math.sin(d));
                    f4 = (float)((double)this.floatValue[i][0] + (double)this.getGaugeDialLineStyle * Math.cos(d));
                    f3 = (float)((double)this.floatValue[i][1] - (double)this.getGaugeDialLineStyle * Math.sin(d));
                    this.getChartDataSetModel[i][j] = new Line2D.Float(f6, f5, f4, f3);
                    continue;
                }
                d = (double)(this.getGaugeDialStopAngle - (this.append[j - 1] - f2) * this.getGaugeDialOuterInnerGap / (f - f2)) * Math.PI / 180.0;
                f6 = (float)((double)this.floatValue[i][0] + (double)this.C * Math.cos(d));
                f5 = (float)((double)this.floatValue[i][1] - (double)this.C * Math.sin(d));
                f4 = (float)((double)this.floatValue[i][0] + (double)this.getGaugeDialLineStyle * Math.cos(d));
                f3 = (float)((double)this.floatValue[i][1] - (double)this.getGaugeDialLineStyle * Math.sin(d));
                this.getChartDataSetModel[i][j] = new Line2D.Float(f6, f5, f4, f3);
            }
        }
    }

    private void getBounds() {
        float f = this.C - this.getGaugeDialCurveStyle;
        this.getAxisY = new Shape[this.contains];
        block5: for (int i = 0; i < this.contains; ++i) {
            float f2 = this.cos[i][0] + this.getGaugeDialCurveStyle;
            float f3 = this.cos[i][1] + this.getGaugeDialCurveStyle;
            switch (this.objectProperties.getGaugeDialCurveStyle()) {
                case 0: {
                    Arc2D.Float float_ = new Arc2D.Float(this.cos[i][0], this.cos[i][1], this.C * 2.0f, this.C * 2.0f, this.getGaugeDialStartAngle, this.getGaugeDialOuterInnerGap, 0);
                    Arc2D.Double double_ = new Arc2D.Double(f2, f3, f * 2.0f, f * 2.0f, this.getGaugeDialStartAngle, this.getGaugeDialOuterInnerGap, 0);
                    GeneralPath generalPath = new GeneralPath();
                    GeneralPath generalPath2 = new GeneralPath();
                    float f4 = this.floatValue[i][0] + (float)((double)this.C * Math.cos(Math.PI * (double)this.getGaugeDialStartAngle / 180.0));
                    float f5 = this.floatValue[i][1] - (float)((double)this.C * Math.sin(Math.PI * (double)this.getGaugeDialStartAngle / 180.0));
                    float f6 = this.floatValue[i][0] + (float)((double)f * Math.cos(Math.PI * (double)this.getGaugeDialStartAngle / 180.0));
                    float f7 = this.floatValue[i][1] - (float)((double)f * Math.sin(Math.PI * (double)this.getGaugeDialStartAngle / 180.0));
                    float f8 = this.floatValue[i][0] + (float)((double)this.C * Math.cos(Math.PI * (double)this.getGaugeDialStopAngle / 180.0));
                    float f9 = this.floatValue[i][1] - (float)((double)this.C * Math.sin(Math.PI * (double)this.getGaugeDialStopAngle / 180.0));
                    float f10 = this.floatValue[i][0] + (float)((double)f * Math.cos(Math.PI * (double)this.getGaugeDialStopAngle / 180.0));
                    float f11 = this.floatValue[i][1] - (float)((double)f * Math.sin(Math.PI * (double)this.getGaugeDialStopAngle / 180.0));
                    GeneralPath generalPath3 = new GeneralPath(double_);
                    GeneralPath generalPath4 = new GeneralPath(float_);
                    generalPath.moveTo(f4, f5);
                    generalPath.lineTo(f6, f7);
                    generalPath2.moveTo(f8, f9);
                    generalPath2.lineTo(f10, f11);
                    this.getAxisY[i] = new GeneralPath();
                    ((GeneralPath)this.getAxisY[i]).append(generalPath4, false);
                    ((GeneralPath)this.getAxisY[i]).append(generalPath3, false);
                    ((GeneralPath)this.getAxisY[i]).append(generalPath2, false);
                    ((GeneralPath)this.getAxisY[i]).append(generalPath, false);
                    continue block5;
                }
                case 1: {
                    this.getAxisY[i] = new Arc2D.Double((this.cos[i][0] + f2) / 2.0f, (this.cos[i][1] + f3) / 2.0f, ((double)f + (double)this.getGaugeDialCurveStyle / 2.0) * 2.0, ((double)f + (double)this.getGaugeDialCurveStyle / 2.0) * 2.0, this.getGaugeDialStartAngle, this.getGaugeDialOuterInnerGap, 0);
                    continue block5;
                }
                case 3: {
                    continue block5;
                }
            }
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        for (int i = 0; i < this.contains; ++i) {
            this.clone[i].paint(graphics2D);
        }
    }

    @Override
    float[][] getStaticHintLocation() {
        return null;
    }

    @Override
    Shape[][] getItemShapes() {
        return this.getFormatedHintValue;
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return this.getAxisYProperties[n];
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.getFormatedHintValue[n][n2];
    }

    @Override
    public String[] search(int n, int n2) {
        this.drilldown = null;
        for (int i = 0; i < this.Z; ++i) {
            for (int j = 0; j < this.contains; ++j) {
                if (this.getFormatedHintValue[i][j] == null || !this.getFormatedHintValue[i][j].contains(n, n2)) continue;
                this.drilldown = new int[2];
                this.drilldown[0] = i;
                this.drilldown[1] = j;
                return this.axisY[i][j];
            }
        }
        return null;
    }

    @Override
    public int searchSeries(int n, int n2) {
        for (int i = 0; i < this.Z; ++i) {
            if (!this.getAxisYProperties[i].contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    public boolean searchGrid(int n, int n2) {
        for (int i = 0; i < this.contains; ++i) {
            for (int j = 0; j < this.getChartDataSetModel[0].length; ++j) {
                if (!this.getChartDataSetModel[i][j].intersects(n - 2, n2 - 2, 5.0, 5.0)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean searchAxis(int n, int n2) {
        switch (this.paper.getProperties().getAxisYProperties().getTickMarkType()) {
            case 3: {
                for (int i = 0; i < this.contains; ++i) {
                    Arc2D.Float float_ = new Arc2D.Float(this.cos[i][0] + 5.0f + this.getGaugeDialCurveStyle, this.cos[i][1] + 5.0f + this.getGaugeDialCurveStyle, 2.0f * (this.C - 5.0f - this.getGaugeDialCurveStyle), 2.0f * (this.C - 5.0f - this.getGaugeDialCurveStyle), this.getGaugeDialStartAngle, this.getGaugeDialStopAngle, 0);
                    Arc2D.Float float_2 = new Arc2D.Float(this.cos[i][0] - 5.0f + this.getGaugeDialCurveStyle, this.cos[i][1] - 5.0f + this.getGaugeDialCurveStyle, 2.0f * (this.C + 5.0f - this.getGaugeDialCurveStyle), 2.0f * (this.C + 5.0f - this.getGaugeDialCurveStyle), this.getGaugeDialStartAngle, this.getGaugeDialStopAngle, 0);
                    Arc2D.Float float_3 = new Arc2D.Float(this.cos[i][0] + 5.0f, this.cos[i][1] + 5.0f, 2.0f * (this.C - 5.0f), 2.0f * (this.C - 5.0f), this.getGaugeDialStartAngle, this.getGaugeDialStopAngle, 0);
                    Arc2D.Float float_4 = new Arc2D.Float(this.cos[i][0] - 5.0f, this.cos[i][1] - 5.0f, 2.0f * (this.C + 5.0f), 2.0f * (this.C + 5.0f), this.getGaugeDialStartAngle, this.getGaugeDialStopAngle, 0);
                    if ((float_.contains(n, n2) || !float_2.contains(n, n2)) && (float_3.contains(n, n2) || !float_4.contains(n, n2))) continue;
                    return true;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.contains; ++i) {
                    Arc2D.Float float_ = new Arc2D.Float(this.cos[i][0] + 5.0f + this.getGaugeDialCurveStyle, this.cos[i][1] + 5.0f + this.getGaugeDialCurveStyle, 2.0f * (this.C - 5.0f - this.getGaugeDialCurveStyle), 2.0f * (this.C - 5.0f - this.getGaugeDialCurveStyle), this.getGaugeDialStartAngle, this.getGaugeDialStopAngle, 0);
                    Arc2D.Float float_5 = new Arc2D.Float(this.cos[i][0] - 5.0f + this.getGaugeDialCurveStyle, this.cos[i][1] - 5.0f + this.getGaugeDialCurveStyle, 2.0f * (this.C + 5.0f - this.getGaugeDialCurveStyle), 2.0f * (this.C + 5.0f - this.getGaugeDialCurveStyle), this.getGaugeDialStartAngle, this.getGaugeDialStopAngle, 0);
                    if (float_.contains(n, n2) || !float_5.contains(n, n2)) continue;
                    return true;
                }
                break;
            }
            case 0: 
            case 1: {
                for (int i = 0; i < this.contains; ++i) {
                    Arc2D.Float float_ = new Arc2D.Float(this.cos[i][0] + 5.0f, this.cos[i][1] + 5.0f, 2.0f * (this.C - 5.0f), 2.0f * (this.C - 5.0f), this.getGaugeDialStartAngle, this.getGaugeDialStopAngle, 0);
                    Arc2D.Float float_6 = new Arc2D.Float(this.cos[i][0] - 5.0f, this.cos[i][1] - 5.0f, 2.0f * (this.C + 5.0f), 2.0f * (this.C + 5.0f), this.getGaugeDialStartAngle, this.getGaugeDialStopAngle, 0);
                    if (float_.contains(n, n2) || !float_6.contains(n, n2)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public Shape getNormalArea(int n) {
        return this.getChartLink[n][0];
    }

    public Shape getAlertArea(int n) {
        return this.getChartLink[n][1];
    }

    public Shape getErrorArea(int n) {
        return this.getChartLink[n][2];
    }

    public Shape getAxisPaths(int n) {
        return this.getBounds[n];
    }

    public Shape[][] getAxisPaths() {
        return this.getGaugeErrorValueMin;
    }

    public Shape[] getTickPath(int n) {
        return this.getCategorySize[n];
    }

    public Shape[] getGridPath(int n) {
        return this.getChartDataSetModel[n];
    }

    public Shape[][] getGridPath() {
        return this.getChartDataSetModel;
    }

    public ChartLabelBase[] getLabels() {
        return this.getGaugeAlertValueMin;
    }

    public float[][] getAxisLabelsPos(int n) {
        return this.get[n];
    }

    public Shape getCurvePath(int n) {
        return this.getAxisY[n];
    }

    public ChartLabelBase getCategoryLabel(int n) {
        return this.getGaugeAlertValueMax[n];
    }

    public float getCategoryLabelsX(int n) {
        return this.getAxisXProperties[n][0];
    }

    public float getCategoryLabelsY(int n) {
        return this.getAxisXProperties[n][1];
    }

    public float getCenterX(int n) {
        return this.floatValue[n][0];
    }

    public float getCenterY(int n) {
        return this.floatValue[n][1];
    }

    public Line2D getArrowLine(int n, int n2) {
        return this.getDimension[n][n2];
    }

    public Shape getArrowPath(int n, int n2) {
        return this.getChartLinkInfo[n][n2];
    }

    public float[] getArrowPoint(int n, int n2) {
        return this.getCondition[n][n2];
    }

    public double getValueAngle(int n, int n2) {
        return this.getGaugeErrorValueMax[n][n2];
    }

    public float getOuterInnerGap() {
        return this.getGaugeDialCurveStyle;
    }

    private float getCategorySize(float f) {
        float f2;
        boolean bl = this.objectProperties.getGaugeDialStartAngle() >= 0.0f && this.objectProperties.getGaugeDialStartAngle() <= 180.0f && this.objectProperties.getGaugeDialStopAngle() >= 0.0f && this.objectProperties.getGaugeDialStopAngle() <= 180.0f;
        int[] nArray = this.abs();
        float f3 = (float)this.paper.getBounds().width * this.paper.getProperties().getScaleX();
        float f4 = f3 / (float)nArray[1];
        f4 /= 2.0f;
        float f5 = f;
        int n = ((ChartNumericAxis)this.layer.getAxisY()).getNumOfTick();
        float f6 = this.paper.getProperties().getAxisYProperties().getTickMarkLength();
        float f7 = this.paper.getProperties().getAxisYProperties().getLabelAxisGap();
        ChartTextStyle chartTextStyle = (ChartTextStyle)this.paper.getProperties().getAxisYProperties().getLabelTextStyle().clone();
        float f8 = this.objectProperties.getGaugeDialStartAngle();
        if (f8 > (f2 = this.objectProperties.getGaugeDialStopAngle())) {
            f2 = f8 + f2;
            f8 = f2 - f8;
            f2 -= f8;
        }
        String[] stringArray = ((ChartNumericAxis)this.layer.getAxisY()).getLabels();
        int n2 = 0;
        if (stringArray != null) {
            n2 = n < stringArray.length ? n : stringArray.length;
        }
        float f9 = 0.0f;
        float f10 = 0.0f;
        for (int i = 0; i < n2 && n > 0; ++i) {
            f10 = 0.0f;
            if (stringArray == null) continue;
            double d = Math.PI * 2 * (double)(f8 + (f2 - f8) * (float)i / (float)(360 * n));
            float f11 = (float)Math.cos(d);
            f10 += Math.abs(f11 * (f6 + f7));
            Rectangle2D rectangle2D = chartTextStyle.getDimension(stringArray[i]);
            float f12 = 0.0f;
            if (f11 > 0.0f) {
                f12 = (float)((double)(f11 * (f6 + f7 + f5)) + rectangle2D.getWidth());
                if (f12 > f4 && f11 != 0.0f) {
                    f10 += Math.abs((f12 - f4) / f11);
                }
            } else if (f11 < 0.0f && (f12 = (float)((double)(f11 * (f6 + f7)) - rectangle2D.getWidth())) < -f4 && f11 != 0.0f) {
                f10 += Math.abs((f12 + f4) / f11);
            }
            f9 = f9 < f10 ? f10 : f9;
        }
        f9 = f - f9;
        f9 = (f9 -= 3.0f) < 10.0f ? 10.0f : f9;
        return f9;
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        int[] nArray = null;
        int n3 = this.dataset.getShowValueBeginIndex();
        int n4 = this.dataset.getShowValueEndIndex();
        int n5 = n4 - n3;
        int n6 = this.Z / n5;
        for (int i = 0; i < this.Z; ++i) {
            for (int j = 0; j < this.contains; ++j) {
                if (this.getFormatedHintValue[i][j] == null || !this.getFormatedHintValue[i][j].contains(n, n2)) continue;
                ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(i, j);
                if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                    int n7 = 0;
                    n7 = i + 1 > n6 ? i - i / n6 * n6 : i;
                    nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(n7)).get(j)).getChartLinkInfo();
                }
                return nArray;
            }
        }
        return null;
    }
}

