/*
 * Decompiled with CFR 0.152.
 */
package chart.graphics;

import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGraphicsUtil;
import com.jinfonet.util.JRLog;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import jet.util.JRInterruptedException;

public class ChartCustomizedPattern
implements ChartFillPattern {
    public static final int TILED = 0;
    public static final int CENTERED = 1;
    public static final int SCALED = 2;
    private String SEDU = null;
    private Rectangle2D.Float copyImage;
    private int drawImage;
    private float fill;
    private BufferedImage fillScaledImage;
    private BufferedImage getBounds;
    private Image getClip = null;

    public ChartCustomizedPattern(String string) {
        this(string, new Rectangle2D.Float(), 1, 0.0f);
    }

    public ChartCustomizedPattern(String string, Rectangle2D.Float float_, int n) {
        this(string, float_, n, 0.0f);
    }

    public ChartCustomizedPattern(String string, Rectangle2D.Float float_, int n, float f) {
        this.getBounds = ChartGraphicsUtil.copyImage(string, new Container());
        if (this.getBounds == null) {
            return;
        }
        this.SEDU = string;
        this.copyImage = float_;
        this.drawImage = n;
        this.fill = f;
    }

    public ChartCustomizedPattern(Image image, Rectangle2D.Float float_, int n, float f) {
        this(image, float_, n, f, "");
    }

    public ChartCustomizedPattern(Image image, Rectangle2D.Float float_, int n, float f, String string) {
        this.getBounds = ChartGraphicsUtil.copyImage(image);
        if (this.getBounds == null) {
            return;
        }
        this.SEDU = string;
        this.getClip = image;
        this.copyImage = float_;
        this.drawImage = n;
        this.fill = f;
    }

    public void setAnchor(Rectangle2D.Float float_) {
        this.copyImage = float_;
        this.fillScaledImage = null;
    }

    public Rectangle2D.Float getAnchor() {
        return this.copyImage;
    }

    public int getLayout() {
        return this.drawImage;
    }

    public void setLayout(int n) {
        this.drawImage = n;
        this.fillScaledImage = null;
    }

    public String getImageName() {
        return this.SEDU;
    }

    public BufferedImage getImageCopy() {
        return this.getBounds;
    }

    @Override
    public void setAlpha(float f) {
        this.fill = f;
    }

    @Override
    public float getAlpha() {
        return this.fill;
    }

    public boolean hasImage() {
        if (this.fillScaledImage == null) {
            this.fillScaledImage = this.SEDU();
        }
        return this.fillScaledImage != null;
    }

    @Override
    public Paint getPaint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        return null;
    }

    @Override
    public void fill(Graphics2D graphics2D, Shape shape) {
        if (!this.hasImage()) {
            return;
        }
        AlphaComposite alphaComposite = null;
        alphaComposite = AlphaComposite.getInstance(3, 1.0f - this.fill);
        Composite composite = graphics2D.getComposite();
        Paint paint = graphics2D.getPaint();
        graphics2D.setComposite(alphaComposite);
        int n = this.fillScaledImage.getWidth();
        int n2 = this.fillScaledImage.getHeight();
        if (n <= 0 || n2 <= 0) {
            return;
        }
        Rectangle rectangle = shape.getBounds();
        AffineTransformOp affineTransformOp = null;
        switch (this.drawImage) {
            case 0: {
                int n3 = rectangle.x;
                int n4 = rectangle.y;
                TexturePaint texturePaint = new TexturePaint(this.fillScaledImage, new Rectangle2D.Float(n3, n4, n, n2));
                graphics2D.setPaint(texturePaint);
                graphics2D.fill(shape);
                break;
            }
            case 1: {
                int n5 = (rectangle.width - n) / 2 + rectangle.x;
                int n6 = (rectangle.height - n2) / 2 + rectangle.y;
                affineTransformOp = new AffineTransformOp(new AffineTransform(), 2);
                if (rectangle.height < n2 || rectangle.width < n) {
                    Shape shape2 = graphics2D.getClip();
                    graphics2D.setClip(rectangle);
                    graphics2D.drawImage(this.fillScaledImage, affineTransformOp, n5, n6);
                    graphics2D.setClip(shape2);
                    break;
                }
                graphics2D.drawImage(this.fillScaledImage, affineTransformOp, n5, n6);
                break;
            }
            case 2: {
                this.fillScaledImage(graphics2D, shape, this.fillScaledImage);
            }
        }
        graphics2D.setPaint(paint);
        graphics2D.setComposite(composite);
    }

    public void fillScaledImage(Graphics2D graphics2D, Shape shape, BufferedImage bufferedImage) {
        block5: {
            if (bufferedImage == null) {
                return;
            }
            AlphaComposite alphaComposite = null;
            alphaComposite = AlphaComposite.getInstance(3, 1.0f - this.fill);
            graphics2D.setComposite(alphaComposite);
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            if (n <= 0 || n2 <= 0) {
                return;
            }
            Rectangle rectangle = shape.getBounds();
            AffineTransformOp affineTransformOp = null;
            try {
                AffineTransform affineTransform = AffineTransform.getScaleInstance((double)rectangle.width / (double)n, (double)rectangle.height / (double)n2);
                affineTransformOp = new AffineTransformOp(affineTransform, 2);
                graphics2D.drawImage(bufferedImage, affineTransformOp, rectangle.x, rectangle.y);
            }
            catch (JRInterruptedException jRInterruptedException) {
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) break block5;
                JRLog.trace(2, exception);
            }
        }
    }

    @Override
    public Object clone() {
        return new ChartCustomizedPattern(this.SEDU, this.copyImage, this.drawImage, this.fill);
    }

    private BufferedImage SEDU() {
        if (this.getBounds == null) {
            return null;
        }
        int n = this.getBounds.getWidth();
        int n2 = this.getBounds.getHeight();
        int n3 = (int)((float)n * this.copyImage.x);
        int n4 = (int)((float)n2 * this.copyImage.y);
        n = (int)((float)n * this.copyImage.width);
        n2 = (int)((float)n2 * this.copyImage.height);
        try {
            BufferedImage bufferedImage = this.getBounds.getSubimage(n3, n4, n, n2);
            return bufferedImage;
        }
        catch (JRInterruptedException jRInterruptedException) {
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void highLightFill(Graphics2D graphics2D, Shape shape, int n) {
    }

    public int[] getImageWidthAndHeight() {
        int[] nArray = new int[2];
        if (this.hasImage()) {
            nArray[0] = this.fillScaledImage.getWidth();
            nArray[1] = this.fillScaledImage.getHeight();
        }
        return nArray;
    }
}

