/*
 * Decompiled with CFR 0.152.
 */
package chart.graphics;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class RoundGradientContext
implements PaintContext {
    protected Point2D mPoint;
    protected Point2D mRadius;
    protected Color mC1;
    protected Color mC2;

    public RoundGradientContext(Point2D point2D, Color color, Point2D point2D2, Color color2) {
        this.mPoint = point2D;
        this.mC1 = color;
        this.mRadius = point2D2;
        this.mC2 = color2;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int n, int n2, int n3, int n4) {
        WritableRaster writableRaster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
        int[] nArray = new int[n3 * n4 * 4];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d;
                double d2 = this.mPoint.distance(n + j, n2 + i);
                double d3 = d2 / (d = this.mRadius.distance(0.0, 0.0));
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                int n5 = (i * n3 + j) * 4;
                nArray[n5 + 0] = (int)((double)this.mC1.getRed() + d3 * (double)(this.mC2.getRed() - this.mC1.getRed()));
                nArray[n5 + 1] = (int)((double)this.mC1.getGreen() + d3 * (double)(this.mC2.getGreen() - this.mC1.getGreen()));
                nArray[n5 + 2] = (int)((double)this.mC1.getBlue() + d3 * (double)(this.mC2.getBlue() - this.mC1.getBlue()));
                nArray[n5 + 3] = (int)((double)this.mC1.getAlpha() + d3 * (double)(this.mC2.getAlpha() - this.mC1.getAlpha()));
            }
        }
        writableRaster.setPixels(0, 0, n3, n4, nArray);
        return writableRaster;
    }
}

