/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import jet.util.Base64;

public class ChartTextProConverter {
    public static final short INTEGER = 1;
    public static final short LONG = 2;
    public static final short FLOAT = 3;
    public static final short DOUBLE = 4;
    public static final short BOOLEAN = 5;
    public static final short STRING = 6;
    public static final short SUBMAP = 7;
    public static final short SUBLIST = 8;
    public static final short NULLVALUE = 9;
    public static final short TIMESTAMP = 10;
    public static final short BIGDECIMAL = 11;
    public static final short BIGINTEGER = 12;
    public static final short SQLDATE = 13;
    public static final short UTILDATE = 14;
    public static final short SQLTIME = 15;
    private String SEDU;

    public ChartTextProConverter(String string) {
        this.SEDU = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map convert() throws IOException {
        byte[] byArray = Base64.decode(this.SEDU.getBytes());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        FilterInputStream filterInputStream = null;
        Map map = null;
        try {
            if (byArray[0] == 80 && byArray[1] == 75) {
                ZipInputStream zipInputStream = new ZipInputStream(byteArrayInputStream);
                zipInputStream.getNextEntry();
                filterInputStream = new DataInputStream(zipInputStream);
            } else {
                filterInputStream = new DataInputStream(byteArrayInputStream);
            }
            map = this.SEDU((DataInput)((Object)filterInputStream));
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
        return map;
    }

    private Map SEDU(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(n);
        for (int i = 0; i < n; ++i) {
            String string = dataInput.readUTF();
            Object object = null;
            short s = dataInput.readShort();
            switch (s) {
                case 1: {
                    object = new Integer(dataInput.readInt());
                    break;
                }
                case 2: {
                    object = new Long(dataInput.readLong());
                    break;
                }
                case 3: {
                    object = new Float(dataInput.readFloat());
                    break;
                }
                case 4: {
                    object = new Double(dataInput.readDouble());
                    break;
                }
                case 5: {
                    object = new Boolean(dataInput.readBoolean());
                    break;
                }
                case 6: {
                    object = dataInput.readUTF();
                    break;
                }
                case 12: {
                    object = new BigInteger(dataInput.readUTF());
                    break;
                }
                case 11: {
                    object = new BigDecimal(dataInput.readUTF());
                    break;
                }
                case 7: {
                    object = this.SEDU(dataInput);
                    break;
                }
                case 8: {
                    object = this.add(dataInput);
                    break;
                }
                case 9: {
                    object = null;
                    break;
                }
                case 10: {
                    object = new Timestamp(dataInput.readLong());
                    break;
                }
                case 13: {
                    object = new Date(dataInput.readLong());
                    break;
                }
                case 14: {
                    object = new java.util.Date(dataInput.readLong());
                    break;
                }
                case 15: {
                    object = new Time(dataInput.readLong());
                    break;
                }
                default: {
                    throw new IOException("Unknow properties type:" + s);
                }
            }
            hashMap.put(string, object);
        }
        return hashMap;
    }

    private List add(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            Object object = null;
            short s = dataInput.readShort();
            switch (s) {
                case 1: {
                    object = new Integer(dataInput.readInt());
                    break;
                }
                case 2: {
                    object = new Long(dataInput.readLong());
                    break;
                }
                case 3: {
                    object = new Float(dataInput.readFloat());
                    break;
                }
                case 4: {
                    object = new Double(dataInput.readDouble());
                    break;
                }
                case 5: {
                    object = new Boolean(dataInput.readBoolean());
                    break;
                }
                case 6: {
                    object = dataInput.readUTF();
                    break;
                }
                case 7: {
                    object = this.SEDU(dataInput);
                    break;
                }
                case 8: {
                    object = this.add(dataInput);
                    break;
                }
                case 11: {
                    object = new BigDecimal(dataInput.readUTF());
                    break;
                }
                case 12: {
                    object = new BigInteger(dataInput.readUTF());
                    break;
                }
                case 9: {
                    object = null;
                    break;
                }
                case 10: {
                    object = new Timestamp(dataInput.readLong());
                    break;
                }
                case 13: {
                    object = new Date(dataInput.readLong());
                    break;
                }
                case 14: {
                    object = new java.util.Date(dataInput.readLong());
                    break;
                }
                case 15: {
                    object = new Time(dataInput.readLong());
                    break;
                }
                default: {
                    throw new IOException("Unknow properties type:" + s);
                }
            }
            arrayList.add(object);
        }
        return arrayList;
    }
}

