/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.ChartComponent;
import chart.ChartLabelBase;
import chart.ChartObject;
import chart.graphics.ChartIcon;
import chart.graphics.ChartTextStyle;
import chart.properties.ChartLabelProperties;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class ChartLabel
extends ChartComponent {
    private ChartLabelBase SEDU;
    public static final int LEFT_TOP = 0;
    public static final int LEFT_CENTER = 1;
    public static final int LEFT_BOTTOM = 2;
    public static final int CENTER_TOP = 3;
    public static final int CENTER_CENTER = 4;
    public static final int CENTER_BOTTOM = 5;
    public static final int RIGHT_TOP = 6;
    public static final int RIGHT_CENTER = 7;
    public static final int RIGHT_BOTTOM = 8;
    private int ceil = -1;
    private boolean contains = true;
    private float getBackground;
    private float getBorderStyle;
    public static final int CUSTOMIZED_TITLE = 0;
    public static final int CHART_TITLE = 1;
    public static final int AXIS_X_TITLE = 2;
    public static final int AXIS_Y_TITLE = 3;
    public static final int AXIS_Y2_TITLE = 4;
    private int getBottomMargin = 0;
    private int getBounds = -1;
    private boolean getCoreArea = false;

    public ChartLabel() {
        this.SEDU = new ChartLabelBase(new ChartLabelProperties());
    }

    public ChartLabel(ChartLabelProperties chartLabelProperties) {
        this.getBottomMargin = chartLabelProperties.getTitleType();
        this.SEDU = new ChartLabelBase(chartLabelProperties);
    }

    public ChartLabel(String string) {
        ChartLabelProperties chartLabelProperties = new ChartLabelProperties();
        chartLabelProperties.setText(string);
        this.SEDU = new ChartLabelBase(chartLabelProperties);
    }

    public void doLayout() {
    }

    @Override
    public void init() {
    }

    @Override
    public void locate() {
        ChartLabelProperties chartLabelProperties = this.SEDU.getLabelBaseProperties();
        if (chartLabelProperties.getTextStyle().getWordWrapper()) {
            if (chartLabelProperties.getIcon() != null) {
                if (chartLabelProperties.getIcon().isNoIcon()) {
                    chartLabelProperties.getTextStyle().setWordWrap((float)this.getCoreArea().getBounds().getWidth());
                } else {
                    chartLabelProperties.getTextStyle().setWordWrap((float)(this.getCoreArea().getBounds().getWidth() - (double)chartLabelProperties.getIcon().getIconWidth() - (double)chartLabelProperties.getIconTextGap()));
                }
            } else {
                chartLabelProperties.getTextStyle().setWordWrap((float)this.getCoreArea().getBounds().getWidth());
            }
        }
        this.SEDU.setLabelBaseProperties(chartLabelProperties);
        this.SEDU.locate();
        Rectangle rectangle = this.getCoreArea();
        Dimension dimension = this.SEDU.getLabelBaseDimension();
        float f = dimension.width;
        float f2 = dimension.height;
        float f3 = (float)rectangle.width - f;
        float f4 = (float)rectangle.height - f2;
        this.getBackground = 0.0f;
        this.getBorderStyle = 0.0f;
        f3 = f3 < 0.0f ? 0.0f : f3;
        f4 = f4 < 0.0f ? 0.0f : f4;
        float f5 = chartLabelProperties.getLeftMargin();
        float f6 = chartLabelProperties.getTopMargin();
        float f7 = chartLabelProperties.getBottomMargin();
        float f8 = chartLabelProperties.getRightMargin();
        float f9 = 0.0f;
        float f10 = 0.0f;
        int n = 0;
        int n2 = 0;
        if (chartLabelProperties.getBackground() != null) {
            n = chartLabelProperties.getBackground().getBorderStyle();
            if (n != 0) {
                n2 = (int)chartLabelProperties.getBackground().getPen().getPenWidth();
            }
            f5 += (float)n2;
            f6 += (float)n2;
            f7 += (float)n2;
            f8 += (float)n2;
        }
        switch (chartLabelProperties.getTextAlignment()) {
            case 0: {
                this.getBackground = (float)rectangle.x + f5;
                this.getBorderStyle = (float)rectangle.y + f6;
                break;
            }
            case 3: {
                this.getBackground = (float)rectangle.x + f3 / 2.0f;
                this.getBorderStyle = (float)rectangle.y + f6;
                break;
            }
            case 6: {
                this.getBackground = (float)rectangle.x + f3 - f8 - 2.0f;
                this.getBorderStyle = (float)rectangle.y + f6;
                break;
            }
            case 1: {
                this.getBackground = (float)rectangle.x + f5;
                this.getBorderStyle = (float)rectangle.y + f4 / 2.0f;
                break;
            }
            case 4: {
                this.getBackground = (float)rectangle.x + f3 / 2.0f;
                this.getBorderStyle = (float)rectangle.y + f4 / 2.0f;
                break;
            }
            case 7: {
                this.getBackground = (float)rectangle.x + f3 - f8 - 2.0f;
                this.getBorderStyle = (float)rectangle.y + f4 / 2.0f;
                break;
            }
            case 2: {
                f9 = this.SEDU.getLabelBaseProperties().getTextStyle().getTextDescend();
                this.getBackground = (float)rectangle.x + f5;
                this.getBorderStyle = (float)rectangle.y + f4 - f7 - (float)Math.ceil(f9);
                break;
            }
            case 5: {
                f9 = this.SEDU.getLabelBaseProperties().getTextStyle().getTextDescend();
                this.getBackground = (float)rectangle.x + f3 / 2.0f;
                this.getBorderStyle = (float)rectangle.y + f4 - f7 - (float)Math.ceil(f9);
                break;
            }
            case 8: {
                f9 = this.SEDU.getLabelBaseProperties().getTextStyle().getTextDescend();
                this.getBackground = (float)rectangle.x + f3 - f8 - 2.0f;
                this.getBorderStyle = (float)rectangle.y + f4 - f7 - (float)Math.ceil(f9);
                break;
            }
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        this.background = this.getProperties().getBackground();
        super.paint(graphics2D);
        this.SEDU.paint(graphics2D, this.getBackground, this.getBorderStyle);
        super.paintBorder(graphics2D);
    }

    public float getIconTextGap() {
        return this.SEDU.getLabelBaseProperties().getIconTextGap();
    }

    public void setIconTextGap(int n) {
        this.SEDU.getLabelBaseProperties().setIconTextGap(n);
    }

    public int getIconWidth() {
        return this.SEDU.getLabelBaseProperties().getIcon().getIconWidth();
    }

    public int getIconHeight() {
        return this.SEDU.getLabelBaseProperties().getIcon().getIconHeight();
    }

    public int getIconStyle() {
        return this.SEDU.getLabelBaseProperties().getIcon().getIconStyle();
    }

    public void setIconStyle(int n) {
        this.SEDU.getLabelBaseProperties().getIcon().setIconStyle(n);
    }

    public void setIconWidth(int n) {
        this.SEDU.getLabelBaseProperties().getIcon().setIconWidth(n);
    }

    public void setIconHeight(int n) {
        this.SEDU.getLabelBaseProperties().getIcon().setIconHeight(n);
    }

    public ChartIcon getIcon() {
        return this.SEDU.getLabelBaseProperties().getIcon();
    }

    public void setIcon(ChartIcon chartIcon) {
        this.SEDU.getLabelBaseProperties().setIcon(chartIcon);
    }

    public int getTextAlignment() {
        return this.SEDU.getLabelBaseProperties().getTextAlignment();
    }

    public void setTextAlignment(int n) {
        this.SEDU.getLabelBaseProperties().setTextAlignment(n);
    }

    public int getIconAlignment() {
        return this.SEDU.getLabelBaseProperties().getIconAlignment();
    }

    public void setIconAlignment(int n) {
        this.SEDU.getLabelBaseProperties().setIconAlignment(n);
    }

    public void setChartTextStyle(ChartTextStyle chartTextStyle) {
        this.SEDU.getLabelBaseProperties().setTextStyle(chartTextStyle);
    }

    public ChartTextStyle getChartTextStyle() {
        return this.SEDU.getLabelBaseProperties().getTextStyle();
    }

    public void setText(String string) {
        this.SEDU.setLabelText(string);
    }

    public String getText() {
        return this.SEDU.getLabelText();
    }

    public void setFont(Font font) {
        if (this.SEDU.getLabelBaseProperties().getTextStyle() != null) {
            this.SEDU.getLabelBaseProperties().getTextStyle().setFont(font);
        }
    }

    public void setForeground(Color color) {
        if (this.SEDU.getLabelBaseProperties().getTextStyle() != null) {
            this.SEDU.getLabelBaseProperties().getTextStyle().setForeground(color);
        }
    }

    public int getLegendIndex() {
        return this.ceil;
    }

    public void setLegendIndex(int n) {
        this.ceil = n;
    }

    public boolean getApplyAll() {
        return this.contains;
    }

    public void setApplyAll(boolean bl) {
        this.contains = bl;
    }

    public ChartLabelProperties getProperties() {
        return this.SEDU.getLabelBaseProperties();
    }

    public void setProperties(ChartLabelProperties chartLabelProperties) {
        this.SEDU.setLabelBaseProperties(chartLabelProperties);
    }

    @Override
    public ChartObject getChartObject(int n, int n2) {
        return this;
    }

    public boolean contains(int n, int n2) {
        return this.getBounds().contains(n, n2);
    }

    public int getTitleType() {
        return this.getBottomMargin;
    }

    public void setTitleType(int n) {
        this.getBottomMargin = n;
    }

    public void setID(int n) {
        this.getBounds = n;
    }

    public int getID() {
        return this.getBounds;
    }

    public boolean isTitle() {
        if (this.SEDU != null) {
            return this.SEDU.isTitle();
        }
        return false;
    }

    public void setTitle(boolean bl) {
        if (this.SEDU != null) {
            this.SEDU.setTitle(bl);
        }
    }

    public void setIsAutoTitle(boolean bl) {
        this.getCoreArea = bl;
    }

    public boolean isAutoTitle() {
        return this.getCoreArea;
    }

    public void setOnlyDrawIcon(boolean bl) {
        if (this.SEDU != null) {
            this.SEDU.setOnlyDrawIcon(bl);
        }
    }

    public boolean getOnlyDrawIcon() {
        if (this.SEDU != null) {
            return this.SEDU.getOnlyDrawIcon();
        }
        return false;
    }
}

