/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.graphics.ChartTextStyle;
import chart.properties.ChartLabelProperties;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class ChartLabelBase {
    public static final int LEFT_TOP = 0;
    public static final int LEFT_CENTER = 1;
    public static final int LEFT_BOTTOM = 2;
    public static final int RIGHT_TOP = 3;
    public static final int RIGHT_CENTER = 4;
    public static final int RIGHT_BOTTOM = 5;
    public static final int CENTER_TOP = 6;
    public static final int CENTER_BOTTOM = 7;
    private ChartLabelProperties SEDU;
    private Dimension ceil;
    private float cos = 0.0f;
    private float drawText = 0.0f;
    private float getDimension = 0.0f;
    private float getHeight = 0.0f;
    private boolean getIcon;
    private boolean getIconAlignment;
    private float getIconHeight = 0.0f;
    private boolean getIconStyle = false;
    private boolean getIconTextGap;

    public ChartLabelBase(ChartLabelProperties chartLabelProperties) {
        this.SEDU = chartLabelProperties;
        this.ceil();
        this.getIcon = false;
    }

    public ChartLabelBase(String string) {
        this.SEDU = new ChartLabelProperties();
        this.SEDU.setText(string);
        this.getIcon = false;
    }

    public ChartLabelBase(String string, ChartLabelProperties chartLabelProperties) {
        this.SEDU = chartLabelProperties;
        this.SEDU.setText(string);
        this.getIcon = false;
    }

    public void locate() {
        this.SEDU();
        float f = 0.0f;
        float f2 = 0.0f;
        this.cos = 0.0f;
        this.drawText = 0.0f;
        this.getDimension = 0.0f;
        this.getHeight = 0.0f;
        ChartTextStyle chartTextStyle = this.SEDU.getTextStyle();
        String string = this.SEDU.getText();
        Rectangle2D.Float float_ = (Rectangle2D.Float)chartTextStyle.getDimension(string);
        float f3 = float_.width;
        float f4 = float_.height;
        if (this.SEDU.getIcon() != null) {
            if (!this.getIconStyle) {
                f = this.SEDU.getIcon().getIconWidth();
                f2 = this.SEDU.getIcon().getIconHeight();
            } else if (this.SEDU.getIcon().getIconStyle() != 9) {
                f = this.SEDU.getIcon().getIconWidth();
                f2 = this.SEDU.getIcon().getIconHeight();
            }
        }
        if (chartTextStyle.getUnderline() != 0 && chartTextStyle.getRotation() == 0.0) {
            this.getIconAlignment = true;
            this.getIconHeight = chartTextStyle.getUnderlineHeight();
            f4 += this.getIconHeight;
        }
        if (chartTextStyle.getRotation() == 0.0) {
            this.drawText = chartTextStyle.getWordWrapper() ? (float)((int)Math.ceil(chartTextStyle.getWordWrapFristLineHeight())) : f4;
        } else {
            double d = Math.PI;
            double d2 = chartTextStyle.getRotation();
            d2 = d2 < 0.0 ? d * 2.0 + d2 % (d * 2.0) : d2 % (d * 2.0);
            String string2 = "";
            chartTextStyle.setRotation(0.0);
            if (string != null && string.length() >= 1) {
                string2 = string.substring(0, 1);
            }
            double d3 = chartTextStyle.getDimension(string2).getHeight();
            double d4 = d2 / Math.PI * 180.0;
            if (d4 != 0.0) {
                if (d4 <= 90.0) {
                    this.drawText += (float)Math.ceil(d3 * Math.cos(d2));
                } else if (d4 > 90.0 && d4 <= 180.0) {
                    this.cos += f3;
                    this.drawText += (float)Math.ceil(-d3 * Math.cos(d2));
                } else if (d4 > 180.0 && d4 <= 270.0) {
                    this.cos += f3;
                    this.drawText += f4 - (float)Math.ceil(-d3 * Math.cos(d2));
                } else if (d4 > 270.0) {
                    this.cos += (float)Math.ceil(-d3 * Math.sin(d2));
                    this.drawText += f4;
                }
            }
            chartTextStyle.setRotation(d2);
        }
        int n = (int)this.SEDU.getIconTextGap();
        float f5 = f3;
        float f6 = f4;
        if (this.SEDU.getIcon() != null && !this.SEDU.getIcon().isNoIcon()) {
            f5 = f3 + f + (float)n;
            f6 = f2 + f4;
            switch (this.SEDU.getIconAlignment()) {
                case 0: {
                    this.cos += f + (float)n;
                    this.drawText += f2;
                    break;
                }
                case 1: {
                    this.cos += f + (float)n;
                    float f7 = f6 = f2 < f4 ? f2 : f4;
                    if (f4 > f2) {
                        this.getHeight += (f4 - f2) / 2.0f;
                        f6 = f4;
                    } else {
                        this.drawText += (f2 - f4) / 2.0f;
                        f6 = f2;
                    }
                    if (this.SEDU.getTextStyle().getRotation() != 0.0 || !(this.SEDU.getTextStyle().getWordWrapWidth() <= 0.0f)) break;
                    float f8 = this.SEDU.getTextStyle().getTextYoffset();
                    f8 = f8 < 0.0f ? 0.0f : f8;
                    this.drawText -= f8;
                    break;
                }
                case 2: {
                    this.getHeight += f4;
                    this.cos += f + (float)n;
                    break;
                }
                case 6: {
                    this.drawText += f2 + (float)n;
                    f6 += (float)n;
                    if (f > f3) {
                        this.cos += (f - f3) / 2.0f;
                        f5 = f;
                        break;
                    }
                    this.getDimension += (f3 - f) / 2.0f;
                    f5 = f3;
                    break;
                }
                case 7: {
                    this.getHeight += f4 + (float)n;
                    f6 += (float)n;
                    if (f > f3) {
                        this.cos += (f - f3) / 2.0f;
                        f5 = f;
                        break;
                    }
                    this.getDimension = (f3 - f) / 2.0f;
                    f5 = f3;
                    break;
                }
                case 3: {
                    this.getDimension = f3 + (float)n;
                    this.drawText += f2;
                    break;
                }
                case 4: {
                    this.getDimension = f3 + (float)n;
                    if (f2 > f4) {
                        this.drawText += (f2 - f4) / 2.0f;
                        f6 = f2;
                    } else {
                        this.getHeight += (f4 - f2) / 2.0f;
                        f6 = f4;
                    }
                    if (this.SEDU.getTextStyle().getRotation() != 0.0 || !(this.SEDU.getTextStyle().getWordWrapWidth() <= 0.0f)) break;
                    float f9 = this.SEDU.getTextStyle().getTextYoffset();
                    f9 = f9 < 0.0f ? 0.0f : f9;
                    break;
                }
                case 5: {
                    this.getDimension = f3 + (float)n;
                    this.getHeight += f4;
                    break;
                }
            }
        }
        this.ceil.width = (int)f5;
        this.ceil.height = (int)f6;
        this.getIcon = true;
    }

    public void paint(Graphics2D graphics2D, float f, float f2) {
        if (!this.getIcon) {
            this.locate();
        }
        if (this.getIconTextGap) {
            if (this.SEDU.getIcon() != null) {
                this.SEDU.getIcon().paintIcon(graphics2D, 0, 0);
            }
            return;
        }
        if (this.SEDU.getIcon() != null) {
            this.SEDU.getIcon().paintIcon(graphics2D, (int)(f + this.getDimension), (int)(f2 + this.getHeight));
        }
        if (this.getIconAlignment) {
            this.SEDU.getTextStyle().drawText(graphics2D, this.SEDU.getText(), f + this.cos, f2 + this.drawText - this.getIconHeight);
        } else {
            this.SEDU.getTextStyle().drawText(graphics2D, this.SEDU.getText(), f + this.cos, f2 + this.drawText);
        }
    }

    public void paintTextNoRotation(Graphics2D graphics2D, float f, float f2) {
        if (!this.getIcon) {
            this.locate();
        }
        this.SEDU.getTextStyle().drawText(graphics2D, this.SEDU.getText(), f, f2);
    }

    private void SEDU() {
        this.getIcon = false;
        this.ceil = new Dimension();
    }

    private void ceil() {
        if (this.SEDU.getText() == null) {
            this.SEDU.setText("");
        }
    }

    public Dimension getLabelBaseDimension() {
        return this.ceil;
    }

    public boolean isNoIcon() {
        return this.SEDU.getIcon() == null || this.SEDU.getIcon().isNoIcon();
    }

    public ChartTextStyle getChartTextStyle() {
        return this.SEDU.getTextStyle();
    }

    public void setChartTextStyle(ChartTextStyle chartTextStyle) {
        this.getIcon = false;
        this.SEDU.setTextStyle(chartTextStyle);
    }

    public String getLabelText() {
        return this.SEDU.getText();
    }

    public void setLabelText(String string) {
        this.getIcon = false;
        this.SEDU.setText(string);
    }

    public ChartLabelProperties getLabelBaseProperties() {
        return this.SEDU;
    }

    public void setLabelBaseProperties(ChartLabelProperties chartLabelProperties) {
        this.SEDU = chartLabelProperties;
        this.getIcon = false;
        this.ceil();
    }

    public void clearLabelBaseDimension() {
        this.ceil = null;
    }

    public boolean isTitle() {
        return this.getIconStyle;
    }

    public void setTitle(boolean bl) {
        this.getIconStyle = bl;
    }

    public void setOnlyDrawIcon(boolean bl) {
        this.getIconTextGap = bl;
    }

    public boolean getOnlyDrawIcon() {
        return this.getIconTextGap;
    }
}

