/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.ChartPlatform;
import chart.data.ChartTypeInfo;
import java.awt.Rectangle;

public class ChartLayoutManager {
    public static final int EAST = 0;
    public static final int WEST = 1;
    public static final int SOUTH = 2;
    public static final int NORTH = 3;

    public static Rectangle calculatePlatformRect(Rectangle rectangle, Rectangle rectangle2, int n) {
        Rectangle rectangle3 = null;
        if (rectangle == null) {
            return rectangle3;
        }
        if (rectangle2 == null) {
            return rectangle;
        }
        rectangle3 = (Rectangle)rectangle.clone();
        Rectangle rectangle4 = (Rectangle)rectangle2.clone();
        switch (n) {
            case 2: {
                rectangle3.height -= rectangle4.height;
                rectangle3.height = rectangle3.height < 0 ? 0 : rectangle3.height;
                break;
            }
            case 0: {
                rectangle3.width -= rectangle4.width;
                rectangle3.width = rectangle3.width < 0 ? 0 : rectangle3.width;
                break;
            }
            case 1: {
                rectangle3.x += rectangle4.width;
                rectangle3.width -= rectangle4.width;
                rectangle3.width = rectangle3.width < 0 ? 0 : rectangle3.width;
                break;
            }
            case 3: {
                rectangle3.y += rectangle4.height;
                rectangle3.height -= rectangle4.height;
                rectangle3.height = rectangle3.height < 0 ? 0 : rectangle3.height;
                break;
            }
        }
        return rectangle3;
    }

    public static Rectangle getPaperRect(ChartPlatform chartPlatform, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = (Rectangle)rectangle.clone();
        if (chartPlatform.getChartLegend() == null) {
            return (Rectangle)rectangle.clone();
        }
        if (chartPlatform.getChartLegend().getProperties() == null) {
            return (Rectangle)rectangle.clone();
        }
        int n = chartPlatform.getChartLegend().getProperties().getPlacement();
        if (!chartPlatform.getProperties().isShowLegend()) {
            n = 0;
        }
        if (chartPlatform.getDataSetModel() != null && chartPlatform.getDataSetModel().getDatasetInfos() != null && ChartTypeInfo.getPrimType(chartPlatform.getDataSetModel().getDatasetInfos()[0].getChartType()) == 10) {
            n = 0;
        }
        float[] fArray2 = chartPlatform.getChartLegend().getWHRate();
        switch (n) {
            case 4: {
                rectangle2.setSize((int)((float)rectangle3.width * (1.0f - fArray2[0])), (int)((float)(rectangle3.height * 15) / 16.0f));
                rectangle2.x = rectangle3.x + (int)((float)rectangle3.width * fArray2[0]);
                rectangle2.y += (int)((float)(rectangle3.height * 1) / 32.0f);
                break;
            }
            case 2: {
                rectangle2.setSize((int)((float)rectangle3.width * (1.0f - fArray2[0])), (int)((float)(rectangle3.height * 15) / 16.0f));
                rectangle2.x = rectangle3.x;
                rectangle2.y += (int)((float)(rectangle3.height * 1) / 32.0f);
                break;
            }
            case 3: {
                rectangle2.setSize((int)((float)(rectangle3.width * 15) / 16.0f), (int)((float)rectangle3.height * (1.0f - fArray2[1])));
                rectangle2.x = rectangle3.x + (int)((float)(rectangle3.width * 1) / 32.0f);
                rectangle2.y = rectangle3.y;
                break;
            }
            case 1: {
                rectangle2.setSize((int)((float)(rectangle3.width * 15) / 16.0f), (int)((float)rectangle3.height * (1.0f - fArray2[0])));
                rectangle2.x = rectangle3.x + (int)((float)(rectangle3.width * 1) / 32.0f);
                rectangle2.y = rectangle3.y + (int)((float)rectangle3.height * fArray2[0]);
                break;
            }
            default: {
                rectangle2.x = rectangle3.x;
                rectangle2.y = rectangle3.y;
                rectangle2.width = rectangle3.width;
                rectangle2.height = rectangle3.height;
            }
        }
        return rectangle2;
    }

    public static Rectangle calculateSimplePeperArea(Rectangle rectangle, ChartPlatform chartPlatform) {
        int n;
        int n2;
        int n3;
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = (Rectangle)rectangle.clone();
        boolean bl = chartPlatform.getSimplePaper().isBench();
        float f = chartPlatform.getChartCoordinatePaper().getProperties().getAxisXProperties().getDisplayAreaPercent();
        f /= 100.0f;
        int n4 = rectangle3.x;
        if (!bl) {
            n3 = (int)((float)chartPlatform.getHeight() * f);
            n2 = rectangle3.width;
            n = rectangle3.y + rectangle3.height - n3;
        } else {
            n3 = rectangle3.height;
            n2 = (int)((float)chartPlatform.getWidth() * f);
            n = rectangle3.y;
        }
        rectangle2.x = n4;
        rectangle2.y = n;
        rectangle2.width = n2;
        rectangle2.height = n3;
        return rectangle2;
    }

    public static void restrictRect(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2.x < rectangle.x) {
            rectangle2.x = rectangle.x;
        }
        if (rectangle2.y < rectangle.y) {
            rectangle2.y = rectangle.y;
        }
        if (rectangle2.x + rectangle2.width > rectangle.x + rectangle.width) {
            rectangle2.width = rectangle.x + rectangle.width - rectangle2.x;
            int n = rectangle2.width = rectangle2.width < 0 ? 0 : rectangle2.width;
        }
        if (rectangle2.height + rectangle2.y > rectangle.y + rectangle.height) {
            rectangle2.height = rectangle.y + rectangle.height - rectangle2.y;
            rectangle2.height = rectangle2.height < 0 ? 0 : rectangle2.height;
        }
    }

    public static Rectangle getChartPaperBounds(Rectangle rectangle, int n) {
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = (Rectangle)rectangle.clone();
        float[] fArray2 = new float[2];
        switch (n) {
            case 4: {
                fArray2[0] = 0.25f;
                fArray2[1] = 0.0f;
                rectangle2.setSize((int)((float)rectangle3.width * (1.0f - fArray2[0])), (int)((float)(rectangle3.height * 15) / 16.0f));
                rectangle2.x = rectangle3.x + (int)((float)rectangle3.width * fArray2[0]);
                rectangle2.y += (int)((float)(rectangle3.height * 1) / 32.0f);
                break;
            }
            case 2: {
                fArray2[0] = 0.25f;
                fArray2[1] = 0.0f;
                rectangle2.setSize((int)((float)rectangle3.width * (1.0f - fArray2[0])), (int)((float)(rectangle3.height * 15) / 16.0f));
                rectangle2.x = rectangle3.x;
                rectangle2.y += (int)((float)(rectangle3.height * 1) / 32.0f);
                break;
            }
            case 3: {
                fArray2[0] = 0.0f;
                fArray2[1] = 0.25f;
                rectangle2.setSize((int)((float)(rectangle3.width * 15) / 16.0f), (int)((float)rectangle3.height * (1.0f - fArray2[1])));
                rectangle2.x = rectangle3.x + (int)((float)(rectangle3.width * 1) / 32.0f);
                rectangle2.y = rectangle3.y;
                break;
            }
            case 1: {
                fArray2[0] = 0.0f;
                fArray2[1] = 0.25f;
                rectangle2.setSize((int)((float)(rectangle3.width * 15) / 16.0f), (int)((float)rectangle3.height * (1.0f - fArray2[1])));
                rectangle2.x = rectangle3.x + (int)((float)(rectangle3.width * 1) / 32.0f);
                rectangle2.y = rectangle3.y + (int)((float)rectangle3.height * fArray2[1]);
                break;
            }
            default: {
                return null;
            }
        }
        return rectangle2;
    }
}

