/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.ChartComponent;
import chart.ChartEnv;
import chart.ChartLabel;
import chart.ChartLegendLM;
import chart.ChartLegendTableModel;
import chart.ChartObject;
import chart.ChartPlatform;
import chart.ChartScrollBar;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartIcon;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTextStyle;
import chart.properties.ChartComponentProperties;
import chart.properties.ChartLabelProperties;
import chart.properties.ChartLegendProperties;
import chart.properties.ChartNodeProperties;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.List;

public class ChartLegend
extends ChartComponent {
    public static final int NONE = 0;
    public static final int NORTH = 1;
    public static final int EAST = 2;
    public static final int SOUTH = 3;
    public static final int WEST = 4;
    public static final int L_T = 0;
    public static final int CENTER = 1;
    public static final int R_B = 2;
    private ChartPlatform COMPONENT_MARGIN;
    private ChartLegendProperties GAP_BETWEEN_COMPNENT;
    private ChartLegendLM SEDU;
    private ChartLegendTableModel add;
    private List calculateUsedLegendRate;
    private ChartLabel[] clone;
    private ChartLabel[] closePath;
    private int[] contains;
    public String[] hintText;
    private ChartLabel createChildrenLabels;
    ChartScrollBar doLayout;
    int get = 1;
    int getBackground;
    boolean getBorderClr = true;
    private boolean getBorderClrTrans = false;
    boolean getBorderStyle = false;
    protected Rectangle paperBounds;
    protected boolean preparedLocate = false;
    float[] getBorderThickness = null;

    public ChartLegend(ChartPlatform chartPlatform) {
        this.COMPONENT_MARGIN = chartPlatform;
        this.GAP_BETWEEN_COMPNENT = new ChartLegendProperties();
        this.add = new ChartLegendTableModel(this);
        this.SEDU = new ChartLegendLM(this);
    }

    public ChartLegend(ChartPlatform chartPlatform, ChartLegendProperties chartLegendProperties) {
        this.COMPONENT_MARGIN = chartPlatform;
        this.GAP_BETWEEN_COMPNENT = chartLegendProperties;
        this.add = new ChartLegendTableModel(this);
        this.SEDU = new ChartLegendLM(this);
    }

    @Override
    public void init() {
        this.setBackground(this.GAP_BETWEEN_COMPNENT.getBackground());
        int n = this.SEDU.getMaxNumsOfLabels();
        this.add.setMaxNumsOfLabel(n);
        this.add.createChildrenLabels();
        this.calculateUsedLegendRate = this.add.getSeriesLabels();
        this.clone = this.add.getLabels();
        this.createChildrenLabels = this.add.getTotalValueLabel();
        this.closePath = new ChartLabel[this.clone.length];
        for (int i = 0; i < this.clone.length; ++i) {
            this.closePath[i] = new ChartLabel(this.clone[i].getText());
        }
        if (this.GAP_BETWEEN_COMPNENT.isAutoSize() && this.GAP_BETWEEN_COMPNENT.getPlacement() == 0) {
            this.GAP_BETWEEN_COMPNENT.setPlacement(2);
        }
        this.setLabelStyle();
        this.setIconStyle();
    }

    public void createChildren(ChartComponentProperties chartComponentProperties) {
    }

    public void setIconStyle() {
        boolean bl = this.GAP_BETWEEN_COMPNENT.getInheritShapeFromNode();
        bl = bl || this.GAP_BETWEEN_COMPNENT.isShowLineForLineChart();
        List list = this.COMPONENT_MARGIN.getChartCoordinatePaper().getProperties().getGraphProperties().getLineNodeList();
        this.contains = this.GAP_BETWEEN_COMPNENT.getIconStyleList();
        int n = 0;
        for (int i = 0; i < this.clone.length; ++i) {
            if (bl && (this.clone[i].getIcon().getIsLineIcon() || this.clone[i].getIcon().getIsNodeMark())) {
                ChartNodeProperties chartNodeProperties = (ChartNodeProperties)list.get(n % list.size());
                this.clone[i].setIconStyle(chartNodeProperties.getShapeStyle());
                ++n;
                continue;
            }
            if (this.contains != null && this.contains.length != 0) {
                this.clone[i].setIconStyle(this.contains[i % this.contains.length]);
                continue;
            }
            this.clone[i].setIconStyle(0);
        }
        this.COMPONENT_MARGIN();
    }

    private void COMPONENT_MARGIN() {
        List list = this.COMPONENT_MARGIN.getDataSetModel().getChartDataSets();
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int n = list.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ChartDataSet chartDataSet = (ChartDataSet)list.get(i);
            int n3 = chartDataSet.getLegendSeriesLabels().size() > this.clone.length ? this.clone.length : chartDataSet.getLegendSeriesLabels().size();
            int[] nArray = new int[n3];
            for (int j = 0; j < n3 && j + n2 < this.clone.length; ++j) {
                nArray[j] = this.clone[j + n2].getIconStyle();
            }
            arrayList.add(nArray);
            n2 += n3;
        }
        this.COMPONENT_MARGIN.getChartRenderInfo().setLegendIconStyleList(arrayList);
    }

    public int[] getIconStyleList() {
        if (this.contains == null || this.contains.length < this.clone.length) {
            this.contains = new int[this.clone.length];
            for (int i = 0; i < this.clone.length; ++i) {
                this.contains[i] = this.clone[i].getIcon().getIconStyle();
            }
        }
        return this.contains;
    }

    public void setLabelStyle() {
        boolean bl = this.GAP_BETWEEN_COMPNENT.getInheritShapeFromNode();
        bl = bl || this.GAP_BETWEEN_COMPNENT.isShowLineForLineChart();
        List list = this.COMPONENT_MARGIN.getChartCoordinatePaper().getProperties().getGraphProperties().getLineNodeList();
        int n = 0;
        for (int i = 0; i < this.clone.length; ++i) {
            ChartLabelProperties chartLabelProperties = (ChartLabelProperties)this.GAP_BETWEEN_COMPNENT.getLabelStyle().clone();
            if (bl && (this.clone[i].getIcon().getIsLineIcon() || this.clone[i].getIcon().getIsNodeMark())) {
                ChartNodeProperties chartNodeProperties = (ChartNodeProperties)list.get(n % list.size());
                ChartColorPattern chartColorPattern = new ChartColorPattern(chartNodeProperties.getNFillClr());
                chartColorPattern.setAlpha(chartNodeProperties.getNFillClrTrans() / 100.0f);
                if (!this.clone[i].getIcon().getUseCondition()) {
                    chartLabelProperties.getIcon().setColor(chartColorPattern);
                } else {
                    chartLabelProperties.getIcon().setUseCondition(true);
                    chartLabelProperties.getIcon().setColor(this.clone[i].getIcon().getColor());
                }
                ChartPenStyle chartPenStyle = new ChartPenStyle();
                chartPenStyle.setDashPattern(chartNodeProperties.getBorderStyle());
                chartPenStyle.setPenWidth(chartNodeProperties.getBorderThickness());
                chartPenStyle.setPenColor(new ChartColorPattern(chartNodeProperties.getBorderClr()));
                chartPenStyle.setTransparency(chartNodeProperties.getBorderClrTrans());
                chartLabelProperties.getIcon().setPen(chartPenStyle);
                ++n;
            } else {
                chartLabelProperties.getIcon().setColor(this.clone[i].getIcon().getColor());
                chartLabelProperties.getIcon().setPen(this.clone[i].getIcon().getPen());
            }
            chartLabelProperties.getIcon().setIsLineIcon(this.clone[i].getIcon().getIsLineIcon());
            chartLabelProperties.getIcon().setIsNodeMark(this.clone[i].getIcon().getIsNodeMark());
            chartLabelProperties.getIcon().setLineStylePen(this.clone[i].getIcon().getLineStylePen());
            chartLabelProperties.getIcon().setLineColor(this.clone[i].getIcon().getLineColor());
            chartLabelProperties.setText(this.clone[i].getText());
            chartLabelProperties.setBackground(null);
            chartLabelProperties.setTextAlignment(1);
            this.clone[i].setProperties(chartLabelProperties);
            this.clone[i].background = null;
        }
        if (this.createChildrenLabels != null) {
            ChartLabelProperties chartLabelProperties = (ChartLabelProperties)this.GAP_BETWEEN_COMPNENT.getLabelStyle().clone();
            chartLabelProperties.setText(this.createChildrenLabels.getText());
            chartLabelProperties.setBackground(null);
            chartLabelProperties.setTextAlignment(4);
            this.createChildrenLabels.setProperties(chartLabelProperties);
            this.createChildrenLabels.background = null;
        }
    }

    public void setLabelStyle(ChartIcon chartIcon, ChartTextStyle chartTextStyle, int n, int n2, int n3) {
        for (int i = 0; i < this.clone.length; ++i) {
            this.clone[i].setIconAlignment(n);
            this.clone[i].setTextAlignment(n2);
            this.clone[i].setIconTextGap(n3);
            ChartIcon chartIcon2 = (ChartIcon)chartIcon.clone();
            this.clone[i].getIcon().setPen(chartIcon2.getPen());
            this.clone[i].getIcon().setIconWidth(chartIcon.getIconWidth());
            this.clone[i].getIcon().setIconHeight(chartIcon.getIconHeight());
            this.clone[i].setChartTextStyle(chartTextStyle);
            this.clone[i].getIcon().setColor(chartIcon.getColor());
            this.clone[i].getIcon().setIsLineIcon(chartIcon.getIsLineIcon());
            if (!chartIcon.getIsLineIcon()) continue;
            this.clone[i].getIcon().setLineStylePen(chartIcon.getLineStylePen());
        }
    }

    @Override
    public void locate() {
        Rectangle rectangle;
        this.setLabelStyle();
        this.setIconStyle();
        boolean bl = false;
        if (this.COMPONENT_MARGIN.getChartDefinition() != null) {
            bl = this.COMPONENT_MARGIN.getChartDefinition().isHeatMapChart();
        }
        if (!this.getBorderStyle && this.COMPONENT_MARGIN.getProperties().isShowLegend() && !bl) {
            this.getBorderStyle = true;
            rectangle = this.COMPONENT_MARGIN.getGraphisRect();
            float[] fArray2 = this.getExtraSize((float)rectangle.width * 0.25f - (float)(2 * ChartEnv.GAP_BETWEEN_COMPNENT), (float)rectangle.height * 0.25f - (float)(2 * ChartEnv.GAP_BETWEEN_COMPNENT));
            Rectangle rectangle2 = this.getBounds();
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = this.getProperties().getBackground().getPen().getPenWidth();
            int n = this.getProperties().getPlacement();
            boolean bl2 = this.COMPONENT_MARGIN.getProperties().isShowLegend();
            if (bl2) {
                switch (n) {
                    case 2: {
                        if (this.paperBounds == null || this.paperBounds.width <= 0) break;
                        f = this.paperBounds.x + this.paperBounds.width;
                        this.setBounds((int)f, rectangle2.y, rectangle2.width, rectangle2.height);
                        break;
                    }
                    case 4: {
                        if (this.paperBounds == null || this.paperBounds.width <= 0) break;
                        f = rectangle.x + ChartEnv.COMPONENT_MARGIN;
                        this.setBounds((int)f, rectangle2.y, (int)((float)this.paperBounds.x - f > 0.0f ? (float)this.paperBounds.x - f : 0.0f), rectangle2.height);
                        break;
                    }
                    case 3: {
                        if (this.paperBounds == null || this.paperBounds.width <= 0) break;
                        f = this.paperBounds.y + this.paperBounds.height;
                        f2 = (float)(rectangle.y + rectangle.height) - f - (float)ChartEnv.COMPONENT_MARGIN;
                        f2 = f2 < 0.0f ? 0.0f : f2;
                        this.setBounds(rectangle2.x, (int)f, rectangle2.width, (int)f2);
                        break;
                    }
                    case 1: {
                        if (this.paperBounds == null || this.paperBounds.width <= 0) break;
                        f = ChartEnv.COMPONENT_MARGIN;
                        f2 = (float)this.paperBounds.y - f - 0.0f;
                        this.setBounds(rectangle2.x, (int)f, rectangle2.width, (int)f2);
                    }
                }
            }
        }
        this.SEDU.doLayout();
        this.GAP_BETWEEN_COMPNENT();
        if (!this.getBorderClr && this.doLayout != null) {
            rectangle = this.getBounds();
            this.setSize(rectangle.width + 16, rectangle.height);
            if (this.GAP_BETWEEN_COMPNENT != null && this.GAP_BETWEEN_COMPNENT.getPlacement() == 2) {
                this.setLocation(rectangle.x - 16, rectangle.y);
            }
        }
        if (this.doLayout != null) {
            this.doLayout.locate();
        }
        if (this.createChildrenLabels != null && !this.getBorderClr) {
            this.createChildrenLabels.setLocation(-1, -1);
            this.createChildrenLabels.setSize(0, 0);
        }
    }

    public void doLayout() {
    }

    void GAP_BETWEEN_COMPNENT() {
        if (this.doLayout != null) {
            float f = this.getChartPlatform().getLegendLabelStart();
            f = (f /= (float)this.get) > 1.0f || f < 0.0f ? 0.0f : f;
            float f2 = this.getBackground;
            f2 = (f2 /= (float)this.get) > 1.0f || f2 < 0.0f ? 0.0f : f2;
            this.doLayout.setStatus(f, f2);
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (this.COMPONENT_MARGIN.getProperties().isShowLegend()) {
            this.background = this.GAP_BETWEEN_COMPNENT.getBackground();
            super.paint(graphics2D);
            super.paintBorder(graphics2D);
            if (this.doLayout != null) {
                this.doLayout.paint(graphics2D);
            }
        }
    }

    public static int ceil(double d) {
        if (Math.round(d) != (long)((int)d)) {
            return (int)Math.round(d);
        }
        return (int)d + 1;
    }

    public List getLegendSeriesLabels() {
        return this.calculateUsedLegendRate;
    }

    public ChartLabel[] getLabels() {
        return this.clone;
    }

    public int getPrePlacement() {
        return this.GAP_BETWEEN_COMPNENT.getPlacement();
    }

    public int getPreferredPlacement() {
        return this.GAP_BETWEEN_COMPNENT.getPlacement();
    }

    public ChartPlatform getChartPlatform() {
        return this.COMPONENT_MARGIN;
    }

    public ChartLegendProperties getProperties() {
        return this.GAP_BETWEEN_COMPNENT;
    }

    public void setProperties(ChartLegendProperties chartLegendProperties) {
        this.GAP_BETWEEN_COMPNENT = chartLegendProperties;
    }

    @Override
    public ChartObject getChartObject(int n, int n2) {
        if (this.getBounds().contains(n, n2)) {
            return this;
        }
        return null;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    public String[] getHintValue(int n, int n2) {
        if (!this.GAP_BETWEEN_COMPNENT.isShowTips()) {
            return null;
        }
        this.hintText = new String[1];
        ChartLabel[] chartLabelArray = this.getLabels();
        ChartLabel[] chartLabelArray2 = this.getOriLabels();
        int n3 = chartLabelArray2.length;
        int n4 = n - this.getBounds().x;
        int n5 = n2 - this.getBounds().y;
        for (int i = 0; i < n3; ++i) {
            if (!chartLabelArray[i].contains(n, n2)) continue;
            this.hintText[0] = chartLabelArray2[i].getText();
            break;
        }
        if (this.createChildrenLabels != null && this.createChildrenLabels.contains(n, n2)) {
            this.hintText[0] = this.createChildrenLabels.getText();
        }
        if (this.hintText[0] == null) {
            this.hintText = null;
        }
        return this.hintText;
    }

    public ChartLabel[] getOriLabels() {
        return this.closePath;
    }

    public ChartLabel getTotalValueLabel() {
        return this.createChildrenLabels;
    }

    public Shape[] getLabelsShapes() {
        int n = this.clone.length;
        Shape[] shapeArray = new GeneralPath[n];
        for (int i = 0; i < n; ++i) {
            shapeArray[i] = new GeneralPath();
            ((Path2D)shapeArray[i]).reset();
            float f = this.clone[i].x;
            float f2 = this.clone[i].y;
            float f3 = this.clone[i].getWidth();
            float f4 = this.clone[i].getHeight();
            ((Path2D.Float)shapeArray[i]).moveTo(f, f2);
            ((Path2D.Float)shapeArray[i]).lineTo(f + f3, f2);
            ((Path2D.Float)shapeArray[i]).lineTo(f + f3, f2 + f4);
            ((Path2D.Float)shapeArray[i]).lineTo(f, f2 + f4);
            ((Path2D.Float)shapeArray[i]).lineTo(f, f2);
            ((Path2D)shapeArray[i]).closePath();
        }
        return shapeArray;
    }

    public void setScrollBar(ChartScrollBar chartScrollBar) {
        this.doLayout = chartScrollBar;
    }

    public void setLegendLabelNum(int n) {
        if (n > 1) {
            this.get = n;
        }
    }

    public void setPaintLabelNum(int n) {
        this.getBackground = n;
    }

    public void setIsExpand(boolean bl) {
        this.getBorderClr = bl;
        this.SEDU.setIsExpand(bl);
    }

    public boolean isExpand() {
        return this.getBorderClr;
    }

    public void calculateWHRate() {
        this.SEDU.calculateUsedLegendRate();
    }

    public float[] getWHRate() {
        return this.SEDU.getLegendWHRate();
    }

    public void setDrawExpandButton(boolean bl) {
        this.getBorderClrTrans = bl;
    }

    public boolean getDrawExpandButton() {
        return this.getBorderClrTrans;
    }

    public int[] getLinkInfo(int n, int n2) {
        int[] nArray = null;
        if (this.COMPONENT_MARGIN.getShowValueConditions().getLegendLink() == null) {
            return null;
        }
        ChartLabel[] chartLabelArray = this.getLabels();
        int n3 = chartLabelArray.length;
        int n4 = n - this.getBounds().x;
        int n5 = n2 - this.getBounds().y;
        for (int i = 0; i < n3; ++i) {
            if (!chartLabelArray[i].contains(n, n2)) continue;
            if (i >= this.COMPONENT_MARGIN.getShowValueConditions().getLegendLink().size()) break;
            nArray = ((ChartDataUsedInfo)this.COMPONENT_MARGIN.getShowValueConditions().getLegendLink().get(i)).getChartLinkInfo();
            break;
        }
        return nArray;
    }

    public void calculateMaxSize() {
        if (!this.preparedLocate) {
            this.setLabelStyle();
            this.setIconStyle();
            this.preparedLocate = true;
        }
        float[] fArray2 = new float[2];
        this.SEDU.getMaxLabelSize(fArray2);
        float[] fArray3 = this.SEDU();
        int n = -1;
        if (this.getLabels() != null) {
            n = this.getLabels().length;
        }
        ChartLegendProperties chartLegendProperties = this.getProperties();
        float f = chartLegendProperties.getBackground().getPen().getPenWidth();
        float f2 = chartLegendProperties.getLeftMargin() + f;
        float f3 = chartLegendProperties.getTopMargin() + f;
        float f4 = chartLegendProperties.getLabelHSpacing();
        float f5 = chartLegendProperties.getLabelVSpacing();
        float f6 = chartLegendProperties.getLabelStyle().getIconTextGap();
        fArray3[0] = fArray3[0] - 2.0f * f2;
        fArray3[1] = fArray3[1] - 2.0f * f3;
        int n2 = (int)(fArray3[0] / fArray2[0]);
        int n3 = (int)(fArray3[1] / (fArray2[1] + f5));
        n3 = n3 <= 0 ? 1 : n3;
        int n4 = n2 = n2 <= 0 ? 1 : n2;
        if (chartLegendProperties.getPlacement() == 2 || chartLegendProperties.getPlacement() == 4) {
            n2 = 1;
            n3 = n;
        } else if (chartLegendProperties.getPlacement() == 3 || chartLegendProperties.getPlacement() == 1) {
            n3 = 1;
            n2 = n;
        } else {
            n2 = 1;
            n3 = n;
        }
        this.getBorderThickness = new float[2];
        this.getBorderThickness[0] = 2.0f * f2 + (float)n2 * fArray2[0] + (float)(n2 - 1) * f4;
        this.getBorderThickness[1] = 2.0f * f3 + (float)n3 * fArray2[1] + (float)(n3 - 1) * f5;
    }

    private float[] SEDU() {
        float[] fArray2 = new float[2];
        int n = 0;
        int n2 = 0;
        ChartLegendProperties chartLegendProperties = this.getProperties();
        float f = chartLegendProperties.getBackground().getPen().getPenWidth();
        float f2 = chartLegendProperties.getLabelHSpacing();
        float f3 = chartLegendProperties.getLabelVSpacing();
        Rectangle rectangle = this.getChartPlatform().getGraphisRect();
        switch (chartLegendProperties.getPlacement()) {
            case 0: {
                n = (int)(this.getBounds().getWidth() - (double)(2.0f * f));
                n = n > 0 ? n : 0;
                n2 = (int)(this.getBounds().getHeight() - (double)(2.0f * f));
                n2 = n2 > 0 ? n2 : 0;
                break;
            }
            case 2: 
            case 4: {
                n = (int)(rectangle.getWidth() * 4.0 / 16.0 - (double)(2 * ChartEnv.GAP_BETWEEN_COMPNENT) - (double)(2.0f * f));
                n = n > 0 ? n : 0;
                n2 = (int)(rectangle.getHeight() - (double)(2 * ChartEnv.GAP_BETWEEN_COMPNENT) - (double)(2.0f * f));
                n2 = n2 > 0 ? n2 : 0;
                break;
            }
            case 1: 
            case 3: {
                n = (int)(rectangle.getWidth() - (double)(2 * ChartEnv.GAP_BETWEEN_COMPNENT) - (double)(2.0f * f));
                n = n > 0 ? n : 0;
                n2 = (int)(rectangle.getHeight() * 4.0 / 16.0 - (double)(2 * ChartEnv.GAP_BETWEEN_COMPNENT) - (double)(2.0f * f));
                n2 = n2 > 0 ? n2 : 0;
            }
        }
        fArray2[0] = n;
        fArray2[1] = n2;
        return fArray2;
    }

    public float[] getExtraSize(float f, float f2) {
        float[] fArray2 = new float[]{0.0f, 0.0f};
        boolean bl = false;
        if (this.COMPONENT_MARGIN.getChartDefinition() != null) {
            bl = this.COMPONENT_MARGIN.getChartDefinition().isHeatMapChart();
        }
        if (!bl) {
            if (this.getBorderThickness != null && this.getBorderThickness[0] < f) {
                fArray2[0] = f - this.getBorderThickness[0];
            }
            if (this.getBorderThickness != null && this.getBorderThickness[1] < f2) {
                fArray2[1] = f2 - this.getBorderThickness[1];
            }
        }
        return fArray2;
    }

    public float[] getFullSize() {
        return this.getBorderThickness;
    }
}

