/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

public class Chart2DMatrix {
    float I = 1.0f;
    float SEDU;
    float cos;
    float sin;
    float Z = 1.0f;
    float C;
    float B;
    float D;
    float F = 1.0f;

    public void shift(float f, float f2) {
        this.cos += f;
        this.C += f2;
    }

    public void scale(float f, float f2) {
        this.I *= f;
        this.SEDU *= f;
        this.cos *= f;
        this.sin *= f2;
        this.Z *= f2;
        this.C *= f2;
    }

    public void rotate(double d) {
        float f = (float)Math.cos(d *= Math.PI / 180);
        float f2 = (float)Math.sin(d);
        float f3 = this.sin * f + this.I * f2;
        float f4 = this.Z * f + this.SEDU * f2;
        float f5 = this.C * f + this.cos * f2;
        float f6 = this.I * f - this.sin * f2;
        float f7 = this.SEDU * f - this.Z * f2;
        float f8 = this.cos * f - this.C * f2;
        this.C = f5;
        this.sin = f3;
        this.Z = f4;
        this.cos = f8;
        this.I = f6;
        this.SEDU = f7;
    }

    public void compositeTransformation(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        f5 = (float)((double)f5 * (Math.PI / 180));
        float f8 = (float)Math.cos(f5);
        float f9 = (float)Math.sin(f5);
        this.I = f3 * f8;
        this.SEDU = -f4 * f9;
        this.cos = f6 * (1.0f - f3 * f8) + f7 * f4 * f9 + f;
        this.sin = f3 * f9;
        this.Z = f4 * f8;
        this.C = f7 * (1.0f - f4 * f8) + f6 * f3 * f9 + f2;
    }

    public void mul(Chart2DMatrix chart2DMatrix) {
        float f = this.I * chart2DMatrix.I + this.sin * chart2DMatrix.SEDU;
        float f2 = this.SEDU * chart2DMatrix.I + this.Z * chart2DMatrix.SEDU;
        float f3 = this.cos * chart2DMatrix.I + this.C * chart2DMatrix.SEDU + chart2DMatrix.cos;
        float f4 = this.I * chart2DMatrix.sin + this.sin * chart2DMatrix.Z;
        float f5 = this.SEDU * chart2DMatrix.sin + this.Z * chart2DMatrix.Z;
        float f6 = this.cos * chart2DMatrix.sin + this.C * chart2DMatrix.Z + chart2DMatrix.C;
        this.I = f;
        this.SEDU = f2;
        this.cos = f3;
        this.sin = f4;
        this.Z = f5;
        this.C = f6;
    }

    public void bench1() {
        this.I = 0.0f;
        this.SEDU = 1.0f;
        this.cos = 0.0f;
        this.sin = -1.0f;
        this.Z = 0.0f;
        this.C = 0.0f;
        this.B = 0.0f;
        this.D = 0.0f;
        this.F = 1.0f;
    }

    public void bench2() {
        this.I = 0.0f;
        this.SEDU = -1.0f;
        this.cos = 0.0f;
        this.sin = 1.0f;
        this.Z = 0.0f;
        this.C = 0.0f;
        this.B = 0.0f;
        this.D = 0.0f;
        this.F = 1.0f;
    }

    public void xmirror() {
        this.I = 1.0f;
        this.SEDU = 0.0f;
        this.cos = 0.0f;
        this.sin = 0.0f;
        this.Z = -1.0f;
        this.C = 0.0f;
        this.B = 0.0f;
        this.D = 0.0f;
        this.F = 1.0f;
    }

    public void unit() {
        this.I = 1.0f;
        this.SEDU = 0.0f;
        this.cos = 0.0f;
        this.sin = 0.0f;
        this.Z = 1.0f;
        this.C = 0.0f;
        this.B = 0.0f;
        this.D = 0.0f;
        this.F = 1.0f;
    }

    public void transform(float[][] fArray2, float[][] fArray3) {
        if (fArray3.length < fArray2.length) {
            fArray3 = new float[fArray2.length][2];
        }
        for (int i = 0; i < fArray2.length; ++i) {
            float f = fArray2[i][0] * this.I + fArray2[i][1] * this.SEDU + this.cos;
            float f2 = fArray2[i][0] * this.sin + fArray2[i][1] * this.Z + this.C;
            fArray3[i][0] = f;
            fArray3[i][1] = f2;
        }
    }
}

