/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.ChartLabelBase;
import chart.ChartShowValueCondition;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DGuageBar;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.util.ChartHintLabel;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.List;

public class Graph2DGuageBars
extends Chart2DObject {
    Shape[] append;
    Shape[][] axisY;
    int contains;
    int I;
    Graph2DGuageBar[] floatValue;
    float Z;
    float C = 0.0f;
    float[] get;
    float[] getAxisXProperties;
    String[][][] getAxisY;
    float[][] B;
    float[] D;
    float[] F;
    float[] getAxisY1Shapes;
    ChartLabelBase[] getBounds;
    float J;
    float S;
    Line2D[] getCategorySize;

    Graph2DGuageBars(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    @Override
    public void init() {
        int n;
        super.init();
        this.contains = this.dataset.getCategorySize();
        this.I = this.dataset.getSeriesSize();
        this.floatValue = new Graph2DGuageBar[this.contains];
        this.append = new Shape[this.I];
        this.axisY = new Shape[this.I][this.contains];
        this.get = new float[this.contains];
        this.getAxisXProperties = new float[this.contains];
        this.getCategorySize = new Line2D[this.contains];
        for (n = 0; n < this.I; ++n) {
            this.append[n] = new GeneralPath();
        }
        for (n = 0; n < this.contains; ++n) {
            this.floatValue[n] = new Graph2DGuageBar(this, n);
        }
        this.SEDU();
        this.append();
        this.axisY();
    }

    private void SEDU() {
        String[] stringArray = this.dataset.getChartDataSetModel().getFilteredCategoryNames();
        if (stringArray != null) {
            int n = stringArray.length;
            this.getBounds = new ChartLabelBase[n];
            for (int i = 0; i < n; ++i) {
                this.getBounds[i] = new ChartLabelBase(stringArray[i]);
                this.getBounds[i].setChartTextStyle(this.paper.getProperties().getAxisXProperties().getLabelTextStyle());
                this.floatValue[i].setCategoryLabel(this.getBounds[i]);
            }
        }
    }

    private void append() {
        int n;
        int n2;
        this.B = new float[this.I][this.contains];
        this.D = new float[this.contains];
        this.getAxisY = new String[this.I][this.contains][3];
        for (n2 = 0; n2 < this.I; ++n2) {
            for (n = 0; n < this.contains; ++n) {
                Number number = ((Chart1DDataSet)this.dataset).getValue(n2, n);
                if (number == null) {
                    this.B[n2][n] = 0.0f;
                    continue;
                }
                this.B[n2][n] = number.floatValue();
                if (this.layer.isShowCategoryAndSeries()) {
                    ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                    this.getAxisY[n2][n] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(n2, n);
                    continue;
                }
                this.getAxisY[n2][n][0] = this.dataset.getFormatedHintValue(number);
            }
        }
        for (n2 = 0; n2 < this.contains; ++n2) {
            this.D[n2] = this.B[0][n2];
            for (n = 0; n < this.I; ++n) {
                if (!(this.B[n][n2] > this.D[n2])) continue;
                this.D[n2] = this.B[n][n2];
            }
        }
    }

    private void axisY() {
        int n;
        this.S = (float)((ChartNumericAxis)this.layer.getAxisY()).getMax();
        this.J = (float)((ChartNumericAxis)this.layer.getAxisY()).getMin();
        this.F = new float[3];
        this.getAxisY1Shapes = new float[3];
        this.F[0] = (float)this.objectProperties.getGaugeNormalValueMin();
        this.F[1] = (float)this.objectProperties.getGaugeAlertValueMin();
        this.F[2] = (float)this.objectProperties.getGaugeErrorValueMin();
        this.getAxisY1Shapes[0] = (float)this.objectProperties.getGaugeNormalValueMax();
        this.getAxisY1Shapes[1] = (float)this.objectProperties.getGaugeAlertValueMax();
        this.getAxisY1Shapes[2] = (float)this.objectProperties.getGaugeErrorValueMax();
        boolean bl = true;
        for (n = 0; n < 3; ++n) {
            if (this.F[n] > this.getAxisY1Shapes[n]) {
                float f = this.F[n];
                this.F[n] = this.getAxisY1Shapes[n];
                this.getAxisY1Shapes[n] = f;
            }
            bl = this.getAxisY1Shapes[n] == this.getAxisY1Shapes[n] && this.getAxisY1Shapes[n] == 0.0f && bl;
        }
        if (bl) {
            float f = (this.S - this.J) / 3.0f;
            for (int i = 0; i < 3; ++i) {
                this.F[i] = this.J + (float)i * f;
                this.getAxisY1Shapes[i] = this.F[i] + f;
            }
        }
        for (n = 0; n < 3; ++n) {
            if (this.F[n] < this.J) {
                this.F[n] = this.J;
            }
            if (this.F[n] > this.S) {
                this.F[n] = this.S;
            }
            if (this.getAxisY1Shapes[n] < this.J) {
                this.getAxisY1Shapes[n] = this.J;
            }
            if (!(this.getAxisY1Shapes[n] > this.S)) continue;
            this.getAxisY1Shapes[n] = this.S;
        }
    }

    @Override
    public void locate() {
        switch (this.paper.getProperties().getGraphProperties().getGaugeBarLayout()) {
            case 0: {
                this.contains();
                break;
            }
            case 1: {
                this.dataset();
            }
        }
    }

    private void contains() {
        this.Z = (float)(this.paper.getBounds().getWidth() * (double)this.paper.getProperties().getScaleX()) - 10.0f;
        this.C = (float)(this.paper.getBounds().getHeight() * (double)this.paper.getProperties().getScaleY() - 10.0) / (float)this.contains;
        float f = (float)this.paper.getBounds().getHeight() * (1.0f - this.paper.getProperties().getScaleY()) / 2.0f + 5.0f;
        float f2 = (float)this.paper.getBounds().getWidth() * (1.0f - this.paper.getProperties().getScaleX()) / 2.0f + 5.0f;
        float f3 = this.drilldown();
        f3 = f3 > f2 ? f3 : f2;
        f3 = f3 > this.Z / 2.0f ? this.Z / 2.0f : f3;
        float f4 = this.floatValue();
        f4 = f4 > f2 ? f4 : f2;
        f2 = f3;
        this.Z = (float)(this.paper.getBounds().getWidth() - (double)(f3 + f4));
        this.Z = this.Z < 0.0f ? 0.0f : this.Z;
        for (int i = 0; i < this.contains; ++i) {
            this.get[i] = f2;
            this.getAxisXProperties[i] = f + (float)i * this.C;
            this.floatValue[i].setStartX(this.get[i]);
            this.floatValue[i].setStartY(this.getAxisXProperties[i]);
            this.floatValue[i].locate();
        }
    }

    private void dataset() {
        this.C = (float)(this.paper.getBounds().getHeight() * (double)this.paper.getProperties().getScaleY() - 10.0);
        this.Z = (float)(this.paper.getBounds().getWidth() * (double)this.paper.getProperties().getScaleX() - 10.0) / (float)this.contains;
        float f = (float)this.paper.getBounds().getHeight() * (1.0f - this.paper.getProperties().getScaleY()) / 2.0f + 5.0f;
        float f2 = (float)this.paper.getBounds().getWidth() * (1.0f - this.paper.getProperties().getScaleX()) / 2.0f + 5.0f;
        for (int i = 0; i < this.contains; ++i) {
            this.getAxisXProperties[i] = f;
            this.get[i] = f2 + (float)i * this.Z;
            this.floatValue[i].setStartX(this.get[i]);
            this.floatValue[i].setStartY(this.getAxisXProperties[i]);
            this.floatValue[i].locate();
        }
    }

    private float drilldown() {
        String[] stringArray;
        float f = 0.0f;
        String[] stringArray2 = stringArray = this.layer.axisY != null ? this.layer.axisY.getLabels() : null;
        if (stringArray != null && stringArray.length > 0 && this.objectProperties.getGaugeBarLayout() == 0) {
            f = (float)this.layer.axisY.getProperties().getLabelTextStyle().getDimension(stringArray[0]).getWidth();
        }
        return f / 2.0f;
    }

    private float floatValue() {
        String[] stringArray;
        float f = 0.0f;
        String[] stringArray2 = stringArray = this.layer.axisY != null ? this.layer.axisY.getLabels() : null;
        if (stringArray != null && stringArray.length > 0 && this.objectProperties.getGaugeBarLayout() == 0) {
            f = (float)this.layer.axisY.getProperties().getLabelTextStyle().getDimension(stringArray[stringArray.length - 1]).getWidth();
        }
        return f / 2.0f;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        int n;
        for (n = 0; n < this.contains; ++n) {
            this.floatValue[n].paint(graphics2D);
        }
        for (n = 0; n < this.I; ++n) {
            for (int i = 0; i < this.contains; ++i) {
                this.axisY[n][i] = this.floatValue[i].getItemShapes(n);
                ((GeneralPath)this.append[n]).append(this.axisY[n][i], false);
            }
        }
        for (n = 0; n < this.contains; ++n) {
            this.getCategorySize[n] = (Line2D)this.floatValue[n].getAxisY1Shapes();
        }
    }

    @Override
    float[][] getStaticHintLocation() {
        return null;
    }

    @Override
    Shape[][] getItemShapes() {
        return this.axisY;
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return this.append[n];
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.axisY[n][n2];
    }

    @Override
    public String[] search(int n, int n2) {
        this.drilldown = null;
        for (int i = 0; i < this.I; ++i) {
            for (int j = 0; j < this.contains; ++j) {
                if (this.axisY[i][j] == null || !this.axisY[i][j].contains(n, n2)) continue;
                this.drilldown = new int[2];
                this.drilldown[0] = i;
                this.drilldown[1] = j;
                return this.getAxisY[i][j];
            }
        }
        return null;
    }

    @Override
    public int searchSeries(int n, int n2) {
        int n3 = this.append.length;
        for (int i = 0; i < this.I; ++i) {
            if (!this.append[i].contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    public Chart2DPaper getPaper() {
        return this.paper;
    }

    public boolean searchAxisY(int n, int n2) {
        boolean bl = false;
        for (int i = 0; i < this.contains; ++i) {
            if (this.getCategorySize[i] == null || !this.getCategorySize[i].intersects(n - 5, n2 - 5, 10.0, 10.0)) continue;
            this.layer.axisY.setStatus(1);
            bl = true;
        }
        return bl;
    }

    public Line2D[] getAxisYShape() {
        return this.getCategorySize;
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        int[] nArray = null;
        int n3 = this.dataset.getShowValueBeginIndex();
        int n4 = this.dataset.getShowValueEndIndex();
        int n5 = n4 - n3;
        int n6 = this.I / n5;
        for (int i = 0; i < this.I; ++i) {
            for (int j = 0; j < this.contains; ++j) {
                if (this.axisY[i][j] == null || !this.axisY[i][j].contains(n, n2)) continue;
                ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(i, j);
                int n7 = 0;
                n7 = i + 1 > n6 ? i - i / n6 * n6 : i;
                if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                    nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(n7)).get(j)).getChartLinkInfo();
                }
                return nArray;
            }
        }
        return null;
    }
}

