/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartLabelBase;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DPaper;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataFilter;
import chart.data.ChartDataSet;
import chart.data.ChartDataSetModel;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartTextStyle;
import chart.util.ChartMath;
import chart.util.ChartRenderTools;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class Graph2DStaticHint {
    public static final int POSITION_NONE = 0;
    public static final int POSITION_AUTO = -1;
    public static final int POSITION_BAR_OUTSIDETOP = 16;
    public static final int POSITION_BAR_INSIDETOP = 17;
    public static final int POSITION_BAR_INSIDECENTER = 18;
    public static final int POSITION_BAR_INSIDEBOTTOM = 19;
    public static final int POSITION_LINE_TOPCENTER = 32;
    public static final int POSITION_LINE_TOPLEFT = 33;
    public static final int POSITION_LINE_TOPRIGHT = 34;
    public static final int POSITION_LINE_BOTTOMLEFT = 35;
    public static final int POSITION_LINE_BOTTOMCENTER = 36;
    public static final int POSITION_LINE_BOTTOMRIGHT = 37;
    public static final int POSITION_PIE_STICKER = 48;
    public static final int POSITION_PIE_SLIMLEG = 49;
    public static final int POSITION_PIE_BESTFIT = 50;
    public static final int POSITION_PIE_ONSLICES = 51;
    public static final int POSITION_SMARTSHOW_ON = 1;
    public static final int POSITION_SMARTSHOW_OFF = 0;
    private Graphics2D SEDU;
    private ChartDataSet abs;
    private Chart2DLayer add;
    private Chart2DPaper append;
    private float[][] v;
    private float[][] clone;
    private float[] p = new float[2];
    private int constructPercentFilter = 0;
    private int cos = -1;
    private boolean doubleValue = false;
    private boolean filter = false;
    private boolean getAxisPen = false;
    private boolean getAxisPosition = false;
    private boolean getAxisX = false;
    private float[] getAxisXProperties = new float[2];
    private float[] getCategorySize = new float[4];
    private int getChartDataSetInfo;
    private int getChartDataSetModel;
    private int getChartTextStyle;
    private GeneralPath getChartType = new GeneralPath();
    private Rectangle[][] getDimension;
    private ChartLabelBase getFormatedHintValue;
    private ChartTextStyle getGraphProperties;
    private double[] getHintPercentFilter;
    private boolean getHintTextStyle = false;
    private ChartDataSetModel getLabelText;
    private boolean getOriginValue = false;
    private float getPenWidth;
    private boolean getPrimType;
    boolean getProperties = true;
    public int[] paintCol = null;
    private float getRotation = 0.0f;

    public Graph2DStaticHint(Graphics2D graphics2D, ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer, float[][] fArray2, float f, float[][] fArray3, int n, int n2, int n3) {
        this.SEDU = graphics2D;
        this.abs = chartDataSet;
        this.append = chart2DPaper;
        this.add = chart2DLayer;
        this.v = fArray2;
        this.clone = fArray3;
        this.getChartDataSetInfo = n;
        this.getChartDataSetModel = n2;
        this.getChartTextStyle = n3;
    }

    public Graph2DStaticHint(ChartDataSetModel chartDataSetModel, ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer, float[][] fArray2, float f, float[][] fArray3, int n, int n2, int n3, double[] dArray, boolean bl) {
        this.getLabelText = chartDataSetModel;
        this.abs = chartDataSet;
        this.append = chart2DPaper;
        this.add = chart2DLayer;
        this.v = fArray2;
        this.clone = fArray3;
        this.getChartDataSetInfo = n;
        this.getChartDataSetModel = n2;
        this.getChartTextStyle = n3;
        this.getHintPercentFilter = dArray;
        this.getHintTextStyle = bl;
    }

    public Graph2DStaticHint(ChartDataSetModel chartDataSetModel, Graphics2D graphics2D, ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer, float[][] fArray2, float f, float[][] fArray3, int n, int n2, int n3, double[] dArray, boolean bl) {
        this.getLabelText = chartDataSetModel;
        this.SEDU = graphics2D;
        this.abs = chartDataSet;
        this.append = chart2DPaper;
        this.add = chart2DLayer;
        this.v = fArray2;
        this.clone = fArray3;
        this.getChartDataSetInfo = n;
        this.getChartDataSetModel = n2;
        this.getChartTextStyle = n3;
        this.getHintPercentFilter = dArray;
        this.getHintTextStyle = bl;
    }

    public Graph2DStaticHint(ChartDataSetModel chartDataSetModel, Graphics2D graphics2D, ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer, float[][] fArray2, int n, int n2, int n3, double[] dArray) {
        this.getLabelText = chartDataSetModel;
        this.SEDU = graphics2D;
        this.abs = chartDataSet;
        this.append = chart2DPaper;
        this.add = chart2DLayer;
        this.v = fArray2;
        this.getChartDataSetInfo = n;
        this.getChartDataSetModel = n2;
        this.getChartTextStyle = n3;
        this.getHintPercentFilter = dArray;
    }

    public Graph2DStaticHint(Graphics2D graphics2D, ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer, float[][] fArray2, int n, int n2, int n3) {
        this.SEDU = graphics2D;
        this.abs = chartDataSet;
        this.append = chart2DPaper;
        this.add = chart2DLayer;
        this.v = fArray2;
        this.getChartDataSetInfo = n;
        this.getChartDataSetModel = n2;
        this.getChartTextStyle = n3;
    }

    public void setColumnNumber(int n) {
        this.cos = n;
    }

    public void paint() {
        int n;
        if (this.append.getProperties().getAxisXProperties() != null) {
            this.getRotation = this.append.getProperties().getAxisXProperties().getAxisPen().getPenWidth();
            this.getRotation /= 2.0f;
        }
        if (this.cos == -1) {
            this.cos = this.abs.getCategorySize();
        }
        int n2 = this.abs.getSeriesSize();
        this.getDimension = new Rectangle[n2][this.cos];
        int n3 = ChartTypeInfo.getPrimType(this.abs.getChartDataSetInfo().getChartType());
        if (n3 == 5) {
            this.getCategorySize[0] = 0.0f;
            this.getCategorySize[1] = 2.1474836E9f;
            this.getCategorySize[2] = 0.0f;
            this.getCategorySize[3] = 2.1474836E9f;
            this.getChartTextStyle = 32;
            this.getAxisPen = true;
        } else {
            if (n3 == 1) {
                this.doubleValue = true;
            }
            if (n3 == 0) {
                this.filter = true;
            }
            this.getAxisX = ChartTypeInfo.getSubType(n = this.abs.getChartDataSetInfo().getChartType()) == 512;
            float[][] fArray2 = this.add.getWallCoordinate();
            if (this.doubleValue && this.add.getAxisX().getAxisPosition() == 4) {
                this.getProperties = false;
            }
            if (this.doubleValue) {
                this.getCategorySize[0] = fArray2[0][0];
                this.getCategorySize[1] = fArray2[2][0];
                this.getCategorySize[2] = fArray2[1][1];
                this.getCategorySize[3] = fArray2[0][1];
            } else {
                this.getCategorySize[0] = fArray2[0][0];
                this.getCategorySize[1] = fArray2[1][0];
                this.getCategorySize[2] = fArray2[2][1];
                this.getCategorySize[3] = fArray2[0][1];
            }
        }
        n = this.cos != this.abs.getCategorySize() ? 1 : 0;
        boolean bl = n3 == 2 || n3 == 3;
        this.getGraphProperties = this.append.properties.getHintTextStyle();
        this.getGraphProperties.setWordWrapper(false);
        double d = this.getGraphProperties.getRotation() % (Math.PI * 2);
        String string = null;
        String string2 = null;
        int n4 = 0;
        boolean bl2 = this.append.properties.getGraphProperties().isSuppressZeroLabel();
        for (int i = this.getChartDataSetInfo; i < this.getChartDataSetModel; ++i) {
            for (int j = 0; j < this.cos; ++j) {
                Cloneable cloneable;
                if (this.paintCol != null && (j < this.paintCol[0] || j > this.paintCol[1])) continue;
                n4 = this.abs.getChartDataSetModel().isOneGroup() ? (n2 == 1 || this.cos == 1 ? 0 : (this.filter || this.doubleValue ? j : i)) : j;
                if (bl) {
                    n4 = i;
                }
                this.p[0] = this.v[i * this.cos + j][0];
                this.p[1] = this.v[i * this.cos + j][1];
                Number number = null;
                number = n == 0 ? (Number)((Chart1DDataSet)this.abs).getOriginValue(i, j) : (Number)((Chart1DDataSet)this.abs).getOriginValue(i, j + this.append.I.showScrollLabelStart());
                switch (this.append.getProperties().getGraphProperties().getValueLabelType()) {
                    case 0: {
                        string = ((Chart1DDataSet)this.abs).getFormatedHintValue(number);
                        break;
                    }
                    case 2: {
                        if (number != null) {
                            number = new Double(number.doubleValue() / this.getHintPercentFilter[n4]);
                        }
                        if ((cloneable = this.getLabelText.getHintPercentFilter()) == null) {
                            cloneable = ChartRenderTools.constructPercentFilter(cloneable, true);
                        }
                        string = cloneable.filter(number);
                        break;
                    }
                    case 3: {
                        ChartDataFilter chartDataFilter = this.getLabelText.getHintPercentFilter();
                        if (chartDataFilter == null) {
                            chartDataFilter = ChartRenderTools.constructPercentFilter(chartDataFilter, true);
                        }
                        if (number != null) {
                            string2 = chartDataFilter.filter(new Double(number.doubleValue() / this.getHintPercentFilter[n4]));
                        }
                        string = ((Chart1DDataSet)this.abs).getFormatedHintValue(number) + "(" + string2 + ")";
                        break;
                    }
                    default: {
                        string = "";
                    }
                }
                if (number == null) continue;
                boolean bl3 = this.getAxisPosition = number.doubleValue() >= 0.0;
                if (bl2 && number.doubleValue() == 0.0) {
                    string = "";
                }
                this.getFormatedHintValue = new ChartLabelBase(string);
                this.getFormatedHintValue.setChartTextStyle(this.getGraphProperties);
                cloneable = (Rectangle2D.Float)this.getGraphProperties.getDimension(this.SEDU, string);
                this.getAxisXProperties[0] = ((Rectangle2D.Float)cloneable).width;
                this.getAxisXProperties[1] = ((Rectangle2D.Float)cloneable).height;
                if (!this.getOriginValue) {
                    if (d == 0.0) {
                        this.abs(i, j);
                        continue;
                    }
                    this.SEDU(i, j);
                    continue;
                }
                this.getPrimType = true;
                this.getChartDataSetModel();
                this.getChartDataSetInfo(i, j);
            }
        }
    }

    private void SEDU(int n, int n2) {
        if (this.filter) {
            if (this.getAxisX) {
                if (this.getAxisPosition) {
                    this.getAxisPosition(this.p[0], this.p[1] - (float)this.constructPercentFilter, this.getFormatedHintValue, 1);
                } else {
                    this.getAxisPosition(this.p[0], this.p[1] + (float)this.constructPercentFilter, this.getFormatedHintValue, 2);
                }
            } else {
                this.p[1] = this.p[1] + this.clone[n][n2] / 2.0f;
                this.getAxisPosition(this.p[0], this.p[1], this.getFormatedHintValue, 0);
            }
        } else if (this.doubleValue) {
            if (this.getAxisX) {
                if (this.getAxisPosition) {
                    this.getAxisPosition(this.p[0] + (float)this.constructPercentFilter, this.p[1], this.getFormatedHintValue, 4);
                } else {
                    this.getAxisPosition(this.p[0] - (float)this.constructPercentFilter, this.p[1], this.getFormatedHintValue, 3);
                }
            } else {
                this.p[0] = this.p[0] - this.clone[n][n2] / 2.0f;
                this.getAxisPosition(this.p[0], this.p[1], this.getFormatedHintValue, 0);
            }
        } else if (this.getAxisPen) {
            this.getAxisPosition(this.p[0], this.p[1], this.getFormatedHintValue, 0);
        } else if (this.getAxisPosition) {
            this.getAxisPosition(this.p[0], this.p[1] - (float)this.constructPercentFilter, this.getFormatedHintValue, 1);
        } else {
            this.getAxisPosition(this.p[0], this.p[1] + (float)this.constructPercentFilter, this.getFormatedHintValue, 2);
        }
        this.getFormatedHintValue.paint(this.SEDU, this.p[0], this.p[1]);
    }

    private void abs(int n, int n2) {
        switch (this.getChartTextStyle) {
            case 32: {
                if (this.filter || this.doubleValue) {
                    this.add(n);
                    break;
                }
                this.constructPercentFilter(32);
                break;
            }
            case 36: {
                if (this.filter || this.doubleValue) {
                    this.add(n);
                    break;
                }
                this.constructPercentFilter(36);
                break;
            }
            case 33: {
                if (this.filter || this.doubleValue) {
                    this.add(n);
                    break;
                }
                this.constructPercentFilter(33);
                break;
            }
            case 34: {
                if (this.filter || this.doubleValue) {
                    this.add(n);
                    break;
                }
                this.constructPercentFilter(34);
                break;
            }
            case 35: {
                if (this.filter || this.doubleValue) {
                    this.add(n);
                    break;
                }
                this.constructPercentFilter(35);
                break;
            }
            case 37: {
                if (this.filter || this.doubleValue) {
                    this.add(n);
                    break;
                }
                this.constructPercentFilter(37);
                break;
            }
            case 16: {
                if (this.filter || this.doubleValue) {
                    this.cos(16, this.clone[n][n2]);
                    break;
                }
                this.add(n);
                break;
            }
            case 17: {
                if (this.filter || this.doubleValue) {
                    this.cos(17, this.clone[n][n2]);
                    break;
                }
                this.add(n);
                break;
            }
            case 18: {
                if (this.filter || this.doubleValue) {
                    this.cos(18, this.clone[n][n2]);
                    break;
                }
                this.add(n);
                break;
            }
            case 19: {
                if (this.filter || this.doubleValue) {
                    this.cos(19, this.clone[n][n2]);
                    break;
                }
                this.add(n);
                break;
            }
            case -1: {
                if (!this.filter && !this.doubleValue) {
                    this.add(n);
                    break;
                }
                if (this.filter) {
                    this.append(this.clone[n][n2]);
                    break;
                }
                this.clone(this.clone[n][n2]);
                break;
            }
            case 0: {
                break;
            }
            default: {
                if (!this.filter && !this.doubleValue) {
                    this.add(n);
                    break;
                }
                if (this.filter) {
                    this.append(this.clone[n][n2]);
                    break;
                }
                this.clone(this.clone[n][n2]);
            }
        }
        if (this.getFormatedHintValue == null) {
            return;
        }
        this.getAxisXProperties();
        if ((this.filter || this.doubleValue) && !this.getAxisX) {
            this.getAxisPen(n, n2);
        }
        if (this.filter(n, n2)) {
            this.getFormatedHintValue.locate();
            this.getFormatedHintValue.paint(this.SEDU, this.p[0], this.p[1]);
            this.getDimension[n][n2] = new Rectangle((int)this.p[0], (int)(this.p[1] - this.getAxisXProperties[1]), (int)this.getAxisXProperties[0], (int)this.getAxisXProperties[1]);
        }
    }

    private float[] add(int n) {
        if (!this.doubleValue(this.p[1], this.getAxisXProperties[1] + (float)this.constructPercentFilter, this.getCategorySize[2], 2)) {
            if (this.doubleValue(this.p[0], this.getAxisXProperties[0] / 2.0f, this.getCategorySize[0], 0)) {
                if (!this.doubleValue(this.p[0], this.getAxisXProperties[0] + (float)this.constructPercentFilter, this.getCategorySize[1], 1)) {
                    this.p = this.constructPercentFilter(34);
                } else {
                    this.getFormatedHintValue = null;
                }
            } else if (this.doubleValue(this.p[0], this.getAxisXProperties[0] / 2.0f, this.getCategorySize[1], 1)) {
                if (!this.doubleValue(this.p[0], this.getAxisXProperties[0] + (float)this.constructPercentFilter, this.getCategorySize[0], 0)) {
                    this.p = this.constructPercentFilter(33);
                } else {
                    this.getFormatedHintValue = null;
                }
            } else {
                this.p = this.constructPercentFilter(32);
            }
        } else if (!this.doubleValue(this.p[1], this.getAxisXProperties[1] + (float)this.constructPercentFilter, this.getCategorySize[3], 3)) {
            if (this.doubleValue(this.p[0], this.getAxisXProperties[0] / 2.0f, this.getCategorySize[0], 0)) {
                if (!this.doubleValue(this.p[0], this.getAxisXProperties[0] + (float)this.constructPercentFilter, this.getCategorySize[1], 1)) {
                    this.p = this.constructPercentFilter(37);
                } else {
                    this.getFormatedHintValue = null;
                }
            } else if (this.doubleValue(this.p[0], this.getAxisXProperties[0] / 2.0f, this.getCategorySize[1], 1)) {
                if (!this.doubleValue(this.p[0], this.getAxisXProperties[0] + (float)this.constructPercentFilter, this.getCategorySize[0], 0)) {
                    this.p = this.constructPercentFilter(35);
                } else {
                    this.getFormatedHintValue = null;
                }
            } else {
                this.p = this.constructPercentFilter(36);
            }
        } else {
            this.getFormatedHintValue = null;
        }
        return this.p;
    }

    private float[] append(float f) {
        if (this.getAxisXProperties[1] > f || this.getAxisX) {
            if (!this.doubleValue(this.p[0], this.getAxisXProperties[0] / 2.0f, this.getCategorySize[0], 0) && !this.doubleValue(this.p[0], this.getAxisXProperties[0] / 2.0f, this.getCategorySize[1], 1)) {
                this.p = this.cos(16, f);
            } else {
                this.getFormatedHintValue = null;
            }
        } else if (this.doubleValue(this.p[0], this.getAxisXProperties[0] / 2.0f, this.getCategorySize[0], 0) || this.doubleValue(this.p[0], this.getAxisXProperties[0] / 2.0f, this.getCategorySize[1], 1)) {
            this.getFormatedHintValue = null;
        } else {
            this.p = !this.doubleValue(this.p[1], (f + this.getAxisXProperties[1]) / 2.0f, this.getCategorySize[3], 3) ? this.cos(18, f) : this.cos(16, f);
        }
        return this.p;
    }

    private float[] clone(float f) {
        this.p = this.getAxisX ? this.cos(16, f) : (!this.doubleValue(this.p[0], (this.getAxisXProperties[0] + f) / 2.0f, this.getCategorySize[0], 0) ? this.cos(18, f) : this.cos(18, f));
        return this.p;
    }

    private float[] constructPercentFilter(int n) {
        switch (n) {
            case 32: {
                this.p[0] = this.p[0] - this.getAxisXProperties[0] / 2.0f;
                this.p[1] = this.p[1] - (this.getAxisXProperties[1] + (float)this.constructPercentFilter);
                break;
            }
            case 33: {
                this.p[0] = this.p[0] - (this.getAxisXProperties[0] + (float)this.constructPercentFilter);
                this.p[1] = this.p[1] - (this.getAxisXProperties[1] + (float)this.constructPercentFilter);
                break;
            }
            case 34: {
                this.p[0] = this.p[0] + (float)this.constructPercentFilter;
                this.p[1] = this.p[1] - (this.getAxisXProperties[1] + (float)this.constructPercentFilter);
                break;
            }
            case 36: {
                this.p[0] = this.p[0] - this.getAxisXProperties[0] / 2.0f;
                this.p[1] = this.p[1] + (float)this.constructPercentFilter;
                break;
            }
            case 35: {
                this.p[0] = this.p[0] - (this.getAxisXProperties[0] + (float)this.constructPercentFilter);
                this.p[1] = this.p[1] + (float)this.constructPercentFilter;
                break;
            }
            case 37: {
                this.p[0] = this.p[0] + (float)this.constructPercentFilter;
                this.p[1] = this.p[1] + (float)this.constructPercentFilter;
                break;
            }
        }
        return this.p;
    }

    private float[] cos(int n, float f) {
        switch (n) {
            case 16: {
                if (this.filter) {
                    this.p[0] = this.p[0] - this.getAxisXProperties[0] / 2.0f;
                    if (!this.getAxisPosition) {
                        this.p[1] = this.p[1] + (float)this.constructPercentFilter;
                        break;
                    }
                    this.p[1] = this.p[1] - ((float)this.constructPercentFilter + this.getAxisXProperties[1]);
                    break;
                }
                this.p[1] = this.p[1] - this.getAxisXProperties[1] / 2.0f;
                if (!this.getAxisPosition) {
                    this.p[0] = this.p[0] - ((float)this.constructPercentFilter + this.getAxisXProperties[0]);
                    break;
                }
                this.p[0] = this.p[0] + (float)this.constructPercentFilter;
                break;
            }
            case 17: {
                if (this.filter) {
                    this.p[0] = this.p[0] - this.getAxisXProperties[0] / 2.0f;
                    if (!this.getAxisPosition) {
                        this.p[1] = this.p[1] - ((float)this.constructPercentFilter + this.getAxisXProperties[1]);
                        break;
                    }
                    this.p[1] = this.p[1] + (float)this.constructPercentFilter;
                    break;
                }
                this.p[1] = this.p[1] - this.getAxisXProperties[1] / 2.0f;
                if (!this.getAxisPosition) {
                    this.p[0] = this.p[0] + (float)this.constructPercentFilter;
                    break;
                }
                if (!this.getProperties) break;
                this.p[0] = this.p[0] - (this.getAxisXProperties[0] + (float)this.constructPercentFilter);
                break;
            }
            case 18: {
                if (this.filter) {
                    this.p[0] = this.p[0] - this.getAxisXProperties[0] / 2.0f;
                    if (!this.getAxisPosition) {
                        this.p[1] = this.p[1] - (f + this.getAxisXProperties[1]) / 2.0f;
                        break;
                    }
                    this.p[1] = this.p[1] + (f - this.getAxisXProperties[1]) / 2.0f;
                    break;
                }
                this.p[1] = this.p[1] - this.getAxisXProperties[1] / 2.0f;
                if (!this.getAxisPosition) {
                    this.p[0] = this.p[0] + (f - this.getAxisXProperties[0]) / 2.0f;
                    break;
                }
                this.p[0] = this.p[0] - (this.getAxisXProperties[0] + f) / 2.0f;
                break;
            }
            case 19: {
                if (this.filter) {
                    this.p[0] = this.p[0] - this.getAxisXProperties[0] / 2.0f;
                    if (!this.getAxisPosition) {
                        this.p[1] = this.p[1] - (f - (float)this.constructPercentFilter);
                        break;
                    }
                    this.p[1] = this.p[1] + (f - this.getAxisXProperties[1] - (float)this.constructPercentFilter - this.getRotation);
                    break;
                }
                this.p[1] = this.p[1] - this.getAxisXProperties[1] / 2.0f;
                if (!this.getAxisPosition) {
                    this.p[0] = this.p[0] + (f - (float)this.constructPercentFilter - this.getAxisXProperties[0]);
                    break;
                }
                if (this.getProperties) {
                    this.p[0] = this.p[0] - f - (float)this.constructPercentFilter + this.getRotation;
                    break;
                }
                this.p[0] = this.p[0] - f - (float)this.constructPercentFilter - this.getAxisXProperties[0] - this.getRotation;
                break;
            }
        }
        return this.p;
    }

    private boolean doubleValue(float f, float f2, float f3, int n) {
        boolean bl = false;
        switch (n) {
            case 0: {
                bl = f - f2 < f3;
                break;
            }
            case 1: {
                bl = f + f2 > f3;
                break;
            }
            case 2: {
                bl = f - f2 < f3;
                break;
            }
            case 3: {
                bl = f + f2 > f3;
                break;
            }
        }
        return bl;
    }

    private boolean filter(int n, int n2) {
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j <= n2; ++j) {
                if (this.getDimension[i][j] == null || !this.getChartType.intersects(this.getDimension[i][j])) continue;
                return false;
            }
        }
        return true;
    }

    private void getAxisPen(int n, int n2) {
        if (this.doubleValue) {
            if (!this.filter(n, n2)) {
                this.getAxisX(n, n2);
                if (this.getAxisXProperties[0] < this.clone[n][n2]) {
                    this.p[0] = this.p[0] - this.getAxisXProperties[0];
                    this.p[0] = this.p[0] - (this.getAxisXProperties[0] < this.clone[n][n2] + (float)this.constructPercentFilter ? (float)this.constructPercentFilter : 0.0f);
                    if (!this.filter(n, n2)) {
                        this.getAxisX(n, n2);
                        this.p[0] = this.p[0] + (float)this.constructPercentFilter;
                    }
                } else {
                    this.p[0] = this.p[0] + (float)this.constructPercentFilter;
                }
            }
        } else if (!this.filter(n, n2)) {
            this.getAxisX(n, n2);
            if (this.getAxisXProperties[1] < this.clone[n][n2]) {
                this.p = this.constructPercentFilter(36);
                this.getAxisXProperties();
                if (!this.filter(n, n2)) {
                    this.getAxisX(n, n2);
                    this.p = this.constructPercentFilter(32);
                }
            } else {
                this.p = this.constructPercentFilter(32);
            }
        }
    }

    private float[][] getAxisPosition(float f, float f2, ChartLabelBase chartLabelBase, int n) {
        boolean bl;
        double d = Math.PI;
        double d2 = Math.abs(chartLabelBase.getChartTextStyle().getRotation()) % (d * 2.0);
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        boolean bl2 = bl = d2 % d == 0.0;
        boolean bl3 = bl ? false : d2 % (d / 2.0) == 0.0;
        Rectangle2D.Float float_ = this.getCategorySize(chartLabelBase.getLabelText());
        float f3 = float_.width;
        float f4 = float_.height;
        float[][] fArray2 = new float[4][2];
        if (bl) {
            if (d4 < 0.0) {
                switch (n) {
                    case 0: {
                        fArray2[0][0] = f + f3 / 2.0f;
                        fArray2[0][1] = f2 - f4 / 2.0f;
                        break;
                    }
                    case 1: {
                        fArray2[0][0] = f + f3 / 2.0f;
                        fArray2[0][1] = f2 - f4;
                        break;
                    }
                    case 2: {
                        fArray2[0][0] = f + f3 / 2.0f;
                        fArray2[0][1] = f2;
                        break;
                    }
                    case 3: {
                        fArray2[0][0] = f;
                        fArray2[0][1] = f2 - f4;
                        break;
                    }
                    case 4: {
                        fArray2[0][0] = f + f3;
                        fArray2[0][1] = f2 - f4 / 2.0f;
                    }
                }
            } else {
                switch (n) {
                    case 0: {
                        fArray2[0][0] = f - f3 / 2.0f;
                        fArray2[0][1] = f2 + f4 / 2.0f;
                        break;
                    }
                    case 1: {
                        fArray2[0][0] = f - f3 / 2.0f;
                        fArray2[0][1] = f2;
                        break;
                    }
                    case 2: {
                        fArray2[0][0] = f - f3 / 2.0f;
                        fArray2[0][1] = f2 + f4;
                        break;
                    }
                    case 3: {
                        fArray2[0][0] = f - f3;
                        fArray2[0][1] = f2 + f4 / 2.0f;
                        break;
                    }
                    case 4: {
                        fArray2[0][0] = f;
                        fArray2[0][1] = f2 + f4 / 2.0f;
                    }
                }
            }
        } else if (bl3) {
            if (d3 > 0.0) {
                switch (n) {
                    case 0: {
                        fArray2[0][0] = f - f4 / 2.0f;
                        fArray2[0][1] = f2 - f3 / 2.0f;
                        break;
                    }
                    case 1: {
                        fArray2[0][0] = f - f4 / 2.0f;
                        fArray2[0][1] = f2 - f3;
                        break;
                    }
                    case 2: {
                        fArray2[0][0] = f - f4 / 2.0f;
                        fArray2[0][1] = f2;
                        break;
                    }
                    case 3: {
                        fArray2[0][0] = f - f4;
                        fArray2[0][1] = f2 - f3 / 2.0f;
                        break;
                    }
                    case 4: {
                        fArray2[0][0] = f;
                        fArray2[0][1] = f2 - f3 / 2.0f;
                    }
                }
            } else {
                switch (n) {
                    case 0: {
                        fArray2[0][0] = f + f4 / 2.0f;
                        fArray2[0][1] = f2 + f3 / 2.0f;
                        break;
                    }
                    case 1: {
                        fArray2[0][0] = f + f4 / 2.0f;
                        fArray2[0][1] = f2;
                        break;
                    }
                    case 2: {
                        fArray2[0][0] = f + f4 / 2.0f;
                        fArray2[0][1] = f2 + f3;
                        break;
                    }
                    case 3: {
                        fArray2[0][0] = f;
                        fArray2[0][1] = f2 + f3 / 2.0f;
                        break;
                    }
                    case 4: {
                        fArray2[0][0] = f + f4;
                        fArray2[0][1] = f2 + f3 / 2.0f;
                    }
                }
            }
        } else if (n == 0) {
            fArray2[0][0] = (float)((double)f - (double)f3 * d4 / 2.0 - (double)f4 * d3 / 2.0);
            fArray2[0][1] = (float)((double)f2 - (double)f3 * d3 / 2.0 + (double)f4 * d4 / 2.0);
        } else if (d3 > 0.0 && d4 > 0.0) {
            switch (n) {
                case 1: 
                case 3: {
                    fArray2[0][0] = (float)((double)f - (double)f3 * d4 - (double)f4 * d3 / 2.0);
                    fArray2[0][1] = (float)((double)f2 - (double)f3 * d3 + (double)f4 * d4 / 2.0);
                    break;
                }
                case 2: 
                case 4: {
                    fArray2[0][0] = (float)((double)f - (double)f4 * d3 / 2.0);
                    fArray2[0][1] = (float)((double)f2 + (double)f4 * d4 / 2.0);
                }
            }
        } else if (d3 > 0.0 && d4 < 0.0) {
            switch (n) {
                case 1: 
                case 4: {
                    fArray2[0][0] = (float)((double)f - (double)f3 * d4 - (double)f4 * d3 / 2.0);
                    fArray2[0][1] = (float)((double)f2 - (double)f3 * d3 + (double)f4 * d4 / 2.0);
                    break;
                }
                case 2: 
                case 3: {
                    fArray2[0][0] = (float)((double)f - (double)f4 * d3 / 2.0);
                    fArray2[0][1] = (float)((double)f2 + (double)f4 * d4 / 2.0);
                }
            }
        } else if (d3 < 0.0 && d4 < 0.0) {
            switch (n) {
                case 1: 
                case 3: {
                    fArray2[0][0] = (float)((double)f - (double)f4 * d3 / 2.0);
                    fArray2[0][1] = (float)((double)f2 + (double)f4 * d4 / 2.0);
                    break;
                }
                case 2: 
                case 4: {
                    fArray2[0][0] = (float)((double)f - (double)f3 * d4 - (double)f4 * d3 / 2.0);
                    fArray2[0][1] = (float)((double)f2 - (double)f3 * d3 + (double)f4 * d4 / 2.0);
                }
            }
        } else if (d3 < 0.0 && d4 > 0.0) {
            switch (n) {
                case 1: 
                case 4: {
                    fArray2[0][0] = (float)((double)f - (double)f4 * d3 / 2.0);
                    fArray2[0][1] = (float)((double)f2 + (double)f4 * d4 / 2.0);
                    break;
                }
                case 2: 
                case 3: {
                    fArray2[0][0] = (float)((double)f - (double)f3 * d4 - (double)f4 * d3 / 2.0);
                    fArray2[0][1] = (float)((double)f2 - (double)f3 * d3 + (double)f4 * d4 / 2.0);
                }
            }
        }
        this.p[0] = fArray2[0][0];
        this.p[1] = fArray2[0][1];
        if (d2 < d / 2.0) {
            this.p[1] = (float)((double)this.p[1] - (double)f4 * d4);
        } else if (!ChartMath.isEquals(d2, d / 2.0)) {
            if (d2 < d) {
                this.p[0] = (float)((double)this.p[0] + ((double)f3 * d4 - (double)f4 * d3 / 2.0));
                this.p[1] = (float)((double)this.p[1] + (double)f4 * d4);
            } else if (bl) {
                this.p[0] = this.p[0] - f3;
                this.p[1] = this.p[1] - f4;
            } else if (d2 < 1.5 * d) {
                this.p[0] = this.p[0] - this.getAxisXProperties[0];
                this.p[1] = (float)((double)this.p[1] + (double)f3 * d3);
            } else if (ChartMath.isEquals(d2, 1.5 * d)) {
                this.p[0] = this.p[0] - f4;
                this.p[1] = this.p[1] - f3;
            } else {
                this.p[0] = (float)((double)this.p[0] + (double)f4 * d3);
                this.p[1] = this.p[1] - this.getAxisXProperties[1];
            }
        }
        return fArray2;
    }

    private void getAxisX(int n, int n2) {
        this.p[0] = this.v[n * this.cos + n2][0];
        this.p[1] = this.v[n * this.cos + n2][1];
    }

    private void getAxisXProperties() {
        this.getChartType.reset();
        this.getChartType.moveTo(this.p[0], this.p[1]);
        this.getChartType.lineTo(this.p[0], this.p[1] - this.getAxisXProperties[1]);
        this.getChartType.lineTo(this.p[0] + this.getAxisXProperties[0], this.p[1] - this.getAxisXProperties[1]);
        this.getChartType.lineTo(this.p[0] + this.getAxisXProperties[0], this.p[1]);
        this.getChartType.lineTo(this.p[0], this.p[1]);
    }

    private Rectangle2D.Float getCategorySize(String string) {
        ChartTextStyle chartTextStyle = (ChartTextStyle)this.getGraphProperties.clone();
        chartTextStyle.setRotation(0.0);
        Rectangle2D.Float float_ = (Rectangle2D.Float)chartTextStyle.getDimension(string);
        return float_;
    }

    private void getChartDataSetInfo(int n, int n2) {
        if (this.getFormatedHintValue == null) {
            return;
        }
        if (this.getFormatedHintValue.getLabelText() == null) {
            return;
        }
        ChartTextStyle chartTextStyle = (ChartTextStyle)this.getGraphProperties.clone();
        chartTextStyle.setRotation(0.0);
        Rectangle2D.Float float_ = (Rectangle2D.Float)chartTextStyle.getDimension(this.getFormatedHintValue.getLabelText());
        float[] fArray2 = null;
        int n3 = ChartTypeInfo.getSubType(this.abs.getChartDataSetInfo().getChartType());
        switch (n3) {
            case 512: {
                if (this.filter) {
                    if (float_.width <= this.getPenWidth && this.getPrimType) {
                        if (!(float_.height < Math.abs(this.clone[n][n2]))) break;
                        fArray2 = this.cos(this.getChartTextStyle, Math.abs(this.clone[n][n2]));
                        this.getFormatedHintValue.locate();
                        this.getFormatedHintValue.paint(this.SEDU, fArray2[0], fArray2[1]);
                        break;
                    }
                    if (!(float_.height < this.getPenWidth) || !(float_.width < Math.abs(this.clone[n][n2])) || this.getPrimType) break;
                    chartTextStyle.setRotation(1.5707963267948966);
                    float_ = (Rectangle2D.Float)chartTextStyle.getDimension(this.getFormatedHintValue.getLabelText());
                    fArray2 = new float[]{this.v[n * this.cos + n2][0], this.v[n * this.cos + n2][1]};
                    switch (this.getChartTextStyle) {
                        case 17: {
                            fArray2[0] = fArray2[0] - float_.width / 2.0f;
                            fArray2[1] = fArray2[1] + (float)(this.clone[n][n2] >= 0.0f ? this.constructPercentFilter : -this.constructPercentFilter);
                            fArray2[1] = fArray2[1] - (this.clone[n][n2] < 0.0f ? float_.height : 0.0f);
                            break;
                        }
                        case 18: {
                            fArray2[0] = fArray2[0] - float_.width / 2.0f;
                            fArray2[1] = fArray2[1] + this.clone[n][n2] / 2.0f;
                            fArray2[1] = fArray2[1] - float_.height / 2.0f;
                            break;
                        }
                        case 19: {
                            fArray2[0] = fArray2[0] - float_.width / 2.0f;
                            fArray2[1] = fArray2[1] + (this.clone[n][n2] > 0.0f ? this.clone[n][n2] - float_.height - 2.0f : this.clone[n][n2]);
                        }
                    }
                    this.getFormatedHintValue.setChartTextStyle(chartTextStyle);
                    this.getFormatedHintValue.locate();
                    this.getFormatedHintValue.paint(this.SEDU, fArray2[0], fArray2[1]);
                    break;
                }
                if (float_.width <= Math.abs(this.clone[n][n2]) && float_.height < this.getPenWidth && this.getPrimType) {
                    fArray2 = this.cos(this.getChartTextStyle, Math.abs(this.clone[n][n2]));
                    this.getFormatedHintValue.locate();
                    this.getFormatedHintValue.paint(this.SEDU, fArray2[0], fArray2[1]);
                    break;
                }
                if (!(float_.height < Math.abs(this.clone[n][n2])) || !(float_.width < this.getPenWidth) || this.getPrimType) break;
                chartTextStyle.setRotation(1.5707963267948966);
                float_ = (Rectangle2D.Float)chartTextStyle.getDimension(this.getFormatedHintValue.getLabelText());
                fArray2 = new float[]{this.v[n * this.cos + n2][0], this.v[n * this.cos + n2][1]};
                fArray2[1] = fArray2[1] - float_.height / 2.0f;
                float f = Math.abs(this.clone[n][n2]) - float_.width;
                float f2 = fArray2[0] = this.clone[n][n2] >= 0.0f ? fArray2[0] - float_.width : fArray2[0];
                if (f < 0.0f && this.clone[n][n2] >= 0.0f) {
                    fArray2[0] = fArray2[0] + Math.abs(f);
                }
                this.getFormatedHintValue.setChartTextStyle(chartTextStyle);
                this.getFormatedHintValue.locate();
                this.getFormatedHintValue.paint(this.SEDU, fArray2[0], fArray2[1]);
                break;
            }
            default: {
                if (this.filter) {
                    if (float_.width < this.getPenWidth && float_.height < Math.abs(this.clone[n][n2])) {
                        fArray2 = new float[]{this.v[n * this.cos + n2][0], this.v[n * this.cos + n2][1]};
                        switch (this.getChartTextStyle) {
                            case 17: {
                                fArray2[0] = fArray2[0] - float_.width / 2.0f;
                                fArray2[1] = this.clone[n][n2] >= 0.0f ? fArray2[1] + (float)this.constructPercentFilter : fArray2[1] - float_.height - (float)this.constructPercentFilter;
                                break;
                            }
                            case 18: {
                                fArray2[0] = fArray2[0] - float_.width / 2.0f;
                                fArray2[1] = fArray2[1] + this.clone[n][n2] / 2.0f;
                                fArray2[1] = fArray2[1] - float_.height / 2.0f;
                                break;
                            }
                            case 19: {
                                fArray2[0] = fArray2[0] - float_.width / 2.0f;
                                fArray2[1] = fArray2[1] + this.clone[n][n2];
                                fArray2[1] = fArray2[1] - (this.clone[n][n2] >= 0.0f ? float_.height : 0.0f);
                            }
                        }
                        this.getFormatedHintValue.locate();
                        this.getFormatedHintValue.paint(this.SEDU, fArray2[0], fArray2[1]);
                        break;
                    }
                    if (!(float_.width < Math.abs(this.clone[n][n2])) || !(float_.height < this.getPenWidth) || this.getPrimType) break;
                    chartTextStyle.setRotation(1.5707963267948966);
                    float_ = (Rectangle2D.Float)chartTextStyle.getDimension(this.getFormatedHintValue.getLabelText());
                    fArray2 = new float[]{this.v[n * this.cos + n2][0], this.v[n * this.cos + n2][1]};
                    switch (this.getChartTextStyle) {
                        case 17: {
                            fArray2[0] = fArray2[0] - float_.width / 2.0f;
                            fArray2[1] = fArray2[1] + (this.clone[n][n2] >= 0.0f ? (float)this.constructPercentFilter : -float_.height - (float)this.constructPercentFilter);
                            break;
                        }
                        case 18: {
                            fArray2[0] = fArray2[0] - float_.width / 2.0f;
                            fArray2[1] = this.clone[n][n2] >= 0.0f ? fArray2[1] + this.clone[n][n2] / 2.0f - float_.height / 2.0f : fArray2[1] + this.clone[n][n2] / 2.0f - float_.height / 2.0f;
                            break;
                        }
                        case 19: {
                            fArray2[0] = fArray2[0] - float_.width / 2.0f;
                            fArray2[1] = this.clone[n][n2] >= 0.0f ? fArray2[1] + this.clone[n][n2] - float_.height - (float)this.constructPercentFilter : fArray2[1] + this.clone[n][n2];
                        }
                    }
                    this.getFormatedHintValue.setChartTextStyle(chartTextStyle);
                    this.getFormatedHintValue.locate();
                    this.getFormatedHintValue.paint(this.SEDU, fArray2[0], fArray2[1]);
                    break;
                }
                if (float_.width < Math.abs(this.clone[n][n2]) && float_.height < this.getPenWidth && this.getPrimType) {
                    fArray2 = this.cos(this.getChartTextStyle, Math.abs(this.clone[n][n2]));
                    this.getFormatedHintValue.locate();
                    this.getFormatedHintValue.paint(this.SEDU, fArray2[0], fArray2[1]);
                    break;
                }
                if (!(float_.height < Math.abs(this.clone[n][n2])) || !(float_.width < this.getPenWidth) || this.getPrimType) break;
                chartTextStyle.setRotation(1.5707963267948966);
                float_ = (Rectangle2D.Float)chartTextStyle.getDimension(this.getFormatedHintValue.getLabelText());
                fArray2 = new float[]{this.v[n * this.cos + n2][0], this.v[n * this.cos + n2][1]};
                switch (this.getChartTextStyle) {
                    case 17: {
                        fArray2[1] = fArray2[1] - float_.height / 2.0f;
                        fArray2[0] = fArray2[0] + (this.clone[n][n2] >= 0.0f ? -float_.width - (float)this.constructPercentFilter : (float)this.constructPercentFilter);
                        break;
                    }
                    case 18: {
                        fArray2[1] = fArray2[1] - float_.height / 2.0f;
                        fArray2[0] = this.clone[n][n2] >= 0.0f ? fArray2[0] - this.clone[n][n2] / 2.0f - float_.width / 2.0f : fArray2[0] + Math.abs(this.clone[n][n2] / 2.0f) - float_.width / 2.0f;
                        break;
                    }
                    case 19: {
                        fArray2[1] = fArray2[1] - float_.height / 2.0f;
                        fArray2[0] = this.clone[n][n2] >= 0.0f ? fArray2[0] - this.clone[n][n2] : fArray2[0] + Math.abs(this.clone[n][n2]) - float_.width;
                    }
                }
                this.getFormatedHintValue.setChartTextStyle(chartTextStyle);
                this.getFormatedHintValue.locate();
                this.getFormatedHintValue.paint(this.SEDU, fArray2[0], fArray2[1]);
            }
        }
    }

    void getChartDataSetModel() {
        int n = ChartTypeInfo.getPrimType(this.abs.getChartDataSetInfo().getChartType());
        if (n == 1) {
            this.getPrimType = true;
            return;
        }
        ChartTextStyle chartTextStyle = (ChartTextStyle)this.getGraphProperties.clone();
        chartTextStyle.setRotation(0.0);
        Rectangle2D.Float float_ = null;
        boolean bl = this.cos != this.abs.getCategorySize();
        Number number = null;
        String string = null;
        String string2 = null;
        boolean bl2 = n == 2 || n == 3;
        int n2 = this.abs.getSeriesSize();
        int n3 = 0;
        for (int i = this.getChartDataSetInfo; i < this.getChartDataSetModel; ++i) {
            for (int j = 0; j < this.cos; ++j) {
                number = !bl ? (Number)((Chart1DDataSet)this.abs).getOriginValue(i, j) : (Number)((Chart1DDataSet)this.abs).getOriginValue(i, j + this.append.I.showScrollLabelStart());
                n3 = this.abs.getChartDataSetModel().isOneGroup() ? (n2 == 1 || this.cos == 1 ? 0 : (this.filter || this.doubleValue ? j : i)) : j;
                if (bl2) {
                    n3 = i;
                }
                if (number == null) continue;
                switch (this.append.getProperties().getGraphProperties().getValueLabelType()) {
                    case 0: {
                        string = ((Chart1DDataSet)this.abs).getFormatedHintValue(number);
                        break;
                    }
                    case 2: {
                        ChartDataFilter chartDataFilter;
                        if (number != null) {
                            number = new Double(number.doubleValue() / this.getHintPercentFilter[n3]);
                        }
                        if ((chartDataFilter = this.getLabelText.getHintPercentFilter()) == null) {
                            chartDataFilter = ChartRenderTools.constructPercentFilter(chartDataFilter, true);
                        }
                        string = chartDataFilter.filter(number);
                        break;
                    }
                    case 3: {
                        ChartDataFilter chartDataFilter = this.getLabelText.getHintPercentFilter();
                        if (chartDataFilter == null) {
                            chartDataFilter = ChartRenderTools.constructPercentFilter(chartDataFilter, true);
                        }
                        if (number != null) {
                            string2 = chartDataFilter.filter(new Double(number.doubleValue() / this.getHintPercentFilter[n3]));
                        }
                        string = ((Chart1DDataSet)this.abs).getFormatedHintValue(number) + "(" + string2 + ")";
                        break;
                    }
                    default: {
                        string = "";
                    }
                }
                float_ = (Rectangle2D.Float)chartTextStyle.getDimension(string);
                if (this.filter) {
                    if (!(float_.width > this.getPenWidth) || !(float_.height < this.getPenWidth) || !(float_.width < Math.abs(this.clone[i][j]))) continue;
                    this.getPrimType = false;
                    return;
                }
                if (!(float_.width > Math.abs(this.clone[i][j])) || !(float_.width < this.getPenWidth) || !(float_.height < Math.abs(this.clone[i][j]))) continue;
                this.getPrimType = false;
                return;
            }
        }
    }

    public void setIsSmartShow(boolean bl) {
        this.getOriginValue = bl;
    }

    public void setBarWidth(float f) {
        this.getPenWidth = f;
    }

    protected boolean isSmartLabelVertical() {
        if (this.cos == -1) {
            this.cos = this.abs.getCategorySize();
        }
        boolean bl = this.cos != this.abs.getCategorySize();
        this.getGraphProperties = this.append.properties.getHintTextStyle();
        this.getGraphProperties.setWordWrapper(false);
        this.getPrimType = true;
        this.getChartDataSetModel();
        return this.getPrimType;
    }

    protected Vector getSmartLabelShowInfo() {
        Vector<Object> vector = new Vector<Object>();
        int n = ChartTypeInfo.getPrimType(this.abs.getChartDataSetInfo().getChartType());
        this.filter = n == 0;
        boolean[][] blArray = null;
        boolean bl = this.cos != this.abs.getCategorySize();
        this.getGraphProperties = this.append.properties.getHintTextStyle();
        this.getGraphProperties.setWordWrapper(false);
        Number number = null;
        String string = null;
        String string2 = null;
        if (this.getPenWidth < 2.0f) {
            vector.add(new Boolean(false));
            vector.add(null);
            return vector;
        }
        boolean bl2 = this.isSmartLabelVertical();
        blArray = new boolean[this.getChartDataSetModel - this.getChartDataSetInfo][this.cos];
        ChartTextStyle chartTextStyle = (ChartTextStyle)this.getGraphProperties.clone();
        chartTextStyle.setRotation(0.0);
        Rectangle2D.Float float_ = null;
        int n2 = ChartTypeInfo.getSubType(this.abs.getChartDataSetInfo().getChartType());
        boolean bl3 = n == 2 || n == 3;
        int n3 = this.abs.getSeriesSize();
        int n4 = 0;
        for (int i = this.getChartDataSetInfo; i < this.getChartDataSetModel; ++i) {
            for (int j = 0; j < this.cos; ++j) {
                n4 = this.abs.getChartDataSetModel().isOneGroup() ? (n3 == 1 || this.cos == 1 ? 0 : (this.filter || this.doubleValue ? j : i)) : j;
                if (bl3) {
                    n4 = i;
                }
                if ((number = !bl ? (Number)((Chart1DDataSet)this.abs).getOriginValue(i, j) : (Number)((Chart1DDataSet)this.abs).getOriginValue(i, j + this.append.I.showScrollLabelStart())) == null) continue;
                switch (this.append.getProperties().getGraphProperties().getValueLabelType()) {
                    case 0: {
                        string = ((Chart1DDataSet)this.abs).getFormatedHintValue(number);
                        break;
                    }
                    case 2: {
                        ChartDataFilter chartDataFilter;
                        if (number != null) {
                            number = new Double(number.doubleValue() / this.getHintPercentFilter[n4]);
                        }
                        if ((chartDataFilter = this.getLabelText.getHintPercentFilter()) == null) {
                            chartDataFilter = ChartRenderTools.constructPercentFilter(chartDataFilter, true);
                        }
                        string = chartDataFilter.filter(number);
                        break;
                    }
                    case 3: {
                        ChartDataFilter chartDataFilter = this.getLabelText.getHintPercentFilter();
                        if (chartDataFilter == null) {
                            chartDataFilter = ChartRenderTools.constructPercentFilter(chartDataFilter, true);
                        }
                        if (number != null) {
                            string2 = chartDataFilter.filter(new Double(number.doubleValue() / this.getHintPercentFilter[n4]));
                        }
                        string = ((Chart1DDataSet)this.abs).getFormatedHintValue(number) + "(" + string2 + ")";
                        break;
                    }
                    default: {
                        string = "";
                    }
                }
                float_ = (Rectangle2D.Float)chartTextStyle.getDimension(string);
                if (this.filter) {
                    if (float_.width <= this.getPenWidth && this.getPrimType) {
                        blArray[i - this.getChartDataSetInfo][j] = true;
                        continue;
                    }
                    if (float_.height < this.getPenWidth && float_.width < Math.abs(this.clone[i][j]) && !this.getPrimType) {
                        blArray[i - this.getChartDataSetInfo][j] = true;
                        continue;
                    }
                    blArray[i - this.getChartDataSetInfo][j] = false;
                    continue;
                }
                blArray[i - this.getChartDataSetInfo][j] = float_.width <= Math.abs(this.clone[i][j]) && float_.height < this.getPenWidth && this.getPrimType ? true : float_.height < Math.abs(this.clone[i][j]) && float_.width < this.getPenWidth && !this.getPrimType;
            }
        }
        vector.add(new Boolean(!this.getPrimType));
        vector.add(blArray);
        return vector;
    }

    public void setGraphics(Graphics2D graphics2D) {
        this.SEDU = graphics2D;
    }

    public void setFilteredPaintColumn(int[] nArray) {
        this.paintCol = nArray;
    }
}

