/*
 * Decompiled with CFR 0.152.
 */
package chart.chart3d;

import chart.ChartShowValueCondition;
import chart.ChartShowValueSubCondition;
import chart.chart3d.ChartBlock;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGraphicsUtil;
import chart.graphics.ChartPenStyle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Vector;

public class Chart3DStrip
extends ChartBlock {
    ChartPenStyle SEDU;
    ChartFillPattern add;
    int addElement;
    boolean addVertex = true;
    int[] x = new int[4];
    int[] y = new int[4];
    Point2D.Float[] append = new Point2D.Float[4];
    GeneralPath closePath = new GeneralPath();
    int[] I = new int[3];
    GeneralPath draw = new GeneralPath();
    Color[] drawArea1;
    Color drawB;
    float drawSelectedShape;
    GeneralPath fill = new GeneralPath();
    private float get;
    private float getCondition;
    private float getConditionType;
    private float getEndValue;
    private float getFillColor;
    private ChartShowValueCondition getOtherColor;
    private float[] getStartValue;
    private float getSubConditons;
    private float lineTo;
    private int max;
    private int min;
    private int moveTo;
    private int reset;
    private int setColor;
    private int setLength;
    private boolean size;
    GeneralPath subtract = new GeneralPath();

    public Chart3DStrip() {
        for (int i = 0; i < 4; ++i) {
            this.append[i] = new Point2D.Float();
        }
        this.add = new ChartColorPattern("Red");
        this.SEDU = new ChartPenStyle("Solid Line");
    }

    public Chart3DStrip(ChartFillPattern chartFillPattern, boolean bl, ChartPenStyle chartPenStyle) {
        for (int i = 0; i < 4; ++i) {
            this.append[i] = new Point2D.Float();
        }
        this.add = chartFillPattern;
        this.addVertex = bl;
        this.SEDU = chartPenStyle;
    }

    public Chart3DStrip(boolean bl, ChartPenStyle chartPenStyle) {
        for (int i = 0; i < 4; ++i) {
            this.append[i] = new Point2D.Float();
        }
        this.addVertex = bl;
        this.SEDU = chartPenStyle;
    }

    public void drawLine(Graphics2D graphics2D, int n) {
        for (int i = 0; i < 6; ++i) {
            if ((n >> i & 1) != 1) continue;
            int n2 = 0;
            this.closePath.reset();
            switch (i) {
                case 0: {
                    this.append[0].x = this.tVertex[++n2][0];
                    this.append[0].y = this.tVertex[n2++][1];
                    this.append[1].x = this.tVertex[n2][0];
                    this.append[1].y = this.tVertex[n2][1];
                    this.append[2].x = this.tVertex[n2 += 4][0];
                    this.append[2].y = this.tVertex[n2--][1];
                    this.append[3].x = this.tVertex[n2][0];
                    this.append[3].y = this.tVertex[n2][1];
                    break;
                }
                case 1: {
                    this.append[0].x = this.tVertex[n2][0];
                    this.append[0].y = this.tVertex[n2][1];
                    this.append[1].x = this.tVertex[n2 += 3][0];
                    this.append[1].y = this.tVertex[n2][1];
                    this.append[2].x = this.tVertex[n2 += 4][0];
                    this.append[2].y = this.tVertex[n2][1];
                    this.append[3].x = this.tVertex[n2 -= 3][0];
                    this.append[3].y = this.tVertex[n2][1];
                    break;
                }
                case 2: {
                    this.append[0].x = this.tVertex[n2 += 4][0];
                    this.append[0].y = this.tVertex[n2++][1];
                    this.append[1].x = this.tVertex[n2][0];
                    this.append[1].y = this.tVertex[n2++][1];
                    this.append[2].x = this.tVertex[n2][0];
                    this.append[2].y = this.tVertex[n2++][1];
                    this.append[3].x = this.tVertex[n2][0];
                    this.append[3].y = this.tVertex[n2][1];
                    break;
                }
                case 3: {
                    this.append[0].x = this.tVertex[n2][0];
                    this.append[0].y = this.tVertex[n2++][1];
                    this.append[1].x = this.tVertex[n2][0];
                    this.append[1].y = this.tVertex[n2++][1];
                    this.append[2].x = this.tVertex[n2][0];
                    this.append[2].y = this.tVertex[n2++][1];
                    this.append[3].x = this.tVertex[n2][0];
                    this.append[3].y = this.tVertex[n2][1];
                    break;
                }
                case 4: {
                    this.append[0].x = this.tVertex[n2 += 3][0];
                    this.append[0].y = this.tVertex[n2--][1];
                    this.append[1].x = this.tVertex[n2][0];
                    this.append[1].y = this.tVertex[n2][1];
                    this.append[2].x = this.tVertex[n2 += 4][0];
                    this.append[2].y = this.tVertex[n2++][1];
                    this.append[3].x = this.tVertex[n2][0];
                    this.append[3].y = this.tVertex[n2][1];
                    break;
                }
                case 5: {
                    this.append[0].x = this.tVertex[n2][0];
                    this.append[0].y = this.tVertex[n2++][1];
                    this.append[1].x = this.tVertex[n2][0];
                    this.append[1].y = this.tVertex[n2][1];
                    this.append[2].x = this.tVertex[n2 += 4][0];
                    this.append[2].y = this.tVertex[n2--][1];
                    this.append[3].x = this.tVertex[n2][0];
                    this.append[3].y = this.tVertex[n2][1];
                }
            }
            this.closePath.moveTo(this.append[0].x, this.append[0].y);
            this.closePath.lineTo(this.append[1].x, this.append[1].y);
            this.closePath.lineTo(this.append[2].x, this.append[2].y);
            this.closePath.lineTo(this.append[3].x, this.append[3].y);
            this.closePath.lineTo(this.append[0].x, this.append[0].y);
            if (this.add != null) {
                this.add.fill(graphics2D, this.closePath);
            }
            if (this.addVertex) {
                this.SEDU.draw(graphics2D, this.closePath);
            }
            if (!this.size) continue;
            ChartGraphicsUtil.drawSelectedShape(graphics2D, this.closePath);
        }
    }

    public void draw1(Graphics2D graphics2D, int n, boolean bl) {
        int n2;
        for (n2 = 0; n2 < this.I[2]; ++n2) {
            graphics2D.setColor(ChartColorPattern.transparent(this.drawArea1[n2], this.drawSelectedShape));
            this.drawArea1(graphics2D, (this.I[1] + 1) * 4 + (n2 + 1) * 4);
        }
        for (n2 = 0; n2 < this.I[1]; ++n2) {
            this.drawB(graphics2D, n, bl, n2 * 4);
            graphics2D.setColor(ChartColorPattern.transparent(this.drawArea1[this.I[2] + n2], this.drawSelectedShape));
            this.drawArea1(graphics2D, (this.I[1] + 1) * 4 + (n2 + 1 + this.I[2]) * 4);
        }
        this.drawB(graphics2D, n, bl, 4 * this.I[1]);
        if (0 < this.I[0] - this.I[1] - this.I[2]) {
            for (n2 = 0; n2 < this.I[0] - this.I[1] - this.I[2]; ++n2) {
                graphics2D.setColor(ChartColorPattern.transparent(this.drawArea1[this.I[1] + this.I[2] + n2], this.drawSelectedShape));
                this.drawArea1(graphics2D, (2 * this.I[1] + 2 + n2 + this.I[2]) * 4);
            }
        }
    }

    public void draw2(Graphics2D graphics2D, int n, boolean bl) {
        int n2;
        if (0 < this.I[0] - this.I[1] - this.I[2]) {
            for (n2 = this.I[0] - this.I[1] - this.I[2] - 1; n2 >= 0; --n2) {
                graphics2D.setColor(ChartColorPattern.transparent(this.drawArea1[n2 + this.I[1] + this.I[2]], this.drawSelectedShape));
                this.drawArea1(graphics2D, (2 * this.I[1] + 2 + n2 + this.I[2]) * 4);
            }
        }
        this.drawB(graphics2D, n, bl, 4 * this.I[1]);
        for (n2 = this.I[1] - 1; n2 >= 0; --n2) {
            graphics2D.setColor(ChartColorPattern.transparent(this.drawArea1[this.I[2] + n2], this.drawSelectedShape));
            this.drawArea1(graphics2D, (this.I[1] + 1) * 4 + (n2 + 1 + this.I[2]) * 4);
            this.drawB(graphics2D, n, bl, n2 * 4);
        }
        for (n2 = this.I[2] - 1; n2 >= 0; --n2) {
            graphics2D.setColor(ChartColorPattern.transparent(this.drawArea1[n2], this.drawSelectedShape));
            this.drawArea1(graphics2D, (this.I[1] + 1) * 4 + (n2 + 1) * 4);
        }
    }

    public void drawArea(Graphics2D graphics2D, int n) {
        int n2 = n;
        if (this.drawB != null) {
            graphics2D.setColor(ChartColorPattern.transparent(this.drawB, this.drawSelectedShape));
        }
        this.append[0].x = this.tVertex[n2][0];
        this.append[0].y = this.tVertex[n2++][1];
        this.append[1].x = this.tVertex[n2][0];
        this.append[1].y = this.tVertex[n2++][1];
        this.append[2].x = this.tVertex[n2][0];
        this.append[2].y = this.tVertex[n2++][1];
        this.append[3].x = this.tVertex[n2][0];
        this.append[3].y = this.tVertex[n2][1];
        this.draw.reset();
        this.draw.moveTo(this.append[0].x, this.append[0].y);
        this.draw.lineTo(this.append[1].x, this.append[1].y);
        this.draw.lineTo(this.append[2].x, this.append[2].y);
        this.draw.lineTo(this.append[3].x, this.append[3].y);
        this.draw.lineTo(this.append[0].x, this.append[0].y);
        graphics2D.fill(this.draw);
    }

    public void drawArea1(Graphics2D graphics2D, int n) {
        int n2 = n;
        this.append[0].x = this.tVertex[n2][0];
        this.append[0].y = this.tVertex[n2++][1];
        this.append[1].x = this.tVertex[n2][0];
        this.append[1].y = this.tVertex[n2++][1];
        this.append[2].x = this.tVertex[n2][0];
        this.append[2].y = this.tVertex[n2++][1];
        this.append[3].x = this.tVertex[n2][0];
        this.append[3].y = this.tVertex[n2][1];
        this.draw.reset();
        this.draw.moveTo(this.append[0].x, this.append[0].y);
        this.draw.lineTo(this.append[1].x, this.append[1].y);
        this.draw.lineTo(this.append[2].x, this.append[2].y);
        this.draw.lineTo(this.append[3].x, this.append[3].y);
        this.draw.lineTo(this.append[0].x, this.append[0].y);
        graphics2D.fill(this.draw);
    }

    public void drawB(Graphics2D graphics2D, int n, boolean bl, int n2) {
        for (int i = 0; i < 6; ++i) {
            if ((n >> i & 1) != 1) continue;
            int n3 = n2;
            this.closePath.reset();
            switch (i) {
                case 0: {
                    this.append[0].x = this.tVertex[++n3][0];
                    this.append[0].y = this.tVertex[n3++][1];
                    this.append[1].x = this.tVertex[n3][0];
                    this.append[1].y = this.tVertex[n3][1];
                    this.append[2].x = this.tVertex[n3 += 4][0];
                    this.append[2].y = this.tVertex[n3--][1];
                    this.append[3].x = this.tVertex[n3][0];
                    this.append[3].y = this.tVertex[n3][1];
                    break;
                }
                case 1: {
                    this.append[0].x = this.tVertex[n3][0];
                    this.append[0].y = this.tVertex[n3][1];
                    this.append[1].x = this.tVertex[n3 += 3][0];
                    this.append[1].y = this.tVertex[n3][1];
                    this.append[2].x = this.tVertex[n3 += 4][0];
                    this.append[2].y = this.tVertex[n3][1];
                    this.append[3].x = this.tVertex[n3 -= 3][0];
                    this.append[3].y = this.tVertex[n3][1];
                    break;
                }
                case 2: {
                    this.append[0].x = this.tVertex[n3 += 4][0];
                    this.append[0].y = this.tVertex[n3++][1];
                    this.append[1].x = this.tVertex[n3][0];
                    this.append[1].y = this.tVertex[n3++][1];
                    this.append[2].x = this.tVertex[n3][0];
                    this.append[2].y = this.tVertex[n3++][1];
                    this.append[3].x = this.tVertex[n3][0];
                    this.append[3].y = this.tVertex[n3][1];
                    break;
                }
                case 3: {
                    this.append[0].x = this.tVertex[n3][0];
                    this.append[0].y = this.tVertex[n3++][1];
                    this.append[1].x = this.tVertex[n3][0];
                    this.append[1].y = this.tVertex[n3++][1];
                    this.append[2].x = this.tVertex[n3][0];
                    this.append[2].y = this.tVertex[n3++][1];
                    this.append[3].x = this.tVertex[n3][0];
                    this.append[3].y = this.tVertex[n3][1];
                    break;
                }
                case 4: {
                    this.append[0].x = this.tVertex[n3 += 3][0];
                    this.append[0].y = this.tVertex[n3--][1];
                    this.append[1].x = this.tVertex[n3][0];
                    this.append[1].y = this.tVertex[n3][1];
                    this.append[2].x = this.tVertex[n3 += 4][0];
                    this.append[2].y = this.tVertex[n3++][1];
                    this.append[3].x = this.tVertex[n3][0];
                    this.append[3].y = this.tVertex[n3][1];
                    break;
                }
                case 5: {
                    this.append[0].x = this.tVertex[n3][0];
                    this.append[0].y = this.tVertex[n3++][1];
                    this.append[1].x = this.tVertex[n3][0];
                    this.append[1].y = this.tVertex[n3][1];
                    this.append[2].x = this.tVertex[n3 += 4][0];
                    this.append[2].y = this.tVertex[n3--][1];
                    this.append[3].x = this.tVertex[n3][0];
                    this.append[3].y = this.tVertex[n3][1];
                }
            }
            this.closePath.moveTo(this.append[0].x, this.append[0].y);
            this.closePath.lineTo(this.append[1].x, this.append[1].y);
            this.closePath.lineTo(this.append[2].x, this.append[2].y);
            this.closePath.lineTo(this.append[3].x, this.append[3].y);
            this.closePath.lineTo(this.append[0].x, this.append[0].y);
            if (this.add != null) {
                this.add.fill(graphics2D, this.closePath);
            }
            if (bl) {
                this.SEDU.draw(graphics2D, this.closePath);
            }
            if (!this.size) continue;
            ChartGraphicsUtil.drawSelectedShape(graphics2D, this.closePath);
        }
    }

    public Vector stripToHtml(int n, int n2, Point point, int n3) {
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer(24);
        for (n = 0; n < 6; ++n) {
            if ((n3 >> n & 1) != 1) continue;
            n2 = 0;
            switch (n) {
                case 0: {
                    this.append[0].x = this.tVertex[++n2][0];
                    this.append[0].y = this.tVertex[n2++][1];
                    this.append[1].x = this.tVertex[n2][0];
                    this.append[1].y = this.tVertex[n2][1];
                    this.append[2].x = this.tVertex[n2 += 4][0];
                    this.append[2].y = this.tVertex[n2--][1];
                    this.append[3].x = this.tVertex[n2][0];
                    this.append[3].y = this.tVertex[n2][1];
                    break;
                }
                case 1: {
                    this.append[0].x = this.tVertex[n2][0];
                    this.append[0].y = this.tVertex[n2][1];
                    this.append[1].x = this.tVertex[n2 += 3][0];
                    this.append[1].y = this.tVertex[n2][1];
                    this.append[2].x = this.tVertex[n2 += 4][0];
                    this.append[2].y = this.tVertex[n2][1];
                    this.append[3].x = this.tVertex[n2 -= 3][0];
                    this.append[3].y = this.tVertex[n2][1];
                    break;
                }
                case 2: {
                    this.append[0].x = this.tVertex[n2 += 4][0];
                    this.append[0].y = this.tVertex[n2++][1];
                    this.append[1].x = this.tVertex[n2][0];
                    this.append[1].y = this.tVertex[n2++][1];
                    this.append[2].x = this.tVertex[n2][0];
                    this.append[2].y = this.tVertex[n2++][1];
                    this.append[3].x = this.tVertex[n2][0];
                    this.append[3].y = this.tVertex[n2][1];
                    break;
                }
                case 3: {
                    this.append[0].x = this.tVertex[n2][0];
                    this.append[0].y = this.tVertex[n2++][1];
                    this.append[1].x = this.tVertex[n2][0];
                    this.append[1].y = this.tVertex[n2++][1];
                    this.append[2].x = this.tVertex[n2][0];
                    this.append[2].y = this.tVertex[n2++][1];
                    this.append[3].x = this.tVertex[n2][0];
                    this.append[3].y = this.tVertex[n2][1];
                    break;
                }
                case 4: {
                    this.append[0].x = this.tVertex[n2 += 3][0];
                    this.append[0].y = this.tVertex[n2--][1];
                    this.append[1].x = this.tVertex[n2][0];
                    this.append[1].y = this.tVertex[n2][1];
                    this.append[2].x = this.tVertex[n2 += 4][0];
                    this.append[2].y = this.tVertex[n2++][1];
                    this.append[3].x = this.tVertex[n2][0];
                    this.append[3].y = this.tVertex[n2][1];
                    break;
                }
                case 5: {
                    this.append[0].x = this.tVertex[n2][0];
                    this.append[0].y = this.tVertex[n2++][1];
                    this.append[1].x = this.tVertex[n2][0];
                    this.append[1].y = this.tVertex[n2][1];
                    this.append[2].x = this.tVertex[n2 += 4][0];
                    this.append[2].y = this.tVertex[n2--][1];
                    this.append[3].x = this.tVertex[n2][0];
                    this.append[3].y = this.tVertex[n2][1];
                }
            }
            int n4 = 5;
            this.x[0] = (int)this.append[0].x - n4;
            this.y[0] = (int)this.append[0].y + n4;
            this.x[1] = (int)this.append[1].x + n4;
            this.y[1] = (int)this.append[1].y - n4;
            this.x[2] = (int)this.append[2].x + n4;
            this.y[2] = (int)this.append[2].y - n4;
            this.x[3] = (int)this.append[3].x - n4;
            this.y[3] = (int)this.append[3].y + n4;
            for (int i = 0; i < 4; ++i) {
                stringBuffer.append(this.x[i] + point.x).append(',').append(this.y[i] + point.y).append(',');
            }
            stringBuffer.append(this.x[0] + point.x).append(',').append(this.y[0] + point.y);
            vector.addElement(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        return vector;
    }

    public void drawAreaSurface(Graphics2D graphics2D, boolean bl) {
        this.closePath.reset();
        this.closePath.moveTo(this.tVertex[0][0], this.tVertex[0][1]);
        this.closePath.lineTo(this.tVertex[1][0], this.tVertex[1][1]);
        this.closePath.lineTo(this.tVertex[2][0], this.tVertex[2][1]);
        this.closePath.lineTo(this.tVertex[3][0], this.tVertex[3][1]);
        this.closePath.lineTo(this.tVertex[0][0], this.tVertex[0][1]);
        int n = 0;
        if (this.getOtherColor != null) {
            n = this.getOtherColor.getConditionType();
        }
        if (n == 2) {
            float f = Math.max(this.get, this.getCondition);
            float f2 = Math.min(this.get, this.getCondition);
            float[][] fArray2 = new float[4][2];
            if (this.get <= this.getCondition && this.get >= 0.0f || this.get <= 0.0f && this.get <= this.getCondition) {
                fArray2[0][0] = this.tVertex[3][0];
                fArray2[0][1] = this.tVertex[3][1];
                fArray2[1][0] = this.tVertex[0][0];
                fArray2[1][1] = this.tVertex[0][1];
                fArray2[2][0] = this.tVertex[1][0];
                fArray2[2][1] = this.tVertex[1][1];
                fArray2[3][0] = this.tVertex[2][0];
                fArray2[3][1] = this.tVertex[2][1];
            } else {
                fArray2[0][0] = this.tVertex[2][0];
                fArray2[0][1] = this.tVertex[2][1];
                fArray2[1][0] = this.tVertex[1][0];
                fArray2[1][1] = this.tVertex[1][1];
                fArray2[2][0] = this.tVertex[0][0];
                fArray2[2][1] = this.tVertex[0][1];
                fArray2[3][0] = this.tVertex[3][0];
                fArray2[3][1] = this.tVertex[3][1];
            }
            if (this.get != this.getCondition) {
                this.SEDU(graphics2D, this.getOtherColor, fArray2, f, f2, this.closePath);
            } else if (this.get == f2) {
                this.addElement(graphics2D, this.getOtherColor, this.closePath, false);
            } else {
                this.addElement(graphics2D, this.getOtherColor, this.closePath, true);
            }
        } else if (this.add != null) {
            this.add.fill(graphics2D, this.closePath);
        }
        if (bl) {
            this.SEDU.draw(graphics2D, this.closePath);
        }
        this.subtract.reset();
        this.subtract.moveTo(this.tVertex[0][0], this.tVertex[0][1]);
        this.subtract.lineTo(this.tVertex[1][0], this.tVertex[1][1]);
        this.subtract.lineTo(this.tVertex[2][0], this.tVertex[2][1]);
        this.subtract.lineTo(this.tVertex[3][0], this.tVertex[3][1]);
        this.subtract.lineTo(this.tVertex[0][0], this.tVertex[0][1]);
    }

    public void fillSurface(Graphics2D graphics2D) {
        int n = this.tVertex.length;
        if (n <= 1) {
            return;
        }
        this.closePath.reset();
        this.closePath.moveTo(this.tVertex[0][0], this.tVertex[0][1]);
        for (int i = 1; i < n; ++i) {
            this.closePath.lineTo(this.tVertex[i][0], this.tVertex[i][1]);
        }
        this.closePath.lineTo(this.tVertex[0][0], this.tVertex[0][1]);
        this.closePath.closePath();
        if (this.add != null) {
            this.add.fill(graphics2D, this.closePath);
        }
    }

    public void drawSurfaceGrid(Graphics2D graphics2D) {
        int n = this.tVertex.length;
        if (n <= 1) {
            return;
        }
        if (this.addVertex) {
            if (n == 3) {
                this.closePath.reset();
                this.closePath.moveTo(this.tVertex[0][0], this.tVertex[0][1]);
                this.closePath.lineTo(this.tVertex[1][0], this.tVertex[1][1]);
                this.SEDU.draw(graphics2D, this.closePath);
            } else {
                this.closePath.reset();
                this.closePath.moveTo(this.tVertex[0][0], this.tVertex[0][1]);
                this.closePath.lineTo(this.tVertex[1][0], this.tVertex[1][1]);
                this.SEDU.draw(graphics2D, this.closePath);
            }
        }
    }

    public void drawSurfaceContour(Graphics2D graphics2D) {
        this.closePath.reset();
        this.closePath.moveTo(this.tVertex[0][0], this.tVertex[0][1]);
        this.closePath.lineTo(this.tVertex[2][0], this.tVertex[2][1]);
        this.closePath.lineTo(this.tVertex[1][0], this.tVertex[1][1]);
        this.SEDU.draw(graphics2D, this.closePath);
    }

    public Area areaSurface() {
        this.closePath.reset();
        this.closePath.moveTo(this.tVertex[0][0], this.tVertex[0][1]);
        this.closePath.lineTo(this.tVertex[1][0], this.tVertex[1][1]);
        this.closePath.lineTo(this.tVertex[2][0], this.tVertex[2][1]);
        this.closePath.lineTo(this.tVertex[3][0], this.tVertex[3][1]);
        this.closePath.lineTo(this.tVertex[0][0], this.tVertex[0][1]);
        return new Area(this.closePath);
    }

    public void setPen(ChartPenStyle chartPenStyle) {
        this.SEDU = chartPenStyle;
    }

    public ChartPenStyle getPen() {
        return this.SEDU;
    }

    public void setPattern(ChartFillPattern chartFillPattern) {
        this.add = chartFillPattern;
    }

    public ChartFillPattern getPattern() {
        return this.add;
    }

    public void setShownFaces(int n) {
        this.addElement = n;
    }

    public int getShownFaces() {
        return this.addElement;
    }

    public void setLineVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.vertex = new float[8][3];
        this.tVertex = new float[8][2];
        this.addVertex(f, f2, f3);
        this.addVertex(f4, f5, f6);
        this.addVertex(f4, f5, f6 + f8);
        this.addVertex(f, f2, f3 + f8);
        this.addVertex(f, f2 + f7, f3);
        this.addVertex(f4, f5 + f7, f6);
        this.addVertex(f4, f5 + f7, f6 + f8);
        this.addVertex(f, f2 + f7, f3 + f8);
    }

    public void setAreaSurfaceVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.vertex = new float[4][3];
        this.tVertex = new float[4][2];
        this.addVertex(f, f2, f3);
        this.addVertex(f4, f5, f6);
        this.addVertex(f4, f5, f6 + f7);
        this.addVertex(f, f2, f3 + f7);
    }

    public void setSurfaceVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.vertex = new float[3][3];
        this.tVertex = new float[3][2];
        this.addVertex(f, f2, f3);
        this.addVertex(f4, f5, f6);
        this.addVertex(f7, f8, f9);
    }

    public void setSurfaceVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.vertex = new float[4][3];
        this.tVertex = new float[4][2];
        this.addVertex(f, f2, f3);
        this.addVertex(f4, f5, f6);
        this.addVertex(f7, f8, f9);
        this.addVertex(f10, f11, f12);
    }

    public void setSurfaceVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15) {
        this.vertex = new float[5][3];
        this.tVertex = new float[5][2];
        this.addVertex(f, f2, f3);
        this.addVertex(f4, f5, f6);
        this.addVertex(f7, f8, f9);
        this.addVertex(f10, f11, f12);
        this.addVertex(f13, f14, f15);
    }

    public void setLineVertex1(float f, float f2, float f3, float f4, float f5, float f6) {
        this.addVertex(f, f2, f3);
        this.addVertex(f + f6, f2 + f4, f3);
        this.addVertex(f + f6, f2 + f4, f3 + f5);
        this.addVertex(f, f2, f3 + f5);
    }

    public void setLineVertexForArea(float f, float f2, float f3, float f4, float f5, float f6) {
        this.addVertex(f, f2, f3);
        this.addVertex(f + f6, f4, f3);
        this.addVertex(f + f6, f4, f3 + f5);
        this.addVertex(f, f2, f3 + f5);
    }

    public void setK(int[] nArray) {
        this.I = nArray;
    }

    public void setThresholdColor(Color[] colorArray, float f) {
        this.drawArea1 = new Color[colorArray.length];
        this.drawArea1 = colorArray;
        this.drawSelectedShape = f;
    }

    public void setThresholdColor(Color color, float f) {
        this.drawB = color;
        this.drawSelectedShape = f;
    }

    public Shape surfaceToHtml() {
        this.fill.reset();
        this.fill.moveTo(this.tVertex[0][0], this.tVertex[0][1]);
        for (int i = 1; i < this.tVertex.length; ++i) {
            this.fill.lineTo(this.tVertex[i][0], this.tVertex[i][1]);
        }
        this.fill.lineTo(this.tVertex[0][0], this.tVertex[0][1]);
        return this.fill;
    }

    public Shape toHtml() {
        this.reset = 0;
        this.setColor = 0;
        this.setLength = 0;
        this.max = 4;
        this.min = 4;
        this.moveTo = 4;
        for (int i = 0; i < 4; ++i) {
            this.reset = this.tVertex[i][0] <= this.tVertex[this.reset][0] ? i : this.reset;
            this.setColor = this.tVertex[i][0] >= this.tVertex[this.setColor][0] ? i : this.setColor;
            this.setLength = this.tVertex[i][1] <= this.tVertex[this.setLength][1] ? i : this.setLength;
            this.max = this.tVertex[i + 4][0] <= this.tVertex[this.max][0] ? i + 4 : this.max;
            this.min = this.tVertex[i + 4][0] >= this.tVertex[this.min][0] ? i + 4 : this.min;
            this.moveTo = this.tVertex[i + 4][1] >= this.tVertex[this.moveTo][1] ? i + 4 : this.moveTo;
        }
        this.fill.reset();
        this.fill.moveTo(this.tVertex[this.reset][0], this.tVertex[this.reset][1]);
        this.fill.lineTo(this.tVertex[this.max][0], this.tVertex[this.max][1]);
        this.fill.lineTo(this.tVertex[this.moveTo][0], this.tVertex[this.moveTo][1]);
        this.fill.lineTo(this.tVertex[this.min][0], this.tVertex[this.min][1]);
        this.fill.lineTo(this.tVertex[this.setColor][0], this.tVertex[this.setColor][1]);
        this.fill.lineTo(this.tVertex[this.setLength][0], this.tVertex[this.setLength][1]);
        this.fill.lineTo(this.tVertex[this.reset][0], this.tVertex[this.reset][1]);
        return this.fill;
    }

    public void setSelectedStatus(boolean bl) {
        this.size = bl;
    }

    public void drawSelectedOutLine(Graphics2D graphics2D) {
        ChartGraphicsUtil.drawSelectedShape(graphics2D, this.subtract);
    }

    private void SEDU(Graphics2D graphics2D, ChartShowValueCondition chartShowValueCondition, float[][] fArray2, float f, float f2, GeneralPath generalPath) {
        int n = chartShowValueCondition.getSubConditons().size();
        Area area = new Area();
        area.add(new Area(generalPath));
        for (int i = 0; i < n; ++i) {
            Shape shape = this.add(fArray2, f2, f, chartShowValueCondition.getCondition(i).getStartValue(), chartShowValueCondition.getCondition(i).getEndValue());
            if (shape == null) continue;
            chartShowValueCondition.getCondition(i).getFillColor().fill(graphics2D, shape);
            area.subtract(new Area(shape));
        }
        if (area != null) {
            chartShowValueCondition.getOtherColor().fill(graphics2D, area);
        }
    }

    private Shape add(float[][] fArray2, float f, float f2, float f3, float f4) {
        float f5;
        float[][] fArray3 = new float[4][2];
        GeneralPath generalPath = new GeneralPath();
        boolean bl = false;
        if (f > f3) {
            if (f > f4) {
                return null;
            }
            f5 = f;
        } else {
            if (f3 > f2) {
                return null;
            }
            f5 = f3;
        }
        if (!bl) {
            fArray3[0][0] = fArray2[0][0] + (fArray2[3][0] - fArray2[0][0]) * (f5 - f) / (f2 - f);
            fArray3[0][1] = fArray2[0][1] + (fArray2[3][1] - fArray2[0][1]) * (f5 - f) / (f2 - f);
            fArray3[1][0] = fArray2[1][0] + (fArray2[2][0] - fArray2[1][0]) * (f5 - f) / (f2 - f);
            fArray3[1][1] = fArray2[1][1] + (fArray2[2][1] - fArray2[1][1]) * (f5 - f) / (f2 - f);
        }
        float f6 = f2 >= f4 ? f4 : f2;
        if (!bl) {
            fArray3[2][0] = fArray2[1][0] + (fArray2[2][0] - fArray2[1][0]) * (f6 - f) / (f2 - f);
            fArray3[2][1] = fArray2[1][1] + (fArray2[2][1] - fArray2[1][1]) * (f6 - f) / (f2 - f);
            fArray3[3][0] = fArray2[0][0] + (fArray2[3][0] - fArray2[0][0]) * (f6 - f) / (f2 - f);
            fArray3[3][1] = fArray2[0][1] + (fArray2[3][1] - fArray2[0][1]) * (f6 - f) / (f2 - f);
        }
        generalPath.moveTo(fArray3[0][0], fArray3[0][1]);
        generalPath.lineTo(fArray3[1][0], fArray3[1][1]);
        generalPath.lineTo(fArray3[2][0], fArray3[2][1]);
        generalPath.lineTo(fArray3[3][0], fArray3[3][1]);
        generalPath.closePath();
        return generalPath;
    }

    public void setValueScope(float f, float f2, float f3, float f4, float f5, float[] fArray2) {
        this.get = f2;
        this.getConditionType = f;
        this.getCondition = f3;
        this.getEndValue = f4;
        this.getFillColor = f5;
        this.getStartValue = fArray2;
    }

    public void setConditionalFill(ChartShowValueCondition chartShowValueCondition) {
        this.getOtherColor = chartShowValueCondition;
    }

    private void addElement(Graphics2D graphics2D, ChartShowValueCondition chartShowValueCondition, GeneralPath generalPath, boolean bl) {
        int n = chartShowValueCondition.getSubConditons().size();
        int n2 = -1;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = bl ? this.get : this.getConditionType;
        for (int i = n - 1; i >= 0; --i) {
            f = ((ChartShowValueSubCondition)chartShowValueCondition.getSubConditons().get(i)).getStartValue();
            f2 = ((ChartShowValueSubCondition)chartShowValueCondition.getSubConditons().get(i)).getEndValue();
            if (!(f <= f3) || !(f3 <= f2)) continue;
            n2 = i;
            break;
        }
        if (n2 != -1) {
            ((ChartShowValueSubCondition)chartShowValueCondition.getSubConditons().get(n2)).getFillColor().fill(graphics2D, generalPath);
        } else {
            chartShowValueCondition.getOtherColor().fill(graphics2D, generalPath);
        }
    }

    public void setStartValue(float f) {
        this.getSubConditons = f;
    }

    public void setEndValue(float f) {
        this.lineTo = f;
    }

    public float getStartValue() {
        return this.getSubConditons;
    }

    public float getEndValue() {
        return this.lineTo;
    }
}

