/*
 * Decompiled with CFR 0.152.
 */
package chart.chart3d;

import chart.ChartDataObject;
import chart.ChartShowValueCondition;
import chart.axis.ChartCategoryAxis;
import chart.chart3d.Chart3DObject;
import chart.chart3d.Chart3DPaper;
import chart.chart3d.ChartCompass;
import chart.chart3d.ChartCube;
import chart.chart3d.ChartMatrix;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartPenStyle;
import chart.properties.ChartNumericAxisProperties;
import chart.util.ChartHintLabel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.List;

public class Graph3DBarA
extends Chart3DObject {
    ChartDataSet addVertex;
    protected int[] grpIdx;
    protected int[][] barIdx;
    protected boolean contour;
    private ChartPenStyle availableLength;
    private ChartCompass availableOriginY;
    ChartCube[][] custommerConstant;
    boolean[][] draw1;
    int draw2;
    protected ChartMatrix tempM = new ChartMatrix();
    private boolean floatValue;
    private boolean get;
    private boolean getAbsoluteValueSumOfCategory;
    int[] getAxisX1;
    protected ChartMatrix matrix;
    protected int col;
    protected int row;
    protected int numofTicks;
    protected ChartFillPattern[] pattern;
    float[] getBarWidth;
    float[][] getCategoryName;
    int getCategorySize = 2;
    float[] getChartDataSet;
    Color[] getChartDataSetInfo;
    float getChartDataSetModel = 0.6f;
    private boolean getChartLink;
    private ChartShowValueCondition getChartLinkInfo = null;

    Graph3DBarA(ChartDataSet chartDataSet, Chart3DPaper chart3DPaper) {
        super(chartDataSet, chart3DPaper);
        this.addVertex = chartDataSet;
        this.getAxisX1 = chart3DPaper.getIntType();
        this.paper = chart3DPaper;
        this.col = chartDataSet.getCategorySize();
        this.row = chartDataSet.getSeriesSize();
        this.pattern = chart3DPaper.getChartPlatform().getFillPatternByArarry(0);
        this.getChartDataSetModel = chart3DPaper.getProperties().getGraphProperties().getThresholdFillTransparency();
    }

    @Override
    public void init() {
        int n;
        int n2;
        int n3 = this.dataset.getChartDataSetInfo().getChartType();
        int n4 = ChartTypeInfo.getPrimType(n3);
        this.getChartLink = n4 == 1;
        this.setCompass(this.paper.getCompass());
        this.contour = this.paper.getProperties().getGraphProperties().isContour();
        this.availableLength = this.properties.getGraphProperties().getContourPen();
        this.custommerConstant = new ChartCube[this.row][this.col];
        this.getCategoryName = new float[this.row][this.col];
        this.draw1 = new boolean[this.row][this.col];
        this.getBarWidth = this.paper.getUnit();
        float f = this.getBarWidth[0] * this.paper.getProperties().getGraphProperties().getBarWidth();
        float f2 = this.getBarWidth[0] / 2.0f + f / 2.0f;
        float f3 = this.getBarWidth[2] * this.paper.getProperties().getGraphProperties().getBarWidth();
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        f9 = this.paper.getOriginY();
        f6 = (this.getBarWidth[2] + f3) / 2.0f;
        f8 = 0.0f;
        float[] fArray2 = new float[this.col];
        if (this.dataset.getChartDataSetModel().isOneGroupForBar()) {
            for (n2 = 0; n2 < this.col; ++n2) {
                for (n = 0; n < this.col; ++n) {
                    fArray2[n2] = fArray2[n2] + (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(n);
                }
            }
        } else {
            for (n2 = 0; n2 < this.col; ++n2) {
                fArray2[n2] = (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(n2);
            }
        }
        for (n2 = 0; n2 < this.row; ++n2) {
            for (n = 0; n < this.col; ++n) {
                Number number = ((Chart1DDataSet)this.dataset).getValue(n2, n);
                if (number == null) {
                    this.getCategoryName[n2][n] = 0.0f;
                    this.draw1[n2][n] = false;
                    continue;
                }
                this.getCategoryName[n2][n] = !((ChartNumericAxisProperties)this.paper.C.getProperties()).getIsShowPercent() ? number.floatValue() : number.floatValue() / fArray2[n];
                this.draw1[n2][n] = this.getCategoryName[n2][n] < 0.0f;
            }
        }
        if (this.paper.getProperties().getGraphProperties().isShowThresholdLine() && this.paper.getProperties().getGraphProperties().isShowThresholdLine2()) {
            this.getCategorySize = 2;
            this.getChartDataSet = new float[this.getCategorySize];
            this.getChartDataSetInfo = new Color[this.getCategorySize];
            this.getChartDataSet[0] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue();
            this.getChartDataSet[1] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue2();
            this.getChartDataSetInfo[0] = this.paper.getProperties().getGraphProperties().getThresholdLineColor();
            this.getChartDataSetInfo[1] = this.paper.getProperties().getGraphProperties().getThresholdLineColor2();
        } else if (this.paper.getProperties().getGraphProperties().isShowThresholdLine()) {
            this.getCategorySize = 1;
            this.getChartDataSet = new float[this.getCategorySize];
            this.getChartDataSetInfo = new Color[this.getCategorySize];
            this.getChartDataSet[0] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue();
            this.getChartDataSetInfo[0] = this.paper.getProperties().getGraphProperties().getThresholdLineColor();
        } else if (this.paper.getProperties().getGraphProperties().isShowThresholdLine2()) {
            this.getCategorySize = 1;
            this.getChartDataSet = new float[this.getCategorySize];
            this.getChartDataSetInfo = new Color[this.getCategorySize];
            this.getChartDataSet[0] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue2();
            this.getChartDataSetInfo[0] = this.paper.getProperties().getGraphProperties().getThresholdLineColor2();
        } else {
            this.getCategorySize = 0;
            this.getChartDataSet = new float[this.getCategorySize];
            this.getChartDataSetInfo = new Color[this.getCategorySize];
        }
        for (n2 = 0; n2 < this.getCategorySize; ++n2) {
            float f11 = 0.0f;
            for (int i = n2; i < this.getCategorySize; ++i) {
                if (!(this.getChartDataSet[n2] > this.getChartDataSet[i])) continue;
                f11 = this.getChartDataSet[i];
                this.getChartDataSet[i] = this.getChartDataSet[n2];
                this.getChartDataSet[n2] = f11;
                Color color = this.getChartDataSetInfo[i];
                this.getChartDataSetInfo[i] = this.getChartDataSetInfo[n2];
                this.getChartDataSetInfo[n2] = color;
            }
        }
        float[] fArray3 = new float[this.getCategorySize];
        for (int i = 0; i < this.getCategorySize; ++i) {
            fArray3[i] = this.paper.availableLength(this.getChartDataSet[i] * this.getBarWidth[1]);
            if (!(fArray3[i] < 2.0f) || fArray3[i] == 0.0f) continue;
            fArray3[i] = fArray3[i] + 3.0f;
        }
        ChartCategoryAxis chartCategoryAxis = (ChartCategoryAxis)this.paper.getAxisX1();
        float f12 = this.properties.getGraphProperties().getBarWidth();
        float f13 = chartCategoryAxis.getMinUnit(this.getBarWidth[0]);
        float f14 = f13 * f12;
        for (int i = 0; i < this.row; ++i) {
            if (!this.paper.getAxisX1().custommerConstant()) {
                f4 = f2;
                f7 = 0.0f;
            }
            for (int j = 0; j < this.col; ++j) {
                int n5;
                int n6;
                float f15;
                Object object;
                if (this.paper.getAxisX1().custommerConstant()) {
                    object = this.getChartDataSet().getChartDataSetModel().getCategoryName(j);
                    f4 = f15 = chartCategoryAxis.getX(object, this.getBarWidth[0]);
                    f = f14;
                    f7 = f4;
                }
                this.custommerConstant[i][j] = new ChartCube();
                this.custommerConstant[i][j].I = this.getCategorySize;
                this.custommerConstant[i][j].setPattern(this.pattern[i]);
                f10 = this.paper.availableLength(this.getCategoryName[i][j] * this.getBarWidth[1]);
                f5 = this.paper.availableOriginY(f9);
                object = new int[3];
                object[0] = this.getCategorySize;
                object[1] = false;
                object[2] = false;
                this.custommerConstant[i][j].addVertex(f4 - f, f5, f6 - f3);
                this.custommerConstant[i][j].addVertex(f4, f5, f6 - f3);
                this.custommerConstant[i][j].addVertex(f4, f5, f6);
                this.custommerConstant[i][j].addVertex(f4 - f, f5, f6);
                if (f5 <= f10) {
                    for (n6 = 0; n6 < this.getCategorySize; ++n6) {
                        if (fArray3[n6] < f10 && fArray3[n6] > f5) {
                            this.custommerConstant[i][j].addVertex(f4 - f, fArray3[n6], f6 - f3);
                            this.custommerConstant[i][j].addVertex(f4, fArray3[n6], f6 - f3);
                            this.custommerConstant[i][j].addVertex(f4, fArray3[n6], f6);
                            this.custommerConstant[i][j].addVertex(f4 - f, fArray3[n6], f6);
                            Object object2 = object;
                            object2[1] = object2[1] + true;
                            continue;
                        }
                        if (!(fArray3[n6] <= f5)) continue;
                        Object object3 = object;
                        object3[2] = object3[2] + true;
                    }
                } else {
                    for (n6 = this.getCategorySize - 1; n6 >= 0; --n6) {
                        if (fArray3[n6] > f10 && fArray3[n6] < f5) {
                            this.custommerConstant[i][j].addVertex(f4 - f, fArray3[n6], f6 - f3);
                            this.custommerConstant[i][j].addVertex(f4, fArray3[n6], f6 - f3);
                            this.custommerConstant[i][j].addVertex(f4, fArray3[n6], f6);
                            this.custommerConstant[i][j].addVertex(f4 - f, fArray3[n6], f6);
                            Object object4 = object;
                            object4[1] = object4[1] + true;
                            continue;
                        }
                        if (!(fArray3[n6] >= f5)) continue;
                        Object object5 = object;
                        object5[2] = object5[2] + true;
                    }
                }
                this.custommerConstant[i][j].addVertex(f4 - f, f10, f6 - f3);
                this.custommerConstant[i][j].addVertex(f4, f10, f6 - f3);
                this.custommerConstant[i][j].addVertex(f4, f10, f6);
                this.custommerConstant[i][j].addVertex(f4 - f, f10, f6);
                f15 = 0.0f;
                float f16 = 0.0f;
                if (this.paper.getAxisX1().custommerConstant()) {
                    float f17;
                    f16 = 0.0f;
                    f15 = f;
                    if (j != this.col - 1) {
                        Object object6 = this.getChartDataSet().getChartDataSetModel().getCategoryName(j + 1);
                        f17 = chartCategoryAxis.getX(object6, this.getBarWidth[0]);
                        f15 = f17 - f4;
                    } else if (j == this.col - 1) {
                        Object object7 = this.getChartDataSet().getChartDataSetModel().getCategoryName(j);
                        f17 = chartCategoryAxis.getX(object7, this.getBarWidth[0]);
                        f15 = this.paper.getLength()[0] - f17;
                    }
                } else {
                    f15 = this.getBarWidth[0];
                }
                if (f5 <= f10) {
                    for (n5 = 0; n5 < this.getCategorySize; ++n5) {
                        this.custommerConstant[i][j].addVertex(f7, fArray3[n5], f8);
                        this.custommerConstant[i][j].addVertex(f7 + f15, fArray3[n5], f8);
                        this.custommerConstant[i][j].addVertex(f7 + f15, fArray3[n5], f8 + this.getBarWidth[2]);
                        this.custommerConstant[i][j].addVertex(f7, fArray3[n5], f8 + this.getBarWidth[2]);
                    }
                } else {
                    for (n5 = this.getCategorySize - 1; n5 >= 0; --n5) {
                        this.custommerConstant[i][j].addVertex(f7, fArray3[n5], f8);
                        this.custommerConstant[i][j].addVertex(f7 + f15, fArray3[n5], f8);
                        this.custommerConstant[i][j].addVertex(f7 + f15, fArray3[n5], f8 + this.getBarWidth[2]);
                        this.custommerConstant[i][j].addVertex(f7, fArray3[n5], f8 + this.getBarWidth[2]);
                    }
                }
                this.custommerConstant[i][j].setNumber((int[])object);
                this.custommerConstant[i][j].setThresholdColor(this.getChartDataSetInfo, this.getChartDataSetModel);
                if (((Chart1DDataSet)this.dataset).getValue(i, j) == null) {
                    this.custommerConstant[i][j].isNullValueBar(true);
                }
                if (this.paper.getAxisX1().custommerConstant()) continue;
                f4 += this.getBarWidth[0];
                f7 += this.getBarWidth[0];
            }
            f6 += this.getBarWidth[2];
            f8 += this.getBarWidth[2];
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (this.paper.I.getShowValueConditions() != null && this.paper.I.getShowValueConditions().getConditions() != null && this.paper.I.getShowValueConditions().getConditions().size() > 0) {
            this.getChartLinkInfo = (ChartShowValueCondition)this.paper.I.getShowValueConditions().getConditions().get(0);
        }
        int[] nArray = new int[]{0, this.col - 1};
        if (this.paper.getFilterConstant() != null) {
            nArray = this.paper.getFilterConstant();
        }
        for (int i = 0; i < this.row; ++i) {
            int n = i;
            if (!this.floatValue) {
                n = this.row - i - 1;
            }
            for (int j = 0; j < this.col; ++j) {
                int n2 = j;
                if (!this.get) {
                    n2 = this.col - j - 1;
                }
                if (n2 < nArray[0] || n2 > nArray[1]) continue;
                this.draw2 = this.availableOriginY.shownFace(this.custommerConstant[n][n2].tVertex, 0);
                if (this.draw1[n][n2]) {
                    this.SEDU();
                }
                if (this.dataset.getChartDataSetModel().isOneGroupForBar() && !this.dataset.getChartDataSetModel().isTurnedXZ()) {
                    if (this.paper.getProperties().getGraphProperties().isVaryColorbyValues()) {
                        this.custommerConstant[n][n2].setPattern(this.pattern[n2]);
                    } else {
                        this.custommerConstant[n][n2].setPattern(this.pattern[0]);
                    }
                } else {
                    this.custommerConstant[n][n2].setPattern(this.pattern[n]);
                }
                if (this.status == 1 && n == this.selectedSeriesIndex) {
                    this.custommerConstant[n][n2].setSelectedStatus(true);
                } else {
                    this.custommerConstant[n][n2].setSelectedStatus(false);
                }
                float f = 0.0f;
                if (((Chart1DDataSet)this.dataset).getValue(n, n2) != null) {
                    f = ((Chart1DDataSet)this.dataset).getValue(n, n2).floatValue();
                }
                float f2 = this.paper.getMinAxisValue();
                float f3 = this.paper.getMaxAxisValue();
                if (f >= 0.0f) {
                    if (f2 < 0.0f) {
                        f2 = 0.0f;
                    }
                    if (f3 > f) {
                        f3 = f;
                    }
                    f = f3;
                } else if (this.paper.getMaxAxisValue() >= 0.0f) {
                    f3 = 0.0f;
                    if (f2 < f) {
                        f2 = f;
                    } else {
                        f = f2;
                    }
                } else {
                    f3 = this.paper.getMaxAxisValue();
                    if (f2 < f) {
                        f2 = f;
                    } else {
                        f = f2;
                    }
                }
                this.custommerConstant[n][n2].setValueScope(f2, f3, f, this.getChartDataSet);
                this.custommerConstant[n][n2].setConditionalFill(this.getChartLinkInfo);
                if (this.getChartLinkInfo != null) {
                    int n3 = this.getChartLinkInfo.getConditionType();
                    switch (n3) {
                        case 1: 
                        case 5: {
                            int n4 = this.getChartLinkInfo.getExpressionIndex(n, n2);
                            ChartFillPattern chartFillPattern = n4 != -1 ? this.getChartLinkInfo.getSubCondition(n4).getFillColor() : this.getChartLinkInfo.getOtherColor();
                            this.custommerConstant[n][n2].setPattern(chartFillPattern);
                        }
                    }
                }
                if (this.getAbsoluteValueSumOfCategory) {
                    if (!this.draw1[n][n2]) {
                        this.custommerConstant[n][n2].draw1(graphics2D, this.draw2, this.contour, true, this.availableLength);
                        continue;
                    }
                    this.custommerConstant[n][n2].draw2(graphics2D, this.draw2, this.contour, false, this.availableLength);
                    continue;
                }
                if (!this.draw1[n][n2]) {
                    this.custommerConstant[n][n2].draw2(graphics2D, this.draw2, this.contour, true, this.availableLength);
                    continue;
                }
                this.custommerConstant[n][n2].draw1(graphics2D, this.draw2, this.contour, false, this.availableLength);
            }
        }
    }

    @Override
    public void locate() {
    }

    private void SEDU() {
        int n;
        int[] nArray = new int[6];
        int n2 = 0;
        for (n = 0; n < 6; ++n) {
            nArray[n] = this.draw2 >> n & 1;
        }
        this.draw2 = 0;
        for (n = 5; n >= 0; --n) {
            n2 = n % 2 == 0 ? n + 1 : n - 1;
            this.draw2 += nArray[n2];
            if (n == 0) continue;
            this.draw2 <<= 1;
        }
    }

    @Override
    void transform(ChartMatrix chartMatrix) {
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                this.custommerConstant[i][j].transform(chartMatrix);
                this.custommerConstant[i][j].updateXUnit();
            }
        }
        this.addVertex();
    }

    private void addVertex() {
        this.availableOriginY();
        this.availableLength();
        this.col();
    }

    private void availableLength() {
        this.floatValue = (this.paper.getShownFace() >> 5 & 1) == 1;
    }

    private void availableOriginY() {
        this.get = (this.paper.getShownFace() & 1) != 1;
    }

    private void col() {
        this.getAbsoluteValueSumOfCategory = (this.paper.getShownFace() >> 3 & 1) == 1;
    }

    public void setCompass(ChartCompass chartCompass) {
        this.availableOriginY = chartCompass;
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return null;
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.custommerConstant[n][n2].toHtml();
    }

    @Override
    public Shape[][] getItemShapes(int n) {
        Shape[][] shapeArray = new Shape[this.row][this.col];
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                shapeArray[i][j] = this.getShapeByItem(i, j);
            }
        }
        return shapeArray;
    }

    @Override
    public String[] search(int n, int n2) {
        this.drilldown = null;
        String[] stringArray = null;
        for (int i = 0; i < this.row; ++i) {
            int n3 = i;
            if (this.floatValue) {
                n3 = this.row - i - 1;
            }
            for (int j = 0; j < this.col; ++j) {
                int n4 = j;
                if (this.get) {
                    n4 = this.col - j - 1;
                }
                this.draw2 = this.paper.getShownFace();
                if (this.draw1[n3][n4]) {
                    this.SEDU();
                }
                if (!this.custommerConstant[n3][n4].inBar(n3, n4, n, n2)) continue;
                if (this.paper.getProperties().isShowCategoryAndSeries()) {
                    stringArray = new String[3];
                    ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                    stringArray = chartHintLabel.hintLabelShowCategoryAndSeries(n3, n4);
                } else {
                    stringArray = new String[]{this.dataset.getFormatedHintValue(((Chart1DDataSet)this.dataset).getValue(n3, n4))};
                }
                this.selectedSeriesIndex = n3;
                this.drilldown = new int[2];
                this.drilldown[0] = n3;
                this.drilldown[1] = n4;
                return stringArray;
            }
        }
        this.selectedSeriesIndex = -1;
        return null;
    }

    public Shape getHTMLShape() {
        return null;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public int searchSeries(int n, int n2) {
        return 0;
    }

    public boolean isBench() {
        return this.getChartLink;
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        int[] nArray = null;
        for (int i = 0; i < this.row; ++i) {
            int n3 = i;
            if (this.floatValue) {
                n3 = this.row - i - 1;
            }
            for (int j = 0; j < this.col; ++j) {
                int n4 = j;
                if (this.get) {
                    n4 = this.col - j - 1;
                }
                this.draw2 = this.paper.getShownFace();
                if (this.draw1[n3][n4]) {
                    this.SEDU();
                }
                if (!this.custommerConstant[n3][n4].inBar(n3, n4, n, n2)) continue;
                ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(n3, n4);
                if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                    nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(n3)).get(n4)).getChartLinkInfo();
                }
                return nArray;
            }
        }
        return null;
    }
}

