/*
 * Decompiled with CFR 0.152.
 */
package chart.data;

public final class ChartTypeInfoVersion2
implements Cloneable {
    public static final int TYPE_MASK = 255;
    public static final int TYPE_BAR = 0;
    public static final int TYPE_BENCH = 1;
    public static final int TYPE_LINE = 2;
    public static final int TYPE_AREA = 3;
    public static final int TYPE_PIE = 4;
    public static final int TYPE_BAR_LINE = 5;
    public static final int TYPE_LINE_LINE = 6;
    public static final int TYPE_BAR_AREA = 7;
    public static final int TYPE_STOCK = 8;
    public static final int TYPE_RADAR = 9;
    public static final int TYPE_SCATTER = 10;
    public static final int TYPE_BUBBLE = 11;
    public static final int EFFECT_MASK = -268435456;
    public static final int EFFECT_2D = 0;
    public static final int EFFECT_3D = 0x10000000;
    public static final int SUBTYPE_MASK = 65280;
    public static final int SUBTYPE_STACK = 0;
    public static final int SUBTYPE_PERCENT = 256;
    public static final int SUBTYPE_SIDEBYSIDE = 512;
    public static final int SUBTYPE_ARRAY = 768;
    public static final int SUBTYPE_MASK2 = 0xFF0000;
    public static final int SUBTYPE_STACK2 = 0;
    public static final int SUBTYPE_PERCENT2 = 65536;
    public static final int SUBTYPE_SIDEBYSIDE2 = 131072;
    public static final int SUBTYPE_ARRAY2 = 196608;
    public static final int AXISTYPE_MASK = 0xF000000;
    public static final int AXISTYPE_1Y = 0;
    public static final int AXISTYPE_2Y = 0x1000000;
    public static final int[][] BUILTINTYPES = new int[][]{{512, 0, 256, 0x10000200, 0x10000000, 0x10000100, 0x10000300}, {513, 1, 257, 0x10000201, 0x10000001, 0x10000101, 0x10000301}, {770, 2, 258, 268436226}, {771, 3, 259, 0x10000303, 0x10000003, 0x10000103}, {516, 268435972}, {16974341, 16973829, 16974085, 16777733, 0x1000005, 0x1000105}, {16974598}, {16777735, 0x1000007, 0x1000107}, {520, 776}, {521}, {778, 10, 522}, {779}};
    private int SEDU = -1;
    private boolean getPrimType = false;

    public ChartTypeInfoVersion2() {
        this(BUILTINTYPES[0][0], false);
    }

    public ChartTypeInfoVersion2(int n, boolean bl) {
        this.SEDU = n;
        this.getPrimType = bl;
    }

    public int getChartType() {
        return this.SEDU;
    }

    public void setChartType(int n) {
        this.SEDU = n;
    }

    public void setMultiPaper(boolean bl) {
        this.getPrimType = bl;
    }

    public boolean isMultiPaper() {
        return this.getPrimType;
    }

    public boolean isCombinedChart() {
        switch (ChartTypeInfoVersion2.getPrimType(this.SEDU)) {
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        return new ChartTypeInfoVersion2(this.SEDU, this.getPrimType);
    }

    public static int getPrimType(int n) {
        return 0xFF & n;
    }

    public static int getSubType(int n) {
        return 0xFF00 & n;
    }

    public static int getSubType2(int n) {
        return 0xFF0000 & n;
    }

    public static int getEffect(int n) {
        return 0xF0000000 & n;
    }

    public static int getAxisType(int n) {
        return 0xF000000 & n;
    }

    public static int[] getRowandCol(int n) {
        int[] nArray = new int[]{-1, -1};
        for (int i = 0; i < BUILTINTYPES.length; ++i) {
            for (int j = 0; j < BUILTINTYPES[i].length; ++j) {
                if (n != BUILTINTYPES[i][j]) continue;
                nArray[0] = i;
                nArray[1] = j;
                return nArray;
            }
        }
        return nArray;
    }

    public boolean isStockChart() {
        return ChartTypeInfoVersion2.getPrimType(this.SEDU) == 8;
    }

    public boolean isBubbleChart() {
        return ChartTypeInfoVersion2.getPrimType(this.SEDU) == 11;
    }

    public boolean isScatterChart() {
        return ChartTypeInfoVersion2.getPrimType(this.SEDU) == 10;
    }

    public boolean isMultiDataChart() {
        return this.isCombinedChart() || this.isScatterChart() || this.isBubbleChart() || this.isStockChart();
    }
}

