/*
 * Decompiled with CFR 0.152.
 */
package chart.graphics;

import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGraphicsUtil;
import com.jinfonet.util.JRLog;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.ParseException;

public class ChartColorPattern
implements ChartFillPattern {
    public static final int[] BUILTINCOLORS = new int[]{0xFF0000, 65280, 255, 0xFFFF00, 0xEE82EE, 16753920, 0x990099, 0xA52A2A, 16737095, 15787660, 65535, 16770229, 14204888, 10506797, 0xD3D3D3, 14596231, 16761035, 0x7FFF00, 128, 16766720, 10494192, 16416882, 7372944, 13789470, 0xB22222, 10145074, 4251856, 16775388, 0xDDA0DD, 0xF0FFF0, 0xBEBEBE, 13808780, 13639824, 65407, 8388564, 15654274, 11546720, 16744272, 16768685, 9127187, 16729344, 3050327, 4620980, 16773077, 14315734, 16770244, 0xFFFFFF, 16032864, 14381203, 0x228B22, 6970061, 0xFFFFE0, 0xFF00FF, 16747520, 16445670, 12357519, 16770273, 7048739, 8900331, 12092939, 0xFFF0F5, 16767673, 16113331, 16119260, 0xCD5C5C, 8190976, 9055202, 16775885, 9699539, 0xF08080, 0, 13468991};
    public static final String[] BUILTINNAMES = new String[]{"Red", "Green", "Blue", "Yellow", "Violet", "Orange", "Pain", "Brown", "Tomato", "Khaki", "Cyan", "Moccasin", "Thistle", "Sienna", "LightGray", "Burlywood", "Pink", "Chartreuse", "Navy", "Gold", "Purple", "Salmon", "SlateGray", "Chocolate", "Firebrick", "YellowGreen", "Turquoise", "Cornsilk", "Plum", "Honeydew", "Grey", "Tan", "VioletRed", "SpringGreen", "Aquamarine", "LightGoldenrod", "Maroon", "Coral", "NavajoWhite", "SaddleBrown", "OrangeRed", "SeaGreen", "SteelBlue", "PapayaWhip", "Orchid", "Bisque", "White", "SandyBrown", "PaleVioletRed", "ForestGreen", "SlateBlue", "LightYellow", "Magenta", "DarkOrange", "Linen", "RosyBrown", "MistyRose", "OliveDrab", "SkyBlue", "DarkGoldenrod", "LavenderBlush", "PeachPuff", "Wheat", "Beige", "IndianRed", "LawnGreen", "BlueViolet", "LemonChiffon", "DarkViolet", "LightCoral", "Black", "Peru"};
    public static final ChartColorPattern DEFAULT_COLORPATTERN = new ChartColorPattern(BUILTINCOLORS[70]);
    public static final int NOCOLOR = BUILTINCOLORS.length;
    public static final String TRANSPARENT = "c0xffffff100";
    private Color SEDU;
    private int brighter;
    private boolean darker = false;

    public ChartColorPattern() {
        this.SEDU = new Color(BUILTINCOLORS[70]);
        this.brighter = 70;
    }

    public ChartColorPattern(int n) {
        this.brighter = n;
        this.SEDU = this.brighter == NOCOLOR ? null : new Color(BUILTINCOLORS[n]);
    }

    public ChartColorPattern(Color color) {
        this.SEDU = color;
        this.brighter = ChartColorPattern.getBuiltinIndex(color);
    }

    public ChartColorPattern(String string) {
        this.brighter = ChartColorPattern.getBuiltinIndex(string);
        this.SEDU = ChartColorPattern.getBuiltinColor(this.brighter);
    }

    public ChartColorPattern(Color color, int n) {
        this.SEDU = color;
        this.brighter = n;
    }

    public void setColor(Color color) {
        this.SEDU = color;
    }

    public Color getColor() {
        return this.SEDU;
    }

    public int getIndex() {
        return this.brighter;
    }

    public boolean isNoColor() {
        return this.SEDU == null;
    }

    @Override
    public float getAlpha() {
        float f;
        block3: {
            f = 0.0f;
            if (this.SEDU != null) {
                f = 1.0f - (float)this.SEDU.getAlpha() / 255.0f;
            }
            try {
                DecimalFormat decimalFormat = new DecimalFormat("#.##");
                String string = decimalFormat.parse(decimalFormat.format(f)).toString();
                f = Float.parseFloat(string);
            }
            catch (ParseException parseException) {
                if (!JRLog.isError(2)) break block3;
                JRLog.error(2, parseException);
            }
        }
        return f;
    }

    @Override
    public void setAlpha(float f) {
        this.SEDU = ChartColorPattern.transparent(this.SEDU, f);
    }

    public ChartColorPattern createAlphaColor(float f) {
        ChartColorPattern chartColorPattern = new ChartColorPattern(ChartColorPattern.transparent(this.SEDU, f), this.brighter);
        return chartColorPattern;
    }

    public ChartColorPattern darkerColor() {
        ChartColorPattern chartColorPattern = new ChartColorPattern(this.SEDU.darker());
        return chartColorPattern;
    }

    public ChartColorPattern brighterColor() {
        ChartColorPattern chartColorPattern = new ChartColorPattern(this.SEDU.brighter());
        return chartColorPattern;
    }

    @Override
    public Paint getPaint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        return this.getColor();
    }

    @Override
    public void fill(Graphics2D graphics2D, Shape shape) {
        if (this.SEDU == null || this.darker) {
            return;
        }
        graphics2D.setColor(this.SEDU);
        graphics2D.fill(shape);
    }

    @Override
    public void highLightFill(Graphics2D graphics2D, Shape shape, int n) {
        if (this.SEDU == null || this.darker) {
            return;
        }
        Color color = this.SEDU;
        Color color2 = ChartGraphicsUtil.highlight(color, n);
        graphics2D.setColor(color2);
        graphics2D.fill(shape);
    }

    @Override
    public Object clone() {
        if (this == null) {
            return null;
        }
        return new ChartColorPattern(this.SEDU, this.brighter);
    }

    public static String[] getBuiltinColorNames() {
        return BUILTINNAMES;
    }

    public static int[] getBuiltinColors() {
        return BUILTINCOLORS;
    }

    public static Color getBuiltinColor(int n) {
        if (n >= NOCOLOR) {
            return null;
        }
        return new Color(BUILTINCOLORS[n]);
    }

    public static int getBuiltinIndex(String string) {
        int n = 0;
        for (n = 0; n < NOCOLOR; ++n) {
            if (!string.equals(BUILTINNAMES[n])) continue;
            return n;
        }
        return n;
    }

    public static int getBuiltinIndex(Color color) {
        for (int i = 0; i < BUILTINCOLORS.length; ++i) {
            if (!ChartColorPattern.getBuiltinColor(i).equals(color)) continue;
            return i;
        }
        return BUILTINCOLORS.length;
    }

    public static Color getBuiltinColor(String string) {
        return ChartColorPattern.getBuiltinColor(ChartColorPattern.getBuiltinIndex(string));
    }

    public static Color transparent(Color color, float f) {
        if (color == null) {
            return null;
        }
        f = f > 1.0f ? 1.0f : f;
        f = f < 0.0f ? 0.0f : f;
        float[] fArray2 = color.getRGBColorComponents(null);
        return new Color(fArray2[0], fArray2[1], fArray2[2], 1.0f - f);
    }

    public void setNoFill(boolean bl) {
        this.darker = bl;
    }

    public boolean getNoFill() {
        return this.darker;
    }
}

