/*
 * Decompiled with CFR 0.152.
 */
package chart.graphics;

import chart.graphics.ChartColorPattern;
import chart.graphics.ChartPenStyle;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;

public class ChartLineStyle
implements Cloneable {
    int SEDU = 0;
    float draw = 3.0f;
    ChartPenStyle getDashPattern;

    public ChartLineStyle() {
    }

    public ChartLineStyle(int n, ChartPenStyle chartPenStyle) {
        this.SEDU = n;
        this.getDashPattern = chartPenStyle;
        this.draw = chartPenStyle.getPenWidth();
    }

    public ChartLineStyle(int n, int n2, int n3) {
        this.SEDU = 1;
        this.getDashPattern = new ChartPenStyle(n2);
        this.draw = n3;
        this.getDashPattern.setPenWidth(n3);
    }

    public ChartLineStyle(boolean bl, int n) {
        this();
        ChartPenStyle chartPenStyle = new ChartPenStyle(1.0f, 2, 0, n, false, false, new ChartColorPattern());
        if (!bl) {
            this.SEDU = 1;
        }
        this.getDashPattern = chartPenStyle;
        this.draw = this.getDashPattern.getPenWidth();
    }

    public ChartLineStyle(String string) {
        String[] stringArray = string.split(",");
        if (stringArray == null) {
            this.SEDU = 1;
            this.getDashPattern = new ChartPenStyle(9);
            this.draw = 2.0f;
            this.getDashPattern.setPenWidth(this.draw);
        } else {
            this.SEDU = Integer.parseInt(stringArray[0]);
            this.getDashPattern = new ChartPenStyle(Integer.parseInt(stringArray[1]));
            this.draw = stringArray.length < 3 ? 3.0f : (float)Integer.parseInt(stringArray[2]);
            this.getDashPattern.setPenWidth(this.draw);
        }
    }

    public void setCureType(int n) {
        this.SEDU = n;
    }

    public int getCureType() {
        return this.SEDU;
    }

    public void setPen(ChartPenStyle chartPenStyle) {
        this.getDashPattern = chartPenStyle;
    }

    public ChartPenStyle getPenStyle() {
        return this.getDashPattern;
    }

    public int getPenStyleType() {
        return this.getDashPattern.getDashPattern();
    }

    public void setPenStyle(int n) {
        if (this.getDashPattern != null) {
            this.getDashPattern.setDashPattern(n);
        } else {
            this.getDashPattern = new ChartPenStyle(n);
            this.getDashPattern.setPenWidth(this.draw);
        }
    }

    public void setPenWidth(float f) {
        this.draw = f;
        this.getDashPattern.setPenWidth(f);
    }

    public float getPenWidth() {
        return this.draw;
    }

    public void paint(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(n, n2 + n4 / 2);
        generalPath.lineTo(n + n3, n2 + n4 / 2);
        this.getDashPattern.draw(graphics2D, generalPath);
    }
}

