/*
 * Decompiled with CFR 0.152.
 */
package chart.graphics;

import chart.ChartEnv;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartPenStyle;
import com.jinfonet.util.JRLog;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Vector;
import jet.util.JRInterruptedException;

public class ChartTextStyle
implements Cloneable {
    private boolean SEDU;
    private static final ChartColorPattern WORDWRAPPER_GAP = new ChartColorPattern(new Color(128, 128, 128));
    public static final int ROT_LEFT = 0;
    public static final int ROT_MID = 1;
    public static final int ROT_RIGHT = 2;
    private static final String[] abs = new String[]{"NONE", "Single", "Single Lower", "Bold Line", "Bold Lower", "Double Lines", "Bold Double", "Patterned Line", "Bold Patterned"};
    private static final String[] add = new String[]{"NONE", "Thin Line", "Bold Line", "Double Lines"};
    private static final String[] append = new String[]{"Plain", "Bold", "Italic", "Bold Italic"};
    public static final int NONE = 0;
    public static final int EMBOSSED = 1;
    public static final int ENGRAVED = 2;
    public static final int SHADOWED = 4;
    public static final int SUPERSCRIPT = 8;
    public static final int SUBSCRIPT = 16;
    public static final int DRAWOUTLINE = 32;
    private String clone;
    private int closePath;
    private int cos;
    private ChartPenStyle createInverse;
    private ChartFillPattern createUnion;
    private int draw;
    private int endsWith;
    private double error;
    private float fill;
    private int get;
    private GeneralPath getAscent;
    private GeneralPath getAttributes;
    private TextLayout getBounds;
    private float getBounds2D;
    private float getColor;
    private AffineTransform getDescent;
    private float getFont = -1.0f;
    private boolean getFontName;
    private int getFontRenderContext = 1;
    private Rectangle2D[] getHeight;
    private Vector getIterator;
    private double getLeading;
    private double getLineMetrics;
    private float getOutline = 0.0f;

    public ChartTextStyle() {
        this("SansSerif", 12, 0, new ChartPenStyle(), null, 0, 0, 0.0, 0.0f, 0, false);
    }

    public ChartTextStyle(String string, int n, int n2) {
        this(string, n, n2, new ChartPenStyle(), null, 0, 0, 0.0, 0.0f, 0, false);
    }

    public ChartTextStyle(String string, int n, int n2, ChartPenStyle chartPenStyle, ChartFillPattern chartFillPattern, int n3, int n4, double d, float f, int n5, boolean bl) {
        this.clone = string;
        this.closePath = n;
        this.cos = n2;
        this.createInverse = chartPenStyle;
        this.createUnion = chartFillPattern;
        this.draw = n3;
        this.endsWith = n4;
        this.error = d;
        this.fill = f;
        this.get = n5;
        this.getFontName = bl;
    }

    private void SEDU(FontRenderContext fontRenderContext, String string) {
        if (string == null || string.length() <= 0) {
            this.getBounds = null;
            return;
        }
        if (this.SEDU && this.getBounds != null) {
            return;
        }
        this.getFontName = this.error == 0.0 ? this.getFontName : false;
        Font font = new Font(this.clone, this.cos, this.closePath);
        if (this.clone.startsWith("*")) {
            font = ChartEnv.getRealFont(this.clone, this.cos, this.closePath);
        }
        if (fontRenderContext == null) {
            this.getDescent = new AffineTransform();
            fontRenderContext = new FontRenderContext(this.getDescent, true, true);
        } else {
            this.getDescent = fontRenderContext.getTransform();
        }
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        float f = textLayout.getVisibleAdvance();
        if (this.draw != 0) {
            this.createInverse(lineMetrics, f);
        }
        if (this.endsWith != 0) {
            this.createUnion(lineMetrics, f);
        }
        float f2 = this.isSuperscript() ? -1.0f : 0.0f;
        float f3 = f2 = this.isSubscript() ? 1.0f : f2;
        if (f2 != 0.0f) {
            float f4 = lineMetrics.getAscent() / 2.0f;
            float f5 = 0.6666667f;
            float f6 = f * (1.0f - f5) / 2.0f;
            this.getDescent.scale(f5, f5);
            this.getDescent.translate(f6, f2 * f4);
        }
        this.getDescent.shear(this.fill, 0.0);
        this.getDescent.rotate(this.error);
        this.getBounds = new TextLayout(string, font, fontRenderContext);
        if (this.getFontName && this.getFont >= 0.0f) {
            this.draw(fontRenderContext, string);
        }
        this.SEDU = true;
    }

    public Rectangle2D getDimension(Graphics2D graphics2D, String string) {
        if (string == null) {
            return new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
        }
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        return this.WORDWRAPPER_GAP(fontRenderContext, string);
    }

    public Rectangle2D getDimension(String string) {
        if (string == null) {
            return new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
        }
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);
        return this.WORDWRAPPER_GAP(fontRenderContext, string);
    }

    public Rectangle2D getZeroRotationDimension(String string) {
        if (string == null) {
            return new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
        }
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);
        double d = this.error;
        this.error = 0.0;
        Rectangle2D rectangle2D = this.WORDWRAPPER_GAP(fontRenderContext, string);
        this.error = d;
        return rectangle2D;
    }

    private Rectangle2D WORDWRAPPER_GAP(FontRenderContext fontRenderContext, String string) {
        Rectangle2D rectangle2D;
        this.SEDU = false;
        this.SEDU(fontRenderContext, string);
        if (this.getBounds == null || string == null) {
            return new Rectangle2D.Float();
        }
        if (!this.getFontName || !(this.getFont >= 0.0f)) {
            Rectangle2D rectangle2D2 = this.getBounds.getBounds();
            Font font = new Font(this.clone, this.cos, this.closePath);
            if (this.clone.startsWith("*")) {
                font = ChartEnv.getRealFont(this.clone, this.cos, this.closePath);
            }
            int n = this.textWidth(string, font);
            Shape shape = this.getBounds.getOutline(this.getDescent);
            rectangle2D = shape.getBounds2D();
            if (string != null && string.endsWith(" ") && (double)n > rectangle2D.getWidth()) {
                rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), n, rectangle2D.getHeight());
                rectangle2D2.setRect(rectangle2D2.getX(), rectangle2D2.getY(), n, rectangle2D2.getHeight());
            }
            if (this.error != 0.0) {
                double d = Math.PI;
                double d2 = Math.abs(Math.sin(this.error));
                double d3 = Math.abs(Math.cos(this.error));
                double d4 = rectangle2D2.getWidth() * d3 + rectangle2D2.getHeight() * d2;
                double d5 = rectangle2D2.getWidth() * d2 + rectangle2D2.getHeight() * d3;
                rectangle2D.setRect(0.0, 0.0, d4, d5);
            }
            this.getLeading = rectangle2D2.getX();
            this.getLineMetrics = rectangle2D2.getY() - rectangle2D.getHeight();
        } else {
            Rectangle2D rectangle2D3 = ((TextLayout)this.getIterator.get(0)).getBounds();
            double d = rectangle2D3.getWidth();
            double d6 = this.getHeight[0].getHeight();
            for (int i = 1; i < this.getFontRenderContext; ++i) {
                d6 += this.getHeight[i].getHeight() + (double)ChartEnv.WORDWRAPPER_GAP;
                rectangle2D3.createUnion(this.getHeight[i]);
                d = d < this.getHeight[i].getWidth() ? this.getHeight[i].getWidth() : d;
            }
            rectangle2D3.setRect(this.getBounds.getBounds().getX(), this.getBounds.getBounds().getY(), d, d6 += (double)ChartEnv.WORDWRAPPER_GAP);
            this.getLeading = this.getBounds.getBounds().getX();
            this.getLineMetrics = this.getBounds.getBounds().getY() - d6;
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(rectangle2D3.getPathIterator(this.getDescent), false);
            rectangle2D = generalPath.getBounds2D();
        }
        return rectangle2D;
    }

    public void drawText(Graphics2D graphics2D, String string, float f, float f2) {
        block11: {
            if (!this.SEDU) {
                this.SEDU(graphics2D.getFontRenderContext(), string);
            }
            if (this.getBounds == null) {
                return;
            }
            boolean bl = false;
            float f3 = 0.0f;
            if (this.isShadowed()) {
                f3 = this.getBounds2D;
                bl = true;
            } else if (this.isEmbossed()) {
                f3 = 1.0f;
                bl = true;
            } else if (this.isEngraved()) {
                f3 = -1.0f;
                bl = true;
            }
            graphics2D.translate(f, f2);
            graphics2D.transform(this.getDescent);
            if (bl) {
                graphics2D.translate(f3, f3);
                this.clone(graphics2D, true);
                this.abs(graphics2D, true);
                this.cos(graphics2D, true);
                graphics2D.translate(-f3, -f3);
            }
            this.clone(graphics2D, false);
            this.abs(graphics2D, false);
            this.cos(graphics2D, false);
            try {
                graphics2D.transform(this.getDescent.createInverse());
            }
            catch (JRInterruptedException jRInterruptedException) {
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) break block11;
                JRLog.error(2, exception);
            }
        }
        graphics2D.translate(-f, -f2);
    }

    private void abs(Graphics2D graphics2D, boolean bl) {
        Paint paint;
        Rectangle2D rectangle2D = this.getBounds.getBounds();
        Paint paint2 = paint = this.createUnion == null ? null : this.createUnion.getPaint(graphics2D, rectangle2D);
        if (paint != null && !this.isOutlined()) {
            this.append(paint, graphics2D, bl);
        } else {
            this.add(graphics2D, bl);
        }
    }

    private void add(Graphics2D graphics2D, boolean bl) {
        Shape shape = this.getBounds.getOutline(null);
        if (bl) {
            WORDWRAPPER_GAP.fill(graphics2D, shape);
        } else {
            if (this.createUnion != null) {
                this.createUnion.fill(graphics2D, shape);
            }
            if (this.isOutlined()) {
                this.createInverse.draw(graphics2D, shape);
            }
        }
    }

    private void append(Paint paint, Graphics2D graphics2D, boolean bl) {
        Paint paint2 = graphics2D.getPaint();
        if (bl) {
            graphics2D.setColor(WORDWRAPPER_GAP.getColor());
        } else {
            graphics2D.setPaint(paint);
        }
        if (this.getFontName && this.getFontRenderContext > 1) {
            this.endsWith(graphics2D);
        } else {
            this.add(graphics2D, bl);
        }
        graphics2D.setPaint(paint2);
    }

    private void clone(Graphics2D graphics2D, boolean bl) {
        if (this.draw != 0 && this.getAscent != null) {
            switch (this.draw) {
                case 1: 
                case 2: 
                case 5: {
                    if (bl) {
                        this.closePath(graphics2D, this.getAscent);
                        break;
                    }
                    this.createInverse.draw(graphics2D, this.getAscent);
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    float f = this.createInverse.getPenWidth();
                    this.createInverse.setPenWidth(this.getBounds2D);
                    if (bl) {
                        this.closePath(graphics2D, this.getAscent);
                    } else {
                        this.createInverse.draw(graphics2D, this.getAscent);
                    }
                    this.createInverse.setPenWidth(f);
                    break;
                }
                case 7: 
                case 8: {
                    if (bl) {
                        WORDWRAPPER_GAP.fill(graphics2D, this.getAscent);
                        break;
                    }
                    if (this.createUnion != null) {
                        this.createUnion.fill(graphics2D, this.getAscent);
                    }
                    if (!this.isOutlined()) break;
                    this.createInverse.draw(graphics2D, this.getAscent);
                }
            }
        }
    }

    private void closePath(Graphics2D graphics2D, GeneralPath generalPath) {
        ChartColorPattern chartColorPattern = this.createInverse.getPenColor();
        this.createInverse.setPenColor(WORDWRAPPER_GAP);
        this.createInverse.draw(graphics2D, generalPath);
        this.createInverse.setPenColor(chartColorPattern);
    }

    private void cos(Graphics2D graphics2D, boolean bl) {
        if (this.endsWith != 0) {
            if (this.endsWith == 2) {
                float f = this.createInverse.getPenWidth();
                this.createInverse.setPenWidth(this.getColor);
                if (bl) {
                    this.closePath(graphics2D, this.getAttributes);
                } else {
                    this.createInverse.draw(graphics2D, this.getAttributes);
                }
                this.createInverse.setPenWidth(f);
            } else if (bl) {
                this.closePath(graphics2D, this.getAttributes);
            } else {
                this.createInverse.draw(graphics2D, this.getAttributes);
            }
        }
    }

    private void createInverse(LineMetrics lineMetrics, float f) {
        this.getOutline = 0.0f;
        this.getBounds2D = lineMetrics.getUnderlineThickness();
        if (this.getAscent == null) {
            this.getAscent = new GeneralPath();
        } else {
            this.getAscent.reset();
        }
        float f2 = lineMetrics.getUnderlineOffset();
        float f3 = lineMetrics.getDescent();
        float f4 = this.getBounds2D;
        f2 += f4 / 3.0f;
        f3 += f4 / 3.0f;
        switch (this.draw) {
            case 1: {
                this.getAscent.moveTo(0.0f, f2);
                this.getAscent.lineTo(f, f2);
                this.getOutline += f2;
                break;
            }
            case 2: {
                this.getAscent.moveTo(0.0f, f3);
                this.getAscent.lineTo(f, f3);
                this.getOutline += f3;
                break;
            }
            case 3: {
                this.getAscent.moveTo(0.0f, f2 + f4 / 2.0f);
                this.getAscent.lineTo(f, f2 + f4 / 2.0f);
                this.getOutline += f2 + f4 / 2.0f;
                break;
            }
            case 4: {
                this.getAscent.moveTo(0.0f, f3 + f4 / 2.0f);
                this.getAscent.lineTo(f, f3 + f4 / 2.0f);
                this.getOutline += f3 + f4 / 2.0f;
                break;
            }
            case 5: {
                this.getAscent.moveTo(0.0f, f2);
                this.getAscent.lineTo(f, f2);
                this.getAscent.moveTo(0.0f, f3);
                this.getAscent.lineTo(f, f3);
                this.getOutline += f3;
                break;
            }
            case 6: {
                this.getAscent.moveTo(0.0f, f2 + f4 / 2.0f);
                this.getAscent.lineTo(f, f2 + f4 / 2.0f);
                this.getAscent.moveTo(0.0f, f3 + f4 / 2.0f);
                this.getAscent.lineTo(f, f3 + f4 / 2.0f);
                this.getOutline += f3 + f4 / 2.0f;
                break;
            }
            case 7: {
                this.getAscent.moveTo(0.0f, f2);
                this.getAscent.lineTo(f, f2);
                this.getAscent.lineTo(f, f2 + f4);
                this.getAscent.lineTo(0.0f, f2 + f4);
                this.getAscent.closePath();
                this.getOutline += f2 + f4;
                break;
            }
            case 8: {
                this.getAscent.moveTo(0.0f, f2);
                this.getAscent.lineTo(f, f2);
                this.getAscent.lineTo(f, f3);
                this.getAscent.lineTo(0.0f, f3);
                this.getAscent.closePath();
                this.getOutline += f3;
            }
        }
    }

    private void createUnion(LineMetrics lineMetrics, float f) {
        float f2;
        float f3 = lineMetrics.getStrikethroughOffset();
        if (this.getAttributes == null) {
            this.getAttributes = new GeneralPath();
        } else {
            this.getAttributes.reset();
        }
        this.getColor = f2 = lineMetrics.getStrikethroughThickness();
        switch (this.endsWith) {
            case 1: {
                this.getAttributes.moveTo(0.0f, f3);
                this.getAttributes.lineTo(f, f3);
                break;
            }
            case 2: {
                this.getAttributes.moveTo(0.0f, f3 + f2 / 2.0f);
                this.getAttributes.lineTo(f, f3 + f2 / 2.0f);
                break;
            }
            case 3: {
                this.getAttributes.moveTo(0.0f, f3 - f2);
                this.getAttributes.lineTo(f, f3 - f2);
                this.getAttributes.moveTo(0.0f, f3 + f2);
                this.getAttributes.lineTo(f, f3 + f2);
            }
        }
    }

    private void draw(FontRenderContext fontRenderContext, String string) {
        AttributedString attributedString = new AttributedString(string, this.getFont().getAttributes());
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
        this.getFontRenderContext = 0;
        this.getIterator = new Vector(0, 1);
        this.getHeight = new Rectangle2D[string.length()];
        TextLayout textLayout = lineBreakMeasurer.nextLayout(this.getFont);
        while (textLayout != null) {
            this.getIterator.add(textLayout);
            this.getHeight[this.getFontRenderContext] = (Rectangle2D.Float)textLayout.getBounds();
            ++this.getFontRenderContext;
            textLayout = lineBreakMeasurer.nextLayout(this.getFont);
        }
        this.error();
    }

    private void endsWith(Graphics2D graphics2D) {
        float f = 0.0f;
        for (int i = 0; i < this.getFontRenderContext; ++i) {
            graphics2D.translate(0.0, f += i == 0 ? 0.0f : (float)this.getHeight[i].getHeight() + (float)ChartEnv.WORDWRAPPER_GAP);
            Shape shape = ((TextLayout)this.getIterator.get(i)).getOutline(null);
            if (this.createUnion != null) {
                this.createUnion.fill(graphics2D, shape);
            }
            graphics2D.translate(0.0, -f);
        }
    }

    private void error() {
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < this.getFontRenderContext; ++i) {
            generalPath.reset();
            generalPath.append(this.getHeight[i].getPathIterator(this.getDescent), false);
            this.getHeight[i] = (Rectangle2D.Float)generalPath.getBounds2D();
        }
    }

    public String getFontName() {
        return this.clone;
    }

    public int getFontStyle() {
        return this.cos;
    }

    public int getFontSize() {
        return this.closePath;
    }

    public ChartPenStyle getFontPen() {
        return this.createInverse;
    }

    public ChartFillPattern getFontColor() {
        if (this.createUnion != null) {
            return this.createUnion;
        }
        return new ChartColorPattern();
    }

    public Color getTextColor() {
        if (this.createUnion != null) {
            return ((ChartColorPattern)this.createUnion).getColor();
        }
        return new Color(0);
    }

    public int getUnderline() {
        return this.draw;
    }

    public float getUnderlineHeight() {
        return this.getOutline;
    }

    public int getStrikethrough() {
        return this.endsWith;
    }

    public double getRotation() {
        return this.error;
    }

    public float getShearing() {
        return this.fill;
    }

    public boolean isEmbossed() {
        return (this.get & 1) == 1;
    }

    public boolean isEngraved() {
        return (this.get & 2) == 2;
    }

    public boolean isShadowed() {
        return (this.get & 4) == 4;
    }

    public boolean isSuperscript() {
        return (this.get & 8) == 8;
    }

    public boolean isSubscript() {
        return (this.get & 0x10) == 16;
    }

    public boolean isOutlined() {
        return (this.get & 0x20) == 32;
    }

    public void setFontName(String string) {
        this.clone = string;
        this.fill();
    }

    public void setFontStyle(int n) {
        this.cos = n;
        this.fill();
    }

    public void setFontSize(int n) {
        this.closePath = n;
        this.fill();
    }

    public void setFontPen(ChartPenStyle chartPenStyle) {
        this.createInverse = chartPenStyle;
    }

    public void setFontColor(ChartFillPattern chartFillPattern) {
        this.createUnion = chartFillPattern;
    }

    public void setUnderline(int n) {
        this.draw = n;
        this.fill();
    }

    public void setStrikethrough(int n) {
        this.endsWith = n;
        this.fill();
    }

    public void setRotation(double d) {
        this.error = d;
        this.fill();
    }

    public void setShearing(float f) {
        this.fill = f;
        this.fill();
    }

    public void toggleEmbossed() {
        this.get ^= 1;
        this.get &= 0xFFFFFFD9;
    }

    public void toggleEngraved() {
        this.get ^= 2;
        this.get &= 0xFFFFFFDA;
    }

    public void toggleShadowed() {
        this.get ^= 4;
        this.get &= 0xFFFFFFFC;
    }

    public void toggleOutlined() {
        this.get ^= 0x20;
        this.get &= 0xFFFFFFFC;
    }

    public void toggleSuperscript() {
        this.get ^= 8;
        this.get &= 0xFFFFFFEF;
        this.fill();
    }

    public void toggleSubscript() {
        this.get ^= 0x10;
        this.get &= 0xFFFFFFF7;
        this.fill();
    }

    private void fill() {
        this.SEDU = false;
    }

    public Font getFont() {
        if (this.clone.startsWith("*")) {
            return ChartEnv.getRealFont(this.clone, this.cos, this.closePath);
        }
        return new Font(this.clone, this.cos, this.closePath);
    }

    public static String[] getBuiltinFontStyles() {
        return append;
    }

    public static String[] getBuiltinUnderlines() {
        return abs;
    }

    public static String[] getBuiltinStrikethrough() {
        return add;
    }

    public void setWordWrap(float f) {
        this.getFont = f < 0.0f ? 0.0f : f;
        this.getFontName = true;
        this.fill();
    }

    public void setWordWrapWidth(float f) {
        this.getFont = f < 0.0f ? 0.0f : f;
        this.getFontName = true;
        this.fill();
    }

    public float getWordWrapWidth() {
        return this.getFont;
    }

    public boolean getWordWrapper() {
        return this.getFontName;
    }

    public void setWordWrapper(boolean bl) {
        this.getFontName = bl;
        this.fill();
    }

    public int getWrapperGap() {
        return ChartEnv.WORDWRAPPER_GAP;
    }

    public double getX() {
        return this.getLeading;
    }

    public double getY() {
        return this.getLineMetrics;
    }

    public Object clone() {
        ChartFillPattern chartFillPattern = null;
        if (this.createUnion != null) {
            chartFillPattern = (ChartFillPattern)this.createUnion.clone();
        }
        return new ChartTextStyle(this.clone, this.closePath, this.cos, (ChartPenStyle)this.createInverse.clone(), chartFillPattern, this.draw, this.endsWith, this.error, this.fill, this.get, this.getFontName);
    }

    public void setForeground(Color color) {
        this.createInverse.getPenColor().setColor(color);
        ChartFillPattern chartFillPattern = this.createUnion;
        if (chartFillPattern != null && chartFillPattern instanceof ChartColorPattern) {
            ((ChartColorPattern)chartFillPattern).setColor(color);
        } else {
            this.createUnion = new ChartColorPattern(color);
        }
    }

    public void setFont(Font font) {
        this.clone = font.getFontName();
        this.closePath = font.getSize();
        this.cos = font.getStyle();
        this.fill();
    }

    public double getWordWrapFristLineHeight() {
        if (this.getHeight != null) {
            return this.getHeight[0].getHeight();
        }
        return -1.0;
    }

    public float getTextDescend() {
        if (!(this.getBounds == null || this.error != 0.0 || this.getFontName && this.getFont >= 0.0f)) {
            return this.getBounds.getDescent();
        }
        return 0.0f;
    }

    public float getTextLeading() {
        if (!(this.getBounds == null || this.error != 0.0 || this.getFontName && this.getFont >= 0.0f)) {
            return this.getBounds.getLeading();
        }
        return 0.0f;
    }

    public int textWidth(String string, Font font) {
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, true);
        int n = (int)font.getStringBounds(string, fontRenderContext).getBounds().getWidth();
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    public float getTextYoffset() {
        if (this.getBounds != null) {
            return (float)(this.getBounds.getBounds().getHeight() + (double)this.getBounds.getDescent() - (double)this.getBounds.getAscent());
        }
        return 0.0f;
    }
}

