/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.api.datatypes;

import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import jet.dataengine.util.DSLog;

public final class Types {
    public static final int NULL = 0;
    public static final int INVALID = 0;
    public static final int BYTE = -6;
    private static final int SEDU = (int)Math.ceil(Math.log(127.0));
    public static final int SHORT = 5;
    private static final int append = (int)Math.ceil(Math.log(32767.0));
    public static final int INTEGER = 4;
    private static final int ceil = (int)Math.ceil(Math.log(2.147483647E9));
    public static final int LONG = -5;
    private static final int debug = (int)Math.ceil(Math.log(9.223372036854776E18));
    public static final int FLOAT = 6;
    private static final int desiredAssertionStatus = (int)Math.ceil(Math.log(Math.pow(2.0, 24.0)));
    public static final double FLOAT_PRECISION_ERROR = (double)4.0E-9f;
    public static final int DOUBLE = 8;
    private static final int equals = (int)Math.ceil(Math.log(Math.pow(2.0, 53.0)));
    public static final double DOUBLE_PRECISION_ERROR = 4.0E-16;
    public static final int BOOLEAN = -7;
    public static final int BIGDECIMAL = 3;
    public static final int STRING = 12;
    public static final int BYTES = -2;
    public static final int CLOB = 2005;
    public static final int BLOB = 2004;
    public static final int RELATION = Integer.MAX_VALUE;
    public static final int DATE = 91;
    public static final int TIME = 92;
    public static final int TIMESTAMP = 93;
    public static final int ARRAY = 2003;
    public static final int REFERENCE = 0x7FFFFFFE;
    public static final int CUSTOMER = 0x7FFFFFFD;
    public static final int UNKNOW = 0x7FFFFFFC;

    public static final int sqlTypeToSqlType(int n) {
        switch (n) {
            case 16: {
                return -7;
            }
            case -8: {
                return 1;
            }
            case -9: {
                return 12;
            }
            case -10: {
                return -1;
            }
            case 9: {
                return 91;
            }
            case 10: {
                return 92;
            }
            case 11: {
                return 93;
            }
        }
        return n;
    }

    public static final int sqlTypeToType(int n) {
        switch (n) {
            case -7: 
            case 16: {
                return -7;
            }
            case -6: {
                return -6;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 4;
            }
            case -5: {
                return -5;
            }
            case 6: 
            case 8: {
                return 8;
            }
            case 2: 
            case 3: {
                return 3;
            }
            case 7: {
                return 6;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                return 12;
            }
            case 9: 
            case 91: {
                return 91;
            }
            case 10: 
            case 92: {
                return 92;
            }
            case 11: 
            case 93: {
                return 93;
            }
            case -4: 
            case -3: 
            case -2: {
                return -2;
            }
            case 0: {
                return 0;
            }
            case 2004: {
                return 2004;
            }
            case 2005: {
                return 2005;
            }
            case 2003: {
                return 2003;
            }
        }
        DSLog dSLog = DSLog.getDSLog(Types.class.getName());
        if (dSLog.isDebugEnabled()) {
            dSLog.debug("Con not mapping sql type " + n + " to sql type!");
        }
        return n;
    }

    public static int typeToSQLType(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case -6: {
                return -6;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 4;
            }
            case -5: {
                return -5;
            }
            case 6: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 12: {
                return 12;
            }
            case -7: {
                return -7;
            }
            case 3: {
                return 3;
            }
            case 91: {
                return 91;
            }
            case 92: {
                return 92;
            }
            case 93: {
                return 93;
            }
            case -2: {
                return -2;
            }
            case 2005: {
                return 2005;
            }
            case 2003: {
                return 2003;
            }
            case 2004: {
                return 2004;
            }
            case 0x7FFFFFFC: 
            case 0x7FFFFFFD: 
            case 0x7FFFFFFE: 
            case 0x7FFFFFFF: {
                assert (false) : "Unknow data type!";
                return 1111;
            }
        }
        assert (false) : "Unknow data type!";
        throw new RuntimeException("Invalid data type : " + n);
    }

    public static boolean isDate(int n) {
        return n == 91 || n == 19;
    }

    public static boolean isTime(int n) {
        return n == 92 || n == 10;
    }

    public static boolean isTimestamp(int n) {
        return n == 93 || n == 11;
    }

    public static String getDataTypeName(int n) {
        switch (n) {
            case 0: {
                return "Null";
            }
            case -6: {
                return "Number";
            }
            case 5: {
                return "Number";
            }
            case 4: {
                return "Integer";
            }
            case -5: {
                return "Number";
            }
            case 6: {
                return "Number";
            }
            case 8: {
                return "Number";
            }
            case -7: {
                return "Boolean";
            }
            case 3: {
                return "Decimal";
            }
            case 91: {
                return "Date";
            }
            case 92: {
                return "Time";
            }
            case 93: {
                return "DateTime";
            }
            case 12: {
                return "String";
            }
            case -2: {
                return "Binary";
            }
            case 2005: {
                return "CLOB";
            }
            case 2004: {
                return "BLOB";
            }
            case 0x7FFFFFFF: {
                return "RELATION";
            }
            case 2003: {
                return "ARRAY";
            }
            case 0x7FFFFFFE: {
                return "REFERENCE";
            }
            case 0x7FFFFFFD: {
                return "CUSTOMER";
            }
            case 0x7FFFFFFC: {
                return "UNKNOW";
            }
        }
        throw new IllegalArgumentException("Invalid data type : " + n);
    }

    public static boolean isNumeric(int n) {
        switch (n) {
            case -6: 
            case -5: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTimeType(int n) {
        switch (n) {
            case 9: 
            case 10: 
            case 11: 
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBooleanType(int n) {
        return n == -7;
    }

    public static boolean isIntType(int n) {
        return n == -6 || n == 5 || n == 4 || n == -5;
    }

    public static boolean isFloatType(int n) {
        return n == 6 || n == 8 || n == 3;
    }

    public static boolean isStringType(int n) {
        return n == 12;
    }

    public static boolean isCompatible(int n, int n2) {
        if (Types.isStringType(n) && Types.isStringType(n2)) {
            return true;
        }
        if (Types.isNumeric(n) && Types.isNumeric(n2)) {
            return true;
        }
        if (Types.isBooleanType(n) && Types.isBooleanType(n2)) {
            return true;
        }
        return n == n2;
    }

    public static final String sqlTypeToString(int n) {
        switch (n) {
            case -7: {
                return "Boolean";
            }
            case -6: {
                return "Number";
            }
            case 5: {
                return "Number";
            }
            case 4: {
                return "Integer";
            }
            case -5: {
                return "Number";
            }
            case 6: 
            case 7: {
                return "Number";
            }
            case 8: {
                return "Number";
            }
            case 2: 
            case 3: {
                return "Decimal";
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                return "String";
            }
            case 9: 
            case 91: {
                return "Date";
            }
            case 10: 
            case 92: {
                return "Time";
            }
            case 11: 
            case 93: {
                return "DateTime";
            }
            case -4: 
            case -3: 
            case -2: {
                return "Binary";
            }
            case 0: {
                return "Null";
            }
        }
        return "";
    }

    public static int sqlIsNullableToType(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        throw new RuntimeException("Invalid column state convertion");
    }

    public static int typeIsNullableToSql(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        throw new RuntimeException("Invalid column state convertion");
    }

    public static JinfonetDate getJinfonetDate(Date date) {
        return new JinfonetDate(date.getTime());
    }

    public static JinfonetTime getJinfonetTime(Date date) {
        return new JinfonetTime(date.getTime());
    }

    public static JinfonetTimeStamp getJinfonetTimeStamp(Date date) {
        return new JinfonetTimeStamp(date.getTime());
    }

    public static Date getSQLDate(JinfonetDate jinfonetDate) {
        return new Date(jinfonetDate.getTime());
    }

    public static Date getSQLDate(JinfonetTime jinfonetTime) {
        return new Date(jinfonetTime.getTime());
    }

    public static Date getSQLDate(JinfonetTimeStamp jinfonetTimeStamp) {
        return new Date(jinfonetTimeStamp.getTime());
    }

    public static Time getSQLTime(JinfonetDate jinfonetDate) {
        return new Time(jinfonetDate.getTime());
    }

    public static Time getSQLTime(JinfonetTime jinfonetTime) {
        return new Time(jinfonetTime.getTime());
    }

    public static Time getSQLTime(JinfonetTimeStamp jinfonetTimeStamp) {
        return new Time(jinfonetTimeStamp.getTime());
    }

    public static Timestamp getSQLTimestamp(JinfonetDate jinfonetDate) {
        return new Timestamp(jinfonetDate.getTime());
    }

    public static Timestamp getSQLTimestamp(JinfonetTime jinfonetTime) {
        return new Timestamp(jinfonetTime.getTime());
    }

    public static Timestamp getSQLTimestamp(JinfonetTimeStamp jinfonetTimeStamp) {
        return new Timestamp(jinfonetTimeStamp.getTime());
    }

    public static int getCompatibleNumaricType(int n, int n2) {
        if (Types.isNumeric(n) && Types.isNumeric(n2)) {
            if (n == n2) {
                return n;
            }
            switch (n) {
                case -6: {
                    return n2;
                }
                case 5: {
                    if (n2 == -6) break;
                    return n2;
                }
                case 4: {
                    if (n2 == -6 || n2 == 5) break;
                    return n2;
                }
                case -5: {
                    if (n2 == -6 || n2 == 5 || n2 == 4) break;
                    return n2;
                }
                case 6: {
                    if (n2 != 8 && n2 != 3) break;
                    return n2;
                }
                case 8: {
                    if (n2 != 3) break;
                    return n2;
                }
                case 3: {
                    return n;
                }
                default: {
                    return n;
                }
            }
            return n;
        }
        throw new RuntimeException("Invalid type, must be numaric");
    }

    public static int getMaxPrecision(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case -6: {
                return SEDU;
            }
            case 5: {
                return append;
            }
            case 4: {
                return ceil;
            }
            case -5: {
                return debug;
            }
            case 6: {
                return desiredAssertionStatus;
            }
            case 8: {
                return equals;
            }
            case -7: {
                return 1;
            }
            case 3: {
                return 19;
            }
            case 91: {
                return 8;
            }
            case 92: {
                return 8;
            }
            case 93: {
                return 8;
            }
            case 12: {
                return 8096;
            }
            case -2: {
                return 0;
            }
            case 2005: {
                return 0;
            }
            case 2004: {
                return 0;
            }
            case 0x7FFFFFFF: {
                return 0;
            }
            case 2003: {
                return 0;
            }
            case 0x7FFFFFFE: {
                return 0;
            }
            case 0x7FFFFFFD: {
                return 0;
            }
            case 0x7FFFFFFC: {
                return 0;
            }
        }
        assert (false) : "not support dataType: " + n;
        return 0;
    }

    public static int dataLength(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case -6: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case -5: {
                return 8;
            }
            case 6: {
                return 4;
            }
            case 8: {
                return 8;
            }
            case -7: {
                return 1;
            }
            case 3: {
                return 0;
            }
            case 91: {
                return 8;
            }
            case 92: {
                return 8;
            }
            case 93: {
                return 8;
            }
            case 12: {
                return 0;
            }
            case -2: {
                return 0;
            }
            case 2005: {
                return 0;
            }
            case 2004: {
                return 0;
            }
            case 0x7FFFFFFF: {
                return 0;
            }
            case 2003: {
                return 0;
            }
            case 0x7FFFFFFE: {
                return 0;
            }
            case 0x7FFFFFFD: {
                return 0;
            }
            case 0x7FFFFFFC: {
                return 0;
            }
        }
        assert (false) : "not support dataType: " + n;
        return 0;
    }

    public static int swapDataLength(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case -6: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case -5: {
                return 8;
            }
            case 6: {
                return 4;
            }
            case 8: {
                return 8;
            }
            case -7: {
                return 1;
            }
            case 3: {
                return 0;
            }
            case 91: {
                return 8;
            }
            case 92: {
                return 8;
            }
            case 93: {
                return 12;
            }
            case 12: {
                return 0;
            }
            case -2: {
                return 0;
            }
            case 2005: {
                return 8;
            }
            case 2004: {
                return 8;
            }
            case 0x7FFFFFFF: {
                return 0;
            }
            case 2003: {
                return 0;
            }
            case 0x7FFFFFFE: {
                return 0;
            }
            case 0x7FFFFFFD: {
                return 0;
            }
            case 0x7FFFFFFC: {
                return 0;
            }
        }
        assert (false) : "not support dataType: " + n;
        return 0;
    }

    public static boolean isBoolean(int n) {
        return n == -7 || n == -7;
    }

    public static int getFuncSqlType(String string, int n) {
        int n2 = 0;
        if (string.equals("Count") || string.equals("DistinctCount") || string.equalsIgnoreCase("RunningCount") || string.equalsIgnoreCase("RunningDistinctCount")) {
            n2 = -5;
        } else if (string.equals("Minimum") || string.equals("Maximum") || string.equalsIgnoreCase("RunningMaximum") || string.equalsIgnoreCase("RunningMinimum")) {
            n2 = n;
        } else if (string.equals("Percentage") || string.equals("Permillage")) {
            n2 = 6;
        } else if (string.equals("Difference")) {
            n2 = Types.$assertionsDisabled(n) ? n : 2;
        } else if (string.equals("Average") || string.equalsIgnoreCase("RunningAvg")) {
            n2 = 8;
        } else {
            switch (n) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    n2 = -5;
                    break;
                }
                case 6: 
                case 8: {
                    n2 = 8;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
                default: {
                    n2 = n;
                }
            }
        }
        return n2;
    }

    private static boolean $assertionsDisabled(int n) {
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }
}

