/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.util;

import com.jinfonet.util.JRBLoggerFactory;
import com.jinfonet.util.JRLevel;
import com.jinfonet.util.JRLoggerReg;
import com.jinfonet.util.JRPatternLayout;
import com.jinfonet.util.JRRepositorySelector;
import com.jinfonet.util.ThrowableLogListener;
import java.io.File;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;

public class JRLogger
extends Logger {
    public static final String CONTEXT = "com.jinfonet";
    protected String JRFQCN = "com.jinfonet.util";
    private static LoggerFactory ALL = new JRBLoggerFactory();
    protected ResourceBundle resourceBundle;
    static boolean I;
    private ThrowableLogListener FATAL = null;
    public static final int TRACE = 1;
    public static final int ERROR = 2;
    public static final String titleSeparator = "*";
    public static String defTraceTitle;
    public static String defErrorTitle;
    public String title = defTraceTitle;
    static final JRLevel[] INFO;
    protected int gErrorLevel = 2;
    protected int gTraceLevel = 5;
    private static String[] J;
    Appender OFF = null;
    private int OUTLINE = 0;
    protected boolean gAdHoc = false;
    static boolean Z;
    protected String keyHeader;
    protected int id;

    public JRLogger(String string) {
        super(string);
    }

    public static Logger getLogger(String string) {
        return JRLogger.getLogger(string, ALL);
    }

    public static Logger getLogger(Class clazz) {
        return JRLogger.getLogger(clazz.getName(), ALL);
    }

    public static Logger getLogger(String string, LoggerFactory loggerFactory) {
        return JRRepositorySelector.getRepository(CONTEXT).getLogger(string, loggerFactory);
    }

    public static Logger getLogger(Class clazz, LoggerFactory loggerFactory) {
        return JRLogger.getLogger(clazz.getName(), loggerFactory);
    }

    public static Logger getRootLogger(String string) {
        return JRRepositorySelector.getRepository(string).getRootLogger();
    }

    public static Logger getRootLogger() {
        return JRLogger.getRootLogger(CONTEXT);
    }

    public static Logger getLogger(String string, String string2) {
        return JRRepositorySelector.getRepository(string2).getLogger(string, ALL);
    }

    public static Logger getLogger(Class clazz, String string) {
        return JRLogger.getLogger(clazz.getName(), string);
    }

    public static Logger exists(String string, String string2) {
        return JRRepositorySelector.getRepository(string2).exists(string);
    }

    public static Enumeration getCurrentCategories(String string) {
        return JRLogger.getCurrentLoggers(string);
    }

    public static Enumeration getCurrentLoggers(String string) {
        return JRRepositorySelector.getRepository(string).getCurrentLoggers();
    }

    public static LoggerRepository getDefaultHierarchy() {
        return JRRepositorySelector.getDefaultRepository();
    }

    public static void shutdown(String string) {
        JRRepositorySelector.getRepository(string).shutdown();
    }

    public void log(Level level, Object object) {
        this.log(level, object, null);
    }

    public void log(Level level, Object object, Throwable throwable) {
        this.log(this.JRFQCN, level, object, throwable);
    }

    public void log(String string, Level level, Object object, Throwable throwable) {
        if (throwable != null && this.FATAL != null) {
            this.FATAL.throwableReceived(NDC.peek(), object != null ? object.toString() : "", throwable);
        }
        if (object != null) {
            object = this.JRFQCN() + this.OFF() + object;
        }
        if (!I) {
            super.log(string, (Priority)level, object, throwable);
        } else {
            super.log(string, (Priority)level, object, throwable);
        }
    }

    public void l7dlog(Level level, int n, Throwable throwable) {
        this.$assertionsDisabled(level, n, null, throwable);
    }

    private void $assertionsDisabled(Level level, int n, Object[] objectArray, Throwable throwable) {
        this.ALL(this.JRFQCN, level, n, objectArray, throwable);
    }

    private void ALL(String string, Level level, int n, Object[] objectArray, Throwable throwable) {
        String string2 = null;
        String string3 = "" + n;
        string2 = this.getResourceBundleString(string3, level.equals((Object)JRLevel.ALL));
        if (string2 == null) {
            string2 = string3;
        } else if (objectArray != null) {
            string2 = MessageFormat.format(string2, objectArray);
        }
        this.log(string, level, string2, throwable);
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String getMessageString(int n, int n2, Object[] objectArray) {
        String string = null;
        String string2 = "" + n2;
        string = this.getResourceBundleString(string2, JRLogger.getMappedLevel(n).equals((Object)JRLevel.ALL));
        if (string == null) {
            string = string2;
        } else if (objectArray != null) {
            string = MessageFormat.format(string, objectArray);
        }
        return string;
    }

    protected String getResourceBundleString(String string, boolean bl) {
        ResourceBundle resourceBundle = this.resourceBundle;
        String string2 = null;
        if (resourceBundle == null) {
            this.error("No resource bundle has been set for logger " + this.name);
        } else {
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                if (!bl) {
                    StackTraceElement[] stackTraceElementArray = missingResourceException.getStackTrace();
                    this.error("Missing Resource at " + (stackTraceElementArray.length > 9 ? stackTraceElementArray[9] : stackTraceElementArray[stackTraceElementArray.length - 1]) + "\t\"" + string + "\" in logger: " + this.getName() + ".");
                    string2 = null;
                }
                string2 = string;
            }
        }
        return string2;
    }

    public void setLevel(int n, int n2) {
        this.FATAL(JRLogger.getMappedLevel(n), n2);
    }

    public void setLevelForV(int n, int n2) {
        this.ERROR(JRLogger.getMappedLevel(n), n2);
    }

    void ERROR(JRLevel jRLevel, int n) {
        if (n == 1) {
            this.gAdHoc = jRLevel.equals((Object)JRLevel.ALL);
            assert (jRLevel.equals((Object)JRLevel.OUTLINE) || jRLevel.equals((Object)JRLevel.INFO) || jRLevel.equals((Object)JRLevel.TRIVIAL) || jRLevel.equals((Object)JRLevel.ALL) || jRLevel.equals((Object)JRLevel.OFF));
        } else if (n == 2) assert (jRLevel.equals((Object)JRLevel.FATAL) || jRLevel.equals((Object)JRLevel.WARN) || jRLevel.equals((Object)JRLevel.ERROR) || jRLevel.equals((Object)JRLevel.OFF));
        if (n == 2) {
            this.gErrorLevel = JRLogger.getLevelValue(jRLevel);
            if (this.getLevel() == null || !jRLevel.equals((Object)JRLevel.OFF)) {
                this.setLevel(jRLevel);
            }
        } else if (n == 1) {
            this.gTraceLevel = JRLogger.getLevelValue(jRLevel);
            if (!jRLevel.equals((Object)JRLevel.OFF)) {
                this.setLevel(jRLevel);
            }
        }
    }

    void FATAL(JRLevel jRLevel, int n) {
        if (n == 1) {
            this.gAdHoc = jRLevel.equals((Object)JRLevel.ALL);
            assert (jRLevel.equals((Object)JRLevel.OUTLINE) || jRLevel.equals((Object)JRLevel.INFO) || jRLevel.equals((Object)JRLevel.TRIVIAL) || jRLevel.equals((Object)JRLevel.ALL) || jRLevel.equals((Object)JRLevel.OFF));
        } else if (n == 2) assert (jRLevel.equals((Object)JRLevel.FATAL) || jRLevel.equals((Object)JRLevel.WARN) || jRLevel.equals((Object)JRLevel.ERROR) || jRLevel.equals((Object)JRLevel.OFF));
        if (n == 2) {
            this.gErrorLevel = JRLogger.getLevelValue(jRLevel);
            if (this.getLevel() == null) {
                this.setLevel(jRLevel);
            }
        } else if (n == 1) {
            this.gTraceLevel = JRLogger.getLevelValue(jRLevel);
            if (!jRLevel.equals((Object)JRLevel.OFF)) {
                this.setLevel(jRLevel);
            }
        }
    }

    public static JRLevel getMappedLevel(int n) {
        if (n == 7) {
            return JRLevel.ALL;
        }
        return INFO[n];
    }

    public int getTraceLevel() {
        return this.gTraceLevel;
    }

    public int getErrorLevel() {
        return this.gErrorLevel;
    }

    public void close() {
        this.removeAllAppenders();
    }

    public void trace(Object object, Throwable throwable, int n) {
        if (this.I(this.gTraceLevel, n)) {
            this.log(JRLogger.getMappedLevel(n), object, throwable);
        }
    }

    public void trace(String string, Object object, Throwable throwable, int n) {
        if (this.I(this.gTraceLevel, n)) {
            this.log(string, JRLogger.getMappedLevel(n), object, throwable);
        }
    }

    public void trace(Object object, int n) {
        if (this.I(this.gTraceLevel, n)) {
            this.log(JRLogger.getMappedLevel(n), object);
        }
    }

    public void trace(int n, Throwable throwable, int n2) {
        if (this.I(this.gTraceLevel, n2)) {
            this.l7dlog(JRLogger.getMappedLevel(n2), n, throwable);
        }
    }

    public void trace(int n, Object[] objectArray, Throwable throwable, int n2) {
        if (this.I(this.gTraceLevel, n2)) {
            this.$assertionsDisabled(JRLogger.getMappedLevel(n2), n, objectArray, throwable);
        }
    }

    public void trace(String string, int n, Object[] objectArray, Throwable throwable, int n2) {
        if (this.I(this.gTraceLevel, n2)) {
            this.ALL(string, JRLogger.getMappedLevel(n2), n, objectArray, throwable);
        }
    }

    public void error(Object object, Throwable throwable, int n) {
        if (this.I(this.gErrorLevel, n)) {
            this.log(JRLogger.getMappedLevel(n), object, throwable);
        }
    }

    public void error(String string, Object object, Throwable throwable, int n) {
        if (this.I(this.gErrorLevel, n)) {
            this.log(string, JRLogger.getMappedLevel(n), object, throwable);
        }
    }

    public void error(int n, Object[] objectArray, Throwable throwable, int n2) {
        if (this.I(this.gErrorLevel, n2)) {
            this.$assertionsDisabled(JRLogger.getMappedLevel(n2), n, objectArray, throwable);
        }
    }

    public void error(String string, int n, Object[] objectArray, Throwable throwable, int n2) {
        if (this.I(this.gErrorLevel, n2)) {
            this.ALL(string, JRLogger.getMappedLevel(n2), n, objectArray, throwable);
        }
    }

    public void error(int n, Throwable throwable, int n2) {
        if (this.I(this.gErrorLevel, n2)) {
            this.l7dlog(JRLogger.getMappedLevel(n2), n, throwable);
        }
    }

    boolean I(int n, int n2) {
        if (n2 >= 3) assert (n2 >= 3) : "illegal error callerLevel : " + JRLogger.getMappedLevel(n2).toString() + "!!";
        return n >= n2;
    }

    public boolean isTraceFor(int n) {
        return this.I(this.gTraceLevel, n);
    }

    public boolean isErrorFor(int n) {
        return this.I(this.gErrorLevel, n);
    }

    boolean I(String string, boolean bl) {
        Appender appender;
        Object object;
        if (this.isTraceFor(7)) {
            StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
            this.trace("reset log file to " + string + ", PreAppender:" + (this.OFF == null ? "no" : this.OFF.getName()) + " at " + (stackTraceElementArray.length > 3 ? stackTraceElementArray[3] : stackTraceElementArray[stackTraceElementArray.length - 1]), 7);
        }
        boolean bl2 = true;
        ConsoleAppender consoleAppender = null;
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string != null && string.indexOf(File.separator) == -1) {
            string = new File(JRLoggerReg.getLogFolder(), string).toString();
        }
        JRPatternLayout jRPatternLayout = null;
        if (this.OFF == null) {
            jRPatternLayout = new JRPatternLayout();
            jRPatternLayout.setConversionPattern(JRPatternLayout.I);
        } else {
            jRPatternLayout = this.OFF.getLayout();
        }
        if (string != null) {
            if (this.OFF == null || !(this.OFF instanceof FileAppender)) {
                object = null;
                try {
                    object = I ? Class.forName("org.apache.log4j.rolling.RollingFileAppender") : Class.forName("org.apache.log4j.RollingFileAppender");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LogLog.error((String)("Fail to config " + string + " since RollingFileAppender Class fail to find!"));
                    bl2 = false;
                }
                try {
                    consoleAppender = (FileAppender)((Class)object).newInstance();
                }
                catch (InstantiationException instantiationException) {
                    LogLog.error((String)("Fail to config " + string), (Throwable)instantiationException);
                    bl2 = false;
                }
                catch (IllegalAccessException illegalAccessException) {
                    LogLog.error((String)("Fail to config " + string), (Throwable)illegalAccessException);
                    bl2 = false;
                }
                if (consoleAppender != null) {
                    GenericDeclaration genericDeclaration;
                    appender = (FileAppender)consoleAppender;
                    appender.setLayout((Layout)jRPatternLayout);
                    appender.setFile(string);
                    appender.setAppend(JRPatternLayout.Z);
                    if (!I) {
                        try {
                            genericDeclaration = ((Class)object).getMethod("setMaxFileSize", String.class);
                            if (genericDeclaration != null) {
                                ((Method)genericDeclaration).invoke(appender, JRPatternLayout.C);
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            LogLog.error((String)("Fail to config " + string), (Throwable)noSuchMethodException);
                            bl2 = false;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            LogLog.error((String)("Fail to config " + string), (Throwable)illegalAccessException);
                            bl2 = false;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            LogLog.error((String)("Fail to config " + string), (Throwable)invocationTargetException);
                            bl2 = false;
                        }
                    } else {
                        try {
                            genericDeclaration = Class.forName("org.apache.log4j.rolling.SizeBasedTriggeringPolicy");
                            Object obj = ((Class)genericDeclaration).newInstance();
                            Method method = ((Class)genericDeclaration).getMethod("setMaxFileSize", Long.TYPE);
                            if (method != null) {
                                method.invoke(obj, new Long(OptionConverter.toFileSize((String)JRPatternLayout.C, (long)(JRPatternLayout.B + 1L))));
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            LogLog.error((String)("Fail to config " + string), (Throwable)classNotFoundException);
                            bl2 = false;
                        }
                        catch (InstantiationException instantiationException) {
                            LogLog.error((String)("Fail to config " + string), (Throwable)instantiationException);
                            bl2 = false;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            LogLog.error((String)("Fail to config " + string), (Throwable)illegalAccessException);
                            bl2 = false;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            LogLog.error((String)("Fail to config " + string), (Throwable)noSuchMethodException);
                            bl2 = false;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            LogLog.error((String)("Fail to config " + string), (Throwable)invocationTargetException);
                            bl2 = false;
                        }
                    }
                    appender.activateOptions();
                }
            } else {
                ((FileAppender)this.OFF).setFile(string);
                ((FileAppender)this.OFF).activateOptions();
            }
        } else {
            consoleAppender = new ConsoleAppender((Layout)jRPatternLayout);
        }
        if (bl) {
            if (this.OFF != null) {
                object = this.getAllAppenders();
                while (object.hasMoreElements()) {
                    appender = (Appender)object.nextElement();
                    if (appender.getName() != null && !appender.getName().equals(this.OFF.getName())) {
                        this.removeAppender(appender);
                        continue;
                    }
                    if (appender.getName() != null) continue;
                    this.removeAppender(appender);
                }
            } else {
                this.removeAllAppenders();
                this.addAppender((Appender)consoleAppender);
            }
        } else {
            this.addAppender((Appender)(consoleAppender != null ? consoleAppender : this.OFF));
        }
        return bl2;
    }

    void I(Appender appender) {
        this.OFF = appender;
    }

    public void indent(String string) {
        this.INFO(string, true);
    }

    public void indent(String string, String string2) {
        this.J(string, string2, true);
    }

    private boolean INFO(String string, boolean bl) {
        return this.J(this.JRFQCN, string, bl);
    }

    private boolean J(String string, String string2, boolean bl) {
        return true;
    }

    public boolean deIndent(String string, String string2) {
        return this.J(string, string2, false);
    }

    public boolean deIndent(String string) {
        return this.INFO(string, false);
    }

    public int getCurIndent() {
        return 0;
    }

    private String JRFQCN() {
        return J[0];
    }

    private String OFF() {
        return "";
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setFQCN(String string) {
        this.JRFQCN = string;
    }

    public static int getLevelValue(String string) {
        for (int i = 0; i < INFO.length; ++i) {
            if (!INFO[i].toString().equalsIgnoreCase(string)) continue;
            return i;
        }
        assert (false) : "Fail to match the level : " + string;
        return -1;
    }

    public static int getLevelValue(JRLevel jRLevel) {
        for (int i = 0; i < INFO.length; ++i) {
            if (!INFO[i].equals((Object)jRLevel)) continue;
            return i;
        }
        return -1;
    }

    public void setThrowableLogListener(ThrowableLogListener throwableLogListener) {
        this.FATAL = throwableLogListener;
    }

    static {
        try {
            Class.forName("org.apache.log4j.rolling.RollingFileAppender");
            I = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            I = false;
        }
        defTraceTitle = "TRACE";
        defErrorTitle = "ERROR";
        INFO = new JRLevel[]{JRLevel.OFF, JRLevel.FATAL, JRLevel.ERROR, JRLevel.WARN, JRLevel.OUTLINE, JRLevel.INFO, JRLevel.TRIVIAL, JRLevel.ALL};
        J = new String[]{"", "   ", "      ", "         ", "            ", "               ", "                  ", "                     ", "                        ", "                           ", "                              "};
        Z = false;
    }
}

