/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.beans;

import com.jinfonet.web.ResultObject;
import com.jinfonet.web.beans.Atom;
import com.jinfonet.web.util.json.JSONArray;
import com.jinfonet.web.util.json.JSONException;
import com.jinfonet.web.util.json.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class Expression
implements ResultObject {
    private String SEDU;
    private List add;
    private Atom addExpression;
    private static final long serialVersionUID = 8406345085445742774L;

    public Expression(String string) {
        this.SEDU = string;
        this.add = new ArrayList();
    }

    public Expression(Atom atom) {
        this.addExpression = atom;
    }

    public String getOP() {
        return this.SEDU;
    }

    public void setOP(String string) {
        if (this.isAtom()) {
            throw new UnsupportedOperationException();
        }
        this.SEDU = string;
    }

    public boolean isAtom() {
        return this.addExpression != null;
    }

    public Atom getAtom() {
        return this.addExpression;
    }

    public List getExpressions() {
        return this.add;
    }

    public Expression addExpression(Expression expression) {
        if (this.isAtom()) {
            throw new UnsupportedOperationException();
        }
        this.add.add(expression);
        return this;
    }

    public String toString() {
        try {
            return this.toJSONObject().toString();
        }
        catch (Exception exception) {
            return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        }
    }

    @Override
    public Object toJSONObject() throws JSONException {
        return this.isAtom() ? this.addExpression.toJSONObject() : this.SEDU();
    }

    @Override
    public String getObjectClass() {
        return this.getClass().getName();
    }

    private JSONArray SEDU() throws JSONException {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put(this.SEDU);
        if (this.add != null) {
            for (Expression expression : this.add) {
                jSONArray.put(expression.toJSONObject());
            }
        }
        return jSONArray;
    }

    public static Expression parse(Object object) throws JSONException {
        if (object instanceof JSONObject) {
            return Expression.add((JSONObject)object);
        }
        if (object instanceof JSONArray) {
            return Expression.addExpression((JSONArray)object);
        }
        if (object instanceof String) {
            String string = ((String)object).trim();
            if (string.startsWith("{")) {
                return Expression.add(new JSONObject(string));
            }
            if (string.startsWith("[")) {
                return Expression.addExpression(new JSONArray(string));
            }
        } else {
            if (object instanceof Expression) {
                return (Expression)object;
            }
            if (object instanceof Atom) {
                return new Expression((Atom)object);
            }
        }
        throw new RuntimeException(object + " is not a valid expression.");
    }

    private static Expression add(JSONObject jSONObject) throws JSONException {
        return new Expression(Atom.parse(jSONObject));
    }

    private static Expression addExpression(JSONArray jSONArray) throws JSONException {
        if (jSONArray.length() == 0) {
            return new Expression("");
        }
        Expression expression = new Expression(jSONArray.optString(0));
        int n = jSONArray.length();
        for (int i = 1; i < n; ++i) {
            Object object = jSONArray.opt(i);
            expression.addExpression(Expression.parse(object));
        }
        return expression;
    }

    public void destroy() {
        if (this.add != null) {
            Iterator iterator = this.add.iterator();
            while (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                expression.destroy();
                iterator.remove();
            }
            this.add = null;
        }
        if (this.addExpression != null) {
            this.addExpression = null;
        }
    }
}

