/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.util;

import com.jinfonet.web.util.CharArray;
import com.jinfonet.web.util.JProperties;
import com.jinfonet.web.util.Tools;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public final class StringUtil {
    public static final JProperties date_patterns;
    public static final JProperties bool_patterns;
    public static final JProperties numeric_patterns;
    private static String SEDU;
    public static final char[] charsNull;
    public static final char[] charsTrue;
    public static final char[] charsFalse;
    public static final char[] charsIntegerMin;
    public static final char[] charsLongMin;
    public static final int[] sizeTable;
    public static final char[] DigitTens;
    public static final char[] DigitOnes;
    public static final char[] digits;
    public static final int[] masks;
    public static final int[] json_encodes;
    public static final int[] json_decodes;
    public static final long MULTMIN_RADIX_TEN = -922337203685477580L;
    public static final long N_MULTMAX_RADIX_TEN = -922337203685477580L;
    public static final int BASE64_J = 0;
    public static final int BASE64_S = 1;
    static final String[] add;
    static final char[][] append;
    static final int[][] appendReplacement;

    public static String findFormat(JProperties jProperties, String string) {
        for (String string2 : jProperties.keySet()) {
            Pattern pattern = Pattern.compile(string2);
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            String string3 = (String)jProperties.get(string2);
            if (jProperties.equals(date_patterns) && string3.contains("$")) {
                return StringUtil.DigitOnes(matcher, string3);
            }
            return string3;
        }
        return null;
    }

    private static String DigitOnes(Matcher matcher, String string) {
        if (matcher == null || string == null || string.length() == 0) {
            return string;
        }
        int n = matcher.groupCount();
        for (int i = 1; i <= n && string.contains("$"); ++i) {
            string = string.replaceFirst("\\$", matcher.group(i));
        }
        return string;
    }

    public static String unformat(int n, String string) throws ParseException {
        return StringUtil.unformat(n, string, Locale.getDefault(), null);
    }

    public static String unformat(int n, String string, Locale locale, String string2) throws ParseException {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string3 = null;
        switch (n) {
            case 91: {
                string3 = StringUtil.findFormat(date_patterns, string);
                break;
            }
            case 92: {
                string3 = StringUtil.findFormat(date_patterns, string);
                break;
            }
            case 93: {
                string3 = StringUtil.findFormat(date_patterns, string);
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string3 = StringUtil.findFormat(numeric_patterns, string);
                break;
            }
            case -7: 
            case 16: {
                string3 = StringUtil.findFormat(bool_patterns, string);
                break;
            }
            default: {
                return string;
            }
        }
        if (string3 == null) {
            throw new ParseException(string, 0);
        }
        return StringUtil.unformat(n, string, locale, string2, string3);
    }

    public static String unformat(int n, String string, Locale locale, String string2, String string3) throws ParseException {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string3 == null) {
            throw new ParseException(string, 0);
        }
        locale = locale == null ? Locale.getDefault() : locale;
        Date date = null;
        switch (n) {
            case 91: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3, locale);
                date = simpleDateFormat.parse(string);
                if (string2 == null || string2.trim().length() == 0) {
                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    DateFormatSymbols dateFormatSymbols = simpleDateFormat.getDateFormatSymbols();
                    dateFormatSymbols.setZoneStrings(new String[0][0]);
                    simpleDateFormat.setDateFormatSymbols(dateFormatSymbols);
                } else {
                    simpleDateFormat = new SimpleDateFormat(string2, locale);
                }
                return simpleDateFormat.format(date);
            }
            case 92: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3, locale);
                date = simpleDateFormat.parse(string);
                simpleDateFormat = string2 == null || string2.trim().length() == 0 ? new SimpleDateFormat("HH:mm:ss") : new SimpleDateFormat(string2, locale);
                return simpleDateFormat.format(date);
            }
            case 93: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3, locale);
                date = simpleDateFormat.parse(string);
                simpleDateFormat = string2 == null || string2.trim().length() == 0 ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS") : new SimpleDateFormat(string2, locale);
                return simpleDateFormat.format(date);
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                Object object = null;
                NumberFormat numberFormat = NumberFormat.getInstance(locale);
                DecimalFormat decimalFormat = null;
                if (numberFormat instanceof DecimalFormat) {
                    decimalFormat = (DecimalFormat)numberFormat;
                    decimalFormat.setDecimalSeparatorAlwaysShown(true);
                    decimalFormat.applyLocalizedPattern(string3);
                    object = decimalFormat.parse(string);
                }
                return object != null ? object.toString() : string;
            }
            case -7: 
            case 16: {
                char c = string.charAt(0);
                if (c >= '0' && c <= '9') {
                    if (c == '1' || c == '0') {
                        return new String(new char[]{c});
                    }
                    throw new ParseException(string, 0);
                }
                return string3;
            }
        }
        return string;
    }

    public static int findFirstDelimiter(String string, char c, char c2, char c3) {
        int n = string.length();
        boolean bl = c2 == c3;
        int n2 = 0;
        char c4 = string.charAt(0);
        for (int i = 0; i < n; ++i) {
            char c5 = string.charAt(i);
            if (bl) {
                if (c5 == c2 && c4 != '\\') {
                    n2 = n2 == 0 ? 1 : 0;
                }
                c4 = c5;
            } else if (c5 == c2) {
                ++n2;
            } else if (c5 == c3) {
                --n2;
            }
            if (c5 != c || n2 != 0) continue;
            return i;
        }
        return n;
    }

    public static List split(String string, char c) {
        return StringUtil.split(string, c, new String[0]);
    }

    public static List split(String string, char c, String[] stringArray) {
        return StringUtil.DigitTens(string, c, stringArray, new ArrayList());
    }

    private static List DigitTens(String string, char c, String[] stringArray, List list) {
        String string2 = string;
        if (string2.length() == 0) {
            return list;
        }
        char c2 = string2.charAt(0);
        int n = -1;
        int n2 = stringArray.length >> 1;
        for (int i = 0; i < n2; ++i) {
            int n3 = i << 1;
            char c3 = stringArray[n3].charAt(0);
            if (c2 != c3) continue;
            char c4 = stringArray[n3 + 1].charAt(0);
            n = StringUtil.findFirstDelimiter(string2, c, c3, c4);
            break;
        }
        if (n == -1) {
            n = StringUtil.findFirstDelimiter(string2, c, '\u0000', '\u0000');
        }
        list.add(string2.substring(0, n));
        if (n < string2.length()) {
            list = StringUtil.DigitTens(string2.substring(n + 1), c, stringArray, list);
        }
        return list;
    }

    public static String replace(String string, char c, char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c3 = string.charAt(i);
            if (c3 == c) {
                c3 = c2;
            }
            stringBuffer.append(c3);
        }
        return stringBuffer.toString();
    }

    public static String escape(String string, char[] cArray) {
        if (string == null || cArray == null || cArray.length == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (StringUtil.SEDU(c, cArray) != -1) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String unescape(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (++i >= n) continue;
                stringBuffer.append(string.charAt(i));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static int SEDU(char c, char[] cArray) {
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (c != cArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static String toHTMLString(String string, boolean ... blArray) {
        if (string == null) {
            return string;
        }
        boolean bl = false;
        if (blArray != null && blArray.length > 0) {
            bl = blArray[0];
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        block9: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block9;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block9;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block9;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block9;
                }
                case '\n': 
                case '\r': 
                case '\'': 
                case '\\': {
                    stringBuilder.append("&#");
                    stringBuilder.append(Integer.toString(c));
                    stringBuilder.append(';');
                    continue block9;
                }
                case ' ': {
                    if (bl) {
                        stringBuilder.append("&nbsp;");
                        continue block9;
                    }
                    stringBuilder.append(' ');
                    continue block9;
                }
                case '\u00a9': {
                    stringBuilder.append("&copy;");
                    continue block9;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String decodeHTMLString(String string) {
        if (string == null) {
            return string;
        }
        String string2 = string.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&").replaceAll("&quot;", "\"").replaceAll("&nbsp;", " ").replaceAll("&copy;", SEDU);
        Pattern pattern = Pattern.compile("&#(\\d+);");
        Matcher matcher = pattern.matcher(string2);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string3 = matcher.group(1);
            matcher.appendReplacement(stringBuffer, StringUtil.add(string3));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private static String add(String string) {
        int n = Integer.parseInt(string);
        char c = (char)n;
        return "" + c;
    }

    public static String decode(String string) {
        String string2 = null;
        if (string == null) {
            return string2;
        }
        try {
            string2 = URLDecoder.decode(string, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
        }
        return string2;
    }

    public static String formatColor(int n) {
        if ((n & 0xFF000000) == 0) {
            return "Transparent";
        }
        int n2 = n & 0xFFFFFF;
        String string = "00000" + Integer.toHexString(n2);
        return "#" + string.substring(string.length() - 6);
    }

    public static int parseColor(String string) {
        if (string == null || "Transparent".equalsIgnoreCase(string)) {
            return 0;
        }
        return Integer.parseInt(string.substring(1), 16) & 0xFFFFFF | 0xFF000000;
    }

    public static String intToHexString(int n) {
        String string = "0000000" + Integer.toHexString(n);
        return string.substring(string.length() - 8);
    }

    public static int hexStringToInt(String string) {
        String string2 = string.substring(string.length() - 6);
        int n = 0;
        try {
            n = Integer.parseInt(string2, 16);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static String byteToHexString(byte by) {
        String string = "0" + Integer.toHexString(by & 0xFF);
        return string.substring(string.length() - 2);
    }

    public static String bytesToHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (byArray != null) {
            int n = byArray.length;
            for (int i = 0; i < n && n > 0; ++i) {
                stringBuilder.append(StringUtil.byteToHexString(byArray[i]));
            }
        }
        return stringBuilder.toString();
    }

    public static byte[] hexStringToBytes(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        byte[] byArray = new byte[n >> 1];
        for (int i = 0; i < n; i += 2) {
            String string2 = string.substring(i, i + 2);
            int n2 = Integer.parseInt(string2, 16);
            byArray[i >> 1] = (byte)n2;
        }
        return byArray;
    }

    public static byte[] stringToBytes(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-16BE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return byArray;
    }

    public static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String string = Double.toString(d);
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static String intArrayToString(int[][] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[0].length;
            for (int j = 0; j < n2; ++j) {
                stringBuilder.append(nArray[i][j]);
                if (j >= n2 - 1) continue;
                stringBuilder.append(",");
            }
            if (i >= n - 1) continue;
            stringBuilder.append(";");
        }
        return stringBuilder.toString();
    }

    public static int[][] stringToIntArra(String string) {
        String string2 = string.trim();
        if (";".equals(string2)) {
            return new int[][]{{-1}, {0}};
        }
        String[] stringArray = string2.split(";");
        int n = stringArray.length;
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            String[] stringArray2 = stringArray[i].split(",");
            int[] nArray = new int[stringArray2.length];
            int n2 = stringArray2.length;
            for (int j = 0; j < n2; ++j) {
                nArray[j] = Integer.parseInt(stringArray2[j]);
            }
            nArrayArray[i] = nArray;
        }
        return nArrayArray;
    }

    public static String getDefaultFormatPattern(int n) {
        String string = null;
        int n2 = n;
        switch (n2) {
            case 91: {
                string = "yyyy-MM-dd";
                break;
            }
            case 92: {
                string = "HH:mm:ss";
                break;
            }
            case 93: {
                string = "yyyy-MM-dd HH:mm:ss.SSS";
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                string = "####";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                string = "#,###.00";
                break;
            }
            case -7: 
            case 16: {
                string = "True/False";
                break;
            }
            default: {
                string = "XXXXXXXXX...";
            }
        }
        return string;
    }

    public static boolean isNumber(int n) {
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static int stringSize(int n) {
        int n2 = 0;
        while (n > sizeTable[n2]) {
            ++n2;
        }
        return n2 + 1;
    }

    public static int stringSize(long l) {
        long l2 = 10L;
        for (int i = 1; i < 19; ++i) {
            if (l < l2) {
                return i;
            }
            l2 = 10L * l2;
        }
        return 19;
    }

    public static void getChars(int n, int n2, char[] cArray) {
        int n3;
        int n4;
        int n5 = n2;
        int n6 = 0;
        if (n < 0) {
            n6 = 45;
            n = -n;
        }
        while (n >= 65536) {
            n4 = n / 100;
            n3 = n - ((n4 << 6) + (n4 << 5) + (n4 << 2));
            n = n4;
            cArray[--n5] = DigitOnes[n3];
            cArray[--n5] = DigitTens[n3];
        }
        do {
            n4 = n * 52429 >>> 19;
            n3 = n - ((n4 << 3) + (n4 << 1));
            cArray[--n5] = digits[n3];
        } while ((n = n4) != 0);
        if (n6 != 0) {
            cArray[--n5] = n6;
        }
    }

    public static void getChars(long l, int n, char[] cArray) {
        int n2;
        int n3;
        int n4 = n;
        int n5 = 0;
        if (l < 0L) {
            n5 = 45;
            l = -l;
        }
        while (l > Integer.MAX_VALUE) {
            long l2 = l / 100L;
            n3 = (int)(l - ((l2 << 6) + (l2 << 5) + (l2 << 2)));
            l = l2;
            cArray[--n4] = DigitOnes[n3];
            cArray[--n4] = DigitTens[n3];
        }
        int n6 = (int)l;
        while (n6 >= 65536) {
            n2 = n6 / 100;
            n3 = n6 - ((n2 << 6) + (n2 << 5) + (n2 << 2));
            n6 = n2;
            cArray[--n4] = DigitOnes[n3];
            cArray[--n4] = DigitTens[n3];
        }
        do {
            n2 = n6 * 52429 >>> 19;
            n3 = n6 - ((n2 << 3) + (n2 << 1));
            cArray[--n4] = digits[n3];
        } while ((n6 = n2) != 0);
        if (n5 != 0) {
            cArray[--n4] = n5;
        }
    }

    public static void toCharArray(CharArray charArray, int n, int ... nArray) {
        int n2;
        int n3 = nArray.length > 0 ? nArray[0] : 10;
        int n4 = n2 = nArray.length > 1 ? nArray[1] : 8;
        if (n3 < 2 || n3 > 36) {
            n3 = 10;
        }
        int n5 = 0;
        int n6 = charArray.size();
        if (n3 == 10) {
            if (n == Integer.MIN_VALUE) {
                charArray.expandCapacity(n6 + charsIntegerMin.length);
                charArray.put(charsIntegerMin, 0, charsIntegerMin.length);
            } else {
                n5 = n < 0 ? StringUtil.stringSize(-n) + 1 : StringUtil.stringSize(n);
                n5 = n6 + n5;
                charArray.expandCapacity(n5);
                StringUtil.getChars(n, n5, charArray.getChars());
                charArray.seekp(n5);
            }
        } else if (n3 == 16) {
            StringUtil.toUnsignedCharArray(charArray, n, 4, n2);
        } else {
            char[] cArray = charArray.expandCapacity(n6 + 33);
            boolean bl = n < 0;
            int n7 = n6 + 32;
            if (!bl) {
                n = -n;
            }
            while (n <= -n3) {
                cArray[n7--] = digits[-(n % n3)];
                n /= n3;
            }
            cArray[n7] = digits[-n];
            if (bl) {
                cArray[--n7] = 45;
            }
            int n8 = n6 + 33 - n7;
            System.arraycopy(cArray, n7, cArray, n6, n8);
            charArray.seekp(n6 + n8);
        }
    }

    public static int toUnsignedCharArray(CharArray charArray, int n, int n2, int n3) {
        int n4 = charArray.size();
        char[] cArray = charArray.expandCapacity(n4 + 32);
        int n5 = n4 + 32;
        int n6 = 1 << n2;
        int n7 = n6 - 1;
        do {
            cArray[--n5] = digits[n & n7];
            n >>>= n2;
        } while (n3-- > 1);
        int n8 = n4 + 32 - n5;
        System.arraycopy(cArray, n5, cArray, n4, n8);
        int n9 = n4 + n8;
        charArray.seekp(n9);
        return n9;
    }

    public static void toCharArray(CharArray charArray, long l, int ... nArray) {
        int n;
        int n2 = nArray.length > 0 ? nArray[0] : 10;
        int n3 = n = nArray.length > 1 ? nArray[1] : 16;
        if (n2 < 2 || n2 > 36) {
            n2 = 10;
        }
        int n4 = 0;
        int n5 = charArray.size();
        if (n2 == 10) {
            if (l == Long.MIN_VALUE) {
                charArray.expandCapacity(n5 + charsLongMin.length);
                charArray.put(charsLongMin, 0, charsLongMin.length);
            } else {
                n4 = l < 0L ? StringUtil.stringSize(-l) + 1 : StringUtil.stringSize(l);
                n4 = n5 + n4;
                charArray.expandCapacity(n4);
                StringUtil.getChars(l, n4, charArray.getChars());
                charArray.seekp(n4);
            }
        } else if (n2 == 16) {
            StringUtil.toUnsignedCharArray(charArray, l, 4, n);
        } else {
            char[] cArray = charArray.expandCapacity(n5 + 65);
            boolean bl = l < 0L;
            int n6 = n5 + 64;
            if (!bl) {
                l = -l;
            }
            while (l <= (long)(-n2)) {
                cArray[n6--] = digits[(int)(-(l % (long)n2))];
                l /= (long)n2;
            }
            cArray[n6] = digits[(int)(-l)];
            if (bl) {
                cArray[--n6] = 45;
            }
            int n7 = n5 + 65 - n6;
            System.arraycopy(cArray, n6, cArray, n5, n7);
            charArray.seekp(n5 + n7);
        }
    }

    public static int toUnsignedCharArray(CharArray charArray, long l, int n, int n2) {
        int n3 = charArray.size();
        char[] cArray = charArray.expandCapacity(n3 + 64);
        int n4 = n3 + 64;
        int n5 = 1 << n;
        int n6 = n5 - 1;
        do {
            cArray[--n4] = digits[(int)(l & (long)n6)];
            l >>>= n;
        } while (n2-- > 1);
        int n7 = n3 + 64 - n4;
        System.arraycopy(cArray, n4, cArray, n3, n7);
        int n8 = n3 + n7;
        charArray.seekp(n8);
        return n8;
    }

    public static Number parseNumber(char[] cArray, int n, int n2, boolean bl, int n3) throws NumberFormatException {
        if (bl) {
            BigDecimal bigDecimal = new BigDecimal(cArray, n, n2);
            if (bigDecimal.precision() < 8) {
                return Float.valueOf(bigDecimal.floatValue());
            }
            return bigDecimal.doubleValue();
        }
        if (n3 == 10) {
            if (cArray[n] == '-' && n2 <= 10 || cArray[n] != '-' && n2 <= 9) {
                return StringUtil.parseInt(cArray, n, n2, 10);
            }
            if (cArray[n] == '-' && n2 <= 19 || cArray[n] != '-' && n2 <= 18) {
                return StringUtil.parseLong(cArray, n, n2, 10);
            }
            return new BigInteger(new String(cArray, n, n2), 10);
        }
        if (n3 == 16) {
            if (n2 <= 8) {
                return StringUtil.parseInt(cArray, n, n2, 16);
            }
            if (n2 <= 16) {
                return StringUtil.parseLong(cArray, n, n2, 16);
            }
            return new BigInteger(new String(cArray, n, n2), 16);
        }
        try {
            return StringUtil.parseLong(cArray, n, n2, n3);
        }
        catch (NumberFormatException numberFormatException) {
            return new BigInteger(new String(cArray, n, n2), n3);
        }
    }

    public static int parseInt(char[] cArray, int n, int n2, int n3) throws NumberFormatException {
        int n4 = 0;
        boolean bl = false;
        int n5 = n;
        int n6 = n + n2;
        if (n2 > 0) {
            int n7;
            int n8;
            if (cArray[n] == '-') {
                bl = true;
                n8 = Integer.MIN_VALUE;
                ++n5;
            } else {
                n8 = -2147483647;
            }
            int n9 = n8 / n3;
            if (n5 < n6) {
                n7 = masks[cArray[n5++]];
                n4 -= n7;
            }
            while (n5 < n6) {
                n7 = masks[cArray[n5++]];
                if (n4 < n9) {
                    throw new NumberFormatException(new String(cArray, n, n2));
                }
                if ((n4 *= n3) < n8 + n7) {
                    throw new NumberFormatException(new String(cArray, n, n2));
                }
                n4 -= n7;
            }
        } else {
            throw new NumberFormatException(new String(cArray, n, n2));
        }
        if (bl) {
            if (n5 > n + 1) {
                return n4;
            }
            throw new NumberFormatException(new String(cArray, n, n2));
        }
        return -n4;
    }

    public static long parseLong(char[] cArray, int n, int n2, int n3) throws NumberFormatException {
        long l = 0L;
        boolean bl = false;
        int n4 = n;
        int n5 = n + n2;
        if (n2 > 0) {
            int n6;
            long l2;
            if (cArray[n] == '-') {
                bl = true;
                l2 = Long.MIN_VALUE;
                ++n4;
            } else {
                l2 = -9223372036854775807L;
            }
            long l3 = n3 == 10 ? (bl ? -922337203685477580L : -922337203685477580L) : l2 / (long)n3;
            if (n4 < n5) {
                n6 = masks[cArray[n4++]];
                l -= (long)n6;
            }
            while (n4 < n5) {
                n6 = masks[cArray[n4++]];
                if (l < l3) {
                    throw new NumberFormatException(new String(cArray, n, n2));
                }
                if ((l *= (long)n3) < l2 + (long)n6) {
                    throw new NumberFormatException(new String(cArray, n, n2));
                }
                l -= (long)n6;
            }
        } else {
            throw new NumberFormatException(new String(cArray, n, n2));
        }
        if (bl) {
            if (n4 > n + 1) {
                return l;
            }
            throw new NumberFormatException(new String(cArray, n, n2));
        }
        return -l;
    }

    public static int parseInt(String string, int n) {
        int n2;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            n2 = n;
        }
        return n2;
    }

    public static long parseLong(String string, long l) {
        long l2;
        try {
            l2 = Long.parseLong(string);
        }
        catch (Throwable throwable) {
            l2 = l;
        }
        return l2;
    }

    public static String base64Encode(String string, int ... nArray) {
        if (string == null || string.length() == 0) {
            return string;
        }
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
        return StringUtil.base64EncodeFoArray(byArray, nArray);
    }

    public static String base64EncodeFoArray(byte[] byArray, int ... nArray) {
        if (byArray == null) {
            return null;
        }
        int n = nArray != null && nArray.length > 0 ? nArray[0] : 0;
        char[] cArray = append[n];
        int n2 = byArray.length;
        char[] cArray2 = new char[(n2 / 3 << 2) + (n2 % 3 > 0 ? 4 : 0)];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int n5;
            int n6;
            byte by = byArray[n3++];
            int n7 = (by & 0xFC) >> 2;
            int n8 = (by & 3) << 4;
            if (n3 < n2) {
                by = byArray[n3++];
                n8 |= (by & 0xF0) >> 4;
                n6 = (by & 0xF) << 2;
                if (n3 < n2) {
                    by = byArray[n3++];
                    n6 |= (by & 0xC0) >> 6;
                    n5 = by & 0x3F;
                } else {
                    n5 = 64;
                }
            } else {
                n5 = 64;
                n6 = 64;
            }
            cArray2[n4++] = cArray[n7];
            cArray2[n4++] = cArray[n8];
            cArray2[n4++] = cArray[n6];
            cArray2[n4++] = cArray[n5];
        }
        return new String(cArray2, 0, n4);
    }

    public static String base64Decode(String string, int ... nArray) {
        byte[] byArray = StringUtil.base64DecodeToArray(string, nArray);
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static byte[] base64DecodeToArray(String string, int ... nArray) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        if (n % 4 != 0) {
            throw new IllegalArgumentException(string);
        }
        int n2 = nArray != null && nArray.length > 0 ? nArray[0] : 0;
        int[] nArray2 = appendReplacement[n2];
        byte[] byArray = new byte[n / 4 * 3];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < n) {
            int n6 = nArray2[string.charAt(n3++)];
            int n7 = n6 << 18;
            n6 = nArray2[string.charAt(n3++)];
            n7 |= n6 << 12;
            if ((n6 = nArray2[string.charAt(n3++)]) < 64) {
                n7 |= n6 << 6;
                if ((n6 = nArray2[string.charAt(n3++)]) < 64) {
                    n7 |= n6;
                } else {
                    n5 = 1;
                }
            } else {
                n5 = 2;
                ++n3;
            }
            byArray[n4 + 2] = (byte)(n7 & 0xFF);
            byArray[n4 + 1] = (byte)((n7 >>= 8) & 0xFF);
            byArray[n4 + 0] = (byte)((n7 >>= 8) & 0xFF);
            n4 += 3;
        }
        if (n5 != 0) {
            n = byArray.length - n5;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            return byArray2;
        }
        return byArray;
    }

    public static String base64EncodeImage(RenderedImage renderedImage, String string) {
        StringBuilder stringBuilder = new StringBuilder("data:");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write(renderedImage, string, byteArrayOutputStream);
            String string2 = StringUtil.base64EncodeFoArray(byteArrayOutputStream.toByteArray(), 1);
            stringBuilder.append("image/").append(string).append(";base64,");
            stringBuilder.append(string2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public static String SBC2DBC(String string) {
        char[] cArray = new char[string.length()];
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            cArray[i] = c >= '\uff01' && c <= '\uff5e' ? (int)(c - 65248) : (c == '\u3000' ? 32 : (char)c);
        }
        return new String(cArray);
    }

    public static double round(double d, int n) {
        BigDecimal bigDecimal = new BigDecimal(d);
        return bigDecimal.setScale(n, 4).doubleValue();
    }

    public static int round(double d) {
        BigDecimal bigDecimal = new BigDecimal(d);
        return bigDecimal.setScale(0, 4).intValue();
    }

    public static boolean isURL(String string) {
        boolean bl = false;
        if (string != null) {
            bl = string.indexOf(47) != -1 || string.indexOf(File.separator) != -1;
        }
        return bl;
    }

    public static String unformat(int n, String string, Locale locale) throws ParseException {
        String string2 = null;
        locale = locale == null ? Locale.getDefault() : locale;
        Date date = null;
        switch (n) {
            case 91: {
                string2 = StringUtil.findFormat(date_patterns, string);
                if (string2 == null) {
                    throw new ParseException(string, 0);
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, locale);
                date = simpleDateFormat.parse(string);
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd z");
                return simpleDateFormat.format(date);
            }
            case 92: {
                string2 = StringUtil.findFormat(date_patterns, string);
                if (string2 == null) {
                    throw new ParseException(string, 0);
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, locale);
                date = simpleDateFormat.parse(string);
                simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
                return simpleDateFormat.format(date);
            }
            case 93: {
                string2 = StringUtil.findFormat(date_patterns, string);
                if (string2 == null) {
                    throw new ParseException(string, 0);
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, locale);
                date = simpleDateFormat.parse(string);
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                return simpleDateFormat.format(date);
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                Object object = null;
                string2 = StringUtil.findFormat(numeric_patterns, string);
                if (string2 == null) {
                    throw new ParseException(string, 0);
                }
                NumberFormat numberFormat = NumberFormat.getInstance(locale);
                DecimalFormat decimalFormat = null;
                if (numberFormat instanceof DecimalFormat) {
                    decimalFormat = (DecimalFormat)numberFormat;
                    decimalFormat.setDecimalSeparatorAlwaysShown(true);
                    decimalFormat.applyLocalizedPattern(string2);
                    object = decimalFormat.parse(string);
                }
                return object != null ? object.toString() : string;
            }
            case -7: 
            case 16: {
                string2 = StringUtil.findFormat(bool_patterns, string);
                if (string2 == null) {
                    throw new ParseException(string, 0);
                }
                char c = string.charAt(0);
                if (c >= '0' && c <= '9') {
                    if (c == '1' || c == '0') {
                        return new String(new char[]{c});
                    }
                    throw new ParseException(string, 0);
                }
                return string2;
            }
        }
        return string;
    }

    public static Map extractQueryString(String string) {
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        if (string == null || string.trim().length() == 0) {
            return hashMap;
        }
        for (String string2 : string.split("&")) {
            Object object;
            String[] stringArray = string2.split("=");
            int n = stringArray.length;
            if (n > 2) {
                object = new IllegalArgumentException("Illegal URL input parameter [ " + string2 + " ]");
                continue;
            }
            if (n == 1) continue;
            try {
                object = URLDecoder.decode(stringArray[0], "UTF-8");
                String string3 = URLDecoder.decode(stringArray[1], "UTF-8");
                hashMap.put(object, string3);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return hashMap;
    }

    public static String parse(int n, String string, Locale locale, String string2) throws ParseException {
        if (string == null || string.length() == 0) {
            return string;
        }
        return StringUtil.unformat(n, string, locale, null, string2);
    }

    public static String buildQueryStr(Map map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : map.keySet()) {
            stringBuilder.append(string).append("=").append((String)map.get(string)).append("&");
        }
        String string = stringBuilder.toString();
        if (string.trim().length() != 0) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static int parseIntWithRadix(String string, int n) {
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 65535;
        }
        return n2;
    }

    public static int[] parseInt(String string) {
        int n;
        if (string == null) {
            return new int[0];
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return new int[0];
        }
        int n2 = string2.indexOf(45);
        if (n2 == -1) {
            return new int[]{StringUtil.parseIntWithRadix(string, 10)};
        }
        int n3 = StringUtil.parseIntWithRadix(string2.substring(0, n2), 10);
        if (n3 == (n = StringUtil.parseIntWithRadix(string2.substring(n2 + 1), 10))) {
            return new int[]{n3};
        }
        if (n3 < n) {
            int n4 = n - n3 + 1;
            int[] nArray = new int[n4];
            for (int i = 0; i < n4; ++i) {
                nArray[i] = n3 + i;
            }
            return nArray;
        }
        if (n3 > n) {
            int n5 = n3 - n + 1;
            int[] nArray = new int[n5];
            for (int i = 0; i < n5; ++i) {
                nArray[i] = n3 - i;
            }
            return nArray;
        }
        return null;
    }

    public static int[] parseInt(String[] stringArray) {
        if (stringArray == null) {
            return new int[0];
        }
        int n = stringArray.length;
        if (n == 0) {
            return new int[0];
        }
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int[] nArray = StringUtil.parseInt(stringArray[i]);
            arrayList.add(nArray);
            n2 += nArray.length;
        }
        int[] nArray = new int[n2];
        n = arrayList.size();
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = (int[])arrayList.get(i);
            int n4 = nArray2.length;
            System.arraycopy(nArray2, 0, nArray, n3, n4);
            n3 += n4;
        }
        return nArray;
    }

    public static String escapeJSONString(String string) {
        int n;
        if (string == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        int n2 = n = cArray == null ? 0 : cArray.length;
        block9: for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block9;
                }
                case '\b': {
                    stringBuilder.append("\\\\b");
                    continue block9;
                }
                case '\n': {
                    stringBuilder.append("\\\\n");
                    continue block9;
                }
                case '\t': {
                    stringBuilder.append("\\\\t");
                    continue block9;
                }
                case '\r': {
                    stringBuilder.append("\\\\r");
                    continue block9;
                }
                case '\f': {
                    stringBuilder.append("\\\\f");
                    continue block9;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static Locale parseLocale(String string) {
        Locale locale;
        if (string == null || string.isEmpty()) {
            locale = Locale.getDefault();
        } else {
            String string2;
            String string3;
            int n = string.indexOf(95);
            if (n > 0) {
                string3 = string.substring(0, n);
                string2 = string.substring(n + 1);
            } else {
                string3 = string;
                string2 = "";
            }
            locale = new Locale(string3, string2);
        }
        return locale;
    }

    public static String toString(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (objectArray != null) {
            stringBuilder.append("[");
            for (Object object : objectArray) {
                stringBuilder.append(object.toString()).append(",");
            }
            if (stringBuilder.length() > 1) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            stringBuilder.append("]");
        } else {
            stringBuilder.append("null");
        }
        return stringBuilder.toString();
    }

    static {
        int n;
        date_patterns = Tools.getProperties("date.pattern.properties");
        bool_patterns = Tools.getProperties("bool.pattern.properties");
        numeric_patterns = Tools.getProperties("numeric.pattern.properties");
        SEDU = new String(new char[]{'\u00a9'});
        charsNull = new char[]{'n', 'u', 'l', 'l'};
        charsTrue = new char[]{'t', 'r', 'u', 'e'};
        charsFalse = new char[]{'f', 'a', 'l', 's', 'e'};
        charsIntegerMin = new char[]{'-', '2', '1', '4', '7', '4', '8', '3', '6', '4', '8'};
        charsLongMin = new char[]{'-', '9', '2', '2', '3', '3', '7', '2', '0', '3', '6', '8', '5', '4', '7', '7', '5', '8', '0', '8'};
        sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
        DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
        DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        masks = new int[256];
        json_encodes = new int[256];
        json_decodes = new int[256];
        block18: for (n = 0; n < 256; ++n) {
            StringUtil.masks[n] = 256;
            StringUtil.json_encodes[n] = -1;
            StringUtil.json_decodes[n] = -1;
            switch (n) {
                case 34: 
                case 47: 
                case 92: {
                    StringUtil.json_encodes[n] = n;
                    StringUtil.json_decodes[n] = n;
                    continue block18;
                }
                case 13: {
                    StringUtil.masks[n] = 128;
                    StringUtil.json_encodes[n] = 114;
                    continue block18;
                }
                case 114: {
                    StringUtil.json_decodes[n] = 13;
                    continue block18;
                }
                case 10: {
                    StringUtil.masks[n] = 128;
                    StringUtil.json_encodes[n] = 110;
                    continue block18;
                }
                case 110: {
                    StringUtil.json_decodes[n] = 10;
                    continue block18;
                }
                case 9: {
                    StringUtil.masks[n] = 128;
                    StringUtil.json_encodes[n] = 116;
                    continue block18;
                }
                case 116: {
                    StringUtil.json_decodes[n] = 9;
                    continue block18;
                }
                case 12: {
                    StringUtil.masks[n] = 128;
                    StringUtil.json_encodes[n] = 102;
                    continue block18;
                }
                case 102: {
                    StringUtil.json_decodes[n] = 12;
                    StringUtil.masks[n] = 10 + n - 97;
                    continue block18;
                }
                case 8: {
                    StringUtil.masks[n] = 128;
                    StringUtil.json_encodes[n] = 98;
                    continue block18;
                }
                case 98: {
                    StringUtil.json_decodes[n] = 8;
                    StringUtil.masks[n] = 10 + n - 97;
                    continue block18;
                }
                case 117: {
                    StringUtil.json_decodes[n] = -2;
                    continue block18;
                }
                case 88: 
                case 120: {
                    StringUtil.masks[n] = 16;
                    continue block18;
                }
                case 46: {
                    StringUtil.masks[n] = 32;
                    continue block18;
                }
                case 43: 
                case 45: {
                    StringUtil.masks[n] = 64;
                    continue block18;
                }
                case 32: {
                    StringUtil.masks[n] = 128;
                    continue block18;
                }
                default: {
                    if (n >= 48 && n <= 57) {
                        StringUtil.masks[n] = n - 48;
                    } else if (n >= 65 && n <= 70) {
                        StringUtil.masks[n] = 10 + n - 65;
                    } else if (n >= 97 && n <= 102) {
                        StringUtil.masks[n] = 10 + n - 97;
                    }
                    if (n >= 32 && (n < 128 || n >= 160)) continue block18;
                    StringUtil.json_encodes[n] = 117;
                }
            }
        }
        add = new String[]{"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789@*-", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/="};
        append = new char[add.length][65];
        appendReplacement = new int[add.length][128];
        for (n = 0; n < add.length; ++n) {
            for (int i = 0; i < 65; ++i) {
                StringUtil.append[n][i] = add[n].charAt(i);
                StringUtil.appendReplacement[n][StringUtil.add[n].codePointAt((int)i)] = i;
            }
        }
    }
}

