/*
 * Decompiled with CFR 0.152.
 */
package guitools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class GroupBox
extends Container {
    public static final int NONE = 0;
    public static final int RAISED = 1;
    public static final int INSET = 2;
    int SEDU;
    String draw3DRect;

    public GroupBox() {
        this(null, 2);
    }

    public GroupBox(String string) {
        this(string, 2);
    }

    public GroupBox(String string, int n) {
        this.setLayout(null);
        this.SEDU = n;
        this.draw3DRect = string;
    }

    public void setLabel(String string) {
        this.draw3DRect = string;
        this.repaint();
    }

    public String getLabel() {
        return this.draw3DRect;
    }

    public int getTDEffect() {
        return this.SEDU;
    }

    public void setTDEffect(int n) {
        this.SEDU = n;
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        int n = fontMetrics.getHeight();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (this.SEDU == 1) {
            graphics.draw3DRect(0, n / 2, dimension.width - 1, dimension.height - n / 2 - 1, true);
            graphics.draw3DRect(1, n / 2 + 1, dimension.width - 3, dimension.height - n / 2 - 3, false);
        } else if (this.SEDU == 2) {
            graphics.draw3DRect(0, n / 2, dimension.width - 1, dimension.height - n / 2 - 1, false);
            graphics.draw3DRect(1, n / 2 + 1, dimension.width - 3, dimension.height - n / 2 - 3, true);
        } else if (this.SEDU == 0) {
            graphics.setColor(this.getForeground());
            graphics.drawRect(0, n / 2, dimension.width - 1, dimension.height - 1);
        }
        if (this.draw3DRect != null && this.draw3DRect.length() != 0) {
            graphics.fillRect(12, 0, fontMetrics.stringWidth(this.draw3DRect) + 10, n);
            graphics.setColor(this.getForeground());
            graphics.drawString(this.draw3DRect, 18, n - 3);
        }
        super.paint(graphics);
    }

    public void setChildEnabled(boolean bl) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(bl);
        }
        this.setEnabled(bl);
    }
}

