/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import guitools.toolkit.ScrollPanelLayout;
import guitools.toolkit.Unit;
import java.awt.Adjustable;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;

public abstract class ScrollPanel
extends Container
implements AdjustmentListener {
    public static final int HASHBAR = 1;
    public static final int HASVBAR = 2;
    public static final int HAUTO = 4;
    public static final int VAUTO = 8;
    int I;
    private int SEDU;
    int addAdjustmentListener;
    int addImpl;
    protected final Scrollbar hScrollbar = new Scrollbar(0);
    protected final Scrollbar vScrollbar = new Scrollbar();
    protected final Canvas corner = new Canvas();
    LayoutManager Z;
    private static int append = 0;

    public ScrollPanel() {
        this(null, 15);
    }

    public ScrollPanel(LayoutManager layoutManager) {
        this(layoutManager, 15);
    }

    public ScrollPanel(int n) {
        this(null, n);
    }

    public ScrollPanel(LayoutManager layoutManager, int n) {
        this.setName("scrollpanel" + append++);
        super.setLayout(new ScrollPanelLayout());
        this.enableEvents(8L);
        this.Z = layoutManager;
        this.I = n;
        this.hScrollbar.setSize(0, Unit.barHeight());
        this.hScrollbar.setMaximum(0);
        this.hScrollbar.setBackground(SystemColor.scrollbar);
        this.hScrollbar.addAdjustmentListener(this);
        this.vScrollbar.setSize(Unit.barWidth(), 0);
        this.vScrollbar.setMaximum(0);
        this.vScrollbar.addAdjustmentListener(this);
        this.vScrollbar.setBackground(SystemColor.scrollbar);
        this.corner.setBackground(SystemColor.scrollbar);
        this.SEDU();
    }

    public void setBarsSize(int n, int n2) {
        Dimension dimension = this.hScrollbar.getSize();
        dimension.height = n2;
        this.hScrollbar.setSize(dimension);
        dimension = this.vScrollbar.getSize();
        dimension.width = n;
        this.vScrollbar.setSize(dimension);
        this.doLayout();
    }

    public Dimension getBarsSize() {
        Dimension dimension = this.hScrollbar.getSize();
        dimension.width = this.vScrollbar.getSize().width;
        return dimension;
    }

    public void setHBarHeight(int n) {
        this.setBarsSize(this.vScrollbar.getSize().width, n);
    }

    public void setVBarWidth(int n) {
        this.setBarsSize(n, this.hScrollbar.getSize().height);
    }

    public int getHBarHeight() {
        return this.hScrollbar.getSize().height;
    }

    public int getVBarWidth() {
        return this.vScrollbar.getSize().width;
    }

    public void setMinimum(int n, int n2) {
        if (n == 0) {
            this.hScrollbar.setMaximum(this.hScrollbar.getMaximum() + this.addAdjustmentListener - n2);
            this.addAdjustmentListener = n2;
            this.setValue(n, this.hScrollbar.getValue() + this.addAdjustmentListener);
        } else if (n == 1) {
            this.vScrollbar.setMaximum(this.vScrollbar.getMaximum() + this.addImpl - n2);
            this.addImpl = n2;
            this.setValue(n, this.vScrollbar.getValue() + this.addImpl);
        }
    }

    public int getMinimum(int n) {
        return n == 0 ? this.addAdjustmentListener : this.addImpl;
    }

    public void setMaximum(int n, int n2) {
        if (n == 0) {
            this.hScrollbar.setMaximum(n2 - this.addAdjustmentListener);
            this.setValue(n, this.hScrollbar.getValue() + this.addAdjustmentListener);
        } else if (n == 1) {
            this.vScrollbar.setMaximum(n2 - this.addImpl);
            this.setValue(n, this.vScrollbar.getValue() + this.addImpl);
        }
    }

    public int getMaximum(int n) {
        return n == 0 ? this.hScrollbar.getMaximum() + this.addAdjustmentListener : this.vScrollbar.getMaximum() + this.addImpl;
    }

    public void setUnitIncrement(int n, int n2) {
        if (n == 0) {
            this.hScrollbar.setUnitIncrement(n2);
        } else if (n == 1) {
            this.vScrollbar.setUnitIncrement(n2);
        }
    }

    public int getUnitIncrement(int n) {
        return n == 0 ? this.hScrollbar.getUnitIncrement() : this.vScrollbar.getUnitIncrement();
    }

    public int getBlockIncrement(int n) {
        return n == 0 ? this.hScrollbar.getBlockIncrement() : this.vScrollbar.getBlockIncrement();
    }

    public int getVisibleAmount(int n) {
        return n == 0 ? this.hScrollbar.getVisibleAmount() : this.vScrollbar.getVisibleAmount();
    }

    public int setValue(int n, int n2) {
        if (n == 0) {
            int n3 = this.hScrollbar.getMaximum() - this.hScrollbar.getVisibleAmount();
            int n4 = n2 - this.addAdjustmentListener;
            n4 = n4 < 0 ? 0 : (n4 > n3 ? n3 : n4);
            this.hScrollbar.setValue(n4);
            if (this.hScrollbar.isVisible()) {
                this.horizontalScroll(n4 + this.addAdjustmentListener);
            }
            return n4;
        }
        if (n == 1) {
            int n5 = this.vScrollbar.getMaximum() - this.vScrollbar.getVisibleAmount();
            int n6 = n2 - this.addImpl;
            n6 = n6 < 0 ? 0 : (n6 > n5 ? n5 : n6);
            this.vScrollbar.setValue(n6);
            if (this.vScrollbar.isVisible()) {
                this.verticalScroll(n6 + this.addImpl);
            }
            return n6;
        }
        return n2;
    }

    public int getValue(int n) {
        return n == 0 ? this.hScrollbar.getValue() + this.addAdjustmentListener : this.vScrollbar.getValue() + this.addImpl;
    }

    public void addAdjustmentListener(int n, AdjustmentListener adjustmentListener) {
        if (n == 0) {
            this.hScrollbar.addAdjustmentListener(adjustmentListener);
        } else if (n == 1) {
            this.vScrollbar.addAdjustmentListener(adjustmentListener);
        }
    }

    public void removeAdjustmentListener(int n, AdjustmentListener adjustmentListener) {
        if (n == 0) {
            this.hScrollbar.removeAdjustmentListener(adjustmentListener);
        } else if (n == 1) {
            this.vScrollbar.removeAdjustmentListener(adjustmentListener);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Adjustable adjustable = adjustmentEvent.getAdjustable();
        int n = adjustmentEvent.getValue();
        if ((Scrollbar)adjustable == this.hScrollbar) {
            int n2 = this.hScrollbar.getMaximum() - this.hScrollbar.getVisibleAmount();
            if (n > n2) {
                n = n2;
                this.hScrollbar.setValue(n);
            }
            this.horizontalScroll(n + this.addAdjustmentListener);
        } else if ((Scrollbar)adjustable == this.vScrollbar) {
            int n3 = this.vScrollbar.getMaximum() - this.vScrollbar.getVisibleAmount();
            if (n > n3) {
                n = n3;
                this.vScrollbar.setValue(n);
            }
            this.verticalScroll(n + this.addImpl);
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            int n = keyEvent.getModifiers();
            switch (keyEvent.getKeyCode()) {
                case 33: {
                    if (n == 0) {
                        this.setValue(1, this.vScrollbar.getValue() - this.vScrollbar.getBlockIncrement() + this.addImpl);
                        break;
                    }
                    if (n != 2) break;
                    this.setValue(0, this.hScrollbar.getValue() - this.hScrollbar.getBlockIncrement() + this.addAdjustmentListener);
                    break;
                }
                case 34: {
                    if (n == 0) {
                        this.setValue(1, this.vScrollbar.getValue() + this.vScrollbar.getBlockIncrement() + this.addImpl);
                        break;
                    }
                    if (n != 2) break;
                    this.setValue(0, this.hScrollbar.getValue() + this.hScrollbar.getBlockIncrement() + this.addAdjustmentListener);
                    break;
                }
                case 35: {
                    if (n == 0) {
                        this.setValue(0, this.hScrollbar.getMaximum() - this.hScrollbar.getVisibleAmount() + this.addAdjustmentListener);
                        break;
                    }
                    if (n != 2) break;
                    this.setValue(1, this.vScrollbar.getMaximum() - this.vScrollbar.getVisibleAmount() + this.addImpl);
                    break;
                }
                case 36: {
                    if (n == 0) {
                        this.setValue(0, 0 + this.addAdjustmentListener);
                        break;
                    }
                    if (n != 2) break;
                    this.setValue(1, 0 + this.addImpl);
                    break;
                }
                case 37: {
                    this.setValue(0, this.hScrollbar.getValue() - this.hScrollbar.getUnitIncrement() + this.addAdjustmentListener);
                    break;
                }
                case 38: {
                    this.setValue(1, this.vScrollbar.getValue() - this.vScrollbar.getUnitIncrement() + this.addImpl);
                    break;
                }
                case 39: {
                    this.setValue(0, this.hScrollbar.getValue() + this.hScrollbar.getUnitIncrement() + this.addAdjustmentListener);
                    break;
                }
                case 40: {
                    this.setValue(1, this.vScrollbar.getValue() + this.vScrollbar.getUnitIncrement() + this.addImpl);
                }
            }
        }
        super.processKeyEvent(keyEvent);
    }

    public abstract void horizontalScroll(int var1);

    public abstract void verticalScroll(int var1);

    @Override
    protected final void addImpl(Component component, Object object, int n) {
        if (n >= 0 && n < this.SEDU) {
            n = -1;
        }
        super.addImpl(component, object, n);
    }

    @Override
    public final void remove(int n) {
        super.remove(n);
    }

    @Override
    public final void removeAll() {
        super.removeAll();
        this.SEDU();
    }

    @Override
    public LayoutManager getLayout() {
        return this.Z;
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        this.Z = layoutManager;
        if (this.isValid()) {
            this.invalidate();
        }
    }

    public Dimension getClientSize() {
        Dimension dimension = this.getSize();
        dimension.width = dimension.width - (this.vScrollbar.isVisible() ? this.vScrollbar.getSize().width : 0);
        dimension.height = dimension.height - (this.hScrollbar.isVisible() ? this.hScrollbar.getSize().height : 0);
        return dimension;
    }

    private void SEDU() {
        this.SEDU = 0;
        if ((this.I & 1) != 0) {
            ++this.SEDU;
            super.addImpl(this.hScrollbar, null, 0);
        }
        if ((this.I & 2) != 0) {
            ++this.SEDU;
            super.addImpl(this.vScrollbar, null, 0);
        }
        if (this.SEDU == 2) {
            ++this.SEDU;
            super.addImpl(this.corner, null, 0);
        }
    }
}

