/*
 * Decompiled with CFR 0.152.
 */
package jet.client.api;

import guitools.toolkit.JDebug;
import java.io.IOException;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Properties;
import jet.JCliResource;
import jet.client.api.JRResponseException;
import jet.cs.CSUtil;
import jet.cs.CustomTaskManager;
import jet.cs.InvalidReportURLException;
import jet.net2.www.protocol.http.HttpURLConnection;

public class APIUtil {
    private APIUtil() {
    }

    public static int getResponseCode(URLConnection uRLConnection) throws IOException {
        if (uRLConnection instanceof java.net.HttpURLConnection) {
            return ((java.net.HttpURLConnection)uRLConnection).getResponseCode();
        }
        String string = uRLConnection.getHeaderField(0);
        try {
            int n = string.indexOf(32);
            while (string.charAt(n) == ' ') {
                ++n;
            }
            int n2 = Integer.parseInt(string.substring(n, n + 3));
            return n2;
        }
        catch (Exception exception) {
            JDebug.WARNING(exception);
            return -1;
        }
    }

    public static boolean isResponseOK(URLConnection uRLConnection) throws IOException {
        return APIUtil.getResponseCode(uRLConnection) == 200;
    }

    public static void checkResponseOK(URLConnection uRLConnection) throws IOException, JRResponseException {
        if (!APIUtil.isResponseOK(uRLConnection)) {
            throw new JRResponseException(uRLConnection);
        }
        String string = uRLConnection.getHeaderField("JRServlet");
        if (string == null || string.trim().length() == 0) {
            APIUtil.close(uRLConnection);
            throw new JRResponseException(800001);
        }
    }

    public static String getResponseMessage(URLConnection uRLConnection) {
        String string = uRLConnection.getHeaderField(0);
        try {
            int n = string.indexOf(32);
            while (string.charAt(n) == ' ') {
                ++n;
            }
            return string.substring(n + 4).trim();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getErrorMessage(URLConnection uRLConnection) {
        StringBuffer stringBuffer = new StringBuffer(uRLConnection.getHeaderField(0));
        stringBuffer.append("\nURL: " + uRLConnection.getURL().toString());
        stringBuffer.append("\n" + JCliResource.getMessage("CLI_ERR_1") + ": ");
        String string = APIUtil.getJRServerErrorMessage(uRLConnection);
        if (string != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String getJRServerErrorMessage(URLConnection uRLConnection) {
        String string = uRLConnection.getHeaderField("JRS-MESSAGE");
        if (string != null) {
            string = CSUtil.convertEscapes(string);
        }
        return string;
    }

    public static String addURLPath(String string, String string2) {
        return CSUtil.addURLPath(string, string2);
    }

    public static String[] getHostAndPath(String string) {
        return CSUtil.getHostAndPath(string);
    }

    public static String[] parseReportURL(String string) throws InvalidReportURLException {
        return CSUtil.parseReportURL(string);
    }

    public static String formatServerURL(String string) {
        return CSUtil.formatServerURL(string);
    }

    public static String escapeURLPath(String string) {
        return CSUtil.escapeURLPath(string);
    }

    public static String escapeURLPathWhenNeed(String string) {
        return CSUtil.escapeURLPathWhenNeed(string);
    }

    public static boolean needEscape(String string) {
        return CSUtil.needEscape(string);
    }

    public static String makeReportURL(String string, String string2, String string3) {
        return CSUtil.makeReportURL(string, string2, string3);
    }

    public static String getTaskID(Hashtable hashtable) {
        return hashtable == null ? null : (String)hashtable.get("jrs.task_id");
    }

    public static String getTaskClass(Hashtable hashtable) {
        return hashtable == null ? null : (String)hashtable.get("jrs.task_class");
    }

    public static String getTaskDisplayName(Hashtable hashtable) {
        String string = APIUtil.getTaskClass(hashtable);
        if (string != null) {
            try {
                string = CustomTaskManager.getDisplayName(string);
            }
            catch (Throwable throwable) {
                JDebug.WARNING(throwable);
            }
        }
        return string;
    }

    public static String makeQuery(Hashtable hashtable) {
        return CSUtil.makeNoHeadQuery(hashtable);
    }

    public static Properties parseQuery(String string) {
        return CSUtil.parseQuery(string);
    }

    public static void close(URLConnection uRLConnection) {
        try {
            if (uRLConnection instanceof HttpURLConnection) {
                uRLConnection.getInputStream().close();
            } else if (uRLConnection instanceof java.net.HttpURLConnection) {
                ((java.net.HttpURLConnection)uRLConnection).disconnect();
            }
        }
        catch (Throwable throwable) {
            JDebug.WARNING(throwable);
        }
    }
}

