/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbBinary;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbValue;

public class DbBinaryColumnBuffer
extends DbColumnBuffer {
    byte[][] I;

    public byte[][] getBuffer() {
        return this.I;
    }

    public DbBinaryColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.I = new byte[n][];
    }

    @Override
    public void updateCell(int n, DbValue dbValue) {
        this.I[n] = ((DbBinary)dbValue).get();
    }

    @Override
    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbBinary)dbValue).set(this.I[n]);
    }

    @Override
    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this.I.length; ++i) {
            dataOutput.write(this.I[i]);
        }
    }

    @Override
    protected void readValueFromFile(DataInput dataInput) throws IOException {
        for (int i = 0; i < this.I.length; ++i) {
            if (this.I[i].length == 0) {
                this.I[i] = new byte[this.C.precision];
            }
            dataInput.readFully(this.I[i]);
        }
    }

    @Override
    public void clearMem() {
        super.clearMem();
        this.I = null;
    }
}

