/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbDouble;
import jet.connect.DbReal;
import jet.connect.DbValue;

public class DbFloatColumnBuffer
extends DbColumnBuffer {
    float[] SEDU;

    public float[] getBuffer() {
        return this.SEDU;
    }

    public DbFloatColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.SEDU = new float[n];
    }

    @Override
    public void updateCell(int n, DbValue dbValue) {
        this.SEDU[n] = ((DbReal)dbValue).get();
    }

    @Override
    public void refreshFromCell(int n, DbValue dbValue) {
        if (dbValue instanceof DbReal) {
            ((DbReal)dbValue).set(this.SEDU[n]);
        } else {
            ((DbDouble)dbValue).set(this.SEDU[n]);
        }
    }

    @Override
    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this.SEDU.length; ++i) {
            dataOutput.writeFloat(this.SEDU[i]);
        }
    }

    @Override
    protected void readValueFromFile(DataInput dataInput) throws IOException {
        for (int i = 0; i < this.SEDU.length; ++i) {
            this.SEDU[i] = dataInput.readFloat();
        }
    }

    @Override
    public void clearMem() {
        super.clearMem();
        this.SEDU = null;
    }
}

