/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbSmallInt;
import jet.connect.DbValue;

public class DbShortColumnBuffer
extends DbColumnBuffer {
    short[] SEDU;

    public short[] getBuffer() {
        return this.SEDU;
    }

    public DbShortColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.SEDU = new short[n];
    }

    @Override
    public void updateCell(int n, DbValue dbValue) {
        this.SEDU[n] = ((DbSmallInt)dbValue).get();
    }

    @Override
    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbSmallInt)dbValue).set(this.SEDU[n]);
    }

    @Override
    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this.SEDU.length; ++i) {
            dataOutput.writeShort(this.SEDU[i]);
        }
    }

    @Override
    protected void readValueFromFile(DataInput dataInput) throws IOException {
        for (int i = 0; i < this.SEDU.length; ++i) {
            this.SEDU[i] = dataInput.readShort();
        }
    }

    @Override
    public void clearMem() {
        super.clearMem();
        this.SEDU = null;
    }
}

