/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import jet.connect.DbColDesc;
import jet.connect.DbDateTime;
import jet.datasource.JRHierarchicalDataset;

public class DbTime
extends DbDateTime {
    public DbTime() {
    }

    public DbTime(Time time) {
        this.value = time.getTime();
        this.bNull = false;
    }

    public DbTime(DbColDesc dbColDesc) {
        super(dbColDesc);
    }

    public Time getTime() {
        return new Time(this.value);
    }

    public void setTime(Time time) {
        this.value = time.getTime();
        this.bNull = false;
    }

    @Override
    public void set(ResultSet resultSet, int n) throws SQLException {
        Time time = resultSet.getTime(n);
        if (time != null) {
            this.value = time.getTime();
            this.bNull = resultSet.wasNull();
        } else {
            this.bNull = true;
        }
    }

    @Override
    public void set(JRHierarchicalDataset jRHierarchicalDataset, int n) throws SQLException {
        Time time = jRHierarchicalDataset.getTime(n);
        if (time != null) {
            this.value = time.getTime();
            this.bNull = jRHierarchicalDataset.wasNull();
        } else {
            this.bNull = true;
        }
    }

    @Override
    public String toString() {
        if (this.bNull) {
            return "NULL";
        }
        return this.getTime().toString();
    }

    @Override
    public Object clone() {
        DbTime dbTime = new DbTime(this.desc);
        dbTime.bNull = this.bNull;
        dbTime.value = this.value;
        return dbTime;
    }

    @Override
    public void setValue(String string) {
        this.value = Time.valueOf(string).getTime();
        this.bNull = false;
    }
}

