/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import jet.connect.DbColDesc;
import jet.connect.DbDateTime;
import jet.connect.DbValue;
import jet.datasource.JRHierarchicalDataset;

public class DbTimestamp
extends DbDateTime {
    public int nanos;

    public DbTimestamp() {
    }

    public DbTimestamp(Timestamp timestamp) {
        this.value = timestamp.getTime();
        this.nanos = timestamp.getNanos();
        this.J();
        this.bNull = false;
    }

    public DbTimestamp(DbColDesc dbColDesc) {
        super(dbColDesc);
    }

    public void setNanos(int n) {
        this.nanos = n;
    }

    public int getNanos() {
        return this.nanos;
    }

    @Override
    public Date toUtilDate() {
        Date date = new Date(this.value + (long)(this.nanos / 1000000));
        return date;
    }

    public void set(long l, int n) {
        this.value = l;
        this.nanos = n;
        this.bNull = false;
        this.J();
    }

    public Timestamp getTimestamp() {
        Timestamp timestamp = new Timestamp(this.value);
        timestamp.setNanos(this.nanos);
        return timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.set(timestamp);
    }

    public void set(Timestamp timestamp) {
        this.value = timestamp.getTime();
        this.nanos = timestamp.getNanos();
        this.bNull = false;
        this.J();
    }

    @Override
    public void set(ResultSet resultSet, int n) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(n);
        if (timestamp != null) {
            this.bNull = resultSet.wasNull();
            this.value = timestamp.getTime();
            this.nanos = timestamp.getNanos();
        } else {
            this.bNull = true;
        }
        this.J();
    }

    @Override
    public void set(JRHierarchicalDataset jRHierarchicalDataset, int n) throws SQLException {
        Timestamp timestamp = jRHierarchicalDataset.getTimestamp(n);
        if (timestamp != null) {
            this.bNull = jRHierarchicalDataset.wasNull();
            this.value = timestamp.getTime();
            this.nanos = timestamp.getNanos();
        } else {
            this.bNull = true;
        }
        this.J();
    }

    @Override
    public String toString() {
        if (this.bNull) {
            return "NULL";
        }
        return this.getTimestamp().toString();
    }

    @Override
    public Object clone() {
        DbTimestamp dbTimestamp = new DbTimestamp(this.desc);
        dbTimestamp.bNull = this.bNull;
        dbTimestamp.value = this.value;
        dbTimestamp.nanos = this.nanos;
        this.J();
        return dbTimestamp;
    }

    @Override
    public boolean equals(DbValue dbValue) {
        if (this == dbValue) {
            return true;
        }
        if (dbValue == null) {
            return false;
        }
        if (dbValue.bNull != this.bNull) {
            return false;
        }
        if (this.bNull) {
            return true;
        }
        if (dbValue instanceof DbTimestamp) {
            DbTimestamp dbTimestamp = (DbTimestamp)dbValue;
            return this.nanos == dbTimestamp.nanos && super.equals(dbValue);
        }
        return false;
    }

    @Override
    public int compareTo(DbValue dbValue) {
        DbTimestamp dbTimestamp = (DbTimestamp)dbValue;
        int n = super.compareTo(dbValue);
        if (n == 0 && !this.bNull) {
            if (this.nanos < dbTimestamp.nanos) {
                n = -1;
            } else if (this.nanos > dbTimestamp.nanos) {
                n = 1;
            }
        }
        return n;
    }

    @Override
    public void set(DbValue dbValue) {
        super.set(dbValue);
        this.nanos = !this.bNull && dbValue instanceof DbTimestamp ? ((DbTimestamp)dbValue).nanos : 0;
        this.J();
    }

    @Override
    public void setValue(String string) {
        Timestamp timestamp = Timestamp.valueOf(string);
        this.value = timestamp.getTime();
        this.nanos = timestamp.getNanos();
        this.bNull = false;
        this.J();
    }

    private void J() {
        if ((this.value - (long)(this.nanos / 1000000)) % 1000L == 0L) {
            this.value -= (long)(this.nanos / 1000000);
        }
    }

    @Override
    public String toFormatString(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        Timestamp timestamp = new Timestamp(this.value);
        timestamp.setNanos(this.nanos);
        String string2 = simpleDateFormat.format(timestamp);
        return string2;
    }

    @Override
    public String toStringValue() {
        byte[] byArray = null;
        if (this.isNull()) {
            byArray = new byte[1];
        } else {
            byArray = new byte[13];
            byArray[0] = 1;
            int n = 1;
            byArray[n++] = (byte)this.value;
            byArray[n++] = (byte)(this.value >> 8);
            byArray[n++] = (byte)(this.value >> 16);
            byArray[n++] = (byte)(this.value >> 24);
            byArray[n++] = (byte)(this.value >> 32);
            byArray[n++] = (byte)(this.value >> 40);
            byArray[n++] = (byte)(this.value >> 48);
            byArray[n++] = (byte)(this.value >> 56);
            byArray[n++] = (byte)this.nanos;
            byArray[n++] = (byte)(this.nanos >> 8);
            byArray[n++] = (byte)(this.nanos >> 16);
            byArray[n++] = (byte)(this.nanos >> 24);
        }
        return Base64.encode(byArray);
    }
}

