/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.dbbuffer;

import jet.connect.DbColDesc;
import jet.connect.Groupable;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JRecordModel;
import jet.dataengine.api.dbbuffer.RecordModelInfo;
import jet.dataengine.util.DSLog;
import jet.dataengine8.dbbuffer.RecordTool;

public class RecordModel
implements JRecordModel {
    private static String SEDU = "RecordModel";
    static DSLog append = DSLog.getDSLog(RecordModel.class.getName());
    private DbColDesc[] countColumns;
    private Groupable deIndent;

    public RecordModel(DbColDesc[] dbColDescArray) throws DSException {
        append.debug("begin create a RecordModel from a JRelationMetaData");
        append.debug("the JRelationMetaData is:");
        this.countColumns = dbColDescArray;
        append.debug("the dbColumns description is :");
        this.dump();
        append.debug("end create a RecordModel from a JRelationMetaData");
    }

    public RecordModel(RecordModelInfo recordModelInfo) {
        append.debug("begin create a RecordModel from a RecordModelInfo");
        this.countColumns = recordModelInfo.getColDescs();
        this.setGroupable(recordModelInfo.getGroupable());
        append.debug("the dbColumns description is :");
        this.dump();
        append.debug("end create a RecordModel from a RecordModelInfo");
    }

    @Override
    public DbColDesc getColDesc(int n) {
        return this.countColumns[n];
    }

    @Override
    public DbColDesc[] getColDescs() {
        return this.countColumns;
    }

    @Override
    public int indexOfCell(String string) {
        for (int i = 0; i < this.countColumns.length; ++i) {
            String string2 = this.countColumns[i].getColName();
            if (string2 == null && string == null) {
                return 0;
            }
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            return i;
        }
        append.warn(6102, new Object[]{string});
        append.debug("Current RecordModel Column is:");
        this.dump();
        return -1;
    }

    @Override
    public Groupable getGroupable() {
        return this.deIndent;
    }

    @Override
    public void setGroupable(Groupable groupable) {
        this.deIndent = groupable;
    }

    @Override
    public int getFetchTime() {
        return 0;
    }

    @Override
    public int getRecordSize() {
        return RecordTool.getRecordLen(this.countColumns);
    }

    @Override
    public int countColumns() {
        return this.countColumns.length;
    }

    public void dump() {
        append.indent(SEDU);
        append.debug("Begin RecordModel");
        append.debug("the Column count = " + this.countColumns());
        int n = this.countColumns();
        for (int i = 0; i < n; ++i) {
            append.debug(this.countColumns[i].toString());
        }
        append.deIndent(SEDU);
        append.debug("End RecordModel");
    }

    @Override
    public void dump(int n) {
        this.dump();
    }
}

