/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import jet.JRStopEngineException;
import jet.datastream.CommNode;
import jet.datastream.Communicator;
import jet.datastream.DSPage;
import jet.security.PageACL;
import jet.util.IntVector;
import jet.util.TreeIterater;

public class CommEnumeration
implements Enumeration {
    int SEDU;
    int addElement;
    int addValueForMembers = 1;
    Communicator append;
    Communicator arraycopy;
    TreeIterater containsKey;
    private boolean error = false;
    private Hashtable get;
    private int getAllElements = 0;
    private boolean getComm = false;
    private IntVector getPLSTable;

    public CommEnumeration(Communicator communicator, boolean bl) {
        this.arraycopy = communicator;
        this.setNewPLS(bl);
        this.containsKey = new TreeIterater(new CommNode(communicator), false, false);
        this.SEDU(communicator);
    }

    public CommEnumeration(Communicator communicator) {
        this.arraycopy = communicator;
        this.containsKey = new TreeIterater(new CommNode(communicator), false, false);
        this.SEDU(communicator);
    }

    private void SEDU(Communicator communicator) {
        this.append = communicator;
        this.SEDU = 1;
        this.addElement = communicator.getPageNum();
        if (this.error) {
            PageACL pageACL = communicator.getPageACL();
            if (null != pageACL) {
                Hashtable hashtable = pageACL.getPLSTable();
                if (this.getComm) {
                    this.mergePLSTable(this.get, hashtable, this.getAllElements);
                } else {
                    if (null == this.getPLSTable) {
                        this.mergePLSTable(this.get, hashtable, this.getAllElements);
                    } else {
                        this.mergePLSTable(this.get, this.getPLSTable, hashtable, this.getAllElements);
                        this.getPLSTable = null;
                    }
                    this.getComm = true;
                }
            } else if (this.getComm) {
                this.mergePLSTable(this.get, this.addElement, this.getAllElements);
            } else {
                this.mergeTotalCountTolastComm(this.getPLSTable, this.addElement, this.getAllElements);
            }
            this.getAllElements += this.addElement;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "in initComm of CommEnumeration, total page Number is: " + this.addElement);
        }
    }

    public void mergePLSTable(Hashtable hashtable, Hashtable hashtable2, int n) {
        if (null == hashtable) {
            hashtable = new Hashtable();
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            int[] nArray = (int[])hashtable2.get(k);
            if (0 != n) {
                this.addValueForMembers(nArray, n);
            }
            if (hashtable.containsKey(k)) {
                int[] nArray2 = (int[])hashtable.get(k);
                int[] nArray3 = this.mergeIntArray(nArray2, nArray);
                hashtable.remove(k);
                hashtable.put(k, nArray3);
                continue;
            }
            hashtable.put(k, nArray);
        }
    }

    public int[] mergeIntArray(int[] nArray, int[] nArray2) {
        int n = nArray.length + nArray2.length;
        int[] nArray3 = new int[n];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    public void addValueForMembers(int[] nArray, int n) {
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3++;
            nArray[n4] = nArray[n4] + n;
        }
    }

    public void mergeTotalCountTolastComm(IntVector intVector, int n, int n2) {
        if (null == intVector) {
            intVector = new IntVector();
        }
        for (int i = 1; i <= n; ++i) {
            intVector.addElement(n2 + i);
        }
    }

    public void mergePLSTable(Hashtable hashtable, int n, int n2) {
        int[] nArray = new int[n];
        for (int i = 1; i <= n; ++i) {
            nArray[i] = n2 + i;
        }
        Enumeration enumeration = hashtable.keys();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            int[] nArray2 = (int[])hashtable.get(k);
            int[] nArray3 = this.mergeIntArray(nArray2, nArray);
            hashtable.remove(k);
            hashtable.put(k, nArray3);
        }
    }

    public void mergePLSTable(Hashtable hashtable, IntVector intVector, Hashtable hashtable2, int n) {
        Enumeration enumeration = hashtable2.keys();
        int n2 = intVector.size();
        int[] nArray = intVector.getAllElements();
        if (null == hashtable) {
            hashtable = new Hashtable();
        }
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            int[] nArray2 = (int[])hashtable2.get(k);
            this.addValueForMembers(nArray2, n);
            int[] nArray3 = this.mergeIntArray(nArray, nArray2);
            hashtable.put(k, nArray3);
        }
    }

    public Hashtable getPLSMapTab() {
        return this.get;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.SEDU > this.addElement) {
            CommNode commNode = (CommNode)this.containsKey.next();
            if (commNode != null) {
                this.SEDU(commNode.getComm());
            } else {
                return false;
            }
        }
        return true;
    }

    public Object nextElement() throws NoSuchElementException {
        if (this.SEDU > this.addElement && !this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        DSPage dSPage = null;
        try {
            dSPage = this.append.getPage(this.SEDU++);
        }
        catch (JRStopEngineException jRStopEngineException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, jRStopEngineException);
            }
            throw new NoSuchElementException("The task has been cancelled.");
        }
        return dSPage;
    }

    public Communicator getCurrentCommunicator() {
        return this.append;
    }

    public boolean isNewPLS() {
        return this.error;
    }

    public void setNewPLS(boolean bl) {
        this.error = bl;
    }
}

