/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import chart.graphics.ChartFillPattern;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.DSBody;
import jet.datastream.DSChartPlatform;
import jet.datastream.DSContainer;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSField;
import jet.datastream.JRObjectResult;
import jet.datastream.JetChartPropertyValues;
import jet.rptengine.RecordWithoutBuffer;
import jet.thinviewer.JReportField;
import jet.util.JFieldValueNLSManager;

public class DSChartHeatMapGroupRect
extends DSContainer {
    private Record I = null;
    private String SEDU = "";
    private double UTFLength = -1.0;
    private Color add = null;
    private boolean booleanValue = false;
    private String convertUnitToPixel = "";
    private double dup = -1.0;
    private DbValue equals = null;
    private Vector fill = null;
    private Vector get = null;
    private String getChildren = "";
    private Vector getCommunicator = new Vector();
    private Record getDataStream = null;
    private String getGraphics = "";
    JFieldValueNLSManager getGroupDbValueList = null;
    private String getGroupNameList = "";

    public void paintForImage(Graphics graphics) {
        BufferedImage bufferedImage = null;
        Graphics2D graphics2D = null;
        int n = Unit.convertUnitToPixel(((DSContainer)this.getParent()).getX() + this.getX());
        int n2 = Unit.convertUnitToPixel(((DSContainer)this.getParent()).getY() + this.getY());
        int n3 = Unit.convertUnitToPixel(this.getWidth());
        int n4 = Unit.convertUnitToPixel(this.getHeight());
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        try {
            graphics2D = (Graphics2D)graphics;
        }
        catch (ClassCastException classCastException) {
            bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 6);
            graphics2D = (Graphics2D)bufferedImage.getGraphics();
        }
        ChartFillPattern chartFillPattern = JetChartPropertyValues.mapFillPattern(this.getChildren);
        chartFillPattern.fill(graphics2D, rectangle);
        int n5 = this.getChildren().size();
        for (int i = 0; i < n5; ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)this.getChildren().get(i);
            if (jRObjectResult instanceof DSChartHeatMapGroupRect) {
                ((DSChartHeatMapGroupRect)jRObjectResult).paintForImage(graphics);
                continue;
            }
            if (!(jRObjectResult instanceof DSField)) continue;
            JReportField jReportField = new JReportField();
            jReportField.setProperty(jRObjectResult);
            jReportField.paint(graphics2D);
        }
    }

    @Override
    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        int n;
        super.readProperties(dataInput, dSDataStreamable);
        this.SEDU = dataInput.readUTF();
        this.getChildren = dataInput.readUTF();
        int n2 = dataInput.readInt();
        if (n2 > 0) {
            this.fill = new Vector();
            for (n = 0; n < n2; ++n) {
                this.fill.add(dataInput.readUTF());
            }
        }
        if ((n = dataInput.readInt()) > 0) {
            this.getCommunicator = new Vector();
            for (int i = 0; i < n; ++i) {
                this.getCommunicator.add(dataInput.readBoolean());
            }
        }
    }

    @Override
    protected void writeProperties(DataOutput dataOutput) throws IOException {
        int n;
        int n2;
        super.writeProperties(dataOutput);
        dataOutput.writeUTF(this.SEDU);
        dataOutput.writeUTF(this.getChildren);
        if (this.fill != null && this.fill.size() > 0) {
            n2 = this.fill.size();
            dataOutput.writeInt(n2);
            for (n = 0; n < n2; ++n) {
                dataOutput.writeUTF((String)this.fill.get(n));
            }
        } else {
            dataOutput.writeInt(0);
        }
        if (this.getCommunicator != null && this.getCommunicator.size() > 0) {
            n2 = this.getCommunicator.size();
            dataOutput.writeInt(n2);
            for (n = 0; n < n2; ++n) {
                dataOutput.writeBoolean((Boolean)this.getCommunicator.get(n));
            }
        } else {
            dataOutput.writeInt(0);
        }
    }

    @Override
    protected int propLength() {
        int n;
        int n2;
        int n3 = super.propLength();
        n3 = n3 + 2 + DSChartHeatMapGroupRect.UTFLength(this.SEDU);
        n3 = n3 + 2 + DSChartHeatMapGroupRect.UTFLength(this.getChildren);
        if (this.fill != null && this.fill.size() > 0) {
            n2 = this.fill.size();
            n3 += 4;
            for (n = 0; n < n2; ++n) {
                n3 = n3 + 2 + DSChartHeatMapGroupRect.UTFLength((String)this.fill.get(n));
            }
        } else {
            n3 += 4;
        }
        if (this.getCommunicator != null && this.getCommunicator.size() > 0) {
            n2 = this.getCommunicator.size();
            n3 += 4;
            for (n = 0; n < n2; ++n) {
                ++n3;
            }
        } else {
            n3 += 4;
        }
        return n3;
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSChartHeatMapGroupRect());
    }

    public DSChartHeatMapGroupRect dup(DSChartHeatMapGroupRect dSChartHeatMapGroupRect) {
        super.dup(dSChartHeatMapGroupRect);
        dSChartHeatMapGroupRect.SEDU = this.SEDU;
        dSChartHeatMapGroupRect.UTFLength = this.UTFLength;
        dSChartHeatMapGroupRect.getChildren = this.getChildren;
        dSChartHeatMapGroupRect.booleanValue = this.booleanValue;
        dSChartHeatMapGroupRect.convertUnitToPixel = this.convertUnitToPixel;
        dSChartHeatMapGroupRect.dup = this.dup;
        dSChartHeatMapGroupRect.equals = this.equals;
        dSChartHeatMapGroupRect.fill = this.fill;
        return dSChartHeatMapGroupRect;
    }

    public void setSumValue(double d) {
        this.UTFLength = d;
        this.booleanValue = true;
    }

    public double getGroupSum() {
        if (this.booleanValue) {
            return this.UTFLength;
        }
        this.UTFLength = 0.0;
        int n = this.getChildren().size();
        for (int i = 0; i < n; ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)this.getChildren().get(i);
            if (!(jRObjectResult instanceof DSChartHeatMapGroupRect)) continue;
            this.UTFLength += ((DSChartHeatMapGroupRect)jRObjectResult).getGroupSum();
        }
        this.booleanValue = true;
        return this.UTFLength;
    }

    public void setBackground(Color color) {
        this.add = color;
    }

    public void setBackgroundForFillPattern(String string) {
        this.getChildren = string;
    }

    public void setGroupName(String string) {
        this.convertUnitToPixel = string;
    }

    public Vector getGroupNameList() {
        Vector vector = new Vector();
        if (this.getParent() instanceof DSChartHeatMapGroupRect) {
            vector = ((DSChartHeatMapGroupRect)this.getParent()).getGroupNameList();
            vector.add(this.convertUnitToPixel);
        } else {
            vector.add(this.convertUnitToPixel);
        }
        return vector;
    }

    public String getGroupName() {
        return this.convertUnitToPixel;
    }

    public double getColorSum() {
        return this.dup;
    }

    public void setColorSum(double d) {
        this.dup = d;
    }

    public Color getBackgroupColor() {
        return this.add;
    }

    public String getBackgroupStringColor() {
        return this.getChildren;
    }

    public ChartFillPattern getBackgroupFillPattern() {
        if (this.getChildren.equals("")) {
            return null;
        }
        return JetChartPropertyValues.mapFillPattern(this.getChildren);
    }

    public void setGroupDbValue(DbValue dbValue) {
        this.equals = dbValue;
    }

    public DbValue getGroupDbValue() {
        return this.equals;
    }

    public void setOtherValue(Vector vector) {
        this.get = vector;
    }

    public Vector getOtherValue() {
        return this.get;
    }

    public Vector getGroupDbValueList() {
        Vector vector = new Vector();
        if (this.getParent() instanceof DSChartHeatMapGroupRect) {
            vector = ((DSChartHeatMapGroupRect)this.getParent()).getGroupDbValueList();
            vector.add(this.equals);
            if (this.get != null && this.get.size() > 0) {
                for (int i = 0; i < this.get.size(); ++i) {
                    vector.add(this.get.get(i));
                }
            }
        } else {
            if (this.get != null && this.get.size() > 0) {
                for (int i = 0; i < this.get.size(); ++i) {
                    vector.add(this.get.get(i));
                }
            }
            vector.add(this.equals);
        }
        return vector;
    }

    public Vector getIsDrawBroderList() {
        if (this.getCommunicator == null) {
            this.getCommunicator = new Vector();
        }
        if (this.getCommunicator.size() == 0) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            this.getCommunicator.add(bl);
            this.getCommunicator.add(bl2);
            this.getCommunicator.add(bl3);
            this.getCommunicator.add(bl4);
        }
        return this.getCommunicator;
    }

    @Override
    public Record getSynRecord() {
        Hashtable hashtable;
        if (this.I == null && (hashtable = this.S) != null && hashtable.size() != 0) {
            this.I = new RecordWithoutBuffer(hashtable);
        }
        return this.I;
    }

    @Override
    public Record getSynRecord2() {
        return this.getSynRecord();
    }

    @Override
    public JRecord getRecord() {
        return (JRecord)this.getSynRecord();
    }

    public void setHintValueList(Vector vector) {
        this.fill = vector;
    }

    public Vector getHintValueList() {
        return this.fill;
    }

    @Override
    public void dealDefaultBounds() {
    }

    public void setIsDrawBroderList(Vector vector) {
        this.getCommunicator = vector;
    }

    @Override
    public int getResolution() {
        JRObjectResult jRObjectResult = this.I(this);
        if (jRObjectResult != null) {
            if (jRObjectResult instanceof DSChartPlatform) {
                int n = jRObjectResult.getResolution();
                return n;
            }
            if (jRObjectResult.getObjectType() == 262177) {
                return ((DSBody)jRObjectResult).getDataStream().getCommunicator().getResolution();
            }
        }
        return Unit.getResolution();
    }

    private JRObjectResult I(JRObjectResult jRObjectResult) {
        while (jRObjectResult != null) {
            if (jRObjectResult.getObjectType() == 262177) {
                return jRObjectResult;
            }
            if (jRObjectResult instanceof DSChartPlatform) {
                return jRObjectResult;
            }
            if (!(jRObjectResult instanceof JRObjectResult)) {
                return null;
            }
            jRObjectResult = (JRObjectResult)((Object)jRObjectResult.getParent());
        }
        return jRObjectResult;
    }

    public void setUsedRecord(JRecord jRecord) {
        this.getDataStream = jRecord;
    }

    public Record getUsedRecord() {
        return this.getDataStream;
    }

    public String getDisplayGroupName() {
        return this.getGraphics;
    }

    public void setDisplayGroupName(String string) {
        this.getGraphics = string;
    }

    public void setCatalogNLSManager(JFieldValueNLSManager jFieldValueNLSManager) {
        this.getGroupDbValueList = jFieldValueNLSManager;
    }

    public void setCatalogPrefix(String string) {
        this.getGroupNameList = string;
    }

    public JFieldValueNLSManager getCatalogNLSManager() {
        return this.getGroupDbValueList;
    }

    public String getNLSPrefix() {
        return this.getGroupNameList;
    }
}

