/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import chart.ChartDefinition;
import chart.ChartPropertyValues;
import chart.data.ChartDataFilter;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartTextStyle;
import chart.graphics.ChartTexturePattern;
import com.jinfonet.util.JRLog;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.util.MiscTools;

public class JetChartPropertyValues
extends ChartPropertyValues {
    private static final String I = "" + (char)("\u0007".charAt(0) + '\u0001');
    public static final String AXIS_PREFIX = "Axis";
    public static final String WALL_PREFIX = "Wall";
    public static final String BACKGROUND_PREFIX = "Background";
    public static final String TEXTSTYLE_PREFIX = "Text";
    public static final String PENSTYLE_PREFIX = "Pen";
    public static final String FILLPATTERN_PREFIX = "Pattern";

    public static String getFontSpecialEffect1String(ChartTextStyle chartTextStyle) {
        String string = null;
        string = chartTextStyle.isEmbossed() ? "Embossed" : (chartTextStyle.isEngraved() ? "Engraved" : (chartTextStyle.isOutlined() && chartTextStyle.isShadowed() ? "Shadowed & Outlined" : (chartTextStyle.isOutlined() ? "Outlined" : (chartTextStyle.isShadowed() ? "Shadowed" : "None"))));
        return string;
    }

    public static String getFontSpecialEffect2String(ChartTextStyle chartTextStyle) {
        String string = null;
        string = chartTextStyle.isSuperscript() ? "Superscript" : (chartTextStyle.isSubscript() ? "Subscript" : "None");
        return string;
    }

    public static void setFontSpecialEffect1(ChartTextStyle chartTextStyle, int n) {
        switch (n) {
            case 1: {
                chartTextStyle.toggleEmbossed();
                break;
            }
            case 2: {
                chartTextStyle.toggleEngraved();
                break;
            }
            case 3: {
                chartTextStyle.toggleShadowed();
                break;
            }
            case 4: {
                chartTextStyle.toggleOutlined();
                break;
            }
            case 5: {
                chartTextStyle.toggleShadowed();
                chartTextStyle.toggleOutlined();
            }
        }
    }

    public static void setFontSpecialEffect2(ChartTextStyle chartTextStyle, int n) {
        switch (n) {
            case 1: {
                chartTextStyle.toggleSuperscript();
                break;
            }
            case 2: {
                chartTextStyle.toggleSubscript();
            }
        }
    }

    public static ChartFillPattern mapFillPattern(String string) {
        ChartFillPattern chartFillPattern = null;
        float f = 0.0f;
        switch (string.charAt(0)) {
            case 'C': 
            case 'c': {
                try {
                    String string2 = string.substring(1, 9);
                    Color color = !string2.equals("No_Color") ? MiscTools.mapStringToColor(string2) : null;
                    chartFillPattern = new ChartColorPattern(color);
                    String string3 = string.substring(9);
                    f = (float)Integer.parseInt(string3) / 100.0f;
                    chartFillPattern.setAlpha(f);
                }
                catch (Exception exception) {
                    if (JRLog.isError(3)) {
                        String string4 = string.length() >= 2 ? string.substring(1) : string;
                        JRLog.error(3, "Chart format color error, Can not format string '" + string4 + "' to color. Get default color: black.");
                    }
                    chartFillPattern = new ChartColorPattern(Color.black);
                }
                break;
            }
            case 'T': 
            case 't': {
                Color color;
                String string5;
                Color color2;
                String string6 = string.charAt(1) != '0' ? string.substring(1, 3) : string.substring(1, 3);
                int n = Integer.parseInt(string6);
                String string7 = string.substring(3, 11);
                try {
                    color2 = !string7.equals("No_Color") ? MiscTools.mapStringToColor(string7) : null;
                }
                catch (Exception exception) {
                    if (JRLog.isError(3)) {
                        string5 = string7.length() >= 2 ? string7.substring(1) : string7;
                        JRLog.error(3, "Chart format color error, Can not format string '" + string5 + "' to color. set this color to null.");
                    }
                    color2 = null;
                }
                String string8 = string.substring(11, 19);
                try {
                    color = !string8.equals("No_Color") ? MiscTools.mapStringToColor(string8) : null;
                }
                catch (Exception exception) {
                    if (JRLog.isError(3)) {
                        string5 = string8.length() >= 2 ? string8.substring(1) : string8;
                        JRLog.error(3, "Chart format color error, Can not format string '" + string5 + "' to color. set this color to null.");
                    }
                    color = null;
                }
                chartFillPattern = new ChartTexturePattern(n, new ChartColorPattern(color2), new ChartColorPattern(color));
                String string9 = string.substring(19);
                f = (float)Integer.parseInt(string9) / 100.0f;
                ((ChartTexturePattern)chartFillPattern).setAlpha(f);
                break;
            }
            case 'G': 
            case 'g': {
                Color color;
                String string10;
                Color color3;
                String string11 = string.substring(1, 3);
                int n = Integer.parseInt(string11);
                String string12 = string.substring(3, 11);
                try {
                    color3 = !string12.equals("No_Color") ? MiscTools.mapStringToColor(string12) : null;
                }
                catch (Exception exception) {
                    if (JRLog.isError(3)) {
                        string10 = string12.length() >= 2 ? string12.substring(1) : string12;
                        JRLog.error(3, "Chart format color error, Can not format string '" + string10 + "' to color. set this color to null.");
                    }
                    color3 = null;
                }
                String string13 = string.substring(11, 19);
                try {
                    color = !string13.equals("No_Color") ? MiscTools.mapStringToColor(string13) : null;
                }
                catch (Exception exception) {
                    if (JRLog.isError(3)) {
                        string10 = string13.length() >= 2 ? string13.substring(1) : string13;
                        JRLog.error(3, "Chart format color error, Can not format string '" + string10 + "' to color. set this color to null.");
                    }
                    color = null;
                }
                String string14 = string.substring(19, 22);
                float f2 = (float)Integer.parseInt(string14) / 100.0f;
                String string15 = string.substring(22, 25);
                float f3 = 1.0f - (float)Integer.parseInt(string15) / 100.0f;
                String string16 = string.substring(25, 28);
                float f4 = (float)Integer.parseInt(string16) / 100.0f;
                String string17 = string.substring(28, 31);
                float f5 = 1.0f - (float)Integer.parseInt(string17) / 100.0f;
                String string18 = string.substring(31);
                chartFillPattern = new ChartGradientPattern(n);
                ((ChartGradientPattern)chartFillPattern).setStartColor(new ChartColorPattern(color3));
                ((ChartGradientPattern)chartFillPattern).setEndColor(new ChartColorPattern(color));
                ((ChartGradientPattern)chartFillPattern).setStartPoint(new Point2D.Float(f2, f3));
                ((ChartGradientPattern)chartFillPattern).setEndPoint(new Point2D.Float(f4, f5));
                f = (float)Integer.parseInt(string18) / 100.0f;
                ((ChartGradientPattern)chartFillPattern).setAlpha(f);
                break;
            }
            case 'N': 
            case 'n': {
                chartFillPattern = null;
            }
        }
        return chartFillPattern;
    }

    public static String mapPatternString(ChartFillPattern chartFillPattern) {
        String string;
        Object object;
        String string2 = "";
        if (chartFillPattern == null) {
            string2 = string2 + "n";
        } else if (chartFillPattern instanceof ChartColorPattern) {
            string2 = string2 + "c";
            Color color = ((ChartColorPattern)chartFillPattern).getColor();
            string2 = color != null ? string2 + MiscTools.mapColorToString(color) : string2 + "No_Color";
        } else if (chartFillPattern instanceof ChartTexturePattern) {
            string2 = string2 + "t";
            object = (ChartTexturePattern)chartFillPattern;
            int n = ((ChartTexturePattern)object).getPattern();
            string = "";
            if (n < 10) {
                string = "0";
            }
            string = string + String.valueOf((Object)n);
            Color color = ((ChartTexturePattern)object).getForeground().getColor();
            String string3 = color != null ? MiscTools.mapColorToString(color) : "No_Color";
            Color color2 = ((ChartTexturePattern)object).getBackground().getColor();
            String string4 = color2 != null ? MiscTools.mapColorToString(color2) : "No_Color";
            string2 = string2 + string + string3 + string4;
        } else if (chartFillPattern instanceof ChartGradientPattern) {
            string2 = string2 + "g";
            object = (ChartGradientPattern)chartFillPattern;
            int n = ((ChartGradientPattern)object).getPattern();
            string = "";
            if (n < 10) {
                string = "0";
            }
            string = string + String.valueOf((Object)n);
            Color color = ((ChartGradientPattern)object).getStartColor().getColor();
            String string5 = color != null ? MiscTools.mapColorToString(color) : "No_Color";
            Color color3 = ((ChartGradientPattern)object).getEndColor().getColor();
            String string6 = color3 != null ? MiscTools.mapColorToString(color3) : "No_Color";
            int n2 = (int)(((ChartGradientPattern)object).getStartPoint().getX() * 100.0);
            int n3 = (int)((1.0 - ((ChartGradientPattern)object).getStartPoint().getY()) * 100.0);
            int n4 = (int)(((ChartGradientPattern)object).getEndPoint().getX() * 100.0);
            int n5 = (int)((1.0 - ((ChartGradientPattern)object).getEndPoint().getY()) * 100.0);
            String string7 = "";
            if (n2 < 10) {
                string7 = "00";
            } else if (n2 < 100) {
                string7 = "0";
            }
            string7 = string7 + String.valueOf((Object)n2);
            String string8 = "";
            if (n4 < 10) {
                string8 = "00";
            } else if (n4 < 100) {
                string8 = "0";
            }
            string8 = string8 + String.valueOf((Object)n4);
            String string9 = "";
            if (n3 < 10) {
                string9 = "00";
            } else if (n3 < 100) {
                string9 = "0";
            }
            string9 = string9 + String.valueOf((Object)n3);
            String string10 = "";
            if (n5 < 10) {
                string10 = "00";
            } else if (n5 < 100) {
                string10 = "0";
            }
            string10 = string10 + String.valueOf((Object)n5);
            string2 = string2 + string + string5 + string6 + string7 + string9 + string8 + string10;
        }
        if (chartFillPattern != null) {
            object = "";
            int n = (int)(chartFillPattern.getAlpha() * 100.0f);
            if (n < 10) {
                object = "00";
            } else if (n < 100) {
                object = "0";
            }
            object = (String)object + String.valueOf((Object)n);
            string2 = string2 + (String)object;
        }
        return string2;
    }

    public static ChartFillPattern[] mapPatterns(Vector vector) {
        ChartFillPattern[] chartFillPatternArray = null;
        if (vector != null) {
            int n = vector.size();
            chartFillPatternArray = new ChartFillPattern[n];
            for (int i = 0; i < n; ++i) {
                chartFillPatternArray[i] = JetChartPropertyValues.mapFillPattern((String)vector.get(i));
            }
        }
        return chartFillPatternArray;
    }

    public static ChartFillPattern[] mapPatterns(String string) {
        StringTokenizer stringTokenizer;
        int n;
        ChartFillPattern[] chartFillPatternArray = null;
        if (string != null && (n = (stringTokenizer = new StringTokenizer(string, "\u0007")).countTokens()) > 0) {
            chartFillPatternArray = new ChartFillPattern[n];
            for (int i = 0; i < n; ++i) {
                String string2 = stringTokenizer.nextToken();
                chartFillPatternArray[i] = JetChartPropertyValues.mapFillPattern(string2);
            }
        }
        return chartFillPatternArray;
    }

    public static String mapPatternList(ChartFillPattern[] chartFillPatternArray) {
        String string = "";
        if (chartFillPatternArray != null) {
            for (int i = 0; i < chartFillPatternArray.length; ++i) {
                if (i != 0) {
                    string = string + "\u0007";
                }
                string = string + JetChartPropertyValues.mapPatternString(chartFillPatternArray[i]);
            }
        }
        return string;
    }

    public static ChartDataFilter mapChartDataFilter(Vector vector) {
        ChartDataFilter chartDataFilter = null;
        if (vector != null && vector.size() > 0) {
            int n = vector.size();
            chartDataFilter = new ChartDataFilter();
            Vector<Object[]> vector2 = new Vector<Object[]>();
            for (int i = 0; i < n; ++i) {
                String string = (String)vector.get(i);
                Object[] objectArray = new Object[]{Integer.parseInt(string.substring(0, 1)), string.substring(1)};
                vector2.add(objectArray);
            }
            chartDataFilter.setFilters(vector2);
        }
        return chartDataFilter;
    }

    public static Vector mapChartDataFilterToVector(ChartDataFilter chartDataFilter) {
        Vector vector = null;
        Vector<String> vector2 = new Vector<String>();
        vector = (Vector)chartDataFilter.getFilters();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string = ((Object[])vector.get(i))[0].toString() + ((Object[])vector.get(i))[1];
            vector2.add(string);
        }
        return vector2;
    }

    public static ChartDataFilter mapChartDataFilter(String string) {
        StringTokenizer stringTokenizer;
        int n;
        ChartDataFilter chartDataFilter = null;
        if (string != null && (n = (stringTokenizer = new StringTokenizer(string, "\u0007")).countTokens()) > 0) {
            chartDataFilter = new ChartDataFilter();
            Vector<Object[]> vector = new Vector<Object[]>();
            for (int i = 0; i < n; ++i) {
                String string2 = stringTokenizer.nextToken();
                Object[] objectArray = new Object[]{Integer.parseInt(string2.substring(0, 1)), string2.substring(1)};
                vector.add(objectArray);
            }
            chartDataFilter.setFilters(vector);
        }
        return chartDataFilter;
    }

    public static String mapFilterString(ChartDataFilter chartDataFilter) {
        String string = "";
        if (chartDataFilter != null) {
            for (int i = 0; i < chartDataFilter.getFilters().size(); ++i) {
                if (i != 0) {
                    string = string + "\u0007";
                }
                Object[] objectArray = (Object[])chartDataFilter.getFilters().get(i);
                string = string + objectArray[0].toString() + objectArray[1].toString();
            }
        }
        return string;
    }

    public static ChartDataFilter[] mapChartDataFilters(String string) {
        StringTokenizer stringTokenizer;
        int n;
        ChartDataFilter[] chartDataFilterArray = null;
        if (string != null && (n = (stringTokenizer = new StringTokenizer(string, I)).countTokens()) > 0) {
            chartDataFilterArray = new ChartDataFilter[n];
            for (int i = 0; i < n; ++i) {
                String string2 = stringTokenizer.nextToken();
                chartDataFilterArray[i] = JetChartPropertyValues.mapChartDataFilter(string2);
            }
        }
        return chartDataFilterArray;
    }

    public static String mapChartDataFilterList(ChartDataFilter[] chartDataFilterArray) {
        String string = "";
        if (chartDataFilterArray != null) {
            for (int i = 0; i < chartDataFilterArray.length; ++i) {
                if (i != 0) {
                    string = string + I;
                }
                JetChartPropertyValues.mapFilterString(chartDataFilterArray[i]);
            }
        }
        return string;
    }

    public static int[] mapIconStyles(String string) {
        int n = string.length() / 2;
        int[] nArray = null;
        if (n > 0) {
            nArray = new int[n];
        }
        for (int i = 0; i < n; ++i) {
            String string2 = string.substring(i * 2, i * 2 + 2);
            nArray[i] = Integer.parseInt(string2);
        }
        return nArray;
    }

    public static String mapIconStyleList(int[] nArray) {
        String string = "";
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] < 10) {
                    string = string + "0";
                }
                string = string + nArray[i];
            }
        }
        return string;
    }

    public static int[] mapValueLabelPositions(String string) {
        int[] nArray = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0007");
            int n = stringTokenizer.countTokens();
            nArray = new int[n];
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    nArray[i] = (Integer)VALUELABEL_POSITION_ENUMERATIONS.get(stringTokenizer.nextToken());
                }
            }
        }
        return nArray;
    }

    public static String mapValueLabelPositionList(int[] nArray) {
        String string = "";
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (i != 0) {
                    string = string + "\u0007";
                }
                string = string + VALUELABEL_POSITION_INTEGERS.get(nArray[i]);
            }
        }
        return string;
    }

    public static String getDefaultPatternString() {
        ChartFillPattern[] chartFillPatternArray = new ChartFillPattern[COLORLENGTH];
        for (int i = 0; i < COLORLENGTH; ++i) {
            chartFillPatternArray[i] = new ChartColorPattern(new Color(ChartPropertyValues.DEFAULTCOLORS[i]));
        }
        return JetChartPropertyValues.mapPatternList(chartFillPatternArray);
    }

    public static String getDefaultAreaPatternString() {
        ChartFillPattern[] chartFillPatternArray = new ChartFillPattern[COLORLENGTH];
        for (int i = 0; i < COLORLENGTH; ++i) {
            chartFillPatternArray[i] = new ChartColorPattern(new Color(ChartPropertyValues.DEFAULTCOLORS[i]));
            chartFillPatternArray[i].setAlpha(100.0f);
        }
        return JetChartPropertyValues.mapPatternList(chartFillPatternArray);
    }

    public static void addFilter(ChartDataFilter chartDataFilter, int n, int n2) {
        String string = "";
        if (n > 0 && n2 > 0) {
            if (chartDataFilter == null) {
                chartDataFilter = new ChartDataFilter();
            }
            for (int i = 0; i < n; ++i) {
                if (i == n2) {
                    string = string + ".";
                }
                string = string + "#";
            }
        }
        JetChartPropertyValues.addFilter(chartDataFilter, 1, JetChartPropertyValues.COLORLENGTH(string));
    }

    private static String COLORLENGTH(String string) {
        int n = string.indexOf(".");
        String string2 = "";
        String string3 = "";
        if (n == -1) {
            string2 = string;
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n, string.length());
        }
        String string4 = "";
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            if (i % 3 == 0 && i != 0) {
                string4 = string4 + ",";
            }
            string4 = string4 + "#";
        }
        char[] cArray = string4.toCharArray();
        n2 = string4.length();
        char[] cArray2 = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray2[i] = cArray[n2 - 1 - i];
        }
        return new String(cArray2) + string3;
    }

    public static String getDefaultLineSyleList() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 15; ++i) {
            stringBuffer.append("1").append(",");
            stringBuffer.append(0).append(",");
            stringBuffer.append("180").append(";");
        }
        stringBuffer.append("1").append(",");
        stringBuffer.append(0).append(",");
        stringBuffer.append("180");
        return stringBuffer.toString();
    }

    public static String getDefaultQualitativeRangesColorListString(String string) {
        if (string == null) {
            return null;
        }
        int n = JetChartPropertyValues.DEFAULTCOLORS(string, 0);
        ChartFillPattern[] chartFillPatternArray = new ChartFillPattern[n];
        switch (n) {
            case 0: {
                chartFillPatternArray = new ChartFillPattern[]{new ChartColorPattern(new Color(0x999999)), new ChartColorPattern(new Color(0xBFBFBF)), new ChartColorPattern(new Color(0xE5E5E5))};
                break;
            }
            case 1: {
                chartFillPatternArray[0] = new ChartColorPattern(new Color(0xA6A6A6));
                break;
            }
            case 2: {
                chartFillPatternArray[0] = new ChartColorPattern(new Color(0xA6A6A6));
                chartFillPatternArray[1] = new ChartColorPattern(new Color(0xE5E5E5));
                break;
            }
            case 3: {
                chartFillPatternArray[0] = new ChartColorPattern(new Color(0x999999));
                chartFillPatternArray[1] = new ChartColorPattern(new Color(0xBFBFBF));
                chartFillPatternArray[2] = new ChartColorPattern(new Color(0xE5E5E5));
                break;
            }
            case 4: {
                chartFillPatternArray[0] = new ChartColorPattern(new Color(0x7F7F7F));
                chartFillPatternArray[1] = new ChartColorPattern(new Color(0xA6A6A6));
                chartFillPatternArray[2] = new ChartColorPattern(new Color(0xCCCCCC));
                chartFillPatternArray[3] = new ChartColorPattern(new Color(0xE5E5E5));
                break;
            }
            case 5: {
                chartFillPatternArray[0] = new ChartColorPattern(new Color(0x7F7F7F));
                chartFillPatternArray[1] = new ChartColorPattern(new Color(0xA6A6A6));
                chartFillPatternArray[2] = new ChartColorPattern(new Color(0xCCCCCC));
                chartFillPatternArray[3] = new ChartColorPattern(new Color(0xE5E5E5));
                chartFillPatternArray[4] = new ChartColorPattern(new Color(0xF7F7F7));
                break;
            }
            default: {
                chartFillPatternArray[0] = new ChartColorPattern(new Color(0x7F7F7F));
                chartFillPatternArray[1] = new ChartColorPattern(new Color(0xA6A6A6));
                chartFillPatternArray[2] = new ChartColorPattern(new Color(0xCCCCCC));
                chartFillPatternArray[3] = new ChartColorPattern(new Color(0xE5E5E5));
                chartFillPatternArray[4] = new ChartColorPattern(new Color(0xF7F7F7));
            }
        }
        return JetChartPropertyValues.mapPatternList(chartFillPatternArray);
    }

    public static String getDefaultComparativeMeasureColorListPatternString(String string) {
        int n = JetChartPropertyValues.DEFAULTCOLORS(string, 1);
        ChartFillPattern[] chartFillPatternArray = new ChartFillPattern[n];
        if (n == 0) {
            chartFillPatternArray = new ChartFillPattern[]{new ChartColorPattern(Color.black)};
        }
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                chartFillPatternArray[i] = new ChartColorPattern(Color.black);
                continue;
            }
            if (i == 1) {
                chartFillPatternArray[i] = new ChartColorPattern(new Color(0x333333));
                continue;
            }
            if (i != 2) continue;
            chartFillPatternArray[i] = new ChartColorPattern(new Color(0x666666));
        }
        return JetChartPropertyValues.mapPatternList(chartFillPatternArray);
    }

    private static int DEFAULTCOLORS(String string, int n) {
        if (string == null) {
            return 0;
        }
        String[] stringArray = string.split(";");
        int n2 = stringArray.length;
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            String string2 = stringArray[i];
            nArray[i] = Integer.parseInt(string2);
        }
        return nArray[n];
    }

    public static int[] mapVectorToIntArray(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = Integer.parseInt(vector.get(i).toString());
        }
        return nArray;
    }

    public static Vector mapArrayToVector(int[] nArray) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < nArray.length; ++i) {
            vector.add("" + nArray[i]);
        }
        return vector;
    }

    public static Vector getDefaultIndictorRangeNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("True");
        vector.add("False");
        vector.add("Safety");
        vector.add("Warning");
        vector.add("Danger");
        return vector;
    }

    public static Vector getDefaultIndictorMinValues() {
        Vector<String> vector = new Vector<String>();
        vector.add("True");
        vector.add("False");
        vector.add("");
        vector.add("");
        vector.add("");
        return vector;
    }

    public static Vector getDefaultIndictorMaxValues() {
        Vector<String> vector = new Vector<String>();
        vector.add("True");
        vector.add("False");
        vector.add("");
        vector.add("");
        vector.add("");
        return vector;
    }

    public static ChartFillPattern[] getDefaultIndictorColors() {
        ChartFillPattern[] chartFillPatternArray = new ChartFillPattern[]{new ChartColorPattern(Color.green), new ChartColorPattern(Color.red), new ChartColorPattern(Color.green), new ChartColorPattern(Color.yellow), new ChartColorPattern(Color.red)};
        return chartFillPatternArray;
    }

    public static Vector getDefaultIndictorImages() {
        Vector<String> vector = new Vector<String>();
        vector.add("\t");
        vector.add("\t");
        vector.add("\t");
        vector.add("\t");
        vector.add("\t");
        return vector;
    }

    public static String mergeToChartFormatString(int n, String string) {
        String string2 = null;
        if (string == null || string.equals("")) {
            return string2;
        }
        switch (n) {
            case 1: {
                string2 = 3 + string;
                break;
            }
            case 2: {
                string2 = 1 + string;
                break;
            }
            case 3: {
                string2 = 1 + string;
                break;
            }
            case 4: {
                string2 = 1 + string;
                break;
            }
            case 5: {
                string2 = 1 + string;
                break;
            }
            case 6: {
                string2 = 1 + string;
                break;
            }
            case 7: {
                string2 = 1 + string;
                break;
            }
            case 8: {
                string2 = 1 + string;
                break;
            }
            case 91: {
                string2 = 2 + string;
                break;
            }
            case 92: {
                string2 = 2 + string;
                break;
            }
            case 93: {
                string2 = 2 + string;
                break;
            }
            case 12: {
                string2 = 3 + string;
                break;
            }
            case -1: {
                string2 = 3 + string;
                break;
            }
            case -2: {
                string2 = 1 + string;
                break;
            }
            case -3: {
                string2 = 1 + string;
                break;
            }
            case -4: {
                string2 = 1 + string;
                break;
            }
            case -5: {
                string2 = 1 + string;
                break;
            }
            case -6: {
                string2 = 1 + string;
                break;
            }
            case -7: {
                string2 = 1 + string;
                break;
            }
            case 0: {
                string2 = 3 + string;
                break;
            }
            case 1111: {
                string2 = 3 + string;
                break;
            }
            case -26803: {
                string2 = 3 + string;
                break;
            }
            case 2005: {
                string2 = 3 + string;
                break;
            }
            case 2004: {
                string2 = 3 + string;
                break;
            }
            case 2003: {
                string2 = 3 + string;
                break;
            }
            default: {
                string2 = null;
            }
        }
        return string2;
    }

    public static ChartDefinition adjustChartDefinition(ChartDefinition chartDefinition, Hashtable hashtable) {
        String string;
        String string2;
        Hashtable hashtable2 = hashtable;
        ChartDefinition chartDefinition2 = chartDefinition.getCopyInstance();
        String string3 = chartDefinition2.getCategory();
        if (string3 != null && !string3.equals("")) {
            chartDefinition2.setCategory((String)hashtable2.get(string3));
        }
        if ((string2 = chartDefinition2.getSeries()) != null && !string2.equals("")) {
            chartDefinition2.setSeries((String)hashtable2.get(string2));
        }
        if ((string = chartDefinition2.getMotionField()) != null && !string.equals("")) {
            chartDefinition2.setMotionField((String)hashtable2.get(string));
        }
        chartDefinition2.changeShowValueName(hashtable2);
        chartDefinition2.changeUniqueKeysName(hashtable2);
        return chartDefinition2;
    }
}

