/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.imageio.ImageIO;
import jet.datastream.DSField;
import jet.datastream.render.Render;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.RenderUtil;

public class RenderDateInputDropdown
extends Render {
    private Vector I;
    private Vector SEDU;
    private boolean black;
    private String close;
    private String convertPixelToUnit;
    private Color drawImage = Color.white;
    private Color fillRect = Color.black;

    public RenderDateInputDropdown(DSField dSField) {
        this.dsField = dSField;
        this.resolution = dSField.getResolution();
    }

    @Override
    protected void calculateAutoSize() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.I.size(); ++i) {
            int n3 = Unit.convertPixelToUnit((int)RenderGraphicsToolkit.getBounds((String)this.I.get(i), this.font).getWidth(), this.resolution) + 4;
            int n4 = Unit.convertPixelToUnit((int)RenderGraphicsToolkit.getBounds((String)this.I.get(i), this.font).getHeight(), this.resolution) + 4;
            if (n < n3) {
                n = n3;
            }
            if (n2 >= n4) continue;
            n2 = n4;
        }
        this.width = n;
        this.height = n2;
    }

    @Override
    protected void paintConcreteRender(Graphics graphics, int n, int n2, int n3, int n4) {
        this.I(graphics);
        boolean bl = false;
        if (this.dsField != null) {
            this.drawImage = RenderUtil.getColorPropertyByName(this.dsField, "Background");
            this.fillRect = RenderUtil.getColorPropertyByName(this.dsField, "Foreground");
            bl = RenderUtil.getBooleanPropertyByName(this.dsField, "Underline");
        }
        RenderGraphicsToolkit.paintDropdown(graphics, this.convertPixelToUnit, this.font, n, n2, n3 - n4, n4, this.black, this.drawImage, this.fillRect);
        Image image = this.getResource();
        if (bl) {
            int n5 = Math.min((this.font.getSize() + (this.font.isBold() ? 2 : 0)) / 10, 2);
            int n6 = Math.max((this.font.getSize() + (this.font.isBold() ? 2 : 0)) / 10, 1);
            int n7 = n3;
            int n8 = 2;
            if (image != null) {
                int n9 = 0;
                n7 -= image.getWidth(this.imageObserver) + n4 - 2 * n9 + n8 * 3;
            }
            graphics.fillRect(n + n8, n2 + n4 - n5 * 2, n7, n6);
        }
        if (image != null) {
            graphics.drawImage(image, n + n3 - n4, n2, this.imageObserver);
        }
    }

    private void I(Graphics graphics) {
    }

    public Color getBg() {
        return this.drawImage;
    }

    public void setBg(Color color) {
        this.drawImage = color;
    }

    public boolean isDisabled() {
        return this.black;
    }

    public void setDisabled(boolean bl) {
        this.black = bl;
    }

    public Vector getTexts() {
        return this.I;
    }

    public void setTexts(Vector vector) {
        this.I = vector;
    }

    public Vector getValues() {
        return this.SEDU;
    }

    public void setValues(Vector vector) {
        this.SEDU = vector;
    }

    public String getSelectedValues() {
        return this.close;
    }

    public void setSelectedValues(String string) {
        this.close = string;
    }

    public String getSelectedTexts() {
        return this.convertPixelToUnit;
    }

    public void setSelectedTexts(String string) {
        this.convertPixelToUnit = string;
    }

    public Image getResource() {
        InputStream inputStream = this.getClass().getResourceAsStream("/resource/images/calendar16.gif");
        if (inputStream == null) {
            return null;
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bufferedImage;
    }
}

