/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render;

import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Vector;
import jet.datastream.DSField;
import jet.datastream.DSMultiValueContainer;
import jet.datastream.render.Render;
import jet.datastream.render.RenderCreator;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.RenderUtil;
import jet.util.image.ImageResource;

public class RenderDropDownList
extends Render {
    private Vector DEFAULT_SHADOW_WIDTH;
    private Vector I;
    private boolean SEDU;
    private String append;
    private String black;
    private Color convertPixelToUnit = Color.white;
    private Color convertUnitToPixel = Color.black;
    private DSMultiValueContainer createGraphics;

    public RenderDropDownList() {
    }

    public RenderDropDownList(DSField dSField) {
        this.dsField = dSField;
        this.resolution = dSField.getResolution();
    }

    public RenderDropDownList(DSMultiValueContainer dSMultiValueContainer) {
        this.createGraphics = dSMultiValueContainer;
        this.resolution = dSMultiValueContainer.getResolution();
    }

    @Override
    protected void calculateAutoSize() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.DEFAULT_SHADOW_WIDTH.size(); ++i) {
            int n3 = Unit.convertPixelToUnit((int)RenderGraphicsToolkit.getBounds((String)this.DEFAULT_SHADOW_WIDTH.get(i), this.font).getWidth(), this.resolution) + 4;
            int n4 = Unit.convertPixelToUnit((int)RenderGraphicsToolkit.getBounds((String)this.DEFAULT_SHADOW_WIDTH.get(i), this.font).getHeight(), this.resolution) + 4;
            if (n < n3) {
                n = n3;
            }
            if (n2 >= n4) continue;
            n2 = n4;
        }
        this.width = n;
        this.height = n2;
    }

    @Override
    protected void paintConcreteRender(Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (this.createGraphics != null) {
            this.convertPixelToUnit = RenderUtil.getColorPropertyByName(this.createGraphics, "Background");
            this.convertUnitToPixel = RenderUtil.getColorPropertyByName(this.createGraphics, "Foreground");
        } else if (this.dsField != null) {
            this.convertPixelToUnit = RenderUtil.getColorPropertyByName(this.dsField, "Background");
            this.convertUnitToPixel = RenderUtil.getColorPropertyByName(this.dsField, "Foreground");
            bl = RenderUtil.getBooleanPropertyByName(this.dsField, "Underline");
        }
        this.DEFAULT_SHADOW_WIDTH(graphics);
        RenderGraphicsToolkit.paintDropdown(graphics, this.black, this.font, n, n2, n3, n4, this.SEDU, this.convertPixelToUnit, this.convertUnitToPixel);
        if (bl) {
            int n5 = Math.min((this.font.getSize() + (this.font.isBold() ? 2 : 0)) / 10, 2);
            int n6 = Math.max((this.font.getSize() + (this.font.isBold() ? 2 : 0)) / 10, 1);
            int n7 = n3;
            int n8 = 2;
            int n9 = 0;
            graphics.fillRect(n + n8, n2 + n4 - n5 * 2, n7 -= n4 - 2 * n9 + n8, n6);
        }
    }

    private void DEFAULT_SHADOW_WIDTH(Graphics graphics) {
        if (this.createGraphics == null) {
            return;
        }
        Rectangle rectangle = null;
        int n = this.createGraphics.getResolution();
        rectangle = new Rectangle(0, 0, Unit.convertUnitToPixel(this.createGraphics.getWidth(), n), Unit.convertUnitToPixel(this.createGraphics.getHeight(), n));
        Color color = RenderUtil.getColorPropertyByName(this.createGraphics, "Background");
        Color color2 = RenderUtil.getColorPropertyByName(this.createGraphics, "BorderColor");
        Color color3 = RenderUtil.getColorPropertyByName(this.createGraphics, "ShadowColor");
        int n2 = RenderUtil.getIntPropertyByName(this.createGraphics, "LeftLine");
        int n3 = RenderUtil.getIntPropertyByName(this.createGraphics, "RightLine");
        int n4 = RenderUtil.getIntPropertyByName(this.createGraphics, "TopLine");
        int n5 = RenderUtil.getIntPropertyByName(this.createGraphics, "BottomLine");
        int n6 = RenderUtil.getIntPropertyByName(this.createGraphics, "BorderWidth");
        int n7 = Unit.convertUnitToPixel(RenderCreator.DEFAULT_SHADOW_WIDTH, n);
        boolean bl = RenderUtil.getBooleanPropertyByName(this.createGraphics, "Shadow");
        boolean bl2 = color != null;
        Color color4 = graphics.getColor();
        RenderGraphicsToolkit.drawBorder(graphics, rectangle, bl2 ? color : null, color2, Unit.convertUnitToPixel(n6, n), n4, n5, n2, n3, bl, color3, n7);
        graphics.setColor(color4);
    }

    public Color getBg() {
        return this.convertPixelToUnit;
    }

    public void setBg(Color color) {
        this.convertPixelToUnit = color;
    }

    public boolean isDisabled() {
        return this.SEDU;
    }

    public void setDisabled(boolean bl) {
        this.SEDU = bl;
    }

    public Vector getTexts() {
        return this.DEFAULT_SHADOW_WIDTH;
    }

    public void setTexts(Vector vector) {
        this.DEFAULT_SHADOW_WIDTH = vector;
    }

    public Vector getValues() {
        return this.I;
    }

    public void setValues(Vector vector) {
        this.I = vector;
    }

    public String getSelectedValues() {
        return this.append;
    }

    public void setSelectedValues(String string) {
        this.append = string;
    }

    public String getSelectedTexts() {
        return this.black;
    }

    public void setSelectedTexts(String string) {
        this.black = string;
    }

    @Override
    public ImageResource getImageResource() {
        if (this.width == 0 || this.height == 0) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "BufferedImage can not be generated for its size is zero.");
            }
            return null;
        }
        BufferedImage bufferedImage = null;
        Color color = null;
        boolean bl = false;
        if (this.dsField != null) {
            color = RenderUtil.getColorPropertyByName(this.dsField, "Background");
            if (JRLog.isTrace(5)) {
                JRLog.error(5, "RenderDropDownList background of dsField: " + color);
            }
            if (color == null) {
                bl = true;
            }
        } else if (this.createGraphics != null) {
            color = RenderUtil.getColorPropertyByName(this.createGraphics, "Background");
            if (JRLog.isTrace(5)) {
                JRLog.error(5, "RenderDropDownList background of multiVContainer: " + color);
            }
            if (color == null) {
                bl = true;
            }
        } else {
            color = Color.white;
            if (JRLog.isTrace(5)) {
                JRLog.error(5, "RenderDropDownList background of no ds object: " + color);
            }
        }
        bufferedImage = bl ? new BufferedImage(Unit.convertUnitToPixel(this.width, this.resolution), Unit.convertUnitToPixel(this.height, this.resolution), 2) : new BufferedImage(Unit.convertUnitToPixel(this.width, this.resolution), Unit.convertUnitToPixel(this.height, this.resolution), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.paint(graphics2D);
        return new ImageResource(bufferedImage, -100);
    }
}

