/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render;

import com.jinfonet.awt.JFont;
import com.jinfonet.util.JRLog;
import guitools.Painter;
import guitools.PainterConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import jet.connect.DbBinary;
import jet.connect.DbValue;
import jet.datastream.DSField;
import jet.datastream.render.UnSupportedImageTypeException;
import jet.util.BitmapReader;
import jet.util.FontSets;
import jet.util.IntVector;
import jet.util.PictureFileFormatDetector;
import jet.util.Propertiable;
import jet.util.TextBreaker;

public class RenderGraphicsToolkit
implements PainterConstants {
    public static final int TEXTAREA_BORDER = 3;
    public static final int BUTTON_BORDER = 3;
    public static final int BORDER_GAP = 3;
    public static final int TEXT_GAP = 4;
    public static final int ERRORIMAGEWIDTH = 10;
    public static final int PENTACLE = 0;
    public static final int DIAMOND = 1;
    public static final int TRIANGLE = 2;
    public static final int RECTANGLE = 3;
    private static final HashMap SEDU = new HashMap();
    private static final HashMap abs = new HashMap();

    public static Shape getPentacle(int n, int n2, int n3, int n4) {
        GeneralPath generalPath = new GeneralPath();
        int n5 = n3 > n4 ? n4 / 2 : n3 / 2;
        float f = 1.2566371f;
        int n6 = n + n3 / 2;
        int n7 = n2 + n4 / 2;
        float[][] fArray2 = new float[5][2];
        for (int i = 0; i < 5; ++i) {
            fArray2[i][0] = (float)((double)n6 + (double)n5 * Math.sin((float)i * f));
            fArray2[i][1] = (float)((double)n7 - (double)n5 * Math.cos((float)i * f));
        }
        generalPath.moveTo(fArray2[0][0], fArray2[0][1]);
        generalPath.lineTo(fArray2[2][0], fArray2[2][1]);
        generalPath.lineTo(fArray2[4][0], fArray2[4][1]);
        generalPath.lineTo(fArray2[1][0], fArray2[1][1]);
        generalPath.lineTo(fArray2[3][0], fArray2[3][1]);
        generalPath.lineTo(fArray2[0][0], fArray2[0][1]);
        return generalPath;
    }

    public static Shape getDiamond(int n, int n2, int n3, int n4) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(n, n2 + n4 / 2);
        generalPath.lineTo(n + n3 / 2, n2);
        generalPath.lineTo(n + n3, n2 + n4 / 2);
        generalPath.lineTo(n + n3 / 2, n2 + n4);
        generalPath.closePath();
        return generalPath;
    }

    public static Shape getShape(int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 0: {
                return RenderGraphicsToolkit.getPentacle(n2, n3, n4, n5);
            }
            case 1: {
                return RenderGraphicsToolkit.getDiamond(n2, n3, n4, n5);
            }
            case 2: {
                return RenderGraphicsToolkit.abs(n2, n3, n4, n5);
            }
            case 3: {
                return RenderGraphicsToolkit.SEDU(n2, n3, n4, n5);
            }
        }
        return null;
    }

    private static Shape SEDU(int n, int n2, int n3, int n4) {
        int n5 = n3 > n4 ? n4 : n3;
        return new Rectangle2D.Float(n, n2, n5, n5);
    }

    private static Shape abs(int n, int n2, int n3, int n4) {
        GeneralPath generalPath = new GeneralPath();
        int n5 = n3 > n4 ? n4 : n3;
        generalPath.moveTo(n + n3 / 2, n2 + (n4 - n5) / 2 + n5 / 3);
        generalPath.lineTo(n + (n3 - n5) / 2 + n5 / 3, n2 + (n4 - n5) / 2 + 2 * n5 / 3);
        generalPath.lineTo(n + (n3 - n5) / 2 + 2 * n5 / 3, n2 + (n4 - n5) / 2 + 2 * n5 / 3);
        generalPath.closePath();
        return generalPath;
    }

    public static BufferedImage getImageByName(String string, Component component) {
        Image image = TextBreaker.getDefaultToolkit().getImage(string);
        if (image == null) {
            try {
                image = TextBreaker.getDefaultToolkit().getImage(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        if (image == null) {
            return null;
        }
        RenderGraphicsToolkit.waitImage(image);
        int n = image.getWidth(component);
        int n2 = image.getHeight(component);
        if (n == -1 || n2 == -1) {
            if (JRLog.isError(3)) {
                JRLog.error(3, 3300010, string);
            }
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.drawImage(image, 0, 0, component);
        return bufferedImage;
    }

    public static Image getImageByName(String string) {
        if (SEDU.containsKey(string)) {
            return (Image)SEDU.get(string);
        }
        Image image = TextBreaker.getDefaultToolkit().getImage(string);
        if (image == null) {
            try {
                image = TextBreaker.getDefaultToolkit().getImage(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        RenderGraphicsToolkit.waitImage(image);
        if (image == null || image.getWidth(null) <= 0 || image.getHeight(null) <= 0) {
            if (JRLog.isError(3)) {
                JRLog.error(3, 3300011, string);
            }
            image = null;
        }
        SEDU.put(string, image);
        return image;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image createImage(DbValue dbValue) {
        Image image = null;
        Object[] objectArray = new Object[2];
        if (dbValue != null && !dbValue.isNull() && dbValue instanceof DbBinary) {
            byte[] byArray = ((DbBinary)dbValue).get();
            if (byArray == null || byArray.length == 0) {
                if (!JRLog.isError(2)) return null;
                JRLog.error(3, 3300019);
                return null;
            }
            int n = PictureFileFormatDetector.getPictureFileType(byArray);
            switch (n) {
                case 4: {
                    image = TextBreaker.getDefaultToolkit().createImage(byArray);
                    objectArray[1] = 4;
                    break;
                }
                case 0: {
                    image = TextBreaker.getDefaultToolkit().createImage(byArray);
                    objectArray[1] = 0;
                    break;
                }
                case 3: {
                    image = TextBreaker.getDefaultToolkit().createImage(byArray);
                    objectArray[1] = 3;
                    break;
                }
                case 1: {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    BitmapReader bitmapReader = BitmapReader.loadFromBMP(dataInputStream);
                    if (bitmapReader != null) {
                        image = TextBreaker.getDefaultToolkit().createImage(bitmapReader.getMemImgSrc());
                        objectArray[1] = 1;
                    }
                    try {
                        byteArrayInputStream.close();
                        dataInputStream.close();
                    }
                    catch (IOException iOException) {
                        if (!JRLog.isError(2)) break;
                        JRLog.error(2, iOException);
                    }
                    break;
                }
                default: {
                    try {
                        throw new UnSupportedImageTypeException();
                    }
                    catch (UnSupportedImageTypeException unSupportedImageTypeException) {
                        if (!JRLog.isError(2)) break;
                        JRLog.error(2, 2300012, (Throwable)unSupportedImageTypeException);
                    }
                    break;
                }
            }
        } else if (JRLog.isError(3)) {
            JRLog.error(3, 3300012);
        }
        RenderGraphicsToolkit.waitImage(image);
        if (image != null && image.getWidth(null) > 0) {
            if (image.getHeight(null) > 0) return image;
        }
        if (!JRLog.isError(3)) return null;
        JRLog.error(3, 3300013);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object[] createImage(DbValue dbValue, int n) {
        Image image = null;
        Object[] objectArray = new Object[2];
        if (dbValue != null && !dbValue.isNull() && dbValue instanceof DbBinary) {
            byte[] byArray = ((DbBinary)dbValue).get();
            if (byArray == null || byArray.length == 0) {
                if (JRLog.isError(3)) {
                    JRLog.error(3, 3300019);
                }
                return null;
            }
            if (n == 2) {
                n = PictureFileFormatDetector.getPictureFileType(byArray);
            }
            switch (n) {
                case 4: {
                    image = TextBreaker.getDefaultToolkit().createImage(byArray);
                    objectArray[1] = 4;
                    break;
                }
                case 0: {
                    image = TextBreaker.getDefaultToolkit().createImage(byArray);
                    objectArray[1] = 0;
                    break;
                }
                case 3: {
                    image = TextBreaker.getDefaultToolkit().createImage(byArray);
                    objectArray[1] = 3;
                    break;
                }
                case 1: {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    BitmapReader bitmapReader = BitmapReader.loadFromBMP(dataInputStream);
                    if (bitmapReader != null) {
                        image = TextBreaker.getDefaultToolkit().createImage(bitmapReader.getMemImgSrc());
                        objectArray[1] = 1;
                    }
                    try {
                        byteArrayInputStream.close();
                        dataInputStream.close();
                    }
                    catch (IOException iOException) {
                        if (!JRLog.isError(2)) break;
                        JRLog.error(2, iOException);
                    }
                    break;
                }
                default: {
                    try {
                        throw new UnSupportedImageTypeException();
                    }
                    catch (UnSupportedImageTypeException unSupportedImageTypeException) {
                        if (!JRLog.isError(2)) break;
                        JRLog.error(2, 2300012, (Throwable)unSupportedImageTypeException);
                    }
                    break;
                }
            }
        } else if (JRLog.isError(3)) {
            JRLog.error(3, 3300012);
        }
        RenderGraphicsToolkit.waitImage(image);
        if (image == null || image.getWidth(null) <= 0 || image.getHeight(null) <= 0) {
            if (JRLog.isError(3)) {
                JRLog.error(3, 3300013);
            }
            image = null;
        }
        objectArray[0] = image;
        return objectArray;
    }

    public static void imageToFile(BufferedImage bufferedImage, String string) throws IOException, UnSupportedImageTypeException {
        ImageWriter imageWriter = null;
        String string2 = string.substring(string.indexOf(46) + 1);
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersBySuffix(string2);
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(new File(string));
        if (!iterator.hasNext()) {
            throw new UnSupportedImageTypeException("Unsupported image format");
        }
        imageWriter = iterator.next();
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(bufferedImage);
        imageOutputStream.close();
    }

    public static Rectangle fieldRotation(double d, int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n - n3 / 2, n2 - n4 / 2, n3, n4);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(d, n, n2);
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(rectangle.getPathIterator(affineTransform), false);
        return generalPath.getBounds();
    }

    public static void drawBorder(Graphics graphics, Rectangle rectangle, Color color, Color color2, int n, int n2, int n3, int n4, int n5, boolean bl, Color color3, int n6) {
        RenderGraphicsToolkit.drawBorder(graphics, rectangle, color, color2, n, n2, n3, n4, n5, bl, bl, bl, bl, color3, n6);
    }

    public static void drawBorder(Graphics graphics, Rectangle rectangle, Color color, Color color2, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3, boolean bl4, Color color3, int n6) {
        int n7 = rectangle.width;
        int n8 = rectangle.height;
        if (bl) {
            n8 -= n6;
        }
        if (bl2) {
            n7 -= n6;
        }
        if (n > 0 && color2 != null && !color2.equals(color)) {
            if (n2 != 0) {
                if (n2 != 5) {
                    Painter.drawLine(graphics, rectangle.x, rectangle.y + (n - 1) / 2, n7 - 1 + rectangle.x, (n - 1) / 2 + rectangle.y, color2, n, n2);
                } else {
                    Painter.drawLine(graphics, rectangle.x, rectangle.y + (n - 1) / 2, n7 - 1 + rectangle.x, (n - 1) / 2 + rectangle.y, color2, n, 1);
                    Painter.drawLine(graphics, rectangle.x, rectangle.y + n * 2 + (n - 1) / 2, n7 - 1 + rectangle.x, n * 2 + (n - 1) / 2 + rectangle.y, color2, n, 1);
                }
            }
            if (n3 != 0) {
                if (n3 != 5) {
                    Painter.drawLine(graphics, rectangle.x, rectangle.y + n8 - 1 - n / 2, n7 - 1 + rectangle.x, n8 - 1 - n / 2 + rectangle.y, color2, n, n3);
                } else {
                    Painter.drawLine(graphics, rectangle.x, rectangle.y + n8 - 1 - n / 2, n7 - 1 + rectangle.x, n8 - 1 - n / 2 + rectangle.y, color2, n, 1);
                    Painter.drawLine(graphics, rectangle.x, rectangle.y + n8 - 1 - n * 2 - n / 2, n7 - 1 + rectangle.x, n8 - 1 - n * 2 - n / 2 + rectangle.y, color2, n, 1);
                }
            }
            if (n4 != 0) {
                if (n4 != 5) {
                    Painter.drawLine(graphics, (n - 1) / 2 + rectangle.x, rectangle.y, (n - 1) / 2 + rectangle.x, n8 - 1 + rectangle.y, color2, n, n4);
                } else {
                    Painter.drawLine(graphics, (n - 1) / 2 + rectangle.x, rectangle.y, (n - 1) / 2 + rectangle.x, n8 - 1 + rectangle.y, color2, n, 1);
                    Painter.drawLine(graphics, n * 2 + (n - 1) / 2 + rectangle.x, rectangle.y, n * 2 + (n - 1) / 2 + rectangle.x, n8 - 1 + rectangle.y, color2, n, 1);
                }
            }
            if (n5 != 0) {
                if (n5 != 5) {
                    Painter.drawLine(graphics, n7 - 1 - n / 2 + rectangle.x, rectangle.y, n7 - 1 - n / 2 + rectangle.x, n8 - 1 + rectangle.y, color2, n, n5);
                } else {
                    Painter.drawLine(graphics, n7 - 1 - n / 2 + rectangle.x, rectangle.y, n7 - 1 - n / 2 + rectangle.x, n8 - 1 + rectangle.y, color2, n, 1);
                    Painter.drawLine(graphics, n7 - 1 - n * 2 - n / 2 + rectangle.x, rectangle.y, n7 - 1 - n * 2 - n / 2 + rectangle.x, n8 - 1 + rectangle.y, color2, n, 1);
                }
            }
        }
        if ((bl || bl2) && color3 != null && n6 > 0) {
            int n9;
            graphics.setColor(color3);
            if (bl) {
                n9 = bl3 ? n6 : 0;
                graphics.fillRect(n9 + rectangle.x, rectangle.height - n6 + rectangle.y, rectangle.width - n9, n6);
            }
            if (bl2) {
                n9 = bl4 ? n6 : 0;
                graphics.fillRect(rectangle.width - n6 + rectangle.x, n9 + rectangle.y, n6, rectangle.height - n9);
            }
        }
    }

    public static void drawPattern(Graphics graphics, Rectangle rectangle, Color color, int n) {
        Painter.drawPattern(graphics, rectangle, color, n);
    }

    public static void paintButton(Graphics graphics, String string, Font font, int n, int n2, int n3, int n4, boolean bl, Color color, Color color2, boolean bl2, boolean bl3, boolean bl4, Color color3, int n5, int n6) {
        int n7 = 3;
        int n8 = 3;
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Rectangle rectangle2 = new Rectangle(n + n7, n2 + n8, n3 - 2 * n7, n4 - 2 * n8);
        if (string == null && JRLog.isError(3)) {
            JRLog.error(3, 3300014);
        }
        Vector vector = Painter.lineBreaker(string, n3 - 6, font);
        string = vector.get(0).toString();
        graphics.setColor(color == null ? new Color(255, 255, 255, 1) : color);
        graphics.fillRect(n, n2, n3, n4);
        int n9 = 3;
        RenderGraphicsToolkit.clipString(graphics, n9, rectangle);
        RenderGraphicsToolkit.drawPattern(graphics, rectangle2, color3, n5);
        graphics.setColor(color2);
        if (bl) {
            Painter.drawText(graphics, rectangle2, 1, string, font, color2, bl2, bl3, bl4, n6);
        } else {
            Painter.drawText(graphics, rectangle2, 1, string, font, color2, bl2, bl3, bl4, n6);
        }
    }

    public static void paintTextField(Graphics graphics, String string, Font font, int n, int n2, int n3, int n4, boolean bl, Color color, Color color2, boolean bl2, boolean bl3, boolean bl4, Color color3, int n5, int n6) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        graphics.setColor(color == null ? Color.white : color);
        graphics.fillRect(n, n2, n3, n4);
        int n7 = 3;
        RenderGraphicsToolkit.black(graphics, n7, rectangle, null);
        Rectangle rectangle2 = new Rectangle(n + n7, n2 + n7, n3 - 2 * n7, n4 - 2 * n7);
        RenderGraphicsToolkit.drawPattern(graphics, rectangle2, color3, n5);
        Painter.drawText(graphics, rectangle2, 1, string, font, color2, bl2, bl3, bl4, n6);
    }

    private static void addImage(int n, int n2, int n3, int n4, Graphics graphics) {
        int n5 = 1;
        graphics.setColor(new Color(Integer.parseInt("d4d0c8", 16)));
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        graphics.fillRect(n, n2, n3, n4);
        RenderGraphicsToolkit.clipString(graphics, n5, rectangle);
    }

    public static void paintPassword(Graphics graphics, String string, Font font, int n, int n2, int n3, int n4, boolean bl, Color color, Color color2, boolean bl2, boolean bl3, boolean bl4, Color color3, int n5, int n6) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append('*');
        }
        String string2 = stringBuffer.toString();
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        graphics.setColor(color == null ? Color.white : color);
        graphics.fillRect(n, n2, n3, n4);
        int n7 = 3;
        RenderGraphicsToolkit.black(graphics, n7, rectangle, null);
        Rectangle rectangle2 = new Rectangle(n + n7, n2 + n7, n3 - 2 * n7, n4 - 2 * n7);
        RenderGraphicsToolkit.drawPattern(graphics, rectangle2, color3, n5);
        if (bl) {
            Painter.drawText(graphics, rectangle2, 1, string2, font, color2, bl2, bl3, bl4, n6);
        } else {
            Painter.drawText(graphics, rectangle2, 1, string2, font, color2, bl2, bl3, bl4, n6);
        }
    }

    public static void paintCheckbox(Graphics graphics, String string, Font font, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, Color color, Color color2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Color color3, int n9) {
        int n10 = 12;
        int n11 = 12;
        int n12 = 5;
        if (string == null) {
            if (JRLog.isError(3)) {
                JRLog.error(3, 3300015);
            }
            string = "";
        }
        int n13 = (int)RenderGraphicsToolkit.getBounds(string, font).getHeight();
        int n14 = (int)RenderGraphicsToolkit.getBounds(string, font).getWidth();
        Rectangle rectangle = new Rectangle(n7, n8, n13, n14);
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        graphics.setColor(color == null ? Color.white : color);
        graphics.fillRect(n, n2, n3, n4);
        RenderGraphicsToolkit.drawPattern(graphics, rectangle2, color3, n9);
        if (bl) {
            graphics.setColor(new Color(255, 242, 198));
            graphics.fillRect(n5, n6, n10, n11);
        } else {
            graphics.setColor(Color.white);
            graphics.fillRect(n5, n6, n10, n11);
        }
        int n15 = 2;
        RenderGraphicsToolkit.black(graphics, n15, new Rectangle(n5, n6, n10, n11), null);
        if (bl5) {
            if (bl) {
                Painter.drawLine(graphics, n5 + 1, n6 + 5 - 2, n5 + 4, n6 + 5 + 3, new Color(255, 225, 139), 2, 1);
                Painter.drawLine(graphics, n5 + 4, n6 + 5 + 3, n5 + 9, n6 + 5 - 4, new Color(255, 225, 139), 2, 1);
            } else {
                Painter.drawLine(graphics, n5 + 1, n6 + 5 - 2, n5 + 4, n6 + 5 + 3, Color.black, 2, 1);
                Painter.drawLine(graphics, n5 + 4, n6 + 5 + 3, n5 + 9, n6 + 5 - 4, Color.black, 2, 1);
            }
        }
        if (bl) {
            Painter.drawText(graphics, rectangle, 1, string, font, color2, bl2, bl3, bl4, 1);
        } else {
            Painter.drawText(graphics, rectangle, 1, string, font, color2, bl2, bl3, bl4, 1);
        }
    }

    public static void paintRadio(Graphics graphics, String string, Font font, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, Color color, Color color2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Color color3, int n9) {
        int n10 = 10;
        int n11 = 10;
        int n12 = 5;
        int n13 = (int)RenderGraphicsToolkit.getBounds(string, font).getHeight();
        int n14 = (int)RenderGraphicsToolkit.getBounds(string, font).getWidth();
        Rectangle rectangle = new Rectangle(n7, n8, n13, n14);
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        graphics.setColor(color == null ? Color.white : color);
        graphics.fillRect(n, n2, n3, n4);
        RenderGraphicsToolkit.drawPattern(graphics, new Rectangle(n, n2, n3, n4), color3, n9);
        if (bl) {
            graphics.setColor(new Color(255, 225, 139));
            graphics.fillOval(n5 - 1, n6 - 1, n10 + 2, n11 + 2);
            graphics.setColor(new Color(255, 242, 198));
            graphics.fillOval(n5 + 1, n6, n10, n11);
        } else {
            graphics.setColor(new Color(255, 225, 139));
            graphics.fillOval(n5, n6 - 1, n10 + 2, n11 + 2);
            graphics.setColor(Color.white);
            graphics.fillOval(n5 + 1, n6, n10, n11);
        }
        graphics.setColor(Color.black);
        graphics.drawArc(n5, n6, n10, n11, 30, 200);
        if (bl5) {
            graphics.fillOval(n5 + n10 / 2 - 2, n2 + n4 / 2 - 2, 4, 4);
        }
        graphics.setColor(color2);
        if (bl) {
            Painter.drawText(graphics, rectangle, 1, string, font, color2, bl2, bl3, bl4, 1);
        } else {
            Painter.drawText(graphics, rectangle, 1, string, font, color2, bl2, bl3, bl4, 1);
        }
    }

    public static void paintList(Graphics graphics, Vector vector, IntVector intVector, Font font, int n, int n2, int n3, int n4, boolean bl, Color color, Vector vector2) {
        RenderGraphicsToolkit.paintList(graphics, vector, intVector, font, n, n2, n3, n4, bl, Color.black, color, null, vector2, 0, null, false);
    }

    public static void paintList(Graphics graphics, Vector vector, IntVector intVector, Font font, int n, int n2, int n3, int n4, boolean bl, Color color, Color color2, Color color3, Vector vector2, int n5, Color color4, boolean bl2) {
        Object object;
        int n6 = n + n3 - 12;
        int n7 = n2 + 3;
        int n8 = 10;
        int n9 = n4 - 3;
        int n10 = 1;
        int n11 = n2 + 4;
        int n12 = TextBreaker.defaultKit.getFontMetrics(font).getHeight();
        if (bl) {
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(color2 == null ? Color.white : color2);
        }
        graphics.fillRect(n, n2, n3, n4);
        int n13 = n5 == 0 ? 2 : n5;
        int n14 = 0;
        int n15 = vector.size();
        if (n15 > 0 && n12 * n15 + n11 > n2 + n4) {
            n14 = 12;
        }
        n += n5;
        String[] stringArray = new String[n15];
        int n16 = 0;
        for (n16 = 0; n16 < n15; ++n16) {
            object = new Rectangle(n + 2, n11, n3 - n13 * 2 - 2, n4);
            if (n11 + 11 >= n2 + n4) break;
            stringArray[n16] = (String)vector.get(n16);
            if (vector2 != null && intVector.contains(n16)) {
                if (color3 == null) {
                    RenderGraphicsToolkit.append(graphics, SystemColor.textHighlight, (Rectangle)object, n12);
                } else {
                    RenderGraphicsToolkit.append(graphics, color3, (Rectangle)object, n12);
                }
            }
            if (bl) {
                Painter.drawText(graphics, (Rectangle)object, 1, stringArray[n16], font, new Color(201, 165, 92), false, false, false, 1);
            } else {
                Painter.drawText(graphics, (Rectangle)object, 1, stringArray[n16], font, color, false, false, false, 1);
            }
            int n17 = Math.max((font.getSize() + (font.isBold() ? 2 : 0)) / 10, 1);
            int n18 = (int)RenderGraphicsToolkit.getBounds(stringArray[n16], font, false).getWidth();
            if (bl2) {
                int n19 = Math.min((font.getSize() + (font.isBold() ? 2 : 0)) / 10, 2);
                graphics.fillRect(n + 2, n11 + graphics.getFontMetrics().getAscent() + n19, n18, n17);
            }
            n11 += n12;
        }
        if (n16 != n15) {
            if (n4 <= 5) {
                RenderGraphicsToolkit.addImage(n + n3 - 12, n2 + 3, 10, n4 - 5, graphics);
                graphics.setColor(Color.black);
                graphics.drawLine(n + n3 - 12, n2 + 2, n + n3 - 12 + 11, n2 + 2);
                graphics.drawLine(n + n3 - 12 + 11, n2 + 2, n + n3 - 12 + 11, n2 + 1);
            } else if (n4 > 5 && n4 <= 10) {
                RenderGraphicsToolkit.addImage(n + n3 - 12, n2 + 3, 10, n4 - 5, graphics);
                graphics.setColor(Color.black);
                graphics.drawLine(n + n3 - 12, n2 + 2, n + n3 - 12 + 11, n2 + 2);
                graphics.drawLine(n + n3 - 12 + 11, n2 + 2, n + n3 - 12 + 11, n2 + 1);
                object = new int[]{n6 + n8 / 2 - n10 * 2, n6 + n8 / 2 + n10 * 2, n6 + n8 / 2};
                int[] nArray = new int[]{n7 + n9 / 4 + n10 - 1, n7 + n9 / 4 + n10 - 1, n7 + n9 / 4 - n10 - 2};
                graphics.fillPolygon((int[])object, nArray, 3);
                int[] nArray2 = new int[]{n6 + n8 / 2 - n10 * 2, n6 + n8 / 2 + n10 * 2, n6 + n8 / 2};
                int[] nArray3 = new int[]{n7 + n9 * 3 / 4 - n10, n7 + n9 * 3 / 4 - n10, n7 + n9 * 3 / 4 + n10};
                graphics.fillPolygon(nArray2, nArray3, 3);
            } else if (n4 > 10 && n4 <= 25) {
                RenderGraphicsToolkit.addImage(n + n3 - 12, n2 + 3, 10, n4 - 5, graphics);
                graphics.setColor(Color.white);
                graphics.drawLine(n6, n7 + n9 / 2 - 1, n6 + 11, n7 + n9 / 2 - 1);
                graphics.setColor(Color.black);
                graphics.drawLine(n6, n7 + n9 / 2 - 2, n6 + 11, n7 + n9 / 2 - 2);
                graphics.drawLine(n6 + 11, n7 + n9 / 2 - 2, n6 + 11, n2 + 1);
                graphics.setColor(Color.black);
                object = new int[]{n6 + n8 / 2 - n10 * 2, n6 + n8 / 2 + n10 * 2, n6 + n8 / 2};
                int[] nArray = new int[]{n7 + n9 / 4 + n10 - 1, n7 + n9 / 4 + n10 - 1, n7 + n9 / 4 - n10 - 2};
                graphics.fillPolygon((int[])object, nArray, 3);
                int[] nArray4 = new int[]{n6 + n8 / 2 - n10 * 2, n6 + n8 / 2 + n10 * 2, n6 + n8 / 2};
                int[] nArray5 = new int[]{n7 + n9 * 3 / 4 - n10, n7 + n9 * 3 / 4 - n10, n7 + n9 * 3 / 4 + n10};
                graphics.fillPolygon(nArray4, nArray5, 3);
            } else if (n4 > 25) {
                graphics.setColor(Color.white);
                graphics.fillRect(n6 - 1, n7, 14, n4 - 5);
                RenderGraphicsToolkit.addImage(n6, n7, 10, 8, graphics);
                RenderGraphicsToolkit.addImage(n6, n7 + n9 - 10, 10, 8, graphics);
                graphics.setColor(Color.black);
                object = new int[]{n6 + 5 - n10 * 2, n6 + 5 + n10 * 2, n6 + 5};
                int[] nArray = new int[]{n7 + 4 + n10, n7 + 4 + n10, n7 + 4 - n10};
                graphics.fillPolygon((int[])object, nArray, 3);
                int[] nArray6 = new int[]{n6 + 5 - n10 * 2, n6 + 5 + n10 * 2, n6 + 5};
                int[] nArray7 = new int[]{n7 + n9 - 5 - n10, n7 + n9 - 5 - n10, n7 + n9 - 5 + n10};
                graphics.fillPolygon(nArray6, nArray7, 3);
            }
        }
    }

    private static void append(Graphics graphics, Color color, Rectangle rectangle, int n) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, 16);
        graphics.setColor(color2);
    }

    public static void paintTitle(String string, Graphics graphics, Color color, Color color2, Font font, Rectangle rectangle, boolean bl) {
        Color color3 = graphics.getColor();
        graphics.setColor(color);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (string != null && string.length() > 0) {
            graphics.setColor(color2);
            Font font2 = graphics.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = TextBreaker.getDefaultToolkit().getFontMetrics(font);
            graphics.drawString(string, rectangle.x + 2, rectangle.y + fontMetrics.getAscent());
            graphics.setFont(font2);
            int n = Math.max((font.getSize() + (font.isBold() ? 2 : 0)) / 10, 1);
            int n2 = (int)RenderGraphicsToolkit.getBounds(string, font, false).getWidth();
            if (bl) {
                int n3 = Math.min((font.getSize() + (font.isBold() ? 2 : 0)) / 10, 2);
                graphics.fillRect(rectangle.x + 2, rectangle.y + fontMetrics.getAscent() + n3, n2, n);
            }
        }
        graphics.setColor(color3);
    }

    public static void paintDropdown(Graphics graphics, String string, Font font, int n, int n2, int n3, int n4, boolean bl, Color color) {
        RenderGraphicsToolkit.paintDropdown(graphics, string, font, n, n2, n3, n4, bl, color, Color.black);
    }

    public static void paintDropdown(Graphics graphics, String string, Font font, int n, int n2, int n3, int n4, boolean bl, Color color, Color color2) {
        String string2 = null;
        if (string == null || string.equals("")) {
            if (JRLog.isError(3)) {
                JRLog.error(3, 3300016);
            }
            string2 = "";
        } else {
            string2 = string;
        }
        int n5 = 2;
        int n6 = 0;
        int n7 = n + n3 - (n4 - n6);
        int n8 = n2 + n6 + n5;
        int n9 = n4 - 2 * n6 - n5;
        int n10 = n4 - 2 * n6 - 2 * n5;
        int n11 = n10 / 5;
        graphics.setColor(color == null ? new Color(255, 255, 255, 1) : color);
        graphics.fillRect(n, n2, n3, n4);
        RenderGraphicsToolkit.black(graphics, n5, new Rectangle(n, n2, n3, n4), null);
        RenderGraphicsToolkit.addImage(n7, n8, n9, n10, graphics);
        if (bl) {
            graphics.setColor(new Color(201, 165, 92));
        } else {
            graphics.setColor(Color.black);
        }
        int[] nArray = new int[]{n7 + n9 / 2 - n11 * 2, n7 + n9 / 2 + n11 * 2, n7 + n9 / 2};
        int[] nArray2 = new int[]{n8 + n10 / 2 - n11, n8 + n10 / 2 - n11, n8 + n10 / 2 + n11};
        graphics.fillPolygon(nArray, nArray2, 3);
        Rectangle rectangle = new Rectangle(n + n5, n2 + n5, n3 - 2 * n5 - n9 - 2 * n6, n4 - 2 * n5);
        String string3 = TextBreaker.clipString(string2, font, 0, n3 - 2 * n5 - n9 - 2 * n6, true);
        if (bl) {
            Painter.drawText(graphics, rectangle, 1, string3, font, new Color(201, 165, 92), false, false, false, 4);
        } else {
            Painter.drawText(graphics, rectangle, 1, string3, font, color2, false, false, false, 4);
        }
    }

    public static Graphics2D convertGraphicsToGraphics2D(Graphics graphics, Rectangle rectangle, BufferedImage bufferedImage) {
        Graphics2D graphics2D = null;
        try {
            graphics2D = (Graphics2D)graphics;
        }
        catch (ClassCastException classCastException) {
            bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 6);
            graphics2D = (Graphics2D)bufferedImage.getGraphics();
        }
        return graphics2D;
    }

    public static BufferedImage convertGraphicsToGraphics2D(Graphics graphics, Rectangle rectangle) {
        BufferedImage bufferedImage = null;
        Graphics2D graphics2D = null;
        try {
            graphics2D = (Graphics2D)graphics;
        }
        catch (ClassCastException classCastException) {
            bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 6);
        }
        return bufferedImage;
    }

    public static Rectangle2D getBounds(String string, Font font) {
        Rectangle2D rectangle2D = null;
        try {
            FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, true);
            rectangle2D = font.getStringBounds(string, fontRenderContext);
        }
        catch (NullPointerException nullPointerException) {
            if (JRLog.isError(2)) {
                if (font != null) {
                    JRLog.error(2, "catch java NPE of font getStringBounds(...), refer to http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6359722 ", (Throwable)nullPointerException);
                } else {
                    JRLog.error(2, nullPointerException);
                }
            }
            FontMetrics fontMetrics = font instanceof JFont ? ((JFont)((Object)font)).getFontMetrics() : TextBreaker.getDefaultToolkit().getFontMetrics(font);
            rectangle2D = new Rectangle(0, 0, fontMetrics.stringWidth(string), fontMetrics.getHeight());
        }
        return new Rectangle2D.Float(0.0f, 0.0f, (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
    }

    public static Rectangle2D getBounds(String string, Font font, boolean bl) {
        if (bl) {
            Rectangle2D rectangle2D = null;
            try {
                FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, bl);
                rectangle2D = font.getStringBounds(string, fontRenderContext);
            }
            catch (NullPointerException nullPointerException) {
                if (JRLog.isError(2)) {
                    if (font != null) {
                        JRLog.error(2, "catch java NPE of font getStringBounds(...), refer to http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6359722 ", (Throwable)nullPointerException);
                    } else {
                        JRLog.error(2, nullPointerException);
                    }
                }
                FontMetrics fontMetrics = font instanceof JFont ? ((JFont)((Object)font)).getFontMetrics() : TextBreaker.getDefaultToolkit().getFontMetrics(font);
                rectangle2D = new Rectangle(0, 0, fontMetrics.stringWidth(string), fontMetrics.getHeight());
            }
            return new Rectangle2D.Float(0.0f, 0.0f, (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
        }
        FontMetrics fontMetrics = font instanceof JFont ? ((JFont)((Object)font)).getFontMetrics() : TextBreaker.getDefaultToolkit().getFontMetrics(font);
        return new Rectangle2D.Float(0.0f, 0.0f, fontMetrics.stringWidth(string), fontMetrics.getHeight());
    }

    public static String convertTextForTextArea(String string) {
        string = string.replace('\t', ' ');
        string = string.replace('\r', ' ');
        string = string.replace('\n', ' ');
        return string;
    }

    public static Color highlight(Color color, int n) {
        if (color != null) {
            int n2 = color.getRGB();
            int n3 = color.getAlpha();
            int n4 = n2 >> 16 & 0xFF;
            int n5 = n2 >> 8 & 0xFF;
            int n6 = n2 & 0xFF;
            int n7 = n >= 0 ? 1 : 0;
            n = Math.abs(n);
            n4 = (n4 * (100 - n) + n7 * 255 * n) / 100;
            n5 = (n5 * (100 - n) + n7 * 255 * n) / 100;
            n6 = (n6 * (100 - n) + n7 * 255 * n) / 100;
            return new Color(n4, n5, n6, n3);
        }
        return null;
    }

    public static void paintTextArea(Graphics graphics, String string, Vector vector, Font font, Color color, int n, int n2, int n3, int n4, Color color2, Color color3, int n5) {
        int[][] nArray = new int[vector.size()][2];
        graphics.setColor(color2 == null ? Color.white : color2);
        graphics.fillRect(n, n2, n3, n4);
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        int n6 = 3;
        RenderGraphicsToolkit.black(graphics, n6, rectangle, null);
        RenderGraphicsToolkit.drawPattern(graphics, rectangle, color3, n5);
        graphics.setFont(font);
        graphics.setColor(color);
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i][0] = 3 + n;
            nArray[i][1] = i == 0 ? (int)((double)(3 + n2) + RenderGraphicsToolkit.getBounds((String)vector.get(i), font).getHeight()) : (int)((double)nArray[i - 1][1] + RenderGraphicsToolkit.getBounds((String)vector.get(i), font).getHeight());
            Painter.drawText(graphics, (String)vector.get(i), nArray[i][0], nArray[i][1]);
        }
    }

    private static void black(Graphics graphics, int n, Rectangle rectangle, Color color) {
        int n2;
        Color color2 = color == null ? new Color(Integer.parseInt("808080", 16)) : color;
        int n3 = -30;
        int n4 = 50;
        if (color == null) {
            graphics.setColor(RenderGraphicsToolkit.highlight(color2, n3));
        } else {
            graphics.setColor(color2);
        }
        for (n2 = 0; n2 < n; ++n2) {
            graphics.drawLine(rectangle.x + n2, rectangle.y + n2, rectangle.x + rectangle.width - 1 - n2, rectangle.y + n2);
        }
        for (n2 = 0; n2 < n; ++n2) {
            graphics.drawLine(rectangle.x + n2, rectangle.y + n2, rectangle.x + n2, rectangle.y + rectangle.height - 1 - n2);
        }
        if (color == null) {
            graphics.setColor(RenderGraphicsToolkit.highlight(color2, n4));
        } else {
            graphics.setColor(color2);
        }
        for (n2 = 0; n2 < n; ++n2) {
            graphics.drawLine(rectangle.x + n2, rectangle.y + rectangle.height - 1 - n2, rectangle.x + rectangle.width - 1 - n2, rectangle.y + rectangle.height - 1 - n2);
        }
        for (n2 = 0; n2 < n; ++n2) {
            graphics.drawLine(rectangle.x + rectangle.width - 1 - n2, rectangle.y + n2, rectangle.x + rectangle.width - 1 - n2, rectangle.y + rectangle.height - 1 - n2);
        }
    }

    private static void clipString(Graphics graphics, int n, Rectangle rectangle) {
        int n2;
        Color color = new Color(Integer.parseInt("808080", 16));
        int n3 = -30;
        int n4 = 50;
        graphics.setColor(RenderGraphicsToolkit.highlight(color, n4));
        for (n2 = 0; n2 < n; ++n2) {
            graphics.drawLine(rectangle.x + n2, rectangle.y + n2, rectangle.x + rectangle.width - 1 - n2, rectangle.y + n2);
        }
        for (n2 = 0; n2 < n; ++n2) {
            graphics.drawLine(rectangle.x + n2, rectangle.y + n2, rectangle.x + n2, rectangle.y + rectangle.height - 1 - n2);
        }
        graphics.setColor(RenderGraphicsToolkit.highlight(color, n3));
        for (n2 = 0; n2 < n; ++n2) {
            graphics.drawLine(rectangle.x + n2, rectangle.y + rectangle.height - 1 - n2, rectangle.x + rectangle.width - 1 - n2, rectangle.y + rectangle.height - 1 - n2);
        }
        for (n2 = 0; n2 < n; ++n2) {
            graphics.drawLine(rectangle.x + rectangle.width - 1 - n2, rectangle.y + n2, rectangle.x + rectangle.width - 1 - n2, rectangle.y + rectangle.height - 1 - n2);
        }
    }

    public static void waitImage(Image image) {
        block3: {
            MediaTracker mediaTracker = new MediaTracker(new Container());
            if (image != null) {
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForID(0);
                }
                catch (InterruptedException interruptedException) {
                    if (!JRLog.isError(2)) break block3;
                    JRLog.error(2, "wait image error.", (Throwable)interruptedException);
                }
            }
        }
    }

    public static Font getFont(String string, int n, float f) {
        Font font = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(n);
        stringBuffer.append((int)(f * 10.0f));
        String string2 = stringBuffer.toString();
        font = (Font)abs.get(string2);
        if (font == null) {
            font = FontSets.getFont(string, n, f);
            abs.put(string2, font);
        }
        return font;
    }

    public static boolean checkConditionNLS(DSField dSField) {
        Propertiable propertiable = dSField.getTemplate().getPropertyByName("FontFace");
        return propertiable != null && propertiable.isChagneByFmtt();
    }
}

