/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;
import jet.datastream.DSField;
import jet.datastream.DSFilterControl;
import jet.datastream.DSMultiValueContainer;
import jet.datastream.render.Render;
import jet.datastream.render.RenderCreator;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.RenderUtil;
import jet.util.IntVector;

public class RenderList
extends Render {
    private Vector DEFAULT_SHADOW_WIDTH;
    private Vector I;
    private Vector SEDU;
    private Vector Z;
    private boolean addElement;
    private Color black = Color.white;
    private Color booleanValue = Color.black;
    private IntVector convertPixelToUnit = new IntVector();
    private DSMultiValueContainer convertUnitToPixel;
    private DSFilterControl drawBorder;

    public RenderList(DSField dSField) {
        this.dsField = dSField;
        this.resolution = dSField.getResolution();
    }

    public RenderList(DSMultiValueContainer dSMultiValueContainer) {
        this.convertUnitToPixel = dSMultiValueContainer;
        this.resolution = dSMultiValueContainer.getResolution();
    }

    public RenderList(DSFilterControl dSFilterControl) {
        this.drawBorder = dSFilterControl;
        this.resolution = dSFilterControl.getResolution();
    }

    @Override
    protected void calculateAutoSize() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.DEFAULT_SHADOW_WIDTH.size(); ++i) {
            int n3 = Unit.convertPixelToUnit((int)RenderGraphicsToolkit.getBounds((String)this.DEFAULT_SHADOW_WIDTH.get(i), this.font).getWidth(), this.resolution) + 4;
            int n4 = Unit.convertPixelToUnit((int)RenderGraphicsToolkit.getBounds((String)this.DEFAULT_SHADOW_WIDTH.get(i), this.font).getHeight(), this.resolution) + 4;
            if (n < n3) {
                n = n3;
            }
            n2 += n4;
        }
        this.width = n;
        this.height = n2;
    }

    @Override
    protected void paintConcreteRender(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = new Color(200, 200, 200);
        Color color2 = null;
        int n5 = -1;
        int n6 = 0;
        String string = "";
        boolean bl = false;
        if (this.convertUnitToPixel != null) {
            this.booleanValue = RenderUtil.getColorPropertyByName(this.convertUnitToPixel, "Foreground");
            this.black = RenderUtil.getColorPropertyByName(this.convertUnitToPixel, "Background");
        } else if (this.drawBorder != null) {
            this.booleanValue = RenderUtil.getColorPropertyByName(this.drawBorder, "Foreground");
            this.black = RenderUtil.getColorPropertyByName(this.drawBorder, "Background");
            color = new Color(16758122);
            if (this.drawBorder.isShowTitle()) {
                string = this.drawBorder.getTitleText();
                n6 = Unit.convertUnitToPixel(this.drawBorder.getTitleHeight());
                Color color3 = (Color)this.drawBorder.getPropertyByName("TitleBackground").getObject();
                Color color4 = (Color)this.drawBorder.getPropertyByName("TitleForeground").getObject();
                Font font = this.drawBorder.getTitleFont();
                n5 = Unit.convertUnitToPixel((Integer)this.drawBorder.getPropertyByName("BorderWidth").getObject());
                color2 = (Color)this.drawBorder.getPropertyByName("BorderColor").getObject();
                boolean bl2 = RenderUtil.getBooleanPropertyByName(this.drawBorder, "TitleUnderline");
                RenderGraphicsToolkit.paintTitle(string, graphics, color3, color4, font, new Rectangle(n, n2, n3, n6), bl2);
            }
            bl = RenderUtil.getBooleanPropertyByName(this.drawBorder, "Underline");
        }
        RenderGraphicsToolkit.paintList(graphics, this.DEFAULT_SHADOW_WIDTH, this.convertPixelToUnit, this.font, n, n2 + n6, n3, n4 - n6, this.addElement, this.booleanValue, this.black, color, this.SEDU, n5, color2, bl);
        this.DEFAULT_SHADOW_WIDTH(graphics);
    }

    private void DEFAULT_SHADOW_WIDTH(Graphics graphics) {
        boolean bl;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Color color;
        Color color2;
        Color color3;
        int n7;
        if (this.convertUnitToPixel == null && this.drawBorder == null) {
            return;
        }
        Rectangle rectangle = null;
        if (this.convertUnitToPixel != null) {
            n7 = this.convertUnitToPixel.getResolution();
            rectangle = new Rectangle(0, 0, Unit.convertUnitToPixel(this.convertUnitToPixel.getWidth(), n7), Unit.convertUnitToPixel(this.convertUnitToPixel.getHeight(), n7));
            color3 = RenderUtil.getColorPropertyByName(this.convertUnitToPixel, "Background");
            color2 = RenderUtil.getColorPropertyByName(this.convertUnitToPixel, "BorderColor");
            color = RenderUtil.getColorPropertyByName(this.convertUnitToPixel, "ShadowColor");
            n6 = RenderUtil.getIntPropertyByName(this.convertUnitToPixel, "LeftLine");
            n5 = RenderUtil.getIntPropertyByName(this.convertUnitToPixel, "RightLine");
            n4 = RenderUtil.getIntPropertyByName(this.convertUnitToPixel, "TopLine");
            n3 = RenderUtil.getIntPropertyByName(this.convertUnitToPixel, "BottomLine");
            n2 = RenderUtil.getIntPropertyByName(this.convertUnitToPixel, "BorderWidth");
            n = Unit.convertUnitToPixel(RenderCreator.DEFAULT_SHADOW_WIDTH, n7);
            bl = RenderUtil.getBooleanPropertyByName(this.convertUnitToPixel, "Shadow");
        } else {
            n7 = this.drawBorder.getResolution();
            rectangle = new Rectangle(0, 0, Unit.convertUnitToPixel(this.drawBorder.getWidth(), n7), Unit.convertUnitToPixel(this.drawBorder.getHeight(), n7));
            color3 = RenderUtil.getColorPropertyByName(this.drawBorder, "Background");
            color2 = RenderUtil.getColorPropertyByName(this.drawBorder, "BorderColor");
            n6 = RenderUtil.getIntPropertyByName(this.drawBorder, "LeftLine");
            n5 = RenderUtil.getIntPropertyByName(this.drawBorder, "RightLine");
            n4 = RenderUtil.getIntPropertyByName(this.drawBorder, "TopLine");
            n3 = RenderUtil.getIntPropertyByName(this.drawBorder, "BottomLine");
            n2 = RenderUtil.getIntPropertyByName(this.drawBorder, "BorderWidth");
            n = Unit.convertUnitToPixel(RenderCreator.DEFAULT_SHADOW_WIDTH, n7);
            bl = this.drawBorder.getPropertyByName("Shadow") != null ? (Boolean)this.drawBorder.getPropertyByName("Shadow").getObject() : false;
            color = this.drawBorder.getPropertyByName("ShadowColor") != null ? (Color)this.drawBorder.getPropertyByName("ShadowColor").getObject() : null;
        }
        boolean bl2 = color3 != null;
        Color color4 = graphics.getColor();
        RenderGraphicsToolkit.drawBorder(graphics, rectangle, bl2 ? color3 : null, color2, Unit.convertUnitToPixel(n2, n7), n4, n3, n6, n5, bl, color, n);
        graphics.setColor(color4);
    }

    public boolean isDisabled() {
        return this.addElement;
    }

    public void setDisabled(boolean bl) {
        this.addElement = bl;
    }

    public Vector getTexts() {
        return this.DEFAULT_SHADOW_WIDTH;
    }

    public void setTexts(Vector vector) {
        this.DEFAULT_SHADOW_WIDTH = vector;
    }

    public Vector getValues() {
        return this.I;
    }

    public void setValues(Vector vector) {
        this.I = vector;
    }

    public Vector getSelectedValues() {
        return this.Z;
    }

    public void setSelectedValues(Vector vector) {
        this.Z = vector;
    }

    public Vector getSelectedText() {
        return this.SEDU;
    }

    public void setSelectedText(Vector vector) {
        this.SEDU = vector;
    }

    public void setIndex(int n) {
        this.convertPixelToUnit.addElement(n);
    }

    @Override
    public void paintFieldBackground(Graphics graphics) {
        if (this.convertUnitToPixel == null && this.drawBorder == null) {
            super.paintFieldBackground(graphics);
        } else if (this.drawBorder != null) {
            Rectangle rectangle = null;
            rectangle = new Rectangle(0, 0, Unit.convertUnitToPixel(this.drawBorder.getWidth(), this.resolution), Unit.convertUnitToPixel(this.drawBorder.getHeight(), this.resolution));
            Color color = RenderUtil.getColorPropertyByName(this.drawBorder, "Background");
            if (color != null) {
                graphics.setColor(color);
                int n = Unit.convertUnitToPixel(this.shadowWidth, this.resolution);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width - n, rectangle.height - n);
            }
        }
    }

    @Override
    protected void calculatePadding(Render.Box box) {
        box.x = 0;
        box.y = 0;
        if (this.drawBorder != null) {
            box.I = this.dsFieldWidth = this.drawBorder.getWidth();
            box.Z = this.dsFieldHeight = this.drawBorder.getHeight();
        } else {
            box.I = this.dsFieldWidth = this.dsField.getWidth();
            box.Z = this.dsFieldHeight = this.dsField.getHeight();
        }
        box.x += this.leftPadding;
        box.I -= this.leftPadding + this.rightPadding;
        box.y += this.topPadding;
        box.Z -= this.topPadding + this.bottomPadding;
        if (this.leftStyle != 0) {
            this.lGap = (this.leftStyle == 5 ? 3 : 1) * this.borderWidth;
            box.x += this.lGap;
            box.I -= this.lGap;
        }
        if (this.topStyle != 0) {
            this.tGap = (this.topStyle == 5 ? 3 : 1) * this.borderWidth;
            box.y += this.tGap;
            box.Z -= this.tGap;
        }
        if (this.rightStyle != 0) {
            this.rGap = (this.rightStyle == 5 ? 3 : 1) * this.borderWidth;
            box.I -= this.rGap;
        }
        if (this.bottomStyle != 0) {
            this.bGap = (this.bottomStyle == 5 ? 3 : 1) * this.borderWidth;
            box.Z -= this.bGap;
        }
        box.I = box.I - (this.isShadow ? this.shadowWidth : 0);
        box.Z = box.Z - (this.isShadow ? this.shadowWidth : 0);
    }
}

