/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls;

import java.io.IOException;
import jet.export.excel.api.PageInfoSetup;
import jet.export.excel.api.PaperSize;
import jet.export.excel.imp.xls.Biff;
import util.RandomAccessStream;

class Setup
extends Biff
implements PageInfoSetup {
    short I = 0;
    short SEDU = (short)100;
    short doubleToLongBits = 1;
    short getIndex = 1;
    short longBitsToDouble = 1;
    short output;
    short readLong = (short)1200;
    short readShort = (short)1200;
    short writeLong = 1;
    double writeShort = 0.5;
    double Z = 0.5;
    private boolean C = false;
    private String B;
    private String D;

    public Setup() {
        this.length = 34;
        this.I(true);
        this.doubleToLongBits(false);
        this.SEDU(true);
    }

    public Setup(short s, short s2, short s3, short s4, short s5, short s6, short s7, short s8, double d, double d2, short s9) {
        this();
        this.I = s;
        this.SEDU = s2;
        this.doubleToLongBits = s3;
        this.getIndex = s4;
        this.longBitsToDouble = s5;
        this.output = s6;
        this.readLong = s7;
        this.readShort = s8;
        this.writeShort = d;
        this.Z = d2;
        this.writeLong = s9;
    }

    @Override
    public final int opcode() {
        return 161;
    }

    @Override
    public int output(RandomAccessStream randomAccessStream) throws IOException {
        super.output(randomAccessStream);
        this.writeShort(randomAccessStream, this.I);
        this.writeShort(randomAccessStream, this.SEDU);
        this.writeShort(randomAccessStream, this.doubleToLongBits);
        this.writeShort(randomAccessStream, this.getIndex);
        this.writeShort(randomAccessStream, this.longBitsToDouble);
        this.writeShort(randomAccessStream, this.output);
        this.writeShort(randomAccessStream, this.readLong);
        this.writeShort(randomAccessStream, this.readShort);
        this.writeLong(randomAccessStream, Double.doubleToLongBits(this.writeShort));
        this.writeLong(randomAccessStream, Double.doubleToLongBits(this.Z));
        this.writeShort(randomAccessStream, this.writeLong);
        return this.length + 4;
    }

    @Override
    public void input(RandomAccessStream randomAccessStream) throws IOException {
        this.I = this.readShort(randomAccessStream);
        this.SEDU = this.readShort(randomAccessStream);
        this.doubleToLongBits = this.readShort(randomAccessStream);
        this.getIndex = this.readShort(randomAccessStream);
        this.longBitsToDouble = this.readShort(randomAccessStream);
        this.output = this.readShort(randomAccessStream);
        this.readLong = this.readShort(randomAccessStream);
        this.readShort = this.readShort(randomAccessStream);
        this.writeShort = Double.longBitsToDouble(this.readLong(randomAccessStream));
        this.Z = Double.longBitsToDouble(this.readLong(randomAccessStream));
        this.writeLong = this.readShort(randomAccessStream);
    }

    private void I(boolean bl) {
        this.output = (short)(bl ? this.output | 4 : this.output & 0xFFFFFFFB);
    }

    private void SEDU(boolean bl) {
        this.output = (short)(bl ? this.output | 0x40 : this.output & 0xFFFFFFBF);
    }

    private void doubleToLongBits(boolean bl) {
        this.output = (short)(bl ? this.output | 0x80 : this.output & 0xFFFFFF7F);
    }

    public boolean getLeftToRight() {
        return (this.output & 1) == 1;
    }

    public boolean getLandscape() {
        return (this.output & 2) != 2;
    }

    public boolean getNoPls() {
        return (this.output & 4) == 4;
    }

    public boolean getNoColor() {
        return (this.output & 8) == 8;
    }

    public boolean getDraft() {
        return (this.output & 0x10) == 16;
    }

    public boolean getNotes() {
        return (this.output & 0x20) == 32;
    }

    public boolean getNoOrient() {
        return (this.output & 0x40) == 64;
    }

    public boolean getUsePage() {
        return (this.output & 0x80) == 128;
    }

    @Override
    public void setPaperSize(PaperSize paperSize) {
        if (paperSize != null) {
            this.I = paperSize.getIndex();
            this.I(false);
        }
    }

    @Override
    public void setScale(short s) {
        if (s >= 10 && s <= 400) {
            this.SEDU = s;
            this.I(false);
        }
    }

    @Override
    public void setPageStart(short s) {
        if (s <= Short.MAX_VALUE && s >= -32765) {
            this.doubleToLongBits = s;
            this.doubleToLongBits(true);
        }
    }

    @Override
    public void setFitHeight(short s) {
        if (s >= 1 && s <= Short.MAX_VALUE) {
            this.longBitsToDouble = s;
        }
    }

    @Override
    public void setFitWidth(short s) {
        if (s >= 1 && s <= Short.MAX_VALUE) {
            this.getIndex = s;
        }
    }

    @Override
    public void setPrintOrder(boolean bl) {
        this.output = (short)(bl ? this.output | 1 : this.output & 0xFFFFFFFE);
    }

    @Override
    public void setIsLandscape(boolean bl) {
        if (bl) {
            this.SEDU(false);
            this.I(false);
            this.output = (short)(this.output & 0xFFFFFFFD);
        } else {
            this.SEDU(true);
            this.output = (short)(this.output | 2);
        }
    }

    @Override
    public void setIsNoColor(boolean bl) {
        this.output = (short)(bl ? this.output | 8 : this.output & 0xFFFFFFF7);
    }

    @Override
    public void setIsDraftPrint(boolean bl) {
        this.output = (short)(bl ? this.output | 0x10 : this.output & 0xFFFFFFEF);
    }

    private void getIndex(boolean bl) {
        this.output = (short)(bl ? this.output | 0x20 : this.output & 0xFFFFFFDF);
    }

    @Override
    public void setPrintCommentFormat(byte by) {
        if (by != 0) {
            this.getIndex(true);
            this.output = (short)(by == 1 ? this.output | 0x200 : this.output & 0xFFFFFDFF);
        } else {
            this.getIndex(false);
        }
    }

    @Override
    public void setPrintErrorFormat(byte by) {
        switch (by) {
            case 1: {
                this.output = (short)(this.output | 0xF7FF);
                break;
            }
            case 2: {
                this.output = (short)(this.output | 0xFBFF);
                break;
            }
            case 3: {
                this.output = (short)(this.output | 0xFFFF);
                break;
            }
            default: {
                this.output = (short)(this.output | 0xF3FF);
            }
        }
    }

    @Override
    public void setPrintDPI(int n) {
        this.readLong = (short)n;
        this.readShort = (short)n;
        this.I(false);
    }

    @Override
    public void setFooterMargin(short s) {
        if (s >= 0 && s <= 3528) {
            this.Z = (double)s / 72.0;
        }
    }

    @Override
    public void setHeaderMargin(short s) {
        if (s >= 0 && s <= 3528) {
            this.writeShort = (double)s / 72.0;
        }
    }

    @Override
    public void setIsPrintGridlines(boolean bl) {
        this.C = bl;
    }

    boolean I() {
        return this.C;
    }

    String Z() {
        return this.B;
    }

    @Override
    public void setPrinterFooter(String string) {
        this.D = string;
    }

    @Override
    public void setPrinterHeader(String string) {
        this.B = string;
    }

    public String getPrintFooter() {
        return this.D;
    }
}

