/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls;

import com.jinfonet.resstore.OutOfSpaceException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import jet.export.excel.api.DocumentException;
import jet.export.excel.imp.xls.CacheClear;
import jet.export.excel.imp.xls.Worksheet;
import jet.export.util.Cache;
import util.RandomAccessStream;

class SheetCache
implements CacheClear {
    private Worksheet[] SEDU;
    private Cache add;
    private int arraycopy = 0;
    private List clear = new ArrayList();
    private RandomAccessStream close = new RandomAccessStream();
    private Hashtable currentTimeMillis = new Hashtable();
    private Hashtable delete = new Hashtable();
    private int fileUpdated = 0;

    SheetCache(int n, Cache cache) {
        if (n <= 1) {
            n = 4;
        }
        this.SEDU = new Worksheet[n];
        this.add = cache;
    }

    public void addSheet(Worksheet worksheet) throws DocumentException {
        if (this.arraycopy < this.SEDU.length) {
            this.SEDU[this.arraycopy] = worksheet;
            ++this.arraycopy;
        } else {
            this.close(worksheet);
        }
        if (this.fileUpdated < this.clear.size() && this.SEDU.length < 8) {
            Worksheet[] worksheetArray = new Worksheet[8];
            System.arraycopy(this.SEDU, 0, worksheetArray, 0, this.SEDU.length);
            this.SEDU = worksheetArray;
        }
        this.clear.add(worksheet);
    }

    private int SEDU() throws DocumentException {
        int n = this.arraycopy - 1;
        long l = 0L;
        long l2 = System.currentTimeMillis();
        int n2 = this.arraycopy;
        while (--n2 >= 0) {
            Worksheet worksheet = this.SEDU[n2];
            if (worksheet.F()) {
                n = n2;
                break;
            }
            long l3 = l2 - worksheet.C();
            if (l3 <= l) continue;
            l = l3;
            n = n2;
        }
        Worksheet worksheet = this.SEDU[n];
        try {
            if (!worksheet.F()) {
                if (worksheet.B()) {
                    this.arraycopy(worksheet);
                } else {
                    this.add(worksheet);
                }
            }
        }
        catch (IOException iOException) {
            throw new DocumentException(iOException);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            throw new DocumentException(outOfSpaceException);
        }
        return n;
    }

    private void add(Worksheet worksheet) throws IOException, OutOfSpaceException {
        Integer n = worksheet.hashCode();
        RandomAccessFileInfo randomAccessFileInfo = (RandomAccessFileInfo)this.currentTimeMillis.get(n);
        if (randomAccessFileInfo == null) {
            File file = this.add.getNextTemporaryFile();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFileInfo = new RandomAccessFileInfo(randomAccessFile, file);
            this.currentTimeMillis.put(n, randomAccessFileInfo);
            this.close.seek(0);
            worksheet.I(randomAccessFile, this.close);
            this.add.fileUpdated(file);
        } else {
            worksheet.clear();
        }
    }

    private void arraycopy(Worksheet worksheet) throws IOException, DocumentException, OutOfSpaceException {
        RandomAccessFile randomAccessFile;
        File file;
        Integer n = worksheet.hashCode();
        RandomAccessFileInfo randomAccessFileInfo = (RandomAccessFileInfo)this.currentTimeMillis.get(n);
        if (randomAccessFileInfo == null) {
            file = this.add.getNextTemporaryFile();
            randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFileInfo = new RandomAccessFileInfo(randomAccessFile, file);
            this.currentTimeMillis.put(n, randomAccessFileInfo);
        }
        randomAccessFile = randomAccessFileInfo.getStream();
        file = randomAccessFileInfo.getFile();
        randomAccessFile.seek(0L);
        this.close.seek(0);
        Integer n2 = worksheet.D();
        this.delete.put(n, n2);
        worksheet.I(randomAccessFile, this.close);
        this.add.fileUpdated(file);
    }

    @Override
    public void clear() {
        this.SEDU = null;
        this.close = null;
        this.clear.clear();
        this.clear = null;
        Enumeration enumeration = this.currentTimeMillis.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            RandomAccessFileInfo randomAccessFileInfo = (RandomAccessFileInfo)this.currentTimeMillis.remove(n);
            File file = randomAccessFileInfo.getFile();
            this.add.delete(file);
        }
        this.currentTimeMillis = null;
    }

    public void readSheet(Integer n) throws IOException, DocumentException {
        RandomAccessFileInfo randomAccessFileInfo = (RandomAccessFileInfo)this.currentTimeMillis.remove(n);
        RandomAccessFile randomAccessFile = randomAccessFileInfo.getStream();
        Worksheet worksheet = this.clear(n);
        randomAccessFile.seek(0L);
        this.close.seek(0);
        worksheet.Z(randomAccessFile, this.close);
        randomAccessFile.close();
        this.close(worksheet);
    }

    public int getLength(Integer n) {
        return (Integer)this.delete.get(n);
    }

    private Worksheet clear(Integer n) {
        Worksheet worksheet = null;
        int n2 = n;
        for (int i = 0; i < this.clear.size() && (worksheet = (Worksheet)this.clear.get(i)).hashCode() != n2; ++i) {
            worksheet = null;
        }
        return worksheet;
    }

    private void close(Worksheet worksheet) throws DocumentException {
        this.SEDU[this.SEDU()] = worksheet;
    }

    @Override
    public void addOneSheetToBook() {
        ++this.fileUpdated;
    }

    class RandomAccessFileInfo {
        private RandomAccessFile SEDU;
        private File I;

        RandomAccessFileInfo(RandomAccessFile randomAccessFile, File file) {
            this.SEDU = randomAccessFile;
            this.I = file;
        }

        public RandomAccessFile getStream() {
            return this.SEDU;
        }

        public File getFile() {
            return this.I;
        }
    }
}

