/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls.chart;

import java.awt.Color;
import java.io.IOException;
import jet.export.excel.imp.xls.Biff;
import jet.export.excel.imp.xls.ColorTable;
import util.RandomAccessStream;

public class AreaFormat
extends Biff {
    public static final short AUTOFORMAT = 1;
    public static final short SWAP = 2;
    public static final short ROUND = 2;
    short SEDU;
    short addColor;
    short black;
    short getColorRGB;
    int needUpdateIndex;
    int output;
    private ColorTable readInt;

    public AreaFormat(ColorTable colorTable) {
        this.readInt = colorTable;
        this.length = 16;
    }

    public AreaFormat(Color color, Color color2, short s, ColorTable colorTable) {
        this(colorTable);
        if (color != null) {
            this.needUpdateIndex = colorTable.getColorRGB(color);
            this.black = colorTable.addColor(color);
        } else {
            this.needUpdateIndex = 0;
            this.black = colorTable.addColor(Color.black);
        }
        if (color2 != null) {
            this.output = colorTable.getColorRGB(color2);
            this.getColorRGB = colorTable.addColor(color2);
        } else {
            this.output = 0;
            this.getColorRGB = colorTable.addColor(Color.black);
        }
        this.SEDU = s;
    }

    public void setIsRound(boolean bl) {
        this.addColor = (short)(bl ? this.addColor | 2 : this.addColor & 0xFFFFFFFD);
    }

    public AreaFormat(int n, int n2, short s, short s2, short s3, short s4, ColorTable colorTable) {
        this(colorTable);
        this.needUpdateIndex = n;
        this.output = n2;
        this.SEDU = s;
        this.addColor = s2;
        this.black = s3;
        this.getColorRGB = s4;
    }

    @Override
    public final int opcode() {
        return 4106;
    }

    @Override
    public int output(RandomAccessStream randomAccessStream) throws IOException {
        super.output(randomAccessStream);
        if (this.readInt.needUpdateIndex()) {
            if (this.black > 0) {
                this.black = this.readInt.updateColorIndex(this.black);
            }
            if (this.getColorRGB > 0) {
                this.getColorRGB = this.readInt.updateColorIndex(this.getColorRGB);
            }
        }
        this.writeInt(randomAccessStream, this.needUpdateIndex);
        this.writeInt(randomAccessStream, this.output);
        this.writeShort(randomAccessStream, this.SEDU);
        this.writeShort(randomAccessStream, this.addColor);
        this.writeShort(randomAccessStream, this.black);
        this.writeShort(randomAccessStream, this.getColorRGB);
        return this.length + 4;
    }

    @Override
    public void input(RandomAccessStream randomAccessStream) throws IOException {
        this.needUpdateIndex = this.readInt(randomAccessStream);
        this.output = this.readInt(randomAccessStream);
        this.SEDU = this.readShort(randomAccessStream);
        this.addColor = this.readShort(randomAccessStream);
        this.black = this.readShort(randomAccessStream);
        this.getColorRGB = this.readShort(randomAccessStream);
    }

    public void setPattern(short s) {
        this.SEDU = s;
    }

    public short getPattern() {
        return this.SEDU;
    }

    public boolean isAutoFormat() {
        return (this.addColor & 1) == 1;
    }

    public void setAutoFormat(boolean bl) {
        this.addColor = (short)(bl ? this.addColor | 1 : this.addColor & 0xFFFFFFFE);
    }

    public boolean isSwap() {
        return (this.addColor & 2) == 2;
    }

    public int getIcvFore() {
        return this.black;
    }

    public int getIcvBack() {
        return this.getColorRGB;
    }
}

