/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls.objWrapper;

import jet.export.excel.api.CellStyle;
import jet.export.excel.api.HyperLink;
import jet.export.excel.imp.xls.GlobalWorksheet;
import jet.export.excel.imp.xls.HLink;
import jet.export.excel.imp.xls.HyperLinkInfo;
import jet.export.excel.imp.xls.Xf;
import jet.export.excel.imp.xls.objWrapper.BlankCellWriter;

public class BlankCellObj
implements BlankCellWriter {
    protected int r;
    protected int c;
    protected int rsp = 1;
    protected int csp = 1;
    protected GlobalWorksheet gws;
    protected HyperLinkInfo link;
    protected CellStyle style;
    protected boolean reuse = false;

    public BlankCellObj(GlobalWorksheet globalWorksheet) {
        this.gws = globalWorksheet;
    }

    public boolean canBeReuse() {
        return this.reuse;
    }

    @Override
    public void setCanBeReuse(boolean bl) {
        this.reuse = bl;
        if (bl) {
            this.setAsDefault();
        }
    }

    protected void setAsDefault() {
        if (this.link != null) {
            this.link.setCanBeReuse(true);
            this.link = null;
        }
        this.style = null;
        this.rsp = 1;
        this.csp = 1;
    }

    public void setRowCol(int n, int n2) {
        this.r = n;
        this.c = n2;
    }

    @Override
    public void setRowSpan(int n) {
        if (n < 1) {
            n = 1;
        }
        this.rsp = n;
    }

    @Override
    public void setColSpan(int n) {
        if (n < 1) {
            n = 1;
        }
        this.csp = n;
    }

    @Override
    public int getRowSpan() {
        return this.rsp;
    }

    @Override
    public int getColSpan() {
        return this.csp;
    }

    @Override
    public CellStyle getCellStyle() {
        return this.style;
    }

    @Override
    public byte getCellType() {
        return 0;
    }

    @Override
    public int getCol() {
        return this.c;
    }

    @Override
    public HLink getLink() {
        if (this.link != null) {
            return new HLink(this.getRow(), this.getRow() + this.getRowSpan() - 1, (short)this.c, (short)(this.c + this.getColSpan() - 1), this.link.getLinkString(), this.link.getType(), this.link.getToolTip());
        }
        return null;
    }

    @Override
    public HyperLink getHyperLink() {
        return this.link;
    }

    @Override
    public int getRow() {
        return this.r;
    }

    @Override
    public void setCellStyle(CellStyle cellStyle) {
        this.style = cellStyle;
    }

    @Override
    public void setHyperLink(HyperLink hyperLink) {
        this.link = (HyperLinkInfo)hyperLink;
    }

    @Override
    public short getXfIdx() {
        if (this.style == null) {
            return 0;
        }
        return (short)this.gws.getXfIndex((Xf)this.style);
    }

    @Override
    public boolean isInvalid() {
        return this.r > 65535 || this.c > 255;
    }
}

