/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import com.jinfonet.util.JRLog;
import java.awt.Color;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.api.SparklineGroup;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.util.Util;

public class SparklineGroupImp
implements SparklineGroup {
    private Vector SEDU = new Vector();
    private Color add = null;
    private String append = null;
    private byte colNumToStr = 0;
    private double get = 0.0;
    private boolean getRGB = false;
    private byte intValue = 0;
    private double isTrace = 0.0;
    private boolean size = false;
    private byte toHexString = 0;
    private double toString = 0.75;

    @Override
    public void setSeriesColor(Color color) {
        this.add = color;
    }

    @Override
    public void setDateAxisRange(String string) {
        this.append = string;
    }

    @Override
    public void setVerticalAxisMaxType(byte by) {
        this.colNumToStr = by;
    }

    @Override
    public void setVerticalAxisMax(double d) {
        this.get = d;
        this.getRGB = true;
    }

    @Override
    public void setVerticalAxisMinType(byte by) {
        this.intValue = by;
    }

    @Override
    public void setVerticalAxisMin(double d) {
        this.isTrace = d;
        this.size = true;
    }

    @Override
    public void setSparklineType(byte by) {
        this.toHexString = by;
    }

    @Override
    public void addSparkline(String string, int n, int n2) {
        this.SEDU.add(new Object[]{string, n, n2});
    }

    void write(XMLStreamWriter xMLStreamWriter) throws XlsxDocumentException {
        try {
            xMLStreamWriter.writeStartElement("x14", "sparklineGroup", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
            if (this.append != null) {
                xMLStreamWriter.writeAttribute("dateAxis", "1");
            }
            if (this.colNumToStr == 2 && !this.getRGB) {
                this.colNumToStr = 0;
            }
            if (this.colNumToStr != 0) {
                switch (this.colNumToStr) {
                    case 1: {
                        xMLStreamWriter.writeAttribute("maxAxisType", "group");
                        break;
                    }
                    case 2: {
                        xMLStreamWriter.writeAttribute("maxAxisType", "custom");
                        xMLStreamWriter.writeAttribute("manualMax", String.valueOf(this.get));
                    }
                }
            }
            if (this.intValue == 2 && !this.size) {
                this.intValue = 0;
            }
            if (this.intValue != 0) {
                switch (this.intValue) {
                    case 1: {
                        xMLStreamWriter.writeAttribute("minAxisType", "group");
                        break;
                    }
                    case 2: {
                        xMLStreamWriter.writeAttribute("minAxisType", "custom");
                        xMLStreamWriter.writeAttribute("manualMin", String.valueOf(this.isTrace));
                    }
                }
            }
            if (this.toHexString != 0) {
                switch (this.toHexString) {
                    case 1: {
                        xMLStreamWriter.writeAttribute("type", "column");
                        break;
                    }
                    case 2: {
                        xMLStreamWriter.writeAttribute("type", "stacked");
                    }
                }
            }
            if (this.toString != 0.75) {
                xMLStreamWriter.writeAttribute("lineWeight", String.valueOf(this.toString));
            }
            if (this.add != null) {
                xMLStreamWriter.writeEmptyElement("x14", "colorSeries", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
                xMLStreamWriter.writeAttribute("rgb", Integer.toHexString(this.add.getRGB()).toUpperCase());
            }
            if (this.append != null) {
                xMLStreamWriter.writeStartElement("xm", "f", "http://schemas.microsoft.com/office/excel/2006/main");
                xMLStreamWriter.writeCharacters(this.append);
                xMLStreamWriter.writeEndElement();
            }
            xMLStreamWriter.writeStartElement("x14", "sparklines", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
            if (this.SEDU.size() == 0) {
                throw new RuntimeException("The sparkline count of a group must be at least 1.");
            }
            for (int i = 0; i < this.SEDU.size(); ++i) {
                xMLStreamWriter.writeStartElement("x14", "sparkline", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
                Object[] objectArray = (Object[])this.SEDU.get(i);
                String string = (String)objectArray[0];
                int n = (Integer)objectArray[1];
                int n2 = (Integer)objectArray[2];
                xMLStreamWriter.writeStartElement("xm", "f", "http://schemas.microsoft.com/office/excel/2006/main");
                xMLStreamWriter.writeCharacters(string);
                xMLStreamWriter.writeEndElement();
                xMLStreamWriter.writeStartElement("xm", "sqref", "http://schemas.microsoft.com/office/excel/2006/main");
                xMLStreamWriter.writeCharacters(Util.colNumToStr(n2) + (n + 1));
                xMLStreamWriter.writeEndElement();
                xMLStreamWriter.writeEndElement();
            }
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    @Override
    public void setLineWeight(double d) {
        if (d < 0.0 || d > 1584.0) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Xlsx API: Invalid parameter " + d + " (SparklineGroupImp.setLineWeight(double))");
            }
            return;
        }
        this.toString = d;
    }
}

