/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx.chart;

import com.jinfonet.util.JRLog;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.api.chart.Area3DType;
import jet.export.excel.api.chart.Series1VInfo;
import jet.export.excel.imp.xlsx.NoneRelsPart;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.chart.AreaSeries;
import jet.export.excel.imp.xlsx.chart.Common3DChartType;

public class Area3DChartType
extends Common3DChartType
implements Area3DType {
    private byte SEDU = 0;
    private short add = (short)-1;

    public Area3DChartType() {
        super("area3DChart");
    }

    @Override
    public boolean supportsXCategoryAxis() {
        return true;
    }

    @Override
    public boolean supportsXValueAxis() {
        return false;
    }

    @Override
    public boolean supportsYValueAxis() {
        return true;
    }

    @Override
    public boolean supportsZSeriesAxis() {
        return this.SEDU == 0;
    }

    @Override
    void write1stSpecificProps(XMLStreamWriter xMLStreamWriter, NoneRelsPart noneRelsPart) throws XlsxDocumentException {
        try {
            xMLStreamWriter.writeEmptyElement("c", "grouping", "http://schemas.openxmlformats.org/drawingml/2006/chart");
            switch (this.SEDU) {
                case 6: {
                    xMLStreamWriter.writeAttribute("val", "percentStacked");
                    break;
                }
                case 2: {
                    xMLStreamWriter.writeAttribute("val", "stacked");
                    break;
                }
                case 0: {
                    xMLStreamWriter.writeAttribute("val", "standard");
                    break;
                }
                default: {
                    xMLStreamWriter.writeAttribute("val", "standard");
                    break;
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    @Override
    void write2ndSpecificProps(XMLStreamWriter xMLStreamWriter, NoneRelsPart noneRelsPart) throws XlsxDocumentException {
        try {
            if (this.add != -1) {
                xMLStreamWriter.writeEmptyElement("c", "gapDepth", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                xMLStreamWriter.writeAttribute("val", String.valueOf(this.add));
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    @Override
    public void setSubType(byte by) {
        this.SEDU = by;
    }

    @Override
    public byte getType() {
        return 11;
    }

    @Override
    public boolean is1VSeriesChartType() {
        return true;
    }

    @Override
    public boolean is2VSeriesChartType() {
        return false;
    }

    @Override
    public boolean is3VSeriesChartType() {
        return false;
    }

    @Override
    public void addSeries(Series1VInfo series1VInfo) {
        if (series1VInfo instanceof AreaSeries) {
            this.seriesContainer.add((AreaSeries)series1VInfo);
        }
    }

    @Override
    public Series1VInfo getSeries(int n) {
        return (AreaSeries)this.getSeriesByIndex(n);
    }

    @Override
    public void setGap(short s) {
        if (s < 0 || s > 500) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Xlsx API: Invalid parameter " + s + " (Area3DChartType.setGap(short))");
            }
            return;
        }
        this.add = s;
    }

    @Override
    void prepareWriting() {
    }

    @Override
    public boolean supportsXDateAxis() {
        return true;
    }
}

