/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx.chart;

import com.jinfonet.util.JRLog;
import java.awt.Color;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.api.chart.MarkInfo;
import jet.export.excel.imp.xlsx.NoneRelsPart;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.shapeprops.FillStyle;
import jet.export.excel.imp.xlsx.shapeprops.LineStyle;
import jet.export.excel.imp.xlsx.shapeprops.NoFill;
import jet.export.excel.imp.xlsx.shapeprops.SolidFill;

public class Marker
implements MarkInfo,
Cloneable {
    private short SEDU = 1;
    private byte append = (byte)-1;
    private FillStyle clone;
    private LineStyle getRGB;
    private double isTrace = -1.0;

    public void setSize(short s) {
        if (s < 2 || s > 72) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Xlsx API: Invalid parameter " + s + " (Marker.setSize(short))");
            }
            return;
        }
        this.SEDU = s;
    }

    public void setFill(FillStyle fillStyle) {
        this.clone = fillStyle;
    }

    public void setBorder(LineStyle lineStyle) {
        this.getRGB = lineStyle;
    }

    public void setType(byte by) {
        this.append = by;
    }

    void write(XMLStreamWriter xMLStreamWriter, NoneRelsPart noneRelsPart) throws XlsxDocumentException {
        try {
            xMLStreamWriter.writeStartElement("c", "marker", "http://schemas.openxmlformats.org/drawingml/2006/chart");
            if (this.append != -1) {
                xMLStreamWriter.writeEmptyElement("c", "symbol", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                switch (this.append) {
                    case 8: {
                        xMLStreamWriter.writeAttribute("val", "circle");
                        break;
                    }
                    case 7: {
                        xMLStreamWriter.writeAttribute("val", "dash");
                        break;
                    }
                    case 2: {
                        xMLStreamWriter.writeAttribute("val", "diamond");
                        break;
                    }
                    case 6: {
                        xMLStreamWriter.writeAttribute("val", "dot");
                        break;
                    }
                    case 0: {
                        xMLStreamWriter.writeAttribute("val", "none");
                        break;
                    }
                    case 9: {
                        xMLStreamWriter.writeAttribute("val", "plus");
                        break;
                    }
                    case 1: {
                        xMLStreamWriter.writeAttribute("val", "square");
                        break;
                    }
                    case 5: {
                        xMLStreamWriter.writeAttribute("val", "star");
                        break;
                    }
                    case 3: {
                        xMLStreamWriter.writeAttribute("val", "triangle");
                        break;
                    }
                    case 4: {
                        xMLStreamWriter.writeAttribute("val", "x");
                        break;
                    }
                    default: {
                        xMLStreamWriter.writeAttribute("val", "circle");
                    }
                }
            }
            if (this.SEDU != 1) {
                xMLStreamWriter.writeEmptyElement("c", "size", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                xMLStreamWriter.writeAttribute("val", String.valueOf(this.SEDU));
            }
            if (this.clone != null || this.getRGB != null) {
                xMLStreamWriter.writeStartElement("c", "spPr", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                if (this.clone != null) {
                    if (this.isTrace != -1.0 && this.clone instanceof SolidFill) {
                        ((SolidFill)this.clone).setTransparency(this.isTrace);
                    }
                    this.clone.write(xMLStreamWriter, noneRelsPart);
                }
                if (this.getRGB != null) {
                    this.getRGB.write(xMLStreamWriter, noneRelsPart);
                }
                xMLStreamWriter.writeEndElement();
            }
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    @Override
    public void setBackColor(Color color) {
        if (color == null) {
            this.setFill(new NoFill());
        } else {
            this.setFill(new SolidFill(color.getRGB()));
        }
    }

    @Override
    public void setForeColor(Color color) {
        LineStyle lineStyle = new LineStyle();
        if (color == null) {
            lineStyle.setFill(new NoFill());
        } else {
            lineStyle.setFill(new SolidFill(color.getRGB()));
        }
        this.setBorder(lineStyle);
    }

    @Override
    public void setSize(int n) {
        this.setSize((short)n);
    }

    @Override
    public void setBackColorTransparency(double d) {
        if (d < 0.0 || d > 100.0) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Xlsx API: Invalid parameter " + d + " (setBackColorTransparency(double))");
            }
            return;
        }
        this.isTrace = d;
    }

    @Override
    public boolean isNotFilled() {
        return this.clone == null || this.clone instanceof NoFill;
    }

    @Override
    public MarkInfo clone() {
        Marker marker = new Marker();
        marker.isTrace = this.isTrace;
        marker.getRGB = this.getRGB;
        marker.clone = this.clone;
        marker.SEDU = this.SEDU;
        marker.append = this.append;
        return marker;
    }
}

