/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx.chart;

import java.util.Arrays;
import java.util.Hashtable;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.api.FillInfo;
import jet.export.excel.api.chart.Series1VInfo;
import jet.export.excel.api.chart.SurfaceType;
import jet.export.excel.imp.xlsx.NoneRelsPart;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.chart.Common3DChartType;
import jet.export.excel.imp.xlsx.chart.SurfaceSeries;
import jet.export.excel.imp.xlsx.shapeprops.FillStyle;

public class Surface3DChartType
extends Common3DChartType
implements SurfaceType {
    private boolean SEDU = false;
    private boolean add = false;
    private Hashtable get = new Hashtable(0);

    public Surface3DChartType() {
        super("surface3DChart");
        this.hasDataLabelProps = false;
        this.hasVaryColorsProp = false;
    }

    public void setBandFill(FillStyle fillStyle, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The parameter index can not be less than 0.");
        }
        this.get.put(n, fillStyle);
    }

    @Override
    public void setBandFill(FillInfo fillInfo, int n) {
        this.setBandFill((FillStyle)fillInfo, n);
    }

    public void setWireframe(boolean bl) {
        this.SEDU = bl;
        this.add = true;
    }

    @Override
    public boolean supportsXCategoryAxis() {
        return true;
    }

    @Override
    public boolean supportsXValueAxis() {
        return false;
    }

    @Override
    public boolean supportsYValueAxis() {
        return true;
    }

    @Override
    public boolean supportsZSeriesAxis() {
        return true;
    }

    @Override
    void write1stSpecificProps(XMLStreamWriter xMLStreamWriter, NoneRelsPart noneRelsPart) throws XlsxDocumentException {
        try {
            if (this.add) {
                xMLStreamWriter.writeEmptyElement("c", "wireframe", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                xMLStreamWriter.writeAttribute("val", this.SEDU ? "1" : "0");
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    @Override
    void write2ndSpecificProps(XMLStreamWriter xMLStreamWriter, NoneRelsPart noneRelsPart) throws XlsxDocumentException {
        try {
            if (this.get.size() > 0) {
                xMLStreamWriter.writeStartElement("c", "bandFmts", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                Object[] objectArray = this.get.keySet().toArray();
                Arrays.sort(objectArray);
                for (Object object : objectArray) {
                    FillStyle fillStyle = (FillStyle)this.get.get(object);
                    if (fillStyle == null) continue;
                    xMLStreamWriter.writeStartElement("c", "bandFmt", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                    xMLStreamWriter.writeEmptyElement("c", "idx", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                    xMLStreamWriter.writeAttribute("val", String.valueOf((Integer)object));
                    xMLStreamWriter.writeStartElement("c", "spPr", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                    fillStyle.write(xMLStreamWriter, noneRelsPart);
                    xMLStreamWriter.writeEndElement();
                    xMLStreamWriter.writeEndElement();
                }
                xMLStreamWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    @Override
    public byte getType() {
        return 13;
    }

    @Override
    public boolean is1VSeriesChartType() {
        return true;
    }

    @Override
    public boolean is2VSeriesChartType() {
        return false;
    }

    @Override
    public boolean is3VSeriesChartType() {
        return false;
    }

    @Override
    public void addSeries(Series1VInfo series1VInfo) {
        if (series1VInfo instanceof SurfaceSeries) {
            this.seriesContainer.add((SurfaceSeries)series1VInfo);
        }
    }

    @Override
    public Series1VInfo getSeries(int n) {
        return (SurfaceSeries)this.getSeriesByIndex(n);
    }

    @Override
    public void setGap(short s) {
    }

    @Override
    void prepareWriting() {
        if (this.seriesContainer.size() < 2) {
            throw new RuntimeException("The total series count can not be less than 2 for 3D surface chart.");
        }
    }

    @Override
    public boolean supportsXDateAxis() {
        return false;
    }
}

