/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx.shapeprops;

import com.jinfonet.util.JRLog;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.imp.xlsx.NoneRelsPart;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.shapeprops.OuterShadow;

public abstract class Shadow {
    private String append;
    private int isTrace;
    private double setAngle = -1.0;
    private long setBlur = -1L;
    private int setDistance = -1;
    private long setTransparency = -1L;

    Shadow(String string, int n) {
        this.append = string;
        this.isTrace = n;
    }

    public void setTransparency(double d) {
        if (d < 0.0 || d > 100.0) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Xlsx API: Invalid parameter " + d + " (Shadow.setTransparency(double))");
            }
            return;
        }
        this.setAngle = d;
    }

    public void setBlur(long l) {
        if (l < 0L || l > Integer.MAX_VALUE) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Xlsx API: Invalid parameter " + l + " (Shadow.setBlur(long))");
            }
            return;
        }
        this.setBlur = l;
    }

    public void setAngle(int n) {
        if (n < 0 || n >= 360) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Xlsx API: Invalid parameter " + n + " (Shadow.setAngle(int))");
            }
            return;
        }
        this.setDistance = n;
    }

    public void setDistance(long l) {
        if (l < 0L || l > Integer.MAX_VALUE) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Xlsx API: Invalid parameter " + l + " (Shadow.setDistance(long))");
            }
            return;
        }
        this.setTransparency = l;
    }

    abstract void writeSpecificProps(XMLStreamWriter var1) throws XlsxDocumentException;

    public void write(XMLStreamWriter xMLStreamWriter, NoneRelsPart noneRelsPart) throws XlsxDocumentException {
        try {
            xMLStreamWriter.writeStartElement("a", "effectLst", "http://schemas.openxmlformats.org/drawingml/2006/main");
            xMLStreamWriter.writeStartElement("a", this.append, "http://schemas.openxmlformats.org/drawingml/2006/main");
            if (this.setBlur != -1L) {
                xMLStreamWriter.writeAttribute("blurRad", String.valueOf(this.setBlur * 12700L));
            }
            if (this.setDistance != -1) {
                xMLStreamWriter.writeAttribute("dir", String.valueOf(this.setDistance * 60000));
            }
            if (this.setTransparency != -1L) {
                xMLStreamWriter.writeAttribute("dist", String.valueOf(this.setTransparency * 12700L));
            }
            this.writeSpecificProps(xMLStreamWriter);
            xMLStreamWriter.writeStartElement("a", "srgbClr", "http://schemas.openxmlformats.org/drawingml/2006/main");
            xMLStreamWriter.writeAttribute("val", Integer.toHexString(this.isTrace | 0xFF000000).substring(2).toUpperCase());
            if (this.setAngle != -1.0) {
                xMLStreamWriter.writeEmptyElement("a", "alpha", "http://schemas.openxmlformats.org/drawingml/2006/main");
                xMLStreamWriter.writeAttribute("val", String.valueOf(100000 - (int)(this.setAngle * 1000.0)));
            }
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    public static Shadow createDefaultShadow() {
        OuterShadow outerShadow = new OuterShadow(-16777216);
        outerShadow.setTransparency(0.0);
        outerShadow.setBlur(0L);
        outerShadow.setAngle(45);
        outerShadow.setDistance(3L);
        return outerShadow;
    }
}

