/*
 * Decompiled with CFR 0.152.
 */
package jet.export.pdf;

import com.jinfonet.util.JRLog;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Font;
import java.io.IOException;
import java.util.Hashtable;
import jet.export.pdf.PDFConstants;
import jet.export.pdf.PDFFont;
import jet.util.FontSets;

public class PdfExt
extends Document
implements PDFConstants {
    private static final String[] SEDU = new String[]{"Bold", "Oblique", "Italic"};
    static Hashtable append = new Hashtable();
    Hashtable charAt = new Hashtable(10);
    Hashtable clear = new Hashtable(10);
    int convertFont;
    private static final char[] createBaseFont;

    public void setEncoding(String string) {
        this.convertFont = PdfExt.getEncoding(string);
    }

    public static final int getEncoding(String string) {
        int n = -1;
        if (string.startsWith("GB") || string.equals("UTF-8")) {
            n = 0;
        } else if (string.equals("MS950") || string.equals("Big5")) {
            n = 1;
        } else if (string.equals("KSC5601") || string.equals("MS949") || string.equals("EUK_KR") || string.equals("ISO2022KR")) {
            n = 2;
        } else if (string.equals("MS932") || string.equals("EUC_JP") || string.equals("EUC_JP_LINUX") || string.equals("SJIS") || string.equals("ISO2022JP")) {
            n = 3;
        }
        return n;
    }

    public BaseFont getBaseFont(String string, PDFFont pDFFont, boolean bl, boolean bl2) throws IOException, DocumentException {
        BaseFont baseFont = null;
        boolean bl3 = this.charAt(string);
        baseFont = bl2 ? (bl3 ? this.getTrueTypeFontUnicode(pDFFont).getBaseFont() : this.getTrueTypeFont(pDFFont, bl).getBaseFont()) : this.getType1Font(pDFFont.getAwtFont(), bl3).getBaseFont();
        return baseFont;
    }

    private com.lowagie.text.Font SEDU(String string, String string2) {
        if (string.equals("Cp1252")) {
            return (com.lowagie.text.Font)this.clear.get(string2);
        }
        return (com.lowagie.text.Font)this.charAt.get(string2);
    }

    private void append(String string, String string2, com.lowagie.text.Font font) {
        if (string.equals("Cp1252")) {
            this.clear.put(string2, font);
        } else {
            this.charAt.put(string2, font);
        }
    }

    protected com.lowagie.text.Font getTrueTypeFontUnicode(PDFFont pDFFont) throws IOException, DocumentException {
        com.lowagie.text.Font font = null;
        try {
            font = this.getUserFont(pDFFont, "Identity-H", true);
        }
        catch (Exception exception) {
            font = this.getTrueTypeFont(pDFFont, false);
            String string = pDFFont.getBasedName();
            this.append("Identity-H", string, font);
            return this.getTrueTypeFont(pDFFont, false);
        }
        return font;
    }

    protected com.lowagie.text.Font getTrueTypeFont(PDFFont pDFFont, boolean bl) throws IOException, DocumentException {
        return this.getUserFont(pDFFont, "Cp1252", bl);
    }

    protected com.lowagie.text.Font getUserFont(PDFFont pDFFont, String string, boolean bl) throws IOException, DocumentException {
        BaseFont baseFont = null;
        String string2 = pDFFont.getActureName();
        com.lowagie.text.Font font = this.SEDU(string, string2);
        if (font == null) {
            font = this.SEDU(string, string2.replace(' ', '-'));
        }
        if (font == null) {
            try {
                String string3 = FontSets.getFontPath(string2);
                baseFont = string3 == null ? this.getType1Font(pDFFont.getAwtFont(), !string.equals("Cp1252")).getBaseFont() : this.createBaseFont(string3, string, bl);
            }
            catch (IOException iOException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2401008, (Throwable)iOException);
                }
                string2 = string2.replace(' ', '-');
                baseFont = this.createBaseFont(FontSets.getFontPath(string2), string, bl);
            }
            catch (DocumentException documentException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2401008, (Throwable)documentException);
                }
                string2 = string2.replace(' ', '-');
                baseFont = this.createBaseFont(FontSets.getFontPath(string2), string, bl);
            }
            font = new com.lowagie.text.Font(baseFont);
            this.append(string, string2, font);
        }
        return font;
    }

    protected com.lowagie.text.Font getType1Font(Font font, boolean bl) throws IOException, DocumentException {
        com.lowagie.text.Font font2;
        String string = null;
        String string2 = null;
        if (bl) {
            switch (this.convertFont) {
                case 0: {
                    string = "STSong-Light";
                    string2 = "UniGB-UCS2-H";
                    break;
                }
                case 1: {
                    string = "MSung-Light";
                    string2 = "UniCNS-UCS2-H";
                    break;
                }
                case 2: {
                    string = "HYGoThic-Medium";
                    string2 = "UniKS-UCS2-H";
                    break;
                }
                case 3: {
                    string = "HeiseiMin-W3";
                    string2 = "UniJIS-UCS2-H";
                }
            }
        }
        if (string == null) {
            string = PdfExt.convertFont(font);
            string2 = "Cp1252";
        }
        if ((font2 = this.SEDU(string2, string)) == null) {
            BaseFont baseFont = this.createBaseFont(string, string2, false);
            font2 = new com.lowagie.text.Font(baseFont, 12.0f, 0);
            this.append(string2, string, font2);
        }
        return font2;
    }

    protected BaseFont createBaseFont(String string, String string2, boolean bl) throws DocumentException, IOException {
        return BaseFont.createFont((String)string, (String)string2, (boolean)bl);
    }

    protected static final String convertFont(Font font) {
        String string = font.getName();
        String string2 = (String)append.get(string);
        if (string2 == null) {
            string2 = "Helvetica";
        }
        String string3 = "-";
        if (font.isBold()) {
            if (string2.startsWith("Times")) {
                string2 = "Times";
            }
            string3 = string3 + SEDU[0];
        }
        if (font.isItalic()) {
            if (string2.startsWith("Times")) {
                string2 = "Times";
                string3 = string3 + SEDU[2];
            } else {
                string3 = string3 + SEDU[1];
            }
        }
        if (string3.length() > 1) {
            string2 = string2 + string3;
        }
        return string2;
    }

    private boolean charAt(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            int n2 = (c = this.clear(c)) & 0xFFFF;
            if (n2 <= 255) continue;
            return true;
        }
        return false;
    }

    private char clear(char c) {
        switch (c) {
            case '\u0080': {
                c = (char)8364;
                break;
            }
            case '\u0082': {
                c = (char)8218;
                break;
            }
            case '\u0083': {
                c = (char)402;
                break;
            }
            case '\u0089': {
                c = (char)8240;
            }
        }
        return c;
    }

    public void close() {
        super.close();
        this.clear.clear();
        this.clear = null;
        this.charAt.clear();
        this.charAt = null;
    }

    public static final byte[] toHex(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length * 2 + byArray.length / 32 + 2];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (i != 0 && i % 32 == 0) {
                byArray2[n++] = 10;
            }
            int n2 = byArray[i] >> 4 & 0xF;
            byArray2[n++] = (byte)createBaseFont[n2];
            n2 = byArray[i] & 0xF;
            byArray2[n++] = (byte)createBaseFont[n2];
        }
        byArray2[n++] = 62;
        byArray2[n++] = 10;
        return byArray2;
    }

    static {
        append.put("Dialog", "Helvetica");
        append.put("SansSerif", "Helvetica");
        append.put("Helvetica", "Helvetica");
        append.put("Serif", "Times-Roman");
        append.put("DialogInput", "Courier");
        append.put("TimesRoman", "Times-Roman");
        append.put("Times New Roman", "Times-Roman");
        append.put("Monospaced", "Courier");
        append.put("Courier", "Courier");
        append.put("Courier New", "Courier");
        append.put("ZapfDingbats", "ZapfDingbats");
        append.put("Default", "Times-Roman");
        createBaseFont = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

